/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tileentity;

import cpw.mods.fml.common.network.PacketDispatcher;
import enhancedcore.util.ArrayHelper;
import enhancedcore.world.WorldPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.BlockIds;
import enhancedportals.lib.Settings;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.network.packet.PacketRequestData;
import enhancedportals.portal.Portal;
import enhancedportals.portal.upgrades.UpgradeHandler;
import enhancedportals.portal.upgrades.modifier.UpgradeDialDevice;
import enhancedportals.portal.upgrades.modifier.UpgradeNetherFrame;
import enhancedportals.portal.upgrades.modifier.UpgradeResourceFrame;
import enhancedportals.tileentity.TileEntityEnhancedPortals;
import enhancedportals.tileentity.TileEntityNetherPortal;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityPortalModifier
extends TileEntityEnhancedPortals
implements IInventory {
    public ItemStack[] inventory = new ItemStack[2];
    public String texture = "";
    public byte thickness = 0;
    public byte redstoneSetting = 0;
    public byte redstoneState = 0;
    public String modifierNetwork = "";
    public String dialDeviceNetwork = "";
    public String tempDialDeviceNetwork = "";
    public UpgradeHandler upgradeHandler = new UpgradeHandler(5);

    public void func_70305_f() {
    }

    public boolean createPortal() {
        if (this.upgradeHandler.hasUpgrade(new UpgradeDialDevice())) {
            return false;
        }
        return new Portal(this).createPortal(this.customBorderBlocks());
    }

    public boolean createPortal(ItemStack stack) {
        if (this.upgradeHandler.hasUpgrade(new UpgradeDialDevice())) {
            return false;
        }
        return new Portal(this).createPortal(this.customBorderBlocks(), stack);
    }

    public boolean createPortalFromDialDevice() {
        return new Portal(this).createPortal(this.customBorderBlocks());
    }

    public boolean createPortalFromDialDevice(String texture, byte thickness) {
        return new Portal(this).createPortal(texture, thickness, this.customBorderBlocks());
    }

    public int[] customBorderBlocks() {
        if (this.upgradeHandler.hasUpgrade(new UpgradeNetherFrame()) && this.upgradeHandler.hasUpgrade(new UpgradeResourceFrame())) {
            if (Settings.NetherFrameUpgrade.isEmpty() && Settings.ResourceFrameUpgrade.isEmpty()) {
                return new int[]{Block.field_72071_ax.field_71990_ca, Block.field_72105_ah.field_71990_ca, Block.field_72083_ai.field_71990_ca, Block.field_72076_bV.field_71990_ca, Block.field_94339_ct.field_71990_ca, Block.field_72014_bd.field_71990_ca, Block.field_72033_bA.field_71990_ca};
            }
            if (!Settings.NetherFrameUpgrade.isEmpty() && Settings.ResourceFrameUpgrade.isEmpty()) {
                return ArrayHelper.concatIntegerArray((int[])ArrayHelper.listToIntegerArray(Settings.NetherFrameUpgrade), (int[])new int[]{Block.field_72071_ax.field_71990_ca, Block.field_72105_ah.field_71990_ca, Block.field_72083_ai.field_71990_ca, Block.field_72076_bV.field_71990_ca});
            }
            if (Settings.NetherFrameUpgrade.isEmpty() && !Settings.ResourceFrameUpgrade.isEmpty()) {
                return ArrayHelper.concatIntegerArray((int[])new int[]{Block.field_94339_ct.field_71990_ca, Block.field_72014_bd.field_71990_ca, Block.field_72033_bA.field_71990_ca}, (int[])ArrayHelper.listToIntegerArray(Settings.ResourceFrameUpgrade));
            }
            return ArrayHelper.concatIntegerArray((int[])ArrayHelper.listToIntegerArray(Settings.NetherFrameUpgrade), (int[])ArrayHelper.listToIntegerArray(Settings.ResourceFrameUpgrade));
        }
        if (this.upgradeHandler.hasUpgrade(new UpgradeNetherFrame())) {
            if (Settings.NetherFrameUpgrade.isEmpty()) {
                return new int[]{Block.field_94339_ct.field_71990_ca, Block.field_72014_bd.field_71990_ca, Block.field_72033_bA.field_71990_ca};
            }
            return ArrayHelper.listToIntegerArray(Settings.NetherFrameUpgrade);
        }
        if (this.upgradeHandler.hasUpgrade(new UpgradeResourceFrame())) {
            if (Settings.ResourceFrameUpgrade.isEmpty()) {
                return new int[]{Block.field_72071_ax.field_71990_ca, Block.field_72105_ah.field_71990_ca, Block.field_72083_ai.field_71990_ca, Block.field_72076_bV.field_71990_ca};
            }
            return ArrayHelper.listToIntegerArray(Settings.ResourceFrameUpgrade);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        stack.field_77994_a -= j;
        return stack;
    }

    public int func_70297_j_() {
        return 4;
    }

    public String func_70303_b() {
        return "portalModifier";
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory[i];
    }

    public void handleRedstoneChanges(int redstoneLevel) {
        if (this.isRemotelyControlled()) {
            return;
        }
        if (this.redstoneSetting == 0) {
            if (redstoneLevel >= 1 && this.redstoneState == 0 && !this.isAnyActive()) {
                this.createPortal();
            } else if (redstoneLevel == 0 && this.redstoneState > 0 && this.isActive()) {
                this.removePortal();
            }
        } else if (this.redstoneSetting == 1) {
            if (redstoneLevel == 0 && this.redstoneState > 0 && !this.isAnyActive()) {
                this.createPortal();
            } else if (redstoneLevel >= 1 && this.redstoneState == 0 && this.isActive()) {
                this.removePortal();
            }
        } else if (this.redstoneSetting > 2) {
            byte rsLevel = (byte)(this.redstoneSetting - 2);
            if (redstoneLevel == rsLevel && this.redstoneState != rsLevel && !this.isAnyActive()) {
                this.createPortal();
            } else if (redstoneLevel != rsLevel && this.redstoneState == rsLevel && this.isActive()) {
                this.removePortal();
            }
        }
        this.redstoneState = (byte)redstoneLevel;
    }

    public boolean isActive() {
        WorldPosition block = this.getWorldPosition().getOffset(ForgeDirection.getOrientation((int)this.func_70322_n()));
        TileEntityNetherPortal portal = null;
        if (!(block.getTileEntity() instanceof TileEntityNetherPortal)) {
            return false;
        }
        portal = (TileEntityNetherPortal)block.getTileEntity();
        if (this.field_70331_k.field_72995_K) {
            return portal.hasParent;
        }
        return portal != null && portal.getParentModifier() != null && portal.getParentModifier().equals((Object)this.getWorldPosition());
    }

    public boolean isAnyActive() {
        WorldPosition block = new WorldPosition(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k).getOffset(ForgeDirection.getOrientation((int)this.func_70322_n()));
        return block.getBlockId() == BlockIds.NetherPortal;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 1 && itemstack.func_77969_a(new ItemStack((Item)EnhancedPortals.proxy.itemMisc, 1, 0));
    }

    public boolean isRemotelyControlled() {
        return this.upgradeHandler.hasUpgrade(new UpgradeDialDevice());
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.texture = tagCompound.func_74779_i("Texture");
        this.thickness = tagCompound.func_74771_c("Thickness");
        this.redstoneSetting = tagCompound.func_74771_c("RedstoneSetting");
        this.redstoneState = tagCompound.func_74771_c("RedstoneState");
        this.modifierNetwork = tagCompound.func_74779_i("mNetwork");
        this.dialDeviceNetwork = tagCompound.func_74779_i("dNetwork");
        this.tempDialDeviceNetwork = tagCompound.func_74779_i("dNetworkTemp");
        this.redstoneSetting = tagCompound.func_74771_c("RedstoneSetting");
        for (int i = 0; i < this.upgradeHandler.getMaximumUpgrades(); ++i) {
            if (!tagCompound.func_74764_b("Upgrade" + i)) continue;
            Byte b = tagCompound.func_74771_c("Upgrade" + i);
            if (b == 3) {
                b = 2;
            }
            this.upgradeHandler.addUpgradeNoActivate(b, this);
        }
        NBTTagList list = tagCompound.func_74761_m("Inventory");
        for (int i = 0; i < list.field_74747_a.size(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)list.field_74747_a.get(i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public boolean removePortal() {
        return new Portal(this).removePortal();
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
    }

    public boolean updateData(byte thick) {
        if (thick == this.thickness) {
            return false;
        }
        this.thickness = thick;
        return true;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketRequestData(this)));
        }
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        tagCompound.func_74778_a("Texture", this.texture);
        tagCompound.func_74774_a("Thickness", this.thickness);
        tagCompound.func_74774_a("RedstoneSetting", this.redstoneSetting);
        tagCompound.func_74774_a("RedstoneState", this.redstoneState);
        tagCompound.func_74778_a("mNetwork", this.modifierNetwork);
        tagCompound.func_74778_a("dNetwork", this.dialDeviceNetwork);
        tagCompound.func_74778_a("dNetworkTemp", this.tempDialDeviceNetwork);
        tagCompound.func_74774_a("RedstoneSetting", this.redstoneSetting);
        int i = 0;
        for (byte b : this.upgradeHandler.getInstalledUpgrades()) {
            tagCompound.func_74774_a("Upgrade" + i, b);
            ++i;
        }
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)list);
    }
}

