/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import enhancedcore.CommonProxy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.Configuration;

@Mod(modid="EnhancedCore", name="EnhancedCore", version="1.1.3", acceptedMinecraftVersions="[1.6.2,)")
public class EnhancedCore {
    @Mod.Instance(value="EnhancedCore")
    public static EnhancedCore instance;
    @SidedProxy(clientSide="enhancedcore.ClientProxy", serverSide="enhancedcore.CommonProxy")
    public static CommonProxy proxy;
    File itemFile;
    File blockFile;
    boolean dumpItemIDs = false;
    boolean dumpBlockIDs = false;
    boolean dumpOnlyTakenIDs = false;
    boolean dumpOnlyFreeIDs = false;
    Configuration config = null;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.dumpItemIDs = this.config.get("general", "dumpItemIDs", false).getBoolean(false);
        this.dumpBlockIDs = this.config.get("general", "dumpBlockIDs", false).getBoolean(false);
        this.dumpOnlyTakenIDs = this.config.get("general", "dumpOnlyTakenIDs", false).getBoolean(false);
        this.dumpOnlyFreeIDs = this.config.get("general", "dumpOnlyFreeIDs", false).getBoolean(false);
        this.config.save();
        this.itemFile = new File(event.getSuggestedConfigurationFile().getParentFile().getParentFile(), "itemIDs.txt");
        this.blockFile = new File(this.itemFile.getParentFile(), "blockIDs.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        BufferedWriter buffer;
        if (this.dumpItemIDs) {
            buffer = null;
            try {
                if (!this.itemFile.exists()) {
                    this.itemFile.createNewFile();
                }
                buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.itemFile.getAbsoluteFile()), "utf-8"));
                for (int i = 0; i < Item.field_77698_e.length; ++i) {
                    if (this.dumpOnlyFreeIDs && Item.field_77698_e[i] != null || this.dumpOnlyTakenIDs && Item.field_77698_e[i] == null) {
                        return;
                    }
                    buffer.write(i + ": " + (i == 0 ? "Unusable" : (Item.field_77698_e[i] == null ? "Unused" : Item.field_77698_e[i].func_77658_a())));
                    buffer.newLine();
                }
            }
            catch (Exception e) {
                System.out.println("Failed to log item IDs");
                e.printStackTrace();
            }
            finally {
                try {
                    buffer.close();
                }
                catch (Exception e) {}
            }
            this.config.load();
            this.config.getCategory("general").get("dumpItemIDs").set(false);
            this.config.save();
        }
        if (this.dumpBlockIDs) {
            buffer = null;
            try {
                if (!this.blockFile.exists()) {
                    this.blockFile.createNewFile();
                }
                buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.blockFile.getAbsoluteFile()), "utf-8"));
                for (int i = 0; i < Block.field_71973_m.length; ++i) {
                    if (this.dumpOnlyFreeIDs && Block.field_71973_m[i] != null || this.dumpOnlyTakenIDs && Block.field_71973_m[i] == null) {
                        return;
                    }
                    buffer.write(i + ": " + (i == 0 ? "Unusable" : (Block.field_71973_m[i] == null ? "Unused" : Block.field_71973_m[i].func_71917_a())));
                    buffer.newLine();
                }
            }
            catch (Exception e) {
                System.out.println("Failed to log block IDs");
                e.printStackTrace();
            }
            finally {
                try {
                    buffer.close();
                }
                catch (Exception exception) {}
            }
            this.config.load();
            this.config.getCategory("general").get("dumpBlockIDs").set(false);
            this.config.save();
        }
    }
}

