/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.computercraft;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.ArrayList;

public class ComputerManager {
    ArrayList<IMethod> methods = new ArrayList();
    ArrayList<IComputerAccess> computerList = new ArrayList();

    public void addComputer(IComputerAccess computer) {
        this.computerList.add(computer);
    }

    public Object[] execute(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (this.methods.size() < method || this.methods.get(method) == null) {
            throw new Exception("Invalid method");
        }
        return this.methods.get(method).execute(computer, context, arguments);
    }

    public String[] getAllMethodNames() {
        String[] names = new String[this.methods.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.methods.get(i).getMethodName();
        }
        return names;
    }

    public void queueEvent(String event, Object[] arguments) {
        for (IComputerAccess computer : this.computerList) {
            computer.queueEvent(event, arguments);
        }
    }

    public void registerMethod(IMethod method) {
        this.methods.add(method);
    }

    public void removeComputer(IComputerAccess computer) {
        this.computerList.remove(computer);
    }

    public static interface IMethod {
        public Object[] execute(IComputerAccess var1, ILuaContext var2, Object[] var3) throws Exception;

        public String getMethodName();
    }
}

