/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.gui.button;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedcore.gui.button.IButtonTextureSet;
import enhancedcore.gui.button.StandardButtonTextureSets;
import enhancedcore.gui.tooltips.ToolTip;
import enhancedcore.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBetterButton
extends GuiButton {
    public static final String BUTTON_TEXTURES = "gui/buttons.png";
    protected final IButtonTextureSet texture;
    private ToolTip toolTip;

    public GuiBetterButton(int id, int x, int y, int width, IButtonTextureSet texture, String label) {
        super(id, x, y, width, texture.getHeight(), label);
        this.texture = texture;
    }

    public GuiBetterButton(int id, int x, int y, int width, String label) {
        this(id, x, y, width, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, String label) {
        this(id, x, y, 200, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    protected void bindButtonTextures(Minecraft minecraft) {
        Properties.bindTexture(minecraft.field_71446_o, BUTTON_TEXTURES);
    }

    public void func_73737_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.field_73748_h) {
            return;
        }
        FontRenderer fontrenderer = minecraft.field_71466_p;
        this.bindButtonTextures(minecraft);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.texture.getX();
        int yOffset = this.texture.getY();
        int h = this.texture.getHeight();
        int w = this.texture.getWidth();
        boolean mouseOver = this.isMouseOverButton(mouseX, mouseY);
        int hoverState = this.func_73738_a(mouseOver);
        this.func_73729_b(this.field_73746_c, this.field_73743_d, xOffset, yOffset + hoverState * h, this.field_73747_a / 2, h);
        this.func_73729_b(this.field_73746_c + this.field_73747_a / 2, this.field_73743_d, xOffset + w - this.field_73747_a / 2, yOffset + hoverState * h, this.field_73747_a / 2, h);
        this.func_73739_b(minecraft, mouseX, mouseY);
        this.func_73732_a(fontrenderer, this.field_73744_e, this.field_73746_c + this.field_73747_a / 2, this.field_73743_d + (h - 8) / 2, this.getTextColor(mouseOver));
    }

    public int getHeight() {
        return this.texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!this.field_73742_g) {
            return -6250336;
        }
        if (mouseOver) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public int getWidth() {
        return this.field_73747_a;
    }

    public boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.field_73746_c && mouseY >= this.field_73743_d && mouseX < this.field_73746_c + this.field_73747_a && mouseY < this.field_73743_d + this.getHeight();
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }
}

