/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.world;

import enhancedcore.util.BlockMetaPair;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldPosition;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;

public class FloodHelper {
    private int MAX_CHANCES = 10;
    private int MINIMUM_CONNECTING_BLOCKS = 2;

    protected void onCompleted(WorldServer world) {
    }

    public void floodAir(WorldServer world, BlockPosition pos, BlockMetaPair blockToReplace, FloodDirection direction) {
        if (world.field_72995_K || world.func_72798_a(pos.getX(), pos.getY(), pos.getZ()) != blockToReplace.ID() && world.func_72805_g(pos.getX(), pos.getY(), pos.getZ()) != blockToReplace.Metadata()) {
            return;
        }
        Queue<BlockPosition> queue = new LinkedList<BlockPosition>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            BlockPosition current = (BlockPosition)queue.remove();
            if (world.func_72798_a(current.getX(), current.getY(), current.getZ()) != blockToReplace.ID() || world.func_72805_g(current.getX(), current.getY(), current.getZ()) != blockToReplace.Metadata()) continue;
            world.func_94571_i(current.getX(), current.getY(), current.getZ());
            queue = this.updateQueue(queue, direction, current);
        }
    }

    public boolean floodFillArea(WorldPosition position, FloodDirection direction, int maxSize, int minSize, BlockMetaPair[] removableBlocks, BlockMetaPair[] borderBlocks, BlockMetaPair blockToFill, boolean validate, boolean ghost, boolean ignoreMetaWhenCheckingFill) {
        if (position.getWorld().field_72995_K) {
            return false;
        }
        WorldServer world = (WorldServer)position.getWorld();
        if (!this.isBlockInList(world, position.toBlockPosition(), removableBlocks, true)) {
            System.out.println("Failed first check!");
            return false;
        }
        Queue<BlockPosition> queue = new LinkedList<BlockPosition>();
        LinkedList<BlockPosition> addedBlocks = new LinkedList<BlockPosition>();
        queue.add(position.toBlockPosition());
        int usedChances = 0;
        while (!queue.isEmpty()) {
            int sides;
            BlockPosition current = (BlockPosition)queue.remove();
            if (!this.isBlockInList(world, current, removableBlocks, true) || addedBlocks.contains(current)) continue;
            int n = sides = ghost ? this.getSidesGhost(world, current, direction, borderBlocks, removableBlocks, blockToFill, addedBlocks, ignoreMetaWhenCheckingFill) : this.getSides(world, current, direction, borderBlocks, removableBlocks, blockToFill, ignoreMetaWhenCheckingFill);
            if (sides == -1 || usedChances > this.MAX_CHANCES && sides < this.MINIMUM_CONNECTING_BLOCKS) {
                this.removeFill(world, addedBlocks);
                System.out.println("Failed side check! " + sides);
                return false;
            }
            if (sides < this.MINIMUM_CONNECTING_BLOCKS && usedChances < this.MAX_CHANCES) {
                ++usedChances;
            }
            addedBlocks.add(current);
            if (!ghost) {
                world.func_72832_d(current.getX(), current.getY(), current.getZ(), blockToFill.ID(), blockToFill.Metadata(), 3);
                this.onBlockAdded(world, current);
            }
            queue = this.updateQueue(queue, direction, current);
        }
        if (addedBlocks.size() < minSize || maxSize != 0 && addedBlocks.size() > maxSize) {
            this.removeFill(world, addedBlocks);
            System.out.println("Failed max/min size check!");
            return false;
        }
        System.out.println("Validating...");
        if (validate && !this.validateFill(world, addedBlocks, blockToFill, direction, borderBlocks, removableBlocks, ignoreMetaWhenCheckingFill)) {
            this.removeFill(world, addedBlocks);
            System.out.println("Failed validation!");
            return false;
        }
        System.out.println("Success.");
        this.onCompleted(world);
        return true;
    }

    protected int getSides(WorldServer world, BlockPosition pos, FloodDirection direction, BlockMetaPair[] borderBlocks, BlockMetaPair[] removeBlocks, BlockMetaPair fillBlock, boolean ignoreMetaWhenCheckingFill) {
        int totalSides = 0;
        BlockPosition[] allBlocks = new BlockPosition[4];
        if (direction == FloodDirection.HORIZONTAL) {
            allBlocks[0] = pos.getOffset(ForgeDirection.NORTH);
            allBlocks[1] = pos.getOffset(ForgeDirection.SOUTH);
            allBlocks[2] = pos.getOffset(ForgeDirection.EAST);
            allBlocks[3] = pos.getOffset(ForgeDirection.WEST);
        } else if (direction == FloodDirection.VERTICALX) {
            allBlocks[0] = pos.getOffset(ForgeDirection.WEST);
            allBlocks[1] = pos.getOffset(ForgeDirection.EAST);
            allBlocks[2] = pos.getOffset(ForgeDirection.UP);
            allBlocks[3] = pos.getOffset(ForgeDirection.DOWN);
        } else if (direction == FloodDirection.VERTICALZ) {
            allBlocks[0] = pos.getOffset(ForgeDirection.NORTH);
            allBlocks[1] = pos.getOffset(ForgeDirection.SOUTH);
            allBlocks[2] = pos.getOffset(ForgeDirection.UP);
            allBlocks[3] = pos.getOffset(ForgeDirection.DOWN);
        }
        for (BlockPosition val : allBlocks) {
            if (this.isBlockInList(world, val, borderBlocks, false, true, fillBlock, ignoreMetaWhenCheckingFill)) {
                ++totalSides;
                continue;
            }
            if (this.isBlockInList(world, val, removeBlocks, true)) continue;
            return -1;
        }
        return totalSides;
    }

    protected int getSidesGhost(WorldServer world, BlockPosition pos, FloodDirection direction, BlockMetaPair[] borderBlocks, BlockMetaPair[] removeBlocks, BlockMetaPair fillBlock, Queue<BlockPosition> addedBlocks, boolean ignoreMetaWhenCheckingFill) {
        int totalSides = 0;
        BlockPosition[] allBlocks = new BlockPosition[4];
        if (direction == FloodDirection.HORIZONTAL) {
            allBlocks[0] = pos.getOffset(ForgeDirection.NORTH);
            allBlocks[1] = pos.getOffset(ForgeDirection.SOUTH);
            allBlocks[2] = pos.getOffset(ForgeDirection.EAST);
            allBlocks[3] = pos.getOffset(ForgeDirection.WEST);
        } else if (direction == FloodDirection.VERTICALX) {
            allBlocks[0] = pos.getOffset(ForgeDirection.WEST);
            allBlocks[1] = pos.getOffset(ForgeDirection.EAST);
            allBlocks[2] = pos.getOffset(ForgeDirection.UP);
            allBlocks[3] = pos.getOffset(ForgeDirection.DOWN);
        } else if (direction == FloodDirection.VERTICALZ) {
            allBlocks[0] = pos.getOffset(ForgeDirection.NORTH);
            allBlocks[1] = pos.getOffset(ForgeDirection.SOUTH);
            allBlocks[2] = pos.getOffset(ForgeDirection.UP);
            allBlocks[3] = pos.getOffset(ForgeDirection.DOWN);
        }
        for (BlockPosition val : allBlocks) {
            if (addedBlocks.contains(val) || this.isBlockInList(world, val, borderBlocks, false, true, fillBlock, ignoreMetaWhenCheckingFill)) {
                ++totalSides;
                continue;
            }
            if (this.isBlockInList(world, val, removeBlocks, true)) continue;
            return -1;
        }
        return totalSides;
    }

    protected boolean isBlockInList(WorldServer world, BlockPosition pos, BlockMetaPair[] blockList, boolean checkAir) {
        if (checkAir && world.func_72799_c(pos.getX(), pos.getY(), pos.getZ())) {
            return true;
        }
        BlockMetaPair pair = new BlockMetaPair(world.func_72798_a(pos.getX(), pos.getY(), pos.getZ()), world.func_72805_g(pos.getX(), pos.getY(), pos.getZ()));
        for (BlockMetaPair p : blockList) {
            if (!pair.matches(p)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBlockInList(WorldServer world, BlockPosition pos, BlockMetaPair[] blockList, boolean checkAir, boolean checkBlock, BlockMetaPair fillBlock, boolean ignoreMetaWhenCheckingFill) {
        if (checkAir && world.func_72799_c(pos.getX(), pos.getY(), pos.getZ())) {
            return true;
        }
        BlockMetaPair pair = new BlockMetaPair(world.func_72798_a(pos.getX(), pos.getY(), pos.getZ()), world.func_72805_g(pos.getX(), pos.getY(), pos.getZ()));
        if (ignoreMetaWhenCheckingFill) {
            fillBlock = new BlockMetaPair(fillBlock.ID(), -1);
        }
        if (checkBlock && pair.matches(fillBlock)) {
            return true;
        }
        for (BlockMetaPair p : blockList) {
            if (!pair.matches(p)) continue;
            return true;
        }
        return false;
    }

    protected void onBlockAdded(WorldServer world, BlockPosition pos) {
    }

    protected void removeFill(WorldServer world, Queue<BlockPosition> addedBlocks) {
        while (!addedBlocks.isEmpty()) {
            BlockPosition current = addedBlocks.remove();
            world.func_94571_i(current.getX(), current.getY(), current.getZ());
        }
    }

    protected Queue<BlockPosition> updateQueue(Queue<BlockPosition> queue, FloodDirection direction, BlockPosition pos) {
        if (direction == FloodDirection.VERTICALX) {
            queue.add(pos.getOffset(ForgeDirection.UP));
            queue.add(pos.getOffset(ForgeDirection.DOWN));
            queue.add(pos.getOffset(ForgeDirection.EAST));
            queue.add(pos.getOffset(ForgeDirection.WEST));
        } else if (direction == FloodDirection.VERTICALZ) {
            queue.add(pos.getOffset(ForgeDirection.UP));
            queue.add(pos.getOffset(ForgeDirection.DOWN));
            queue.add(pos.getOffset(ForgeDirection.NORTH));
            queue.add(pos.getOffset(ForgeDirection.SOUTH));
        } else if (direction == FloodDirection.HORIZONTAL) {
            queue.add(pos.getOffset(ForgeDirection.NORTH));
            queue.add(pos.getOffset(ForgeDirection.SOUTH));
            queue.add(pos.getOffset(ForgeDirection.EAST));
            queue.add(pos.getOffset(ForgeDirection.WEST));
        }
        return queue;
    }

    protected boolean validateFill(WorldServer world, Queue<BlockPosition> queue, BlockMetaPair fillBlock, FloodDirection direction, BlockMetaPair[] borderBlocks, BlockMetaPair[] replaceBlocks, boolean ignoreMetaWhenCheckingFill) {
        LinkedList<BlockPosition> checkedQueue = new LinkedList<BlockPosition>();
        while (!queue.isEmpty()) {
            BlockPosition current = queue.remove();
            if (world.func_72798_a(current.getX(), current.getY(), current.getZ()) != fillBlock.ID() || world.func_72805_g(current.getX(), current.getY(), current.getZ()) != fillBlock.Metadata() || checkedQueue.contains(current)) continue;
            int sides = this.getSides(world, current, direction, borderBlocks, replaceBlocks, fillBlock, ignoreMetaWhenCheckingFill);
            if (sides != 4) {
                this.removeFill(world, queue);
                return false;
            }
            queue = this.updateQueue(queue, direction, current);
            checkedQueue.add(current);
        }
        return true;
    }

    public static enum FloodDirection {
        HORIZONTAL,
        VERTICALX,
        VERTICALZ;

    }
}

