/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.world;

import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class WorldPosition
extends BlockPosition {
    protected int dimension;

    public WorldPosition(int x, int y, int z, int dim) {
        super(x, y, z);
        this.dimension = dim;
    }

    public WorldPosition(int x, int y, int z, World world) {
        super(x, y, z);
        this.dimension = world.field_73011_w.field_76574_g;
    }

    @Override
    public WorldPosition above() {
        return new WorldPosition(this.x, this.y + 1, this.z, this.dimension);
    }

    @Override
    public WorldPosition below() {
        return new WorldPosition(this.x, this.y - 1, this.z, this.dimension);
    }

    public boolean canBlockSeeTheSky() {
        return this.getWorld().func_72937_j(this.x, this.y, this.z);
    }

    @Override
    public WorldPosition east() {
        return new WorldPosition(this.x + 1, this.y, this.z, this.dimension);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WorldPosition)) {
            return false;
        }
        WorldPosition loc = (WorldPosition)obj;
        return this.dimension == loc.dimension && super.equals(obj);
    }

    public int getBlockId() {
        return this.getWorld().func_72798_a(this.x, this.y, this.z);
    }

    public BlockPosition getBlockPosition() {
        return new BlockPosition(this.x, this.y, this.z);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getMetadata() {
        return this.getWorld().func_72805_g(this.x, this.y, this.z);
    }

    @Override
    public WorldPosition getOffset(ForgeDirection dir) {
        BlockPosition sup = super.getOffset(dir);
        return new WorldPosition(sup.x, sup.y, sup.z, this.dimension);
    }

    @Override
    public WorldPosition getOffset(ForgeDirection dir, int count) {
        BlockPosition sup = super.getOffset(dir, count);
        return new WorldPosition(sup.x, sup.y, sup.z, this.dimension);
    }

    public TileEntity getTileEntity() {
        return this.getWorld().func_72796_p(this.x, this.y, this.z);
    }

    public World getWorld() {
        return WorldHelper.getWorld(this.dimension);
    }

    public boolean isAirBlock() {
        return this.getWorld().func_72799_c(this.x, this.y, this.z);
    }

    public void markBlockForUpdate() {
        this.getWorld().func_72845_h(this.x, this.y, this.z);
    }

    @Override
    public WorldPosition north() {
        return new WorldPosition(this.x, this.y, this.z - 1, this.dimension);
    }

    public void setBlock(int id, int meta, int flag) {
        this.getWorld().func_72832_d(this.x, this.y, this.z, id, meta, flag);
    }

    public void setBlockToAir() {
        this.getWorld().func_94571_i(this.x, this.y, this.z);
    }

    @Override
    public WorldPosition south() {
        return new WorldPosition(this.x, this.y, this.z + 1, this.dimension);
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + " : " + this.dimension + ")";
    }

    @Override
    public WorldPosition west() {
        return new WorldPosition(this.x - 1, this.y, this.z, this.dimension);
    }

    public BlockPosition toBlockPosition() {
        return new BlockPosition(this.x, this.y, this.z);
    }
}

