/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNetworkContainer;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;

public class BlockRedNetCable
extends BlockContainer
implements IRedNetNetworkContainer {
    private static float _wireSize = 0.25f;
    private static float _plateWidth = 0.875f;
    private static float _plateDepth = 0.0625f;
    private static float _bandWidth = 0.3125f;
    private static float _bandOffset = 0.125f;
    private static float _bandDepth = 0.0625f;
    private static float _wireStart = 0.5f - _wireSize / 2.0f;
    private static float _wireEnd = 0.5f + _wireSize / 2.0f;
    private static float _plateStart = 0.5f - _plateWidth / 2.0f;
    private static float _plateEnd = 0.5f + _plateWidth / 2.0f;
    private static float _bandWidthStart = 0.5f - _bandWidth / 2.0f;
    private static float _bandWidthEnd = 0.5f + _bandWidth / 2.0f;
    private static float _bandDepthStart = _bandOffset;
    private static float _bandDepthEnd = _bandOffset + _bandDepth;
    private static int[] _partSideMappings = new int[]{-1, -1, -1, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3};

    public BlockRedNetCable(int n) {
        super(n, Material.field_76267_y);
        this.func_71864_b("mfr.cable.redstone");
        this.func_71848_c(0.8f);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    private AxisAlignedBB[] getParts(TileEntityRedNetCable tileEntityRedNetCable) {
        RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getConnectionState(ForgeDirection.UP);
        RedNetConnectionType redNetConnectionType2 = tileEntityRedNetCable.getConnectionState(ForgeDirection.DOWN);
        RedNetConnectionType redNetConnectionType3 = tileEntityRedNetCable.getConnectionState(ForgeDirection.NORTH);
        RedNetConnectionType redNetConnectionType4 = tileEntityRedNetCable.getConnectionState(ForgeDirection.SOUTH);
        RedNetConnectionType redNetConnectionType5 = tileEntityRedNetCable.getConnectionState(ForgeDirection.WEST);
        RedNetConnectionType redNetConnectionType6 = tileEntityRedNetCable.getConnectionState(ForgeDirection.EAST);
        AxisAlignedBB[] axisAlignedBBArray = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)(redNetConnectionType5 != RedNetConnectionType.None ? 0.0 : (double)_wireStart), (double)_wireStart, (double)_wireStart, (double)(redNetConnectionType6 != RedNetConnectionType.None ? 1.0 : (double)_wireEnd), (double)_wireEnd, (double)_wireEnd), AxisAlignedBB.func_72330_a((double)_wireStart, (double)(redNetConnectionType2 != RedNetConnectionType.None ? 0.0 : (double)_wireStart), (double)_wireStart, (double)_wireEnd, (double)(redNetConnectionType != RedNetConnectionType.None ? 1.0 : (double)_wireEnd), (double)_wireEnd), AxisAlignedBB.func_72330_a((double)_wireStart, (double)_wireStart, (double)(redNetConnectionType3 != RedNetConnectionType.None ? 0.0 : (double)_wireStart), (double)_wireEnd, (double)_wireEnd, (double)(redNetConnectionType4 != RedNetConnectionType.None ? 1.0 : (double)_wireEnd)), !redNetConnectionType5.isPlate ? null : AxisAlignedBB.func_72330_a((double)0.0, (double)_plateStart, (double)_plateStart, (double)_plateDepth, (double)_plateEnd, (double)_plateEnd), !redNetConnectionType6.isPlate ? null : AxisAlignedBB.func_72330_a((double)(1.0f - _plateDepth), (double)_plateStart, (double)_plateStart, (double)1.0, (double)_plateEnd, (double)_plateEnd), !redNetConnectionType2.isPlate ? null : AxisAlignedBB.func_72330_a((double)_plateStart, (double)0.0, (double)_plateStart, (double)_plateEnd, (double)_plateDepth, (double)_plateEnd), !redNetConnectionType.isPlate ? null : AxisAlignedBB.func_72330_a((double)_plateStart, (double)(1.0f - _plateDepth), (double)_plateStart, (double)_plateEnd, (double)1.0, (double)_plateEnd), !redNetConnectionType3.isPlate ? null : AxisAlignedBB.func_72330_a((double)_plateStart, (double)_plateStart, (double)0.0, (double)_plateEnd, (double)_plateEnd, (double)_plateDepth), !redNetConnectionType4.isPlate ? null : AxisAlignedBB.func_72330_a((double)_plateStart, (double)_plateStart, (double)(1.0f - _plateDepth), (double)_plateEnd, (double)_plateEnd, (double)1.0), !redNetConnectionType5.isSingleSubnet ? null : AxisAlignedBB.func_72330_a((double)_bandDepthStart, (double)_bandWidthStart, (double)_bandWidthStart, (double)_bandDepthEnd, (double)_bandWidthEnd, (double)_bandWidthEnd), !redNetConnectionType6.isSingleSubnet ? null : AxisAlignedBB.func_72330_a((double)(1.0f - _bandDepthEnd), (double)_bandWidthStart, (double)_bandWidthStart, (double)(1.0f - _bandDepthStart), (double)_bandWidthEnd, (double)_bandWidthEnd), !redNetConnectionType2.isSingleSubnet ? null : AxisAlignedBB.func_72330_a((double)_bandWidthStart, (double)_bandDepthStart, (double)_bandWidthStart, (double)_bandWidthEnd, (double)_bandDepthEnd, (double)_bandWidthEnd), !redNetConnectionType.isSingleSubnet ? null : AxisAlignedBB.func_72330_a((double)_bandWidthStart, (double)(1.0f - _bandDepthEnd), (double)_bandWidthStart, (double)_bandWidthEnd, (double)(1.0f - _bandDepthStart), (double)_bandWidthEnd), !redNetConnectionType3.isSingleSubnet ? null : AxisAlignedBB.func_72330_a((double)_bandWidthStart, (double)_bandWidthStart, (double)_bandDepthStart, (double)_bandWidthEnd, (double)_bandWidthEnd, (double)_bandDepthEnd), !redNetConnectionType4.isSingleSubnet ? null : AxisAlignedBB.func_72330_a((double)_bandWidthStart, (double)_bandWidthStart, (double)(1.0f - _bandDepthEnd), (double)_bandWidthEnd, (double)_bandWidthEnd, (double)(1.0f - _bandDepthStart))};
        return axisAlignedBBArray;
    }

    private int getPartClicked(EntityPlayer entityPlayer, double d, TileEntityRedNetCable tileEntityRedNetCable) {
        AxisAlignedBB[] axisAlignedBBArray = this.getParts(tileEntityRedNetCable);
        Vec3 vec3 = entityPlayer.field_70170_p.func_82732_R().func_72345_a(entityPlayer.field_70165_t - (double)tileEntityRedNetCable.field_70329_l, entityPlayer.field_70163_u - (double)tileEntityRedNetCable.field_70330_m + (double)entityPlayer.func_70047_e(), entityPlayer.field_70161_v - (double)tileEntityRedNetCable.field_70327_n);
        Vec3 vec32 = entityPlayer.func_70040_Z();
        Vec3 vec33 = entityPlayer.field_70170_p.func_82732_R().func_72345_a(vec3.field_72450_a + vec32.field_72450_a * d, vec3.field_72448_b + vec32.field_72448_b * d, vec3.field_72449_c + vec32.field_72449_c * d);
        int n = -1;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < axisAlignedBBArray.length; ++i) {
            double d3;
            MovingObjectPosition movingObjectPosition;
            AxisAlignedBB axisAlignedBB = axisAlignedBBArray[i];
            if (axisAlignedBB == null || (movingObjectPosition = axisAlignedBB.func_72327_a(vec3, vec33)) == null || !((d3 = vec3.func_72438_d(movingObjectPosition.field_72307_f)) < d2)) continue;
            d2 = d3;
            n = i;
        }
        return n;
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            int n5 = this.getPartClicked(entityPlayer, 3.0, tileEntityRedNetCable);
            if (n5 < 0) {
                return false;
            }
            n4 = _partSideMappings[n5];
            ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
            if (n4 >= 0) {
                if (MFRUtil.isHoldingHammer(entityPlayer) || itemStack != null && itemStack.func_77973_b() instanceof IToolWrench) {
                    if (!world.field_72995_K) {
                        int n6;
                        if (!entityPlayer.func_70093_af()) {
                            n6 = tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4)) + 1;
                            if (n6 > 15) {
                                n6 = 0;
                            }
                        } else {
                            n6 = tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4)) - 1;
                            if (n6 < 0) {
                                n6 = 15;
                            }
                        }
                        tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), n6);
                        world.func_72845_h(n, n2, n3);
                        return true;
                    }
                } else if (itemStack != null && itemStack.field_77993_c == Item.field_77756_aW.field_77779_bT && !world.field_72995_K) {
                    tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), 15 - itemStack.func_77960_j());
                    world.func_72845_h(n, n2, n3);
                    return true;
                }
            } else if (MFRUtil.isHoldingHammer(entityPlayer) || itemStack != null && itemStack.func_77973_b() instanceof IToolWrench) {
                byte by = tileEntityRedNetCable.getMode();
                if ((by = (byte)(by + 1)) > 2) {
                    by = 0;
                }
                tileEntityRedNetCable.setMode(by);
                if (!world.field_72995_K) {
                    PacketDispatcher.sendPacketToAllAround((double)n, (double)n2, (double)n3, (double)50.0, (int)world.field_73011_w.field_76574_g, (Packet)tileEntityRedNetCable.func_70319_e());
                    if (by == 0) {
                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.standard"));
                    } else if (by == 1) {
                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.forced"));
                    } else if (by == 2) {
                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.cableonly"));
                    }
                }
            }
        }
        return false;
    }

    public void func_71902_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            for (AxisAlignedBB axisAlignedBB : this.getParts((TileEntityRedNetCable)tileEntity)) {
                if (axisAlignedBB == null) continue;
                f = Math.min(f, (float)axisAlignedBB.field_72340_a);
                f2 = Math.min(f2, (float)axisAlignedBB.field_72338_b);
                f3 = Math.min(f3, (float)axisAlignedBB.field_72339_c);
                f4 = Math.max(f4, (float)axisAlignedBB.field_72336_d);
                f5 = Math.max(f5, (float)axisAlignedBB.field_72337_e);
                f6 = Math.max(f6, (float)axisAlignedBB.field_72334_f);
            }
            this.func_71905_a(f, f2, f3, f4, f5, f6);
        } else {
            super.func_71902_a(iBlockAccess, n, n2, n3);
        }
    }

    public void func_71871_a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            for (AxisAlignedBB axisAlignedBB2 : this.getParts((TileEntityRedNetCable)tileEntity)) {
                if (axisAlignedBB2 == null) continue;
                axisAlignedBB2 = AxisAlignedBB.func_72330_a((double)axisAlignedBB2.field_72340_a, (double)axisAlignedBB2.field_72338_b, (double)axisAlignedBB2.field_72339_c, (double)axisAlignedBB2.field_72336_d, (double)axisAlignedBB2.field_72337_e, (double)axisAlignedBB2.field_72334_f);
                axisAlignedBB2.field_72340_a += (double)n;
                axisAlignedBB2.field_72336_d += (double)n;
                axisAlignedBB2.field_72338_b += (double)n2;
                axisAlignedBB2.field_72337_e += (double)n2;
                axisAlignedBB2.field_72339_c += (double)n3;
                axisAlignedBB2.field_72334_f += (double)n3;
                if (!axisAlignedBB.func_72326_a(axisAlignedBB2)) continue;
                list.add(axisAlignedBB2);
            }
        } else {
            super.func_71871_a(world, n, n2, n3, axisAlignedBB, list, entity);
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        super.func_71863_a(world, n, n2, n3, n4);
        if (n4 == this.field_71990_ca || world.field_72995_K) {
            return;
        }
        RedstoneNetwork.log("Cable block at %d, %d, %d got update from ID %d", n, n2, n3, n4);
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            ((TileEntityRedNetCable)tileEntity).onNeighboorChanged();
        }
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable && ((TileEntityRedNetCable)tileEntity).getNetwork() != null) {
            ((TileEntityRedNetCable)tileEntity).getNetwork().setInvalid();
        }
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition blockPosition = new BlockPosition(n, n2, n3);
            blockPosition.orientation = forgeDirection;
            blockPosition.moveForwards(1);
            world.func_72821_m(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
            world.func_72898_h(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public int func_71865_a(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = 0;
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getConnectionState(ForgeDirection.getOrientation((int)n4).getOpposite());
            if (tileEntityRedNetCable.getNetwork() == null || !redNetConnectionType.isConnected || redNetConnectionType.isAllSubnets) {
                return 0;
            }
            int n6 = ((TileEntityRedNetCable)tileEntity).getSideColor(ForgeDirection.getOrientation((int)n4).getOpposite());
            n5 = Math.min(Math.max(((TileEntityRedNetCable)tileEntity).getNetwork().getPowerLevelOutput(n6), 0), 15);
            RedstoneNetwork.log("Asked for weak power at " + n + "," + n2 + "," + n3 + " - got " + n5 + " from network " + ((TileEntityRedNetCable)tileEntity).getNetwork().getId() + ":" + n6, new Object[0]);
        }
        return n5;
    }

    public int func_71855_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = 0;
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getConnectionState(ForgeDirection.getOrientation((int)n4).getOpposite());
            if (tileEntityRedNetCable.getNetwork() == null || !redNetConnectionType.isConnected || redNetConnectionType.isAllSubnets) {
                return 0;
            }
            BlockPosition blockPosition = new BlockPosition(n, n2, n3, ForgeDirection.getOrientation((int)n4).getOpposite());
            blockPosition.moveForwards(1);
            int n6 = tileEntityRedNetCable.getSideColor(blockPosition.orientation);
            if (tileEntityRedNetCable.getNetwork().isWeakNode(blockPosition)) {
                n5 = 0;
                RedstoneNetwork.log("Asked for strong power at " + n + "," + n2 + "," + n3 + " - weak node, power 0", new Object[0]);
            } else {
                n5 = Math.min(Math.max(tileEntityRedNetCable.getNetwork().getPowerLevelOutput(n6), 0), 15);
                RedstoneNetwork.log("Asked for strong power at " + n + "," + n2 + "," + n3 + " - got " + n5 + " from network " + ((TileEntityRedNetCable)tileEntity).getNetwork().getId() + ":" + n6, new Object[0]);
            }
        }
        return n5;
    }

    public boolean isBlockSolidOnSide(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_71853_i() {
        return true;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityRedNetCable();
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdRedstoneCable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a());
    }

    @Override
    public void updateNetwork(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable && ((TileEntityRedNetCable)tileEntity).getNetwork() != null) {
            ((TileEntityRedNetCable)tileEntity).getNetwork().updatePowerLevels();
        }
    }

    @Override
    public void updateNetwork(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable && ((TileEntityRedNetCable)tileEntity).getNetwork() != null) {
            ((TileEntityRedNetCable)tileEntity).getNetwork().updatePowerLevels(n4);
        }
    }
}

