/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.client;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;
import powercrystals.core.gui.GuiScreenBase;
import powercrystals.core.gui.controls.Button;
import powercrystals.core.gui.controls.IListBoxElement;
import powercrystals.core.gui.controls.ListBox;
import powercrystals.core.gui.controls.SliderVertical;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedClient;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.gui.control.ButtonLogicBufferSelect;
import powercrystals.minefactoryreloaded.gui.control.ButtonLogicPinSelect;
import powercrystals.minefactoryreloaded.gui.control.ListBoxElementCircuit;
import powercrystals.minefactoryreloaded.gui.control.LogicButtonType;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

public class GuiRedNetLogic
extends GuiScreenBase {
    private TileEntityRedNetLogic _logic;
    private int _selectedCircuit;
    private ListBox _circuitList;
    private SliderVertical _circuitScroll;
    private ButtonLogicBufferSelect[] _inputIOBufferButtons = new ButtonLogicBufferSelect[16];
    private ButtonLogicBufferSelect[] _outputIOBufferButtons = new ButtonLogicBufferSelect[16];
    private ButtonLogicPinSelect[] _inputIOPinButtons = new ButtonLogicPinSelect[16];
    private ButtonLogicPinSelect[] _outputIOPinButtons = new ButtonLogicPinSelect[16];
    private Button _nextCircuit;
    private Button _prevCircuit;
    private Button _reinit;
    private Button _reinitConfirm;
    private int _reinitCountdown;

    public GuiRedNetLogic(Container container, TileEntityRedNetLogic tileEntityRedNetLogic) {
        super(container, "minefactoryreloaded:textures/gui/rednetlogic.png");
        this.field_74194_b = 384;
        this.field_74195_c = 256;
        this._logic = tileEntityRedNetLogic;
        this._circuitList = new ListBox((GuiContainer)this, 86, 16, 130, 234){

            protected void onSelectionChanged(int n, IListBoxElement iListBoxElement) {
            }

            protected void onElementClicked(IListBoxElement iListBoxElement) {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket((String)"MFReloaded", (int)14, (Object[])new Object[]{((GuiRedNetLogic)GuiRedNetLogic.this)._logic.field_70329_l, ((GuiRedNetLogic)GuiRedNetLogic.this)._logic.field_70330_m, ((GuiRedNetLogic)GuiRedNetLogic.this)._logic.field_70327_n, GuiRedNetLogic.this._selectedCircuit, iListBoxElement.getValue().getClass().getName()}));
            }

            protected void onScroll(int n) {
                GuiRedNetLogic.this._circuitScroll.setValue(n);
            }
        };
        LinkedList<IRedNetLogicCircuit> linkedList = new LinkedList<IRedNetLogicCircuit>(MFRRegistry.getRedNetLogicCircuits());
        Collections.sort(linkedList, new CircuitComparator());
        for (IRedNetLogicCircuit iRedNetLogicCircuit : linkedList) {
            this._circuitList.add((IListBoxElement)new ListBoxElementCircuit(iRedNetLogicCircuit));
        }
        this.addControl((Control)this._circuitList);
        this._circuitScroll = new SliderVertical((GuiContainer)this, 218, 16, 10, 234, this._circuitList.getLastScrollPosition()){

            public void onValueChanged(int n) {
                GuiRedNetLogic.this._circuitList.scrollTo(n);
            }
        };
        this.addControl((Control)this._circuitScroll);
        this._prevCircuit = new Button((GuiContainer)this, 344, 16, 30, 30, "Prev"){

            public void onClick() {
                GuiRedNetLogic.this._selectedCircuit--;
                if (GuiRedNetLogic.this._selectedCircuit < 0) {
                    GuiRedNetLogic.this._selectedCircuit = GuiRedNetLogic.this._logic.getCircuitCount() - 1;
                }
                MineFactoryReloadedClient.prcPages.put(new BlockPosition((TileEntity)GuiRedNetLogic.this._logic), GuiRedNetLogic.this._selectedCircuit);
                GuiRedNetLogic.this.requestCircuit();
            }
        };
        this._nextCircuit = new Button((GuiContainer)this, 344, 76, 30, 30, "Next"){

            public void onClick() {
                GuiRedNetLogic.this._selectedCircuit++;
                if (GuiRedNetLogic.this._selectedCircuit >= GuiRedNetLogic.this._logic.getCircuitCount()) {
                    GuiRedNetLogic.this._selectedCircuit = 0;
                }
                MineFactoryReloadedClient.prcPages.put(new BlockPosition((TileEntity)GuiRedNetLogic.this._logic), GuiRedNetLogic.this._selectedCircuit);
                GuiRedNetLogic.this.requestCircuit();
            }
        };
        this.addControl((Control)this._prevCircuit);
        this.addControl((Control)this._nextCircuit);
        this._reinit = new Button((GuiContainer)this, 316, 228, 60, 20, "Reinitialize"){

            public void onClick() {
                GuiRedNetLogic.this._reinitCountdown = 40;
            }
        };
        this._reinitConfirm = new Button((GuiContainer)this, 316, 228, 60, 20, "Confirm"){

            public void onClick() {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket((String)"MFReloaded", (int)16, (Object[])new Object[]{((GuiRedNetLogic)GuiRedNetLogic.this)._logic.field_70329_l, ((GuiRedNetLogic)GuiRedNetLogic.this)._logic.field_70330_m, ((GuiRedNetLogic)GuiRedNetLogic.this)._logic.field_70327_n}));
                GuiRedNetLogic.this._reinitCountdown = 0;
            }
        };
        this.addControl((Control)this._reinit);
        this.addControl((Control)this._reinitConfirm);
        this._reinitConfirm.setVisible(false);
        int n = tileEntityRedNetLogic.field_70331_k.func_72805_g(tileEntityRedNetLogic.field_70329_l, tileEntityRedNetLogic.field_70330_m, tileEntityRedNetLogic.field_70327_n);
        for (int i = 0; i < this._inputIOPinButtons.length; ++i) {
            this._inputIOBufferButtons[i] = new ButtonLogicBufferSelect(this, 22, 16 + i * 14, i, LogicButtonType.Input, n);
            this._inputIOPinButtons[i] = new ButtonLogicPinSelect(this, 52, 16 + i * 14, i, LogicButtonType.Input);
            this._outputIOBufferButtons[i] = new ButtonLogicBufferSelect(this, 254, 16 + i * 14, i, LogicButtonType.Output, n);
            this._outputIOPinButtons[i] = new ButtonLogicPinSelect(this, 284, 16 + i * 14, i, LogicButtonType.Output);
            this.addControl((Control)this._inputIOBufferButtons[i]);
            this.addControl((Control)this._outputIOBufferButtons[i]);
            this.addControl((Control)this._inputIOPinButtons[i]);
            this.addControl((Control)this._outputIOPinButtons[i]);
        }
        Integer n2 = MineFactoryReloadedClient.prcPages.get(new BlockPosition((TileEntity)this._logic));
        if (n2 != null && n2 < this._logic.getCircuitCount()) {
            this._selectedCircuit = n2;
        }
        this.requestCircuit();
    }

    public TileEntityRedNetLogic.PinMapping getInputPin(int n) {
        return this._logic.getInputPinMapping(this._selectedCircuit, n);
    }

    public TileEntityRedNetLogic.PinMapping getOutputPin(int n) {
        return this._logic.getOutputPinMapping(this._selectedCircuit, n);
    }

    private void requestCircuit() {
        PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket((String)"MFReloaded", (int)13, (Object[])new Object[]{this._logic.field_70329_l, this._logic.field_70330_m, this._logic.field_70327_n, this._selectedCircuit}));
    }

    public void func_73876_c() {
        int n;
        if (((IRedNetLogicCircuit)this._circuitList.getSelectedElement().getValue()).getClass() != this._logic.getCircuit(this._selectedCircuit).getClass()) {
            for (n = 0; n < this._circuitList.getElementCount(); ++n) {
                if (((IRedNetLogicCircuit)this._circuitList.getElement(n).getValue()).getClass() != this._logic.getCircuit(this._selectedCircuit).getClass()) continue;
                this._circuitList.setSelectedIndex(n);
                this._circuitScroll.setValue(Math.min(n, this._circuitList.getLastScrollPosition()));
                break;
            }
        }
        for (n = 0; n < this._inputIOPinButtons.length; ++n) {
            if (n < this._logic.getCircuit(this._selectedCircuit).getInputCount()) {
                this._inputIOPinButtons[n].setVisible(true);
                this._inputIOBufferButtons[n].setVisible(true);
                this._inputIOPinButtons[n].setPin(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).pin);
                this._inputIOPinButtons[n].setBuffer(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                this._inputIOBufferButtons[n].setBuffer(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                continue;
            }
            this._inputIOBufferButtons[n].setVisible(false);
            this._inputIOPinButtons[n].setVisible(false);
        }
        for (n = 0; n < this._outputIOPinButtons.length; ++n) {
            if (n < this._logic.getCircuit(this._selectedCircuit).getOutputCount()) {
                this._outputIOBufferButtons[n].setVisible(true);
                this._outputIOPinButtons[n].setVisible(true);
                this._outputIOPinButtons[n].setPin(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).pin);
                this._outputIOPinButtons[n].setBuffer(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                this._outputIOBufferButtons[n].setBuffer(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                continue;
            }
            this._outputIOBufferButtons[n].setVisible(false);
            this._outputIOPinButtons[n].setVisible(false);
        }
        if (this._reinitCountdown > 0) {
            --this._reinitCountdown;
        }
        this._reinit.setVisible(this._reinitCountdown == 0);
        this._reinitConfirm.setVisible(this._reinitCountdown > 0);
    }

    protected void func_74189_g(int n, int n2) {
        int n3;
        super.func_74189_g(n, n2);
        this.field_73886_k.func_78276_b("Programmable RedNet Controller", 8, 6, 0x404040);
        this.field_73886_k.func_78276_b(this._selectedCircuit + 1 + " of " + this._logic.getCircuitCount(), 336, 60, 0x404040);
        for (n3 = 0; n3 < this._inputIOPinButtons.length; ++n3) {
            if (n3 >= this._logic.getCircuit(this._selectedCircuit).getInputCount()) continue;
            this.field_73886_k.func_78276_b(this._logic.getCircuit(this._selectedCircuit).getInputPinLabel(n3), 4, 20 + n3 * 14, 0x404040);
        }
        for (n3 = 0; n3 < this._outputIOPinButtons.length; ++n3) {
            if (n3 >= this._logic.getCircuit(this._selectedCircuit).getOutputCount()) continue;
            this.field_73886_k.func_78276_b(this._logic.getCircuit(this._selectedCircuit).getOutputPinLabel(n3), 232, 20 + n3 * 14, 0x404040);
        }
    }

    public void setInputPinMapping(int n, int n2, int n3) {
        PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket((String)"MFReloaded", (int)15, (Object[])new Object[]{this._logic.field_70329_l, this._logic.field_70330_m, this._logic.field_70327_n, 0, this._selectedCircuit, n, n2, n3}));
    }

    public void setOutputPinMapping(int n, int n2, int n3) {
        PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket((String)"MFReloaded", (int)15, (Object[])new Object[]{this._logic.field_70329_l, this._logic.field_70330_m, this._logic.field_70327_n, 1, this._selectedCircuit, n, n2, n3}));
    }

    public int getVariableCount() {
        return this._logic.getVariableBufferSize();
    }

    protected void func_74185_a(float f, int n, int n2) {
        n -= this.field_74198_m;
        n2 -= this.field_74197_n;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(this._backgroundTexture);
        this.drawLargeTexturedModalRect(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_74198_m, (float)this.field_74197_n, (float)0.0f);
        for (Control control : this._controls) {
            if (!control.getVisible()) continue;
            control.drawBackground(n, n2, f);
        }
        GL11.glPopMatrix();
    }

    public void drawLargeTexturedModalRect(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.0026041667f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n6), (double)this.field_73735_i, (double)((float)(n3 + 0) * f), (double)((float)(n4 + n6) * f2));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + n6), (double)this.field_73735_i, (double)((float)(n3 + n5) * f), (double)((float)(n4 + n6) * f2));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + 0), (double)this.field_73735_i, (double)((float)(n3 + n5) * f), (double)((float)(n4 + 0) * f2));
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)this.field_73735_i, (double)((float)(n3 + 0) * f), (double)((float)(n4 + 0) * f2));
        tessellator.func_78381_a();
    }

    private class CircuitComparator
    implements Comparator<IRedNetLogicCircuit> {
        private CircuitComparator() {
        }

        @Override
        public int compare(IRedNetLogicCircuit iRedNetLogicCircuit, IRedNetLogicCircuit iRedNetLogicCircuit2) {
            return StatCollector.func_74838_a((String)iRedNetLogicCircuit.getUnlocalizedName()).compareTo(StatCollector.func_74838_a((String)iRedNetLogicCircuit2.getUnlocalizedName()));
        }
    }
}

