/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.control;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import powercrystals.core.gui.GuiColor;
import powercrystals.core.gui.GuiRender;
import powercrystals.core.gui.controls.Button;
import powercrystals.minefactoryreloaded.gui.client.GuiRedNetLogic;
import powercrystals.minefactoryreloaded.gui.control.LogicButtonType;
import powercrystals.minefactoryreloaded.setup.MFRConfig;

public class ButtonLogicPinSelect
extends Button {
    private static GuiColor[] _pinColors = new GuiColor[]{new GuiColor(223, 223, 223), new GuiColor(219, 125, 63), new GuiColor(180, 81, 188), new GuiColor(107, 138, 207), new GuiColor(177, 166, 39), new GuiColor(66, 174, 57), new GuiColor(208, 132, 153), new GuiColor(65, 65, 65), new GuiColor(155, 155, 155), new GuiColor(47, 111, 137), new GuiColor(127, 62, 182), new GuiColor(46, 57, 141), new GuiColor(79, 50, 31), new GuiColor(53, 71, 28), new GuiColor(151, 52, 49), new GuiColor(22, 22, 26)};
    private static String[] _pinColorNames = new String[]{"WHIT", "ORNG", "MGTA", "L_BL", "YLLW", "LIME", "PINK", "GRAY", "L_GR", "CYAN", "PURP", "BLUE", "BRWN", "GRN", "RED", "BLK"};
    private int _pinIndex;
    private LogicButtonType _buttonType;
    private GuiRedNetLogic _containerScreen;
    private int _pin;
    private int _buffer;

    public ButtonLogicPinSelect(GuiRedNetLogic guiRedNetLogic, int n, int n2, int n3, LogicButtonType logicButtonType) {
        super((GuiContainer)guiRedNetLogic, n, n2, 30, 14, "");
        this._pinIndex = n3;
        this._buttonType = logicButtonType;
        this._containerScreen = guiRedNetLogic;
        this.setVisible(false);
    }

    public int getBuffer() {
        return this._buffer;
    }

    public void setBuffer(int n) {
        this._buffer = n;
    }

    public int getPin() {
        return this._pin;
    }

    public void setPin(int n) {
        this._pin = n;
        this.setText(Integer.valueOf(this._pin).toString());
    }

    public void onClick() {
        ++this._pin;
        if (this._buffer == 14 && this._pin > 0 || this._buffer == 13 && this._pin >= this._containerScreen.getVariableCount() || this._buffer == 12 && this._pin > 255 || this._buffer < 12 && this._pin > 15) {
            this._pin = 0;
        }
        this.updatePin();
    }

    public void onRightClick() {
        --this._pin;
        if (this._pin < 0) {
            this._pin = this._buffer == 14 ? 0 : (this._buffer == 13 ? this._containerScreen.getVariableCount() - 1 : (this._buffer == 12 ? 255 : 15));
        }
        this.updatePin();
    }

    public void onMiddleClick() {
        if (this._buffer == 13) {
            this._pin += 16;
            if (this._pin >= this._containerScreen.getVariableCount()) {
                this._pin -= this._containerScreen.getVariableCount();
            }
            this.updatePin();
        } else if (this._buffer == 12) {
            this._pin += 16;
            if (this._pin >= 256) {
                this._pin -= 256;
            }
            this.updatePin();
        } else {
            this.onClick();
        }
    }

    private void updatePin() {
        this.setText(Integer.valueOf(this._pin).toString());
        if (this._buttonType == LogicButtonType.Input) {
            this._containerScreen.setInputPinMapping(this._pinIndex, this._buffer, this._pin);
        } else {
            this._containerScreen.setOutputPinMapping(this._pinIndex, this._buffer, this._pin);
        }
    }

    public void drawForeground(int n, int n2) {
        if (this._buffer < 12) {
            if (!MFRConfig.colorblindMode.getBoolean(false)) {
                GuiRender.drawRect((int)(this.x + 3), (int)(this.y + 3), (int)(this.x + this.width - 3), (int)(this.y + this.height - 3), (int)_pinColors[this._pin].getColor());
            } else {
                GuiRender.drawCenteredString((FontRenderer)this.containerScreen.field_73886_k, (String)_pinColorNames[this._pin], (int)(this.x + this.width / 2), (int)(this.y + this.height / 2 - 4), (int)this.getTextColor(n, n2));
            }
        } else if (this._buffer < 14) {
            super.drawForeground(n, n2);
        }
    }
}

