/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.modhelpers.forestry.fertilizer.FertilizerForestry;
import powercrystals.minefactoryreloaded.modhelpers.forestry.leaves.FertilizableForestryLeaves;
import powercrystals.minefactoryreloaded.modhelpers.forestry.leaves.FruitForestry;
import powercrystals.minefactoryreloaded.modhelpers.forestry.pods.FertilizableForestryPods;
import powercrystals.minefactoryreloaded.modhelpers.forestry.pods.FruitForestryPod;
import powercrystals.minefactoryreloaded.modhelpers.forestry.trees.FertilizableForestryTree;
import powercrystals.minefactoryreloaded.modhelpers.forestry.trees.HarvestableForestryTree;
import powercrystals.minefactoryreloaded.modhelpers.forestry.trees.PlantableForestryTree;
import powercrystals.minefactoryreloaded.modhelpers.forestry.utils.ForestryUtils;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityUnifier;

@Mod(modid="MineFactoryReloaded|CompatForestry", name="MFR Compat: Forestry", version="1.6.2R2.7.1", dependencies="after:MineFactoryReloaded;after:Forestry")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Forestry {
    @Mod.EventHandler
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        if (!Loader.isModLoaded((String)"Forestry")) {
            FMLLog.warning((String)"Forestry missing - MFR Forestry Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> clazz = Class.forName("forestry.core.config.ForestryItem");
            if (clazz != null) {
                Field[] fieldArray = (Field[])clazz.getField("peat").get(null);
                MFRRegistry.registerSludgeDrop(5, new ItemStack((Item)fieldArray));
            }
            MFRRegistry.registerPlantable(new PlantableForestryTree());
            MFRRegistry.registerFertilizable(new FertilizableForestryTree());
            for (Field field : Class.forName("forestry.core.config.ForestryBlock").getDeclaredFields()) {
                Block block;
                if (field.getName().contains("log")) {
                    block = (Block)field.get(null);
                    if (block == null) continue;
                    MFRRegistry.registerHarvestable(new HarvestableForestryTree(block.field_71990_ca));
                    MFRRegistry.registerFruitLogBlockId(block.field_71990_ca);
                    continue;
                }
                if (field.getName().contains("leaves")) {
                    block = (Block)field.get(null);
                    if (block == null) continue;
                    MFRRegistry.registerFruit(new FruitForestry(block.field_71990_ca));
                    MFRRegistry.registerFertilizable(new FertilizableForestryLeaves(block.field_71990_ca));
                    continue;
                }
                if (!field.getName().contains("pods") || (block = (Block)field.get(null)) == null) continue;
                MFRRegistry.registerFruit(new FruitForestryPod(block.field_71990_ca));
                MFRRegistry.registerFertilizable(new FertilizableForestryPods(block.field_71990_ca));
            }
            MFRRegistry.registerFertilizer(new FertilizerForestry(ForestryUtils.getItem("fertilizerCompound")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        if (!Loader.isModLoaded((String)"Forestry")) {
            return;
        }
        MineFactoryReloadedCore.proxy.onPostTextureStitch(null);
        ForestryUtils.setTreeRoot();
        TileEntityUnifier.updateUnifierLiquids();
    }
}

