/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry.leaves;

import forestry.api.genetics.IFruitBearer;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.BonemealEvent;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.modhelpers.forestry.utils.ForestryUtils;

public class FertilizableForestryLeaves
implements IFactoryFertilizable {
    private int _id;

    public FertilizableForestryLeaves(int n) {
        this._id = n;
    }

    @Override
    public int getFertilizableBlockId() {
        return this._id;
    }

    @Override
    public boolean canFertilizeBlock(World world, int n, int n2, int n3, FertilizerType fertilizerType) {
        return world.func_72798_a(n, n2, n3) == this.getFertilizableBlockId();
    }

    @Override
    public boolean fertilize(World world, Random random, int n, int n2, int n3, FertilizerType fertilizerType) {
        IFruitBearer iFruitBearer;
        if (world.func_72798_a(n, n2, n3) == this.getFertilizableBlockId() && (iFruitBearer = ForestryUtils.getFruitBearer(world.func_72796_p(n, n2, n3))).hasFruit() && iFruitBearer.getRipeness() < 1.0f) {
            BonemealEvent bonemealEvent = new BonemealEvent(null, world, 1, n, n2, n3);
            MinecraftForge.EVENT_BUS.post((Event)bonemealEvent);
            if (bonemealEvent.getResult().equals((Object)Event.Result.ALLOW)) {
                return true;
            }
        }
        return false;
    }
}

