/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.transport.IPipeConnection;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedClient;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;

public abstract class TileEntityFactory
extends TileEntity
implements IRotateableTile,
IPipeConnection {
    private static final int[][] _textureSelection = new int[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 3, 2, 5, 4}, {0, 1, 5, 4, 2, 3}, {0, 1, 4, 5, 3, 2}};
    private ForgeDirection _forwardDirection = ForgeDirection.NORTH;
    private boolean _isActive;
    protected int _rednetState;

    protected TileEntityFactory() {
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K && this instanceof IHarvestAreaContainer) {
            MineFactoryReloadedClient.addTileToAreaList((IHarvestAreaContainer)((Object)this));
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_70331_k.field_72995_K && this instanceof IHarvestAreaContainer) {
            MineFactoryReloadedClient.removeTileFromAreaList((IHarvestAreaContainer)((Object)this));
        }
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public ForgeDirection getDirectionFacing() {
        return this._forwardDirection;
    }

    public boolean canRotate() {
        return false;
    }

    public void rotate() {
        if (!this.field_70331_k.field_72995_K) {
            this._forwardDirection = this._forwardDirection == ForgeDirection.NORTH ? ForgeDirection.EAST : (this._forwardDirection == ForgeDirection.EAST ? ForgeDirection.SOUTH : (this._forwardDirection == ForgeDirection.SOUTH ? ForgeDirection.WEST : (this._forwardDirection == ForgeDirection.WEST ? ForgeDirection.NORTH : ForgeDirection.NORTH)));
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
    }

    public void rotateDirectlyTo(int n) {
        this._forwardDirection = ForgeDirection.getOrientation((int)n);
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public int getRotatedSide(int n) {
        return _textureSelection[this._forwardDirection.ordinal()][n];
    }

    public ForgeDirection getDropDirection() {
        return this.getDirectionFacing().getOpposite();
    }

    public boolean getIsActive() {
        return this._isActive;
    }

    public void setIsActive(boolean bl) {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K && this._isActive != bl) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
        this._isActive = bl;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public String getGuiBackground() {
        return null;
    }

    public Packet func_70319_e() {
        Object[] objectArray = new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, this._forwardDirection.ordinal(), this._isActive};
        return PacketWrapper.createPacket((String)"MFReloaded", (int)1, (Object[])objectArray);
    }

    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        int n = nBTTagCompound.func_74762_e("rotation");
        this.rotateDirectlyTo(n);
    }

    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("rotation", this.getDirectionFacing().ordinal());
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public void onRedNetChanged(ForgeDirection forgeDirection, int n) {
        this._rednetState = n;
    }

    public int getRedNetOutput(ForgeDirection forgeDirection) {
        return 0;
    }
}

