/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoAnvil;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoAnvil
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private int maximumCost;
    private int stackSizeToBeUsedInRepair;
    private ItemStack _output;

    public TileEntityAutoAnvil() {
        super(Machine.AutoAnvil);
        this._tank = new FluidTank(4000);
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0 || n == 1;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 2;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public String getGuiBackground() {
        return "autoanvil.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoAnvil(this, inventoryPlayer);
    }

    @Override
    protected boolean activateMachine() {
        if (this._output == null) {
            return false;
        }
        if (this._tank.getFluid() == null || this._tank.getFluid().amount < 4) {
            return false;
        }
        if (this.stackSizeToBeUsedInRepair > 0 && (this._inventory[1] == null || this._inventory[1].field_77994_a < this.stackSizeToBeUsedInRepair)) {
            return false;
        }
        this._tank.drain(4, true);
        this.setWorkDone(this.getWorkDone() + 1);
        if (this.getWorkDone() >= this.getWorkMax()) {
            this._inventory[0] = null;
            this._inventory[2] = this._output;
            if (this.stackSizeToBeUsedInRepair > 0 && this._inventory[1].field_77994_a > this.stackSizeToBeUsedInRepair) {
                this._inventory[1].field_77994_a -= this.stackSizeToBeUsedInRepair;
            } else {
                this._inventory[1] = null;
            }
            this.setWorkDone(0);
            this._output = null;
        }
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        super.onFactoryInventoryChanged();
        this._output = this.getAnvilOutput();
        this.setWorkDone(0);
    }

    private ItemStack getAnvilOutput() {
        int n;
        int n2;
        int n3;
        ItemStack itemStack = this._inventory[0];
        this.maximumCost = 0;
        int n4 = 0;
        if (itemStack == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack.func_77946_l();
        ItemStack itemStack3 = this._inventory[1];
        Map map = EnchantmentHelper.func_82781_a((ItemStack)itemStack2);
        boolean bl = false;
        int n5 = itemStack2.func_82838_A() + (itemStack3 == null ? 0 : itemStack3.func_82838_A());
        this.stackSizeToBeUsedInRepair = 0;
        if (itemStack3 != null) {
            boolean bl2 = bl = itemStack3.field_77993_c == Item.field_92105_bW.field_77779_bT && Item.field_92105_bW.func_92110_g(itemStack3).func_74745_c() > 0;
            if (itemStack2.func_77984_f() && Item.field_77698_e[itemStack2.field_77993_c].func_82789_a(itemStack2, itemStack3)) {
                int n6;
                n3 = Math.min(itemStack2.func_77952_i(), itemStack2.func_77958_k() / 4);
                if (n3 <= 0) {
                    return null;
                }
                for (n6 = 0; n3 > 0 && n6 < itemStack3.field_77994_a; ++n6) {
                    itemStack2.func_77964_b(itemStack2.func_77952_i() - n3);
                    n4 += Math.max(1, n3 / 100) + map.size();
                    n3 = Math.min(itemStack2.func_77952_i(), itemStack2.func_77958_k() / 4);
                }
                this.stackSizeToBeUsedInRepair = n6;
            } else {
                if (!(bl || itemStack2.field_77993_c == itemStack3.field_77993_c && itemStack2.func_77984_f())) {
                    return null;
                }
                if (itemStack2.func_77984_f() && !bl) {
                    int n7 = itemStack2.func_77958_k() - itemStack2.func_77952_i();
                    int n8 = itemStack3.func_77958_k() - itemStack3.func_77952_i();
                    int n9 = n8 + itemStack2.func_77958_k() * 12 / 100;
                    int n10 = n7 + n9;
                    n2 = itemStack2.func_77958_k() - n10;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 < itemStack2.func_77960_j()) {
                        itemStack2.func_77964_b(n2);
                        n4 += Math.max(1, n9 / 100);
                    }
                }
                Map map2 = EnchantmentHelper.func_82781_a((ItemStack)itemStack3);
                for (Integer n11 : map2.keySet()) {
                    Enchantment enchantment = Enchantment.field_77331_b[n11];
                    n2 = map.containsKey(n11) ? (Integer)map.get(n11) : 0;
                    n = (Integer)map2.get(n11);
                    int n12 = n2 == n ? ++n : Math.max(n, n2);
                    n = n12;
                    int n13 = n - n2;
                    boolean bl3 = enchantment.func_92089_a(itemStack2);
                    if (itemStack2.field_77993_c == ItemEnchantedBook.field_92105_bW.field_77779_bT) {
                        bl3 = true;
                    }
                    for (Integer n14 : map.keySet()) {
                        if (n14 == n11 || enchantment.func_77326_a(Enchantment.field_77331_b[n14])) continue;
                        bl3 = false;
                        n4 += n13;
                    }
                    if (!bl3) continue;
                    if (n12 > enchantment.func_77325_b()) {
                        n12 = enchantment.func_77325_b();
                    }
                    map.put(Integer.valueOf(n11), n12);
                    int n15 = 0;
                    switch (enchantment.func_77324_c()) {
                        case 1: {
                            n15 = 8;
                            break;
                        }
                        case 2: {
                            n15 = 4;
                        }
                        default: {
                            break;
                        }
                        case 5: {
                            n15 = 2;
                            break;
                        }
                        case 10: {
                            n15 = 1;
                        }
                    }
                    if (bl) {
                        n15 = Math.max(1, n15 / 2);
                    }
                    n4 += n15 * n13;
                }
            }
        }
        n3 = 0;
        for (Integer n16 : map.keySet()) {
            Enchantment enchantment = Enchantment.field_77331_b[n16];
            n2 = (Integer)map.get(n16);
            n = 0;
            ++n3;
            switch (enchantment.func_77324_c()) {
                case 1: {
                    n = 8;
                    break;
                }
                case 2: {
                    n = 4;
                }
                default: {
                    break;
                }
                case 5: {
                    n = 2;
                    break;
                }
                case 10: {
                    n = 1;
                }
            }
            if (bl) {
                n = Math.max(1, n / 2);
            }
            n5 += n3 + n2 * n;
        }
        if (bl) {
            n5 = Math.max(1, n5 / 2);
        }
        if (bl && !Item.field_77698_e[itemStack2.field_77993_c].isBookEnchantable(itemStack2, itemStack3)) {
            itemStack2 = null;
        }
        this.maximumCost = n5 + n4;
        if (n4 <= 0) {
            itemStack2 = null;
        }
        if (itemStack2 != null) {
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemStack2);
        }
        return itemStack2;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 100 * this.maximumCost;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && FluidRegistry.getFluid((String)"mobessence").equals(fluidStack.getFluid())) {
            return this._tank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    @Override
    public IFluidTank getTank(ForgeDirection forgeDirection, FluidStack fluidStack) {
        if (fluidStack != null && FluidRegistry.getFluid((String)"mobessence").equals(fluidStack.getFluid())) {
            return this._tank;
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

