/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoSpawner;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoSpawner;
import powercrystals.minefactoryreloaded.item.ItemSafariNet;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoSpawner
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private static final int _spawnRange = 4;
    private boolean _spawnExact = false;

    public TileEntityAutoSpawner() {
        super(Machine.AutoSpawner);
        this._tank = new FluidTank(4000);
    }

    public boolean getSpawnExact() {
        return this._spawnExact;
    }

    public void setSpawnExact(boolean bl) {
        this._spawnExact = bl;
    }

    @Override
    public String getGuiBackground() {
        return "autospawner.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoSpawner(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerAutoSpawner getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoSpawner(this, inventoryPlayer);
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    protected boolean activateMachine() {
        Class clazz;
        ItemStack itemStack = this.func_70301_a(0);
        if (!this.func_94041_b(0, itemStack)) {
            this.setWorkDone(0);
            return false;
        }
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        String string = nBTTagCompound.func_74779_i("id");
        boolean bl = MFRRegistry.getAutoSpawnerBlacklist().contains(string);
        if (!bl) {
            clazz = (Class)EntityList.field_75625_b.get(string);
            if (clazz == null) {
                bl = true;
            } else {
                for (Class<?> nBTTagCompound2 : MFRRegistry.getAutoSpawnerClassBlacklist()) {
                    if (!nBTTagCompound2.isAssignableFrom(clazz)) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            this.setWorkDone(0);
            return false;
        }
        if (this.getWorkDone() < this.getWorkMax()) {
            if (this._tank.getFluid() != null && this._tank.getFluid().amount >= 10) {
                this._tank.getFluid().amount -= 10;
                this.setWorkDone(this.getWorkDone() + 1);
                return true;
            }
            return false;
        }
        clazz = EntityList.func_75620_a((String)string, (World)this.field_70331_k);
        if (!(clazz instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)clazz;
        if (this._spawnExact) {
            NBTTagCompound d = (NBTTagCompound)nBTTagCompound.func_74737_b();
            entityLivingBase.func_70037_a(d);
            for (int i = 0; i < 5; ++i) {
                if (!(entityLivingBase instanceof EntityLiving)) continue;
                ((EntityLiving)entityLivingBase).func_96120_a(i, 0.0f);
            }
        }
        double d = (double)this.field_70329_l + (this.field_70331_k.field_73012_v.nextDouble() - this.field_70331_k.field_73012_v.nextDouble()) * 4.0;
        double d2 = this.field_70330_m + this.field_70331_k.field_73012_v.nextInt(3) - 1;
        double d3 = (double)this.field_70327_n + (this.field_70331_k.field_73012_v.nextDouble() - this.field_70331_k.field_73012_v.nextDouble()) * 4.0;
        entityLivingBase.func_70012_b(d, d2, d3, this.field_70331_k.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!this.field_70331_k.func_72855_b(entityLivingBase.field_70121_D) || !this.field_70331_k.func_72945_a((Entity)entityLivingBase, entityLivingBase.field_70121_D).isEmpty() || this.field_70331_k.func_72953_d(entityLivingBase.field_70121_D) != entityLivingBase instanceof EntityWaterMob) {
            return false;
        }
        if (!this._spawnExact && entityLivingBase instanceof EntityLiving) {
            ((EntityLiving)entityLivingBase).func_110161_a(null);
        }
        this.field_70331_k.func_72838_d((Entity)entityLivingBase);
        this.field_70331_k.func_72926_e(2004, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        if (entityLivingBase instanceof EntityLiving) {
            ((EntityLiving)entityLivingBase).func_70656_aK();
        }
        this.setWorkDone(0);
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return this._spawnExact ? MFRConfig.autospawnerCostExact.getInt() : MFRConfig.autospawnerCostStandard.getInt();
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !fluidStack.isFluidEqual(FluidRegistry.getFluidStack((String)"mobessence", (int)1))) {
            return 0;
        }
        return this._tank.fill(fluidStack, bl);
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    @Override
    public IFluidTank getTank(ForgeDirection forgeDirection, FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.isFluidEqual(FluidRegistry.getFluidStack((String)"mobessence", (int)1))) {
            return this._tank;
        }
        return null;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.func_94041_b(n, itemStack);
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return ItemSafariNet.isSafariNet(itemStack) && !ItemSafariNet.isSingleUse(itemStack) && !ItemSafariNet.isEmpty(itemStack);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._spawnExact = nBTTagCompound.func_74767_n("spawnExact");
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("spawnExact", this._spawnExact);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

