/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiSewer;
import powercrystals.minefactoryreloaded.gui.container.ContainerSewer;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntitySewer
extends TileEntityFactoryInventory
implements ITankContainerBucketable,
IHarvestAreaContainer {
    private HarvestAreaManager _areaManager;
    private int _tick;
    private long _nextSewerCheckTick;
    private boolean _jammed;
    private FluidTank[] _tanks = new FluidTank[]{new FluidTank(1000), new FluidTank(1000)};

    public TileEntitySewer() {
        super(Machine.Sewer);
        this._areaManager = new HarvestAreaManager(this, 0, 1, 0);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
    }

    @Override
    public String getGuiBackground() {
        return "sewagecollector.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiSewer(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerSewer getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerSewer(this, inventoryPlayer);
    }

    @Override
    public IFluidTank[] getTanks() {
        return this._tanks;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public HarvestAreaManager getHAM() {
        return this._areaManager;
    }

    @Override
    public void func_70316_g() {
        Object object;
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ++this._tick;
        if (this._nextSewerCheckTick <= this.field_70331_k.func_82737_E()) {
            object = new Area(BlockPosition.fromFactoryTile((IRotateableTile)this), this._areaManager.getRadius(), 0, 0);
            this._jammed = false;
            for (BlockPosition blockPosition : object.getPositionsBottomFirst()) {
                if (this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z) != MineFactoryReloadedCore.machineBlocks.get((Object)Integer.valueOf((int)0)).field_71990_ca || this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z) != Machine.Sewer.getMeta() || blockPosition.x == this.field_70329_l && blockPosition.y == this.field_70330_m && blockPosition.z == this.field_70327_n) continue;
                this._jammed = true;
                break;
            }
            this._nextSewerCheckTick = this.field_70331_k.func_82737_E() + 800L + (long)this.field_70331_k.field_73012_v.nextInt(800);
        }
        if (this._tick >= 31 && !this._jammed) {
            int n;
            Object object2;
            this._tick = 0;
            object = this.field_70331_k.func_72872_a(EntityLivingBase.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
            double d = 0.0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 instanceof EntityAnimal || object2 instanceof EntityVillager) {
                    d += Math.pow(((EntityLivingBase)object2).field_70121_D.func_72320_b(), 2.0);
                    continue;
                }
                if (!(object2 instanceof EntityPlayer) || !((EntityPlayer)object2).func_70093_af()) continue;
                d += Math.pow(((EntityLivingBase)object2).field_70121_D.func_72320_b(), 2.0);
            }
            if (d > 0.0) {
                this._tanks[0].fill(FluidRegistry.getFluidStack((String)"sewage", (int)((int)(25.0 * d))), true);
            }
            if ((n = Math.max(this._tanks[1].getCapacity() - this._tanks[1].getFluidAmount(), 0)) < 0) {
                return;
            }
            object = this.field_70331_k.func_72872_a(EntityXPOrb.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
            object2 = object.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                Entity entity = (Entity)e;
                if (!(entity != null & entity instanceof EntityXPOrb) || entity.field_70128_L) continue;
                EntityXPOrb entityXPOrb = (EntityXPOrb)e;
                int n2 = Math.min(entityXPOrb.field_70530_e, n);
                entityXPOrb.field_70530_e -= n2;
                if (entityXPOrb.field_70530_e <= 0) {
                    entityXPOrb.func_70106_y();
                    n2 = Math.max(n2, 0);
                }
                if (n2 <= 0) continue;
                n2 = (int)((float)n2 * 66.666664f);
                this._tanks[1].fill(FluidRegistry.getFluidStack((String)"mobessence", (int)n2), true);
                if ((n -= n2) > 0) continue;
                break;
            }
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        int n2 = 0;
        FluidTank[] fluidTankArray = (FluidTank[])this.getTanks();
        int n3 = fluidTankArray.length;
        if (n2 < n3) {
            FluidTank fluidTank = fluidTankArray[n2];
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidStack == null || !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
            return fluidTank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

