/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import java.util.List;

public class ElectricityPack
implements Cloneable {
    public float amperes;
    public float voltage;

    public ElectricityPack(float f, float f2) {
        this.amperes = f;
        this.voltage = f2;
    }

    public ElectricityPack() {
        this(0.0f, 0.0f);
    }

    public static ElectricityPack getFromWatts(float f, float f2) {
        return new ElectricityPack(f / f2, f2);
    }

    public static ElectricityPack merge(ElectricityPack ... electricityPackArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (ElectricityPack electricityPack : electricityPackArray) {
            f += electricityPack.getWatts();
            f2 += electricityPack.voltage;
        }
        if (f <= 0.0f || f2 <= 0.0f) {
            return new ElectricityPack();
        }
        return ElectricityPack.getFromWatts(f, f2 / (float)electricityPackArray.length);
    }

    public static ElectricityPack merge(List<ElectricityPack> list) {
        return ElectricityPack.merge(list.toArray(new ElectricityPack[0]));
    }

    public static ElectricityPack max(ElectricityPack ... electricityPackArray) {
        ElectricityPack electricityPack = null;
        for (ElectricityPack electricityPack2 : electricityPackArray) {
            if (electricityPack != null && (electricityPack == null || !(electricityPack2.getWatts() > electricityPack.getWatts()))) continue;
            electricityPack = electricityPack2;
        }
        return electricityPack;
    }

    public static ElectricityPack min(ElectricityPack ... electricityPackArray) {
        ElectricityPack electricityPack = null;
        for (ElectricityPack electricityPack2 : electricityPackArray) {
            if (electricityPack != null && (electricityPack == null || !(electricityPack2.getWatts() < electricityPack.getWatts()))) continue;
            electricityPack = electricityPack2;
        }
        return electricityPack;
    }

    public float getWatts() {
        return ElectricityPack.getWatts(this.amperes, this.voltage);
    }

    public float getConductance() {
        return ElectricityPack.getConductance(this.amperes, this.voltage);
    }

    public float getResistance() {
        return ElectricityPack.getResistance(this.amperes, this.voltage);
    }

    public static float getJoules(float f, float f2) {
        return f * f2;
    }

    public static float getJoules(float f, float f2, float f3) {
        return f * f2 * f3;
    }

    public static float getWattsFromJoules(float f, float f2) {
        return f / f2;
    }

    public static float getAmps(float f, float f2) {
        return f / f2;
    }

    public static float getAmps(float f) {
        return f * 3600.0f;
    }

    public static float getAmpsFromWattHours(float f, float f2) {
        return ElectricityPack.getWatts(f) / f2;
    }

    public static float getWattHoursFromAmpHours(float f, float f2) {
        return f * f2;
    }

    public static float getAmpHours(float f) {
        return f / 3600.0f;
    }

    public static float getWatts(float f, float f2) {
        return f * f2;
    }

    public static float getWatts(float f) {
        return f * 3600.0f;
    }

    public static float getWattHours(float f) {
        return f / 3600.0f;
    }

    public static float getWattHours(float f, float f2) {
        return ElectricityPack.getWattHours(ElectricityPack.getWatts(f, f2));
    }

    public static float getResistance(float f, float f2) {
        return f2 / f;
    }

    public static float getConductance(float f, float f2) {
        return f / f2;
    }

    public String toString() {
        return "ElectricityPack [Amps:" + this.amperes + " Volts:" + this.voltage + "]";
    }

    public ElectricityPack clone() {
        return new ElectricityPack(this.amperes, this.voltage);
    }

    public boolean isEqual(ElectricityPack electricityPack) {
        return this.amperes == electricityPack.amperes && this.voltage == electricityPack.voltage;
    }
}

