/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityCrop;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.util.Util;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemCropSeed
extends ItemIC2 {
    public ItemCropSeed(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77625_d(1);
        if (!Util.inDev()) {
            this.func_77637_a(null);
        }
    }

    @Override
    public String func_77667_c(ItemStack itemstack) {
        if (itemstack == null) {
            return "cropSeedUn";
        }
        byte level = ItemCropSeed.getScannedFromStack(itemstack);
        if (level == 0) {
            return "cropSeedUn";
        }
        if (level < 0) {
            return "cropSeedInvalid";
        }
        return "cropSeed" + ItemCropSeed.getIdFromStack(itemstack);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean debugTooltips) {
        if (ItemCropSeed.getScannedFromStack(stack) >= 4) {
            info.add("\u00a72Gr\u00a77 " + ItemCropSeed.getGrowthFromStack(stack));
            info.add("\u00a76Ga\u00a77 " + ItemCropSeed.getGainFromStack(stack));
            info.add("\u00a73Re\u00a77 " + ItemCropSeed.getResistanceFromStack(stack));
        }
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float a, float b, float c) {
        if (world.func_72796_p(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)world.func_72796_p(x, y, z);
            if (crop.tryPlantIn(ItemCropSeed.getIdFromStack(itemstack), 1, ItemCropSeed.getGrowthFromStack(itemstack), ItemCropSeed.getGainFromStack(itemstack), ItemCropSeed.getResistanceFromStack(itemstack), ItemCropSeed.getScannedFromStack(itemstack))) {
                entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = null;
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_77633_a(int id, CreativeTabs tabs, List items) {
        CropCard[] crops = Crops.instance.getCropList();
        for (int i = 0; i < crops.length; ++i) {
            if (crops[i] == null) continue;
            items.add(ItemCropSeed.generateItemStackFromValues((short)i, (byte)1, (byte)1, (byte)1, (byte)4));
        }
    }

    public static ItemStack generateItemStackFromValues(short id, byte statGrowth, byte statGain, byte statResistance, byte scan) {
        ItemStack is = new ItemStack(Ic2Items.cropSeed.func_77973_b());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("id", id);
        tag.func_74774_a("growth", statGrowth);
        tag.func_74774_a("gain", statGain);
        tag.func_74774_a("resistance", statResistance);
        tag.func_74774_a("scan", scan);
        is.func_77982_d(tag);
        return is;
    }

    public static short getIdFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74765_d("id");
    }

    public static byte getGrowthFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("growth");
    }

    public static byte getGainFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("gain");
    }

    public static byte getResistanceFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("resistance");
    }

    public static byte getScannedFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("scan");
    }

    public static void incrementScannedOfStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return;
        }
        is.func_77978_p().func_74774_a("scan", (byte)(ItemCropSeed.getScannedFromStack(is) + 1));
    }
}

