/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.tool.ItemElectricTool;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class ItemElectricToolHoe
extends ItemElectricTool {
    public ItemElectricToolHoe(Configuration config, InternalName internalName) {
        super(config, internalName, EnumToolMaterial.IRON, 50);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77864_a = 16.0f;
    }

    public void init() {
        this.mineableBlocks.add(Block.field_71979_v);
        this.mineableBlocks.add(Block.field_71980_u);
        this.mineableBlocks.add(Block.field_71994_by);
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int x, int y, int z, EntityPlayer entityLiving) {
        ElectricItem.manager.use(itemStack, this.operationEnergyCost, (EntityLivingBase)entityLiving);
        return false;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!entityPlayer.func_82247_a(x, y, z, side, itemStack)) {
            return false;
        }
        if (!ElectricItem.manager.canUse(itemStack, this.operationEnergyCost)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new UseHoeEvent(entityPlayer, itemStack, world, x, y, z))) {
            return false;
        }
        int blockId = world.func_72798_a(x, y, z);
        if (side != 0 && world.func_72799_c(x, y + 1, z) && blockId == Block.field_71980_u.field_71990_ca || blockId == Block.field_71979_v.field_71990_ca) {
            Block block = Block.field_72050_aA;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_72675_d(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
            if (IC2.platform.isSimulating()) {
                world.func_72832_d(x, y, z, block.field_71990_ca, 0, 3);
                ElectricItem.manager.use(itemStack, this.operationEnergyCost, (EntityLivingBase)entityPlayer);
            }
            return true;
        }
        return false;
    }
}

