/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class Liquid {
    public static LiquidData getLiquid(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        Fluid liquid = null;
        boolean isSource = false;
        if (Block.field_71973_m[blockId] instanceof IFluidBlock) {
            IFluidBlock block = (IFluidBlock)Block.field_71973_m[blockId];
            liquid = block.getFluid();
            isSource = block.canDrain(world, x, y, z);
        } else if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
            liquid = FluidRegistry.WATER;
            isSource = world.func_72805_g(x, y, z) == 0;
        } else if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
            liquid = FluidRegistry.LAVA;
            boolean bl = isSource = world.func_72805_g(x, y, z) == 0;
        }
        if (liquid != null) {
            return new LiquidData(liquid, isSource);
        }
        return null;
    }

    public static class LiquidData {
        public final Fluid liquid;
        public final boolean isSource;

        LiquidData(Fluid liquid, boolean isSource) {
            this.liquid = liquid;
            this.isSource = isSource;
        }
    }
}

