/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ASMReader;
import codechicken.lib.asm.InstructionComparator;
import codechicken.lib.asm.ObfMapping;
import codechicken.lib.config.ConfigTag;
import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class TweakTransformer
implements IClassTransformer,
Opcodes {
    private static HashMultimap<String, ASMHelper.MethodAltercator> altercators = HashMultimap.create();
    private static Map<String, ASMReader.ASMBlock> blocks = ASMReader.loadResource((String)"/assets/codechickencore/asm/tweaks.asm");
    public static ConfigTag tweaks;

    public static void load() {
        tweaks = CodeChickenCoreModContainer.config.getTag("tweaks").setComment("Various tweaks that can be applied to game mechanics.").useBraces();
        tweaks.removeTag("persistantLava");
        if (tweaks.getTag("environmentallyFriendlyCreepers").setComment("If set to true, creepers will not destroy landscape. (A version of mobGreifing setting just for creepers)").getBooleanValue(false)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfMapping("te", "l_", "()V")){

                public void alter(MethodNode mv) {
                    InsnList needle = ((ASMReader.ASMBlock)blocks.get((Object)"environmentallyFriendlyCreepers")).insns;
                    List lists = InstructionComparator.insnListFindL((InsnList)mv.instructions, (InsnList)needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList((InsnList)needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    mv.instructions.insertBefore(subsection.first, (AbstractInsnNode)new InsnNode(3));
                    ASMHelper.removeBlock((InsnList)mv.instructions, (InstructionComparator.InsnListSection)subsection);
                }
            });
        }
        if (!tweaks.getTag("softLeafReplace").setComment("If set to false, leaves will only replace air when growing").getBooleanValue(false)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfMapping("aqw", "canBeReplacedByLeaves", "(Labv;III)Z")){

                public void alter(MethodNode mv) {
                    mv.instructions = ((ASMReader.ASMBlock)blocks.get((Object)"softLeafReplace")).insns;
                }
            });
        }
        if (tweaks.getTag("doFireTickOut").setComment("If set to true and doFireTick is disabed in the game rules, fire will still dissipate if it's not over a fire source").getBooleanValue(true)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfMapping("aof", "a", "(Labv;IIILjava/util/Random;)V")){

                public void alter(MethodNode mv) {
                    InsnList needle = ((ASMReader.ASMBlock)blocks.get((Object)"doFireTick_needle")).insns;
                    List lists = InstructionComparator.insnListFindL((InsnList)mv.instructions, (InsnList)needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList((InsnList)needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    LabelNode jlabel = ((JumpInsnNode)subsection.last).label;
                    ASMReader.ASMBlock inject = (ASMReader.ASMBlock)blocks.get("doFireTick_injection");
                    mv.instructions.insertBefore((AbstractInsnNode)jlabel, (AbstractInsnNode)new JumpInsnNode(167, inject.get("LRET")));
                    mv.instructions.insert((AbstractInsnNode)jlabel, inject.insns);
                }
            });
        }
        if (tweaks.getTag("finiteWater").setComment("If set to true two adjacent water source blocks will not generate a third.").getBooleanValue(false)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfMapping("apa", "a", "(Labv;IIILjava/util/Random;)V")){

                public void alter(MethodNode mv) {
                    InsnList needle = ((ASMReader.ASMBlock)blocks.get((Object)"finiteWater")).insns;
                    List lists = InstructionComparator.insnListFindL((InsnList)mv.instructions, (InsnList)needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList((InsnList)needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    LabelNode jlabel = ((JumpInsnNode)subsection.last).label;
                    subsection.last = jlabel;
                    ASMHelper.removeBlock((InsnList)mv.instructions, (InstructionComparator.InsnListSection)subsection);
                }
            });
        }
    }

    private static void alterMethod(ASMHelper.MethodAltercator ma) {
        altercators.put((Object)ma.method.javaClass(), (Object)ma);
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        bytes = ASMHelper.alterMethods((String)name, (byte[])bytes, altercators);
        return bytes;
    }
}

