/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import java.util.LinkedList;
import java.util.Random;
import mrtjp.projectred.exploration.GeneratorOre;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.world.World;

public class GeneratorVolcano
extends GeneratorOre {
    LinkedList<GeneratorOre.Evaluation> openList = new LinkedList();
    LinkedList<GeneratorOre.Evaluation> closedList = new LinkedList();

    public GeneratorVolcano(int id, int meta, int veinSize) {
        super(id, meta, veinSize);
    }

    @Override
    public boolean func_76484_a(World w, Random rand, int x, int y, int z) {
        if (w.func_72798_a(x, y, z) != Block.field_71938_D.field_71990_ca) {
            return false;
        }
        int grass = this.makeLavaTube(w, x, y, z);
        int head = 3;
        int spread = rand.nextInt(1);
        int yIndex = grass;
        while (this.veinSize > 0) {
            int evalLevel;
            boolean reachedTop = false;
            while (this.openList.size() == 0) {
                w.func_94575_c(x, yIndex, z, Block.field_71944_C.field_71990_ca);
                this.closedList.clear();
                this.evaluateNeighbors(x, yIndex, z, head, rand);
                if (++yIndex <= 125) continue;
                reachedTop = true;
                break;
            }
            if (reachedTop) break;
            GeneratorOre.Evaluation nextEval = this.openList.removeFirst();
            if (!w.func_72899_e(nextEval.x, 64, nextEval.z)) continue;
            int pow = this.getClosedEval((int)nextEval.x, (int)nextEval.z).sides;
            for (evalLevel = w.func_72976_f(nextEval.x, nextEval.z); evalLevel > 0 && this.isUnimportant(w.func_72798_a(nextEval.x, evalLevel - 1, nextEval.z)); --evalLevel) {
            }
            if (evalLevel > nextEval.y || !this.isUnimportant(w.func_72798_a(nextEval.x, evalLevel, nextEval.z))) continue;
            this.purgeArea(w, nextEval.x, evalLevel, nextEval.z);
            w.func_72832_d(nextEval.x, evalLevel, nextEval.z, this.id, this.meta, 3);
            if (nextEval.y > evalLevel) {
                pow = Math.max(pow, spread);
            }
            this.evaluateNeighbors(nextEval.x, evalLevel, nextEval.z, pow, rand);
            --this.veinSize;
        }
        w.func_94575_c(x, yIndex, z, Block.field_71938_D.field_71990_ca);
        while (yIndex > grass && w.func_72798_a(x, yIndex, z) == Block.field_71938_D.field_71990_ca) {
            w.func_72845_h(x, yIndex, z);
            w.func_72898_h(x, yIndex, z, Block.field_71938_D.field_71990_ca);
            w.field_72999_e = true;
            Block.field_71973_m[Block.field_71938_D.field_71990_ca].func_71847_b(w, x, yIndex, z, rand);
            w.field_72999_e = false;
            --yIndex;
        }
        return true;
    }

    public void purgeArea(World world, int x, int y, int z) {
        int center = world.func_72798_a(x, y, z);
        if (center == 0) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                int block = world.func_72798_a(x + i, y, z + j);
                if (block == Block.field_72037_aS.field_71990_ca) {
                    world.func_94575_c(x + i, y, z + j, 0);
                    continue;
                }
                if (block != Block.field_71951_J.field_71990_ca && block != Block.field_71952_K.field_71990_ca && block != Block.field_71998_bu.field_71990_ca) continue;
                world.func_94575_c(x + i, y, z + j, 0);
            }
        }
        this.purgeArea(world, x, y + 1, z);
    }

    private GeneratorOre.Evaluation getClosedEval(int x, int z) {
        for (GeneratorOre.Evaluation e : this.closedList) {
            if (e.x != x || e.z != z) continue;
            return e;
        }
        return null;
    }

    private void addBlockForEvaluation(int x, int y, int z, int sides) {
        if (sides <= 0) {
            return;
        }
        GeneratorOre.Evaluation eval = this.getClosedEval(x, z);
        if (eval != null && sides <= eval.sides) {
            return;
        }
        GeneratorOre.Evaluation newEval = new GeneratorOre.Evaluation(x, y, z, sides);
        this.openList.addLast(newEval);
        this.closedList.add(newEval);
    }

    private void evaluateNeighbors(int x, int y, int z, int sides, Random random) {
        this.addBlockForEvaluation(x - 1, y, z, random.nextInt(2) > 0 ? sides - 1 : sides);
        this.addBlockForEvaluation(x + 1, y, z, random.nextInt(2) > 0 ? sides - 1 : sides);
        this.addBlockForEvaluation(x, y, z - 1, random.nextInt(2) > 0 ? sides - 1 : sides);
        this.addBlockForEvaluation(x, y, z + 1, random.nextInt(2) > 0 ? sides - 1 : sides);
    }

    private int makeLavaTube(World w, int x, int y, int z) {
        int grassHeight = w.func_72976_f(x, z);
        int lavaid = Block.field_71944_C.field_71990_ca;
        while (this.isUnimportant(w.func_72798_a(x, grassHeight - 1, z))) {
            --grassHeight;
        }
        for (int i = y; i < grassHeight; ++i) {
            w.func_94575_c(x, i, z, lavaid);
            w.func_72832_d(x - 1, i, z, this.id, this.meta, 3);
            w.func_72832_d(x + 1, i, z, this.id, this.meta, 3);
            w.func_72832_d(x, i, z - 1, this.id, this.meta, 3);
            w.func_72832_d(x, i, z + 1, this.id, this.meta, 3);
        }
        return grassHeight;
    }

    private boolean isUnimportant(int id) {
        if (id == 0) {
            return true;
        }
        if (id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_71951_J.field_71990_ca || id == Block.field_71952_K.field_71990_ca || id == Block.field_71998_bu.field_71990_ca || id == Block.field_72037_aS.field_71990_ca || id == Block.field_72036_aT.field_71990_ca) {
            return true;
        }
        return Block.field_71973_m[id] instanceof BlockFlower;
    }
}

