/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mrtjp.projectred.ProjectRedExploration;
import mrtjp.projectred.core.GhostContainer;
import mrtjp.projectred.core.GuiRestrictedSlot;
import mrtjp.projectred.core.SimpleInventory;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBackpack
extends Item {
    public static Icon[] bpIcons = new Icon[EnumBackpack.VALID_BP.length];

    public ItemBackpack(int par1) {
        super(par1);
        this.field_77787_bX = true;
        this.field_77777_bU = 1;
        this.func_77655_b("projectred.exploration.backpack");
        this.func_77637_a(ProjectRedExploration.tabExploration);
    }

    public static IInventory getBackpackInventory(EntityPlayer player) {
        BagInventory inv = null;
        ItemStack held = player.func_70694_bm();
        if (held != null && held.field_77993_c == ProjectRedExploration.itemBackpack.field_77779_bT) {
            inv = new BagInventory(player, held);
            inv.readFromNBT(held.func_77978_p(), "conents");
        }
        return inv;
    }

    public static Container getContainer(EntityPlayer player) {
        Object backpackInv = ItemBackpack.getBackpackInventory(player);
        if (backpackInv == null) {
            backpackInv = new BagInventory(player, new ItemStack((Item)ProjectRedExploration.itemBackpack));
        }
        GhostContainer ghost = new GhostContainer((IInventory)player.field_71071_by, backpackInv);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotNumber = i * 9 + j;
                ghost.addRestrictedSlot(slotNumber, backpackInv, 8 + j * 18, 18 + i * 18, new GuiRestrictedSlot.ISlotCheck(){

                    public boolean isSlotAllowed(ItemStack stack) {
                        if (stack == null) {
                            return true;
                        }
                        return stack.field_77993_c != ProjectRedExploration.itemBackpack.field_77779_bT;
                    }
                });
            }
        }
        ghost.addNormalSlotsForPlayerInventory(8, 86, player.field_71071_by.field_70461_c);
        return ghost;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        this.openGui(player);
        return super.func_77648_a(stack, player, world, x, y, z, par7, par8, par9, par10);
    }

    public ItemStack func_77659_a(ItemStack stack, World w, EntityPlayer player) {
        this.openGui(player);
        return super.func_77659_a(stack, w, player);
    }

    public void openGui(EntityPlayer player) {
        if (!player.func_70093_af()) {
            player.openGui((Object)ProjectRedExploration.instance, 1, player.field_70170_p, 0, 0, 0);
        }
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (EnumBackpack b : EnumBackpack.VALID_BP) {
            list.add(b.getItemStack());
        }
    }

    public String func_77667_c(ItemStack itemstack) {
        return this.func_77658_a() + "." + EnumBackpack.get((int)itemstack.func_77960_j()).unlocalname;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reg) {
        for (EnumBackpack b : EnumBackpack.VALID_BP) {
            ItemBackpack.bpIcons[b.meta] = reg.func_94245_a("projectred:backpacks/" + b.unlocalname);
        }
    }

    public Icon func_77617_a(int meta) {
        if (meta > bpIcons.length - 1) {
            return null;
        }
        return bpIcons[meta];
    }

    public static enum EnumBackpack {
        WHITE("White Backpack", "bpwhite"),
        ORANGE("Orange Backpack", "bporange"),
        MAGENTA("Magenta Backpack", "bpmagenta"),
        LIGHT_BLUE("Light Blue Backpack", "bplightblue"),
        YELLOW("Yellow Backpack", "bpyellow"),
        LIME("Lime Backpack", "bplime"),
        PINK("Pink Backpack", "bppink"),
        GREY("Grey Backpack", "bpgrey"),
        LIGHT_GREY("Light Grey Backpack", "bplightgrey"),
        CYAN("Cyan Backpack", "bpcyan"),
        PURPLE("Purple Backpack", "bppurple"),
        BLUE("Blue Backpack", "bpblue"),
        BROWN("Brown Backpack", "bpbrown"),
        GREEN("Green Backpack", "bpgreen"),
        RED("Red Backpack", "bpred"),
        BLACK("Black Backpack", "bpblack");

        public final String fullname;
        public final String unlocalname;
        public final int meta = this.ordinal();
        public static final EnumBackpack[] VALID_BP;
        public static final String oreDictDefinition = "pr_bag";

        private EnumBackpack(String name, String unlocal) {
            this.fullname = name;
            this.unlocalname = unlocal;
        }

        public static EnumBackpack get(int i) {
            if (i > VALID_BP.length - 1) {
                return WHITE;
            }
            return VALID_BP[i];
        }

        public ItemStack getItemStack() {
            return this.getItemStack(1);
        }

        public ItemStack getItemStack(int i) {
            return new ItemStack((Item)ProjectRedExploration.itemBackpack, i, this.meta);
        }

        public static void initOreDictDefinitions() {
            for (EnumBackpack b : VALID_BP) {
                OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)b.getItemStack());
            }
        }

        static {
            VALID_BP = new EnumBackpack[]{WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GREY, LIGHT_GREY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK};
        }
    }

    public static class BagInventory
    extends SimpleInventory {
        public ItemStack _bagOriginal;
        public EntityPlayer _player;
        public boolean isLoading = false;

        public BagInventory(EntityPlayer player, ItemStack bag) {
            super(27, "bag", 64);
            this._bagOriginal = bag;
            this._player = player;
            this.loadInventory();
        }

        public void func_70296_d() {
            super.func_70296_d();
            if (!this.isLoading) {
                this.saveInventory();
            }
        }

        public void func_70295_k_() {
            this.isLoading = true;
            this.loadInventory();
            this.isLoading = false;
        }

        public void func_70305_f() {
            this.saveInventory();
        }

        private void loadInventory() {
            this.readFromNBT(this._bagOriginal.func_77978_p());
        }

        private void saveInventory() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            this._bagOriginal.func_77982_d(nbt);
            this.refreshNBT();
        }

        private void refreshNBT() {
            ItemStack currentBag = this._player.func_70694_bm();
            if (currentBag != null && currentBag.field_77993_c == ProjectRedExploration.itemBackpack.field_77779_bT) {
                currentBag.func_77982_d(this._bagOriginal.func_77978_p());
            }
        }
    }
}

