/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.BasicWireUtils;
import mrtjp.projectred.illumination.ILight;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class BaseLightPart
extends JCuboidPart
implements TSlottedPart,
JNormalOcclusion,
IRedstonePart,
ILight {
    protected byte type;
    protected boolean isInverted;
    protected boolean powered;
    protected int side;
    protected boolean initialized = false;

    public void preparePlacement(int side, int meta, boolean inv) {
        this.isInverted = inv;
        this.side = side;
        this.type = (byte)meta;
    }

    public void writeDesc(MCDataOutput out) {
        out.writeByte((int)this.type);
        out.writeBoolean(this.isInverted);
        out.writeByte(this.side);
        out.writeBoolean(this.powered);
    }

    public void readDesc(MCDataInput in) {
        this.type = in.readByte();
        this.isInverted = in.readBoolean();
        this.side = in.readByte();
        this.powered = in.readBoolean();
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74757_a("inverted", this.isInverted);
        nbt.func_74774_a("meta", this.type);
        nbt.func_74768_a("rot", this.side);
        nbt.func_74757_a("powered", this.powered);
    }

    public void load(NBTTagCompound nbt) {
        this.isInverted = nbt.func_74767_n("inverted");
        this.type = nbt.func_74771_c("meta");
        this.side = nbt.func_74762_e("rot");
        this.powered = nbt.func_74767_n("powered");
    }

    public void onNeighborChanged() {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onPartChanged(TMultiPart t) {
        this.updateState(false);
    }

    public void onAdded() {
        this.updateState(true);
    }

    private boolean isBeingPowered() {
        return this.world().func_72864_z(this.x(), this.y(), this.z()) || this.world().func_94577_B(this.x(), this.y(), this.z()) > 0;
    }

    public void updateState(boolean forceRender) {
        boolean updated = false;
        if (!this.powered && this.isBeingPowered()) {
            this.powered = true;
            this.updateRender();
            updated = true;
        } else if (this.powered && !this.isBeingPowered()) {
            this.powered = false;
            this.updateRender();
            updated = true;
        }
        if (forceRender && !updated) {
            this.updateRender();
        }
    }

    public void updateRender() {
        this.world().func_72845_h(this.x(), this.y(), this.z());
        this.world().func_72969_x(this.x(), this.y(), this.z());
        if (BasicUtils.isServer((World)this.world())) {
            this.sendDescUpdate();
        }
    }

    public boolean checkSupport() {
        if (BasicUtils.isClient((World)this.world())) {
            return false;
        }
        BlockCoord bc = new BlockCoord(this.x(), this.y(), this.z());
        bc.offset(this.side);
        if (!BasicWireUtils.canPlaceWireOnSide((World)this.world(), (int)bc.x, (int)bc.y, (int)bc.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side ^ 1)), (boolean)false)) {
            BasicUtils.dropItemFromLocation((World)this.world(), (ItemStack)this.getItem(), (boolean)false, null, (int)this.side, (int)10, (BlockCoord)new BlockCoord(this.x(), this.y(), this.z()));
            this.tile().remPart((TMultiPart)this);
            return true;
        }
        return false;
    }

    public abstract String getType();

    public void update() {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    public int getLightValue() {
        if (this.powered != this.isInverted) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(Vector3 var1, LazyLightMatrix var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public abstract void drawBreaking(RenderBlocks var1);

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return 2.0f;
    }

    public abstract ItemStack getItem();

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public abstract Cuboid6 getBounds();

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public abstract int getSlotMask();

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public boolean canConnectRedstone(int arg0) {
        return true;
    }

    public int strongPowerLevel(int arg0) {
        return 0;
    }

    public int weakPowerLevel(int arg0) {
        return 0;
    }

    @Override
    public boolean isOn() {
        return this.getLightValue() == 15;
    }
}

