/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.vec.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.illumination.IlluminationClientProxy;
import mrtjp.projectred.illumination.TileLamp;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLamp
extends Block {
    public static Icon[] onIcons = new Icon[16];
    public static Icon[] offIcons = new Icon[16];

    public BlockLamp(int id) {
        super(id, new Material(Material.field_76265_p.field_76234_F));
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_71848_c(0.5f);
        this.func_71864_b("projectred.illumination.lamp");
        this.func_71849_a(ProjectRedIllumination.tabLighting);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, (BlockCoord)new BlockCoord(x, y, z), TileLamp.class);
        if (tile != null) {
            tile.onNeighborBlockChange();
        }
    }

    public boolean func_71886_c() {
        return true;
    }

    public int func_71857_b() {
        return IlluminationClientProxy.lampRenderID;
    }

    public boolean func_71926_d() {
        return true;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return true;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 32; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, (BlockCoord)new BlockCoord(x, y, z), TileLamp.class);
        if (tile != null) {
            return tile.getLightValue();
        }
        return 0;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_71853_i() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        for (int i = 0; i < 16; ++i) {
            BlockLamp.onIcons[i] = reg.func_94245_a("projectred:lights/lampon/" + i);
            BlockLamp.offIcons[i] = reg.func_94245_a("projectred:lights/lampoff/" + i);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, (BlockCoord)new BlockCoord(x, y, z), TileLamp.class);
        if (tile != null) {
            return tile.getDroppedBlock();
        }
        return null;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, (BlockCoord)new BlockCoord(x, y, z), TileLamp.class);
        if (tile != null && !player.field_71075_bZ.field_75098_d) {
            BasicUtils.dropItem((World)world, (int)x, (int)y, (int)z, (ItemStack)tile.getDroppedBlock());
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, (BlockCoord)new BlockCoord(x, y, z), TileLamp.class);
        if (tile != null) {
            if (tile.getLightValue() == 15) {
                return onIcons[tile.color];
            }
            return offIcons[tile.color];
        }
        return super.func_71895_b(world, x, y, z, side);
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta > 15) {
            return onIcons[meta - 16];
        }
        return offIcons[meta];
    }

    public TileEntity createTileEntity(World world, int meta) {
        TileLamp t = new TileLamp();
        t.prepairPlacement(meta > 15, meta > 15 ? meta - 15 : meta);
        return t;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }
}

