/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.IPartMeta;
import codechicken.multipart.minecraft.PartMetaAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.illumination.ILight;
import mrtjp.projectred.illumination.ItemPartIllumarButton;
import mrtjp.projectred.illumination.LastEventBasedHaloRenderer;
import net.minecraft.block.BlockButton;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;

public class IllumarButtonPart
extends ButtonPart
implements ILight {
    public byte colorMeta;

    public IllumarButtonPart() {
    }

    public IllumarButtonPart(int meta) {
        super(meta);
    }

    public void onPlaced(ItemStack is) {
        this.colorMeta = (byte)is.func_77960_j();
    }

    @Override
    public boolean isOn() {
        return this.pressed();
    }

    public static BlockButton getButton(int meta) {
        return stoneButton;
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74774_a("colorMeta", this.colorMeta);
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.colorMeta = tag.func_74771_c("colorMeta");
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.colorMeta);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.colorMeta = packet.readByte();
    }

    public String getType() {
        return "pr_lightbutton";
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItemStack());
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItemStack();
    }

    public ItemStack getItemStack() {
        return new ItemStack((Item)ProjectRedIllumination.itemPartIllumarButton, 1, (int)this.colorMeta);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0) {
            RenderBlocks r = new RenderBlocks((IBlockAccess)new PartMetaAccess((IPartMeta)this));
            r.func_78604_a(this.getBlock(), this.x(), this.y(), this.z(), ItemPartIllumarButton.icons[this.colorMeta]);
            if (this.pressed()) {
                Cuboid6 box = this.getBounds().expand(0.025);
                LastEventBasedHaloRenderer.addLight(this.x(), this.y(), this.z(), this.colorMeta, this.getFace(), box);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBrokenIcon(int side) {
        return ItemPartIllumarButton.icons[this.colorMeta];
    }

    public Icon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    public int getLightValue() {
        return this.pressed() ? 5 : 0;
    }
}

