/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mrtjp.projectred.core.BasicRenderUtils;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.illumination.ILight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LastEventBasedHaloRenderer {
    public static LastEventBasedHaloRenderer instance = new LastEventBasedHaloRenderer();
    private static Set<CoordCache> renderQueue = new HashSet<CoordCache>();

    public static void addLight(int x, int y, int z, int color, int slot, Cuboid6 box) {
        CoordCache cc = new CoordCache(x, y, z, color, slot, box);
        for (CoordCache c : renderQueue) {
            if (!cc.equals(c)) continue;
            return;
        }
        renderQueue.add(cc);
    }

    @ForgeSubscribe
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ArrayList<CoordCache> removeQueue = new ArrayList<CoordCache>();
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        EntityLivingBase view = Minecraft.func_71410_x().field_71451_h;
        if (view != null) {
            double partials = event.partialTicks;
            double x = view.field_70169_q + (view.field_70165_t - view.field_70169_q) * partials;
            double y = view.field_70167_r + (view.field_70163_u - view.field_70167_r) * partials;
            double z = view.field_70166_s + (view.field_70161_v - view.field_70166_s) * partials;
            GL11.glTranslated((double)(-1.0 * x), (double)(-1.0 * y), (double)(-1.0 * z));
        }
        WorldClient w = event.context.field_72769_h;
        CCRenderState.reset();
        CCRenderState.startDrawing((int)7);
        for (CoordCache r : renderQueue) {
            if (LastEventBasedHaloRenderer.shouldRemove((World)w, r)) {
                removeQueue.add(r);
                continue;
            }
            LastEventBasedHaloRenderer.renderHalo(tess, r);
        }
        CCRenderState.draw();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        renderQueue.removeAll(removeQueue);
    }

    private static void renderHalo(Tessellator tess, CoordCache cc) {
        BasicRenderUtils.setFullBrightness();
        tess.func_78384_a(PRColors.VALID_COLORS[cc.color].hex, 128);
        RenderUtils.renderBlock((Cuboid6)cc.cube, (int)0, (Transformation)new Translation((double)cc.x, (double)cc.y, (double)cc.z), null, null);
    }

    private static boolean shouldRemove(World w, CoordCache cc) {
        TMultiPart tp;
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)w, (BlockCoord)new BlockCoord(cc.x, cc.y, cc.z));
        if (t != null && (tp = t.partMap(cc.multipartSlot)) instanceof ILight) {
            return !((ILight)tp).isOn();
        }
        TileEntity te = (TileEntity)BasicUtils.getTileEntity((IBlockAccess)w, (BlockCoord)new BlockCoord(cc.x, cc.y, cc.z), TileEntity.class);
        if (te instanceof ILight) {
            return !((ILight)te).isOn();
        }
        return true;
    }

    private static class CoordCache {
        final int x;
        final int y;
        final int z;
        final int color;
        final Cuboid6 cube;
        final int multipartSlot;

        public CoordCache(int x, int y, int z, int colorIndex, int slot, Cuboid6 cube) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.color = colorIndex;
            this.multipartSlot = slot;
            this.cube = cube;
        }

        public boolean equals(Object o) {
            if (o instanceof CoordCache) {
                CoordCache coord = (CoordCache)o;
                return this.x == coord.x && this.y == coord.y && this.z == coord.z && coord.cube.min.equals((Object)this.cube.min) && coord.cube.max.equals((Object)this.cube.max);
            }
            return false;
        }
    }
}

