/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Map;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.illumination.CageLampPart;
import mrtjp.projectred.illumination.LastEventBasedHaloRenderer;
import mrtjp.projectred.illumination.RenderLantern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCageLamp
implements IItemRenderer {
    public static RenderCageLamp instance = new RenderCageLamp();
    static CCModel[] base;

    public void renderCageLamp(CageLampPart l) {
        Icon icon = l.isOn() ? RenderLantern.onIcons[l.type] : RenderLantern.offIcons[l.type];
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.setBrightness((IBlockAccess)l.world(), (int)l.x(), (int)l.y(), (int)l.z());
        CCRenderState.useModelColours((boolean)true);
        this.renderPart(icon, base[l.side], l.x(), l.y(), l.z());
        if (l.isOn()) {
            LastEventBasedHaloRenderer.addLight(l.x(), l.y(), l.z(), l.type, l.side, CageLampPart.lightBounds[l.side]);
        }
    }

    public void renderBreaking(CageLampPart c, Icon icon) {
        RenderUtils.renderBlock((Cuboid6)CageLampPart.bounds[c.side], (int)0, (Transformation)new Translation((double)c.x(), (double)c.y(), (double)c.z()), (IUVTransformation)new IconTransformation(icon), null);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Icon icon = item.func_77973_b() == ProjectRedIllumination.itemPartInvCageLamp ? RenderLantern.onIcons[item.func_77960_j()] : RenderLantern.offIcons[item.func_77960_j()];
        switch (type) {
            case ENTITY: {
                this.renderInventory(icon, -0.1, 0.0, -0.1, 0.75);
                return;
            }
            case EQUIPPED: {
                this.renderInventory(icon, -0.15, -0.15, -0.15, 1.5);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderInventory(icon, -0.15, -0.15, -0.15, 1.5);
                return;
            }
            case INVENTORY: {
                this.renderInventory(icon, 0.0, -0.05, 0.0, 1.0);
                return;
            }
        }
    }

    public void renderInventory(Icon icon, double x, double y, double z, double scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.startDrawing((int)7);
        this.renderPart(icon, base[0], x, y, z);
        CCRenderState.draw();
        GL11.glPopMatrix();
    }

    public void renderPart(Icon icon, CCModel cc, double x, double y, double z) {
        cc.render(0, cc.verts.length, (Transformation)new Translation(x, y, z), (IUVTransformation)new IconTransformation(icon), (IVertexModifier)ColourModifier.instance);
    }

    static {
        Map models = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("projectred", "textures/obj/lights/cagelamp.obj"), (int)7, (Transformation)new InvertX());
        base = new CCModel[6];
        for (int i = 0; i < 6; ++i) {
            CCModel m = ((CCModel)models.get("base")).copy();
            m.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            m.apply(Rotation.sideOrientation((int)i, (int)0).at(Vector3.center));
            m.computeLighting(LightModel.standardLightModel);
            m.shrinkUVs(5.0E-4);
            RenderCageLamp.base[i] = m.copy();
        }
    }
}

