/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import mrtjp.projectred.illumination.ILight;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileLamp
extends TileEntity
implements ILight {
    public boolean inverted;
    public boolean powered;
    public byte color;

    public void prepairPlacement(boolean inverted, int meta) {
        this.color = (byte)meta;
        this.inverted = inverted;
    }

    public int getLightValue() {
        if (this.powered != this.inverted) {
            return 15;
        }
        return 0;
    }

    public ItemStack getDroppedBlock() {
        return new ItemStack(this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), 1, this.color + (this.inverted ? 16 : 0));
    }

    public void onNeighborBlockChange() {
        this.updateState(false);
    }

    public void updateState(boolean forceRender) {
        boolean updated = false;
        if (!this.powered && this.isBeingPowered()) {
            this.powered = true;
            this.updateRender();
            updated = true;
        } else if (this.powered && !this.isBeingPowered()) {
            this.powered = false;
            this.updateRender();
            updated = true;
        }
        if (forceRender && !updated) {
            this.updateRender();
        }
    }

    public void updateRender() {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("inverted", this.inverted);
        nbt.func_74757_a("powered", this.powered);
        nbt.func_74774_a("meta", this.color);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.inverted = nbt.func_74767_n("inverted");
        this.powered = nbt.func_74767_n("powered");
        this.color = nbt.func_74771_c("meta");
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, nbt);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
        this.updateState(true);
    }

    private boolean isBeingPowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean isOn() {
        return this.getLightValue() == 15;
    }
}

