/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mrtjp.projectred.core.BasicUtils;
import net.minecraft.item.ItemStack;

public class AlloySmelterRecipe {
    private final ItemStack[] _matrix;
    private final ItemStack _result;
    public final ICraftingHandler _handler;
    private final int _burnTime;
    private static final ArrayList<AlloySmelterRecipe> alloyRecipes = new ArrayList();

    public static List<AlloySmelterRecipe> getAlloyRecipes() {
        return Collections.unmodifiableList(alloyRecipes);
    }

    public static void add(AlloySmelterRecipe r) {
        alloyRecipes.add(r);
    }

    public AlloySmelterRecipe(ItemStack[] matrix, ItemStack result, ICraftingHandler handler) {
        this(matrix, result, handler, 200);
    }

    public AlloySmelterRecipe(ItemStack[] matrix, ItemStack result, ICraftingHandler handler, int burnTime) {
        this._matrix = matrix;
        this._result = result;
        this._handler = handler == null ? new ICraftingHandler(){

            @Override
            public void onItemCrafted(ItemStack stack) {
            }
        } : handler;
        this._burnTime = burnTime;
    }

    public AlloySmelterRecipe(ItemStack[] matrix, ItemStack result) {
        this(matrix, result, null, 200);
    }

    public AlloySmelterRecipe(ItemStack[] matrix, ItemStack result, int burnTime) {
        this(matrix, result, null, burnTime);
    }

    public ItemStack getResult() {
        return this._result.func_77946_l();
    }

    public ItemStack[] getMatrix() {
        return (ItemStack[])this._matrix.clone();
    }

    public int getBurnTime() {
        return this._burnTime;
    }

    public boolean calculateMatch(ItemStack[] inv) {
        if (inv.length != 9) {
            return false;
        }
        for (ItemStack ingredient : this._matrix) {
            int missing = ingredient.field_77994_a;
            for (ItemStack itemInGrid : inv) {
                if (BasicUtils.areStacksTheSame(ingredient, itemInGrid)) {
                    missing -= itemInGrid.field_77994_a;
                }
                if (missing <= 0) break;
            }
            if (missing <= 0) continue;
            return false;
        }
        return true;
    }

    public AlloySmelterRecipe copy() {
        return new AlloySmelterRecipe(this._matrix, this._result, this._handler, this._burnTime);
    }

    public abstract class ICraftingHandler {
        public abstract void onItemCrafted(ItemStack var1);
    }
}

