/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TileMultipart;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BasicUtils {
    public static boolean isServer(World world) {
        if (world != null) {
            return !world.field_72995_K;
        }
        return false;
    }

    public static boolean isClient(World world) {
        if (world != null) {
            return world.field_72995_K;
        }
        return false;
    }

    public static void dropItem(World world, int x, int y, int z, ItemStack itemStack) {
        if (!BasicUtils.isClient(world)) {
            double var5 = 0.7;
            double var7 = (double)world.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            double var9 = (double)world.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            double var11 = (double)world.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            EntityItem var13 = new EntityItem(world, (double)x + var7, (double)y + var9, (double)z + var11, itemStack);
            var13.field_70293_c = 10;
            world.func_72838_d((Entity)var13);
        }
    }

    public static void dropItemFromLocation(World w, ItemStack is, boolean violent, EntityPlayer player, int to_side, int tickDelay, BlockCoord coord) {
        if (w.field_72995_K) {
            return;
        }
        if (is == null || is.field_77994_a == 0) {
            return;
        }
        if (player == null) {
            to_side = -1;
        }
        double mult = 0.02;
        if (violent) {
            mult = 0.2;
        }
        Vec3 pos = w.func_82732_R().func_72345_a((double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5);
        Vec3 vel = w.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        if (to_side != -1) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)to_side);
            double d = 0.75;
            pos.field_72450_a += (double)dir.offsetX * d;
            pos.field_72448_b += (double)dir.offsetY * d;
            pos.field_72449_c += (double)dir.offsetZ * d;
            vel.field_72450_a = dir.offsetX;
            vel.field_72448_b = dir.offsetY;
            vel.field_72449_c = dir.offsetZ;
        } else if (player != null) {
            Vec3 vec = Vec3.func_72443_a((double)(player.field_70165_t - (double)coord.x), (double)(player.field_70163_u - (double)coord.y), (double)(player.field_70161_v - (double)coord.z));
            vel = vec = vec.func_72432_b();
            double d = 0.25;
            pos.field_72450_a += vec.field_72450_a * d;
            pos.field_72448_b += vec.field_72448_b * d;
            pos.field_72449_c += vec.field_72449_c * d;
        } else {
            vel.field_72450_a = w.field_73012_v.nextGaussian();
            vel.field_72448_b = w.field_73012_v.nextGaussian();
            vel.field_72449_c = w.field_73012_v.nextGaussian();
        }
        EntityItem ent = new EntityItem(w, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, is);
        ent.field_70159_w = vel.field_72450_a * mult;
        ent.field_70181_x = vel.field_72448_b * mult;
        ent.field_70179_y = vel.field_72449_c * mult;
        ent.field_70293_c = tickDelay;
        w.func_72838_d((Entity)ent);
    }

    public static <T> T getTileEntity(IBlockAccess access, BlockCoord coords, Class<T> clazz) {
        TileEntity te = access.func_72796_p(coords.x, coords.y, coords.z);
        return (T)(!clazz.isInstance(te) ? null : te);
    }

    public static TileMultipart getMultipartTile(IBlockAccess access, BlockCoord pos) {
        TileEntity te = access.func_72796_p(pos.x, pos.y, pos.z);
        return te instanceof TileMultipart ? (TileMultipart)te : null;
    }

    public static boolean areStacksTheSame(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return false;
        }
        return is1.field_77993_c == is2.field_77993_c && is1.func_77960_j() == is2.func_77960_j();
    }

    public static void writeNBTToData(NBTBase nbt, DataOutputStream data) throws IOException {
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    public static NBTBase readNBTFromData(DataInputStream data) throws IOException {
        return NBTBase.func_74739_b((DataInput)data);
    }
}

