/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import java.util.Map;
import mrtjp.projectred.core.BasicRenderUtils;
import mrtjp.projectred.core.BlockBasics;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.core.TileAlloySmelter;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderAlloySmelter {
    private static Map<String, CCModel> models = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("projectred:textures/obj/machines/presser.obj"), (int)7, (Transformation)new InvertX());
    private static CCModel base = models.get("base");
    private static CCModel plate = models.get("plate");
    private static CCModel shaft = models.get("shaft");

    public static void renderStatic(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        CCRenderState.reset();
        CCRenderState.useModelColours((boolean)true);
        TextureUtils.bindAtlas((int)0);
        if (renderer.field_78664_d == null) {
            base.render((Transformation)new Translation((double)x + 0.5, (double)y, (double)z + 0.5), (IUVTransformation)new IconTransformation(BlockBasics.EnumBasics.ALLOYSMELTER.icons[0]));
        } else {
            RenderUtils.renderBlock((Cuboid6)Cuboid6.full, (int)0, (Transformation)new Translation((double)x, (double)y, (double)z), (IUVTransformation)new IconTransformation(renderer.field_78664_d), null);
        }
    }

    public static void renderDynamic(double x, double y, double z, double frame, TileAlloySmelter presser) {
        double yHeight = 0.0;
        double color = 0.0;
        if (presser.burnTimeForRecipe <= 0) {
            yHeight = 0.3;
        } else {
            double percent = presser.progress * 100 / presser.burnTimeForRecipe;
            yHeight = Math.max(0.3 - percent / 20.0, 0.0);
            if (percent > 80.0) {
                yHeight = Math.min(0.015 * (percent - 80.0), 0.3);
            }
            if (percent > 20.0 && percent < 80.0) {
                color = Math.sin(percent / 30.0);
            }
        }
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.useNormals((boolean)true);
        CCRenderState.pullLightmap();
        CCRenderState.startDrawing((int)7);
        BasicRenderUtils.setFullColor();
        BasicRenderUtils.setFullBrightness();
        shaft.render((Transformation)new Translation(x + 0.5, y + yHeight, z + 0.5), (IUVTransformation)new IconTransformation(BlockBasics.EnumBasics.ALLOYSMELTER.icons[0]));
        if (color > 0.0) {
            Tessellator.field_78398_a.func_78386_a((float)color, 0.0f, 0.0f);
        }
        plate.render((Transformation)new Translation(x + 0.5, y + yHeight, z + 0.5), (IUVTransformation)new IconTransformation(BlockBasics.EnumBasics.ALLOYSMELTER.icons[0]));
        CCRenderState.draw();
    }

    public static void renderInventory() {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.useNormals((boolean)true);
        CCRenderState.pullLightmap();
        CCRenderState.startDrawing((int)7);
        base.render((Transformation)new Translation(0.5, 0.0, 0.5), (IUVTransformation)new IconTransformation(BlockBasics.EnumBasics.ALLOYSMELTER.icons[0]));
        plate.render((Transformation)new Translation(0.5, 0.0, 0.5), (IUVTransformation)new IconTransformation(BlockBasics.EnumBasics.ALLOYSMELTER.icons[0]));
        shaft.render((Transformation)new Translation(0.5, 0.0, 0.5), (IUVTransformation)new IconTransformation(BlockBasics.EnumBasics.ALLOYSMELTER.icons[0]));
        CCRenderState.draw();
        GL11.glPopMatrix();
    }

    static {
        base.shrinkUVs(0.001);
        plate.shrinkUVs(0.001);
        shaft.shrinkUVs(0.001);
        base.computeLighting(LightModel.standardLightModel);
        plate.computeLighting(LightModel.standardLightModel);
        shaft.computeLighting(LightModel.standardLightModel);
    }
}

