/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.packet.PacketCustom;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.ProjectRedCore;
import mrtjp.projectred.core.AlloySmelterRecipe;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.BlockBasics;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.core.GhostContainer;
import mrtjp.projectred.core.GuiRestrictedSlot;
import mrtjp.projectred.core.SimpleInventory;
import mrtjp.projectred.core.TileBasicsBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.chunk.Chunk;

public class TileAlloySmelter
extends TileBasicsBase
implements IInventory {
    private SimpleInventory _inv = new SimpleInventory(11, "alloy", 64);
    boolean updateNextTick;
    public boolean hasWork = false;
    public int progress = 0;
    public int heat = 0;
    public boolean queueWatcherUpdate = false;
    public boolean queueWorkUpdate = false;
    public int burnTimeForRecipe = 0;

    @Override
    public void onBlockBreak() {
        BasicUtils.dropItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, new ItemStack(ProjectRedCore.blockMachines.field_71990_ca, 1, BlockBasics.EnumBasics.ALLOYSMELTER.meta));
        this._inv.dropContents(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Container getContainer(EntityPlayer player) {
        GhostContainer ghost = new GhostContainer((IInventory)player.field_71071_by, this);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int slotNumber = i * 3 + j;
                ghost.addNormalSlot(slotNumber, this, 44 + j * 18, 17 + i * 18);
            }
        }
        ghost.addRestrictedSlot(9, (IInventory)this, 107, 17, new GuiRestrictedSlot.ISlotCheck(){

            @Override
            public boolean isSlotAllowed(ItemStack stack) {
                return TileAlloySmelter.this.getItemBurnTime(stack) > 0;
            }
        });
        ghost.addRestrictedSlot(10, (IInventory)this, 141, 47, -1);
        ghost.addNormalSlotsForPlayerInventory(8, 84);
        return ghost;
    }

    @Override
    public void onBlockClicked(EntityPlayer player) {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (!player.func_70093_af()) {
            player.openGui((Object)ProjectRedCore.instance, 1, player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return false;
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this._inv.writeToNBT(nbt);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("time", this.burnTimeForRecipe);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this._inv.readFromNBT(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.progress = nbt.func_74762_e("progress");
        this.burnTimeForRecipe = nbt.func_74762_e("time");
        this.updateNextTick = true;
    }

    @Override
    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 3, nbt);
    }

    public int func_70302_i_() {
        return this._inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this._inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this._inv.func_70298_a(i, j);
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        return this._inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._inv.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return this._inv.func_70303_b();
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return this._inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this._inv.func_70300_a(player);
    }

    public void func_70295_k_() {
        this._inv.func_70295_k_();
    }

    public void func_70305_f() {
        this._inv.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public int getLightLevel() {
        return this.heat > 0 ? (this.hasWork ? 13 : 10) : 0;
    }

    @Override
    public void func_70316_g() {
        AlloySmelterRecipe r;
        if (this.queueWorkUpdate) {
            this.queueWorkUpdate = false;
            this.hasWork = this.hasWork();
        }
        if (this.hasWork && this.heat <= 0) {
            this.eatFuel();
            if (this.heat > 0) {
                this.queueWatcherUpdate = true;
                this.updateNextTick = true;
            }
        }
        if (this.heat > 0) {
            if (BasicUtils.isClient(this.field_70331_k)) {
                this.spawnParticles();
            }
            if (this.hasWork) {
                ++this.progress;
            }
            if (this.heat > 0) {
                --this.heat;
            }
            if (this.heat <= 0) {
                this.updateNextTick = true;
            }
            this.queueWatcherUpdate = true;
        }
        if (this.hasWork && this.progress >= this.burnTimeForRecipe && (r = this.getSuggestedRecipe()) != null) {
            this.eatAllResourcesForRecipe(r);
            ItemStack result = r.getResult();
            r._handler.onItemCrafted(result);
            if (this._inv.func_70301_a(10) == null) {
                this._inv.func_70299_a(10, result);
            } else {
                ItemStack inslot = this._inv.func_70301_a(10);
                inslot.field_77994_a += result.field_77994_a;
                this._inv.func_70299_a(10, inslot);
            }
            this.progress = 0;
            this.burnTimeForRecipe = 0;
            this.queueWatcherUpdate = true;
            this.queueWorkUpdate = true;
            this.updateNextTick = true;
        }
        if (this.queueWatcherUpdate) {
            this.queueWatcherUpdate = false;
            this.updateWatchers();
        }
        if (this.updateNextTick) {
            this.updateNextTick = false;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
    }

    public void updateWatchers() {
        if (BasicUtils.isClient(this.field_70331_k)) {
            return;
        }
        PacketCustom packet = new PacketCustom(CoreSPH.channel, 3);
        packet.writeCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        packet.writeShort(this.heat);
        packet.writeShort(this.progress);
        Chunk c = this.field_70331_k.func_72938_d(this.field_70329_l, this.field_70327_n);
        packet.sendToChunk(this.field_70331_k, c.field_76635_g, c.field_76647_h);
    }

    public boolean hasWork() {
        boolean shouldWork;
        AlloySmelterRecipe r = this.getSuggestedRecipe();
        boolean bl = shouldWork = r != null && (this._inv.func_70301_a(10) == null || BasicUtils.areStacksTheSame(this._inv.func_70301_a(10), r.getResult()) && this._inv.func_70301_a((int)10).field_77994_a + r.getResult().field_77994_a <= this._inv.func_70297_j_());
        if (shouldWork) {
            this.burnTimeForRecipe = r.getBurnTime();
            this.updateNextTick = true;
            return true;
        }
        this.progress = 0;
        this.burnTimeForRecipe = 0;
        return false;
    }

    private void eatFuel() {
        int burntime = this.getItemBurnTime(this._inv.func_70301_a(9));
        if (burntime > 0) {
            this._inv.func_70298_a(9, 1);
            this.heat += burntime;
            if (this.heat > 6400) {
                this.heat = 6400;
            }
        }
    }

    private void eatResource(ItemStack s) {
        int missing = s.field_77994_a;
        block0: while (missing > 0) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stackinslot = this._inv.func_70301_a(i);
                if (stackinslot == null || !BasicUtils.areStacksTheSame(stackinslot, s)) continue;
                this._inv.func_70298_a(i, 1);
                if (--missing <= 0) continue block0;
            }
        }
    }

    private void eatAllResourcesForRecipe(AlloySmelterRecipe r) {
        for (ItemStack s : r.getMatrix()) {
            this.eatResource(s);
        }
    }

    public AlloySmelterRecipe getSuggestedRecipe() {
        for (AlloySmelterRecipe r : AlloySmelterRecipe.getAlloyRecipes()) {
            if (!r.calculateMatch(this.getCraftingMatrix())) continue;
            return r;
        }
        return null;
    }

    private ItemStack[] getCraftingMatrix() {
        ItemStack[] matrix = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            ItemStack inslot = this._inv.func_70301_a(i);
            matrix[i] = inslot != null ? inslot.func_77946_l() : null;
        }
        return matrix;
    }

    private int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int i = stack.func_77973_b().field_77779_bT;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[i] != null) {
            Block block = Block.field_71973_m[i];
            if (block == Block.field_72092_bO) {
                return 150;
            }
            if (block.field_72018_cp == Material.field_76245_d) {
                return 300;
            }
            if (block == Block.field_111034_cE) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_77825_f().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (i == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (i == Item.field_77705_m.field_77779_bT) {
            return 1600;
        }
        if (i == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (i == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (i == Item.field_77731_bo.field_77779_bT) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void func_70296_d() {
        this.queueWorkUpdate = true;
    }

    @Override
    public BlockBasics.EnumBasics getType() {
        return BlockBasics.EnumBasics.ALLOYSMELTER;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase player, ItemStack item) {
    }
}

