/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.integration.ArrayGatePart;
import mrtjp.projectred.integration.GateLogic;
import mrtjp.projectred.transmission.IRedwireEmitter;

public abstract class ArrayGateLogic
extends GateLogic<ArrayGatePart> {
    public static ArrayGateLogic[] logic = new ArrayGateLogic[]{new Null(), new Invert(), new Buffer()};

    @Override
    public boolean canConnectTo(ArrayGatePart gate, IConnectable wire, int r) {
        return wire instanceof IRedwireEmitter;
    }

    @Override
    public void onChange(ArrayGatePart gate) {
        boolean newSignal;
        boolean oldSignal = (gate.state & 1) != 0;
        boolean bl = newSignal = gate.signal1 != 0;
        if (oldSignal != newSignal) {
            gate.setState(gate.state & 2 | (newSignal ? 1 : 0));
            gate.scheduleTick(2);
            gate.tile().markDirty();
        }
    }

    @Override
    public void scheduledTick(ArrayGatePart gate) {
        boolean newOutput;
        boolean input = (gate.state & 1) != 0;
        boolean oldOutput = (gate.state & 2) != 0;
        boolean bl = newOutput = !input;
        if (oldOutput != newOutput) {
            gate.setState(gate.state & 1 | (newOutput ? 2 : 0));
            gate.sendStateUpdate();
            gate.tile().markDirty();
            gate.onChange();
        }
    }

    public boolean canCross() {
        return false;
    }

    public abstract boolean powerUp(int var1);

    public static class Buffer
    extends ArrayGateLogic {
        @Override
        public boolean powerUp(int state) {
            return (state & 2) == 0;
        }
    }

    public static class Invert
    extends ArrayGateLogic {
        @Override
        public boolean powerUp(int state) {
            return (state & 2) != 0;
        }
    }

    public static class Null
    extends ArrayGateLogic {
        @Override
        public boolean powerUp(int state) {
            return false;
        }

        @Override
        public boolean canCross() {
            return true;
        }
    }
}

