/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRandomDisplayTick;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import java.util.Random;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.ArrayGateLogic;
import mrtjp.projectred.integration.EnumGate;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RenderGate;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.WirePropogator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class ArrayGatePart
extends GatePart
implements IRedwirePart,
IFaceRedstonePart,
IRandomDisplayTick,
ArrayCommons.ITopArrayWire {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    public static Cuboid6[] cBoxes = new Cuboid6[6];
    public byte signal1;
    public byte signal2;
    public byte state;

    @Override
    public ArrayGateLogic getLogic() {
        return ArrayGateLogic.logic[this.subID - EnumGate.NullCell.ordinal()];
    }

    @Override
    public String getType() {
        return "pr_agate";
    }

    public int state() {
        return this.state & 0xFF;
    }

    public void setState(int newState) {
        this.state = (byte)newState;
    }

    public void sendStateUpdate() {
        this.getWriteStream(11).writeByte((int)this.state);
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74774_a("s1", this.signal1);
        tag.func_74774_a("s2", this.signal2);
        tag.func_74774_a("state", this.state);
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.signal1 = tag.func_74771_c("s1");
        this.signal2 = tag.func_74771_c("s2");
        this.state = tag.func_74771_c("state");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal1);
        packet.writeByte((int)this.signal2);
        packet.writeByte((int)this.state);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal1 = packet.readByte();
        this.signal2 = packet.readByte();
        this.state = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 10) {
            this.signal1 = packet.readByte();
            this.signal2 = packet.readByte();
            this.tile().markRender();
        } else if (switch_key == 11) {
            this.state = packet.readByte();
            this.tile().markRender();
        } else {
            super.read(packet, switch_key);
        }
    }

    @Override
    public void updateAndPropogate(TMultiPart prev, int mode) {
        int wireMask = this.wireMask(prev);
        if ((wireMask & 1) != 0) {
            this.updateAndPropogate(0, prev, mode);
        }
        if ((wireMask & 2) != 0) {
            this.updateAndPropogate(1, prev, mode);
        }
    }

    private void updateAndPropogate(int wire, TMultiPart prev, int mode) {
        int oldSignal = this.getRedwireSignal(this.toAbsolute(wire));
        if (mode == 1 && oldSignal == 0) {
            return;
        }
        int pMask = 5 << wire;
        int newSignal = this.calculateSignal(pMask);
        if (newSignal < oldSignal) {
            this.setRedwireSignal(wire, 0);
            this.propogate(pMask, prev, 1);
        } else if (newSignal > oldSignal) {
            this.setRedwireSignal(wire, newSignal);
            if (mode == 1) {
                this.propogate(pMask, null, 0);
            } else {
                this.propogate(pMask, prev, 0);
            }
        } else if (mode == 1) {
            this.propogateTo(prev, 0);
        } else if (mode == 2) {
            this.propogate(pMask, prev, 3);
        }
    }

    public int calculateSignal(int pMask) {
        if (pMask == 10 && this.getLogic().powerUp(this.state())) {
            return 255;
        }
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int s = 0;
        int i = 0;
        for (int r = 0; r < 4; ++r) {
            if ((pMask & 1 << this.toInternal(r)) == 0 || (i = (this.connMap & 1 << r) != 0 ? this.calculateCornerSignal(r) : this.calculateStraightSignal(r)) <= s) continue;
            s = i;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return s;
    }

    public int calculateCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord cnrPos = new BlockCoord(this.getTile()).offset(absDir);
        BlockCoord pos = cnrPos.copy().offset(this.side());
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    public int calculateStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int s = 0;
        BlockCoord pos = new BlockCoord(this.getTile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (this.connMap & 16 << r) != 0) {
            TMultiPart tp = t.partMap(this.side());
            if (tp != null) {
                s = this.getPartSignal(tp, (r + 2) % 4);
            }
        } else {
            int blockID = this.world().func_72798_a(pos.x, pos.y, pos.z);
            if (blockID == Block.field_72075_av.field_71990_ca) {
                return this.world().func_72805_g(pos.x, pos.y, pos.z) - 1;
            }
        }
        int i = this.calculateRedstoneSignal(r);
        if (i > s) {
            s = i;
        }
        return s;
    }

    public int calculateRedstoneSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int i = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)absDir) * 17;
        if (i > 0) {
            return i;
        }
        BlockCoord pos = new BlockCoord(this.getTile()).offset(absDir);
        return this.world().func_72878_l(pos.x, pos.y, pos.z, absDir) * 17;
    }

    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwirePart && ((IRedwirePart)part).isWireSide(r)) {
            return ((IRedwirePart)part).getRedwireSignal(r) - 1;
        }
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        return 0;
    }

    public void setRedwireSignal(int wire, int newSignal) {
        if (wire == 0) {
            this.signal1 = (byte)newSignal;
        } else {
            this.signal2 = (byte)newSignal;
        }
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
        super.onChange();
        this.getWriteStream(10).writeByte((int)this.signal1).writeByte((int)this.signal2);
    }

    public void propogate(int pMask, TMultiPart prev, int mode) {
        if (mode != 3) {
            WirePropogator.addPartChange((TMultiPart)this);
        }
        for (int r = 0; r < 4; ++r) {
            if ((pMask & 1 << this.toInternal(r)) == 0) continue;
            if ((this.connMap & 1 << r) != 0) {
                this.propogateCorner(r, prev, mode);
                continue;
            }
            this.propogateStraight(r, prev, mode);
        }
    }

    public void propogateCorner(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord(this.getTile()).offset(absDir).offset(this.side());
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(absDir ^ 1);
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public void propogateStraight(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord(this.getTile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(this.side());
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public int wireMask(TMultiPart propogator) {
        if (propogator.tile() == null) {
            return 3;
        }
        if (this.sideDiff(propogator) == Rotation.rotateSide((int)this.side(), (int)this.toAbsolute(0)) >> 1) {
            return 1;
        }
        return 2;
    }

    public int sideDiff(TMultiPart part) {
        int a = this.side() >> 1;
        if (a != 0 && this.y() != part.y()) {
            return 0;
        }
        if (a != 1 && this.z() != part.z()) {
            return 1;
        }
        return 2;
    }

    public boolean propogateTo(TMultiPart part, int mode) {
        if (part instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)part, (TMultiPart)this, mode);
            return true;
        }
        return false;
    }

    @Override
    public int getRedwireSignal(int side) {
        return (this.toInternal(side) % 2 == 0 ? this.signal1 : this.signal2) & 0xFF;
    }

    public void randomDisplayTick(Random rand) {
        RenderGate.spawnParticles(this, rand);
    }

    @Override
    public void onChange() {
        super.onChange();
        WirePropogator.propogateTo(this, 0);
    }

    public boolean canConnectRedstone(int side) {
        return (side & 6) != (this.side() & 6);
    }

    public int getFace() {
        return this.side();
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return 0;
        }
        return this.rsLevel(this.getRedwireSignal(Rotation.rotationTo((int)this.side(), (int)side)));
    }

    public int rsLevel(int i) {
        if (WirePropogator.redwiresProvidePower) {
            return (i + 16) / 17;
        }
        return 0;
    }

    @Override
    public boolean isWireSide(int side) {
        return side >= 0;
    }

    @Override
    public Cuboid6 getBounds() {
        return cBoxes[this.side()];
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(oBoxes[this.side()]);
    }

    @Override
    public void rotate() {
        int r = this.rotation();
        this.setRotation((r + 1) % 4);
        boolean b = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        this.setRotation(r);
        if (b) {
            super.rotate();
        }
    }

    @Override
    public void preparePlacement(EntityPlayer player, BlockCoord pos, int side, int meta) {
        TMultiPart npart;
        TileMultipart t;
        super.preparePlacement(player, pos, side, meta);
        if (this.getLogic().canCross() && (t = BasicUtils.getMultipartTile((IBlockAccess)player.field_70170_p, (BlockCoord)pos)) != null && (npart = t.partMap(this.side() ^ 1)) instanceof ArrayGatePart) {
            ArrayGatePart apart = (ArrayGatePart)npart;
            if (apart.subID == this.subID && (apart.rotation() & 1) == (this.rotation() & 1)) {
                this.setRotation((this.rotation() + 1) % 4);
            }
        }
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        if (this.getLogic().canCross() && npart instanceof ArrayGatePart) {
            ArrayGatePart apart = (ArrayGatePart)npart;
            if (apart.subID == this.subID && apart.side() == (this.side() ^ 1) && (apart.rotation() & 1) != (this.rotation() & 1)) {
                return true;
            }
        }
        return super.occlusionTest(npart);
    }

    static {
        ArrayGatePart.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.75, 1.0);
        ArrayGatePart.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.75, 0.875);
        ArrayGatePart.cBoxes[0] = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        for (int s = 1; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(Vector3.center);
            ArrayGatePart.oBoxes[s][0] = oBoxes[0][0].copy().apply(t);
            ArrayGatePart.oBoxes[s][1] = oBoxes[0][1].copy().apply(t);
            ArrayGatePart.cBoxes[s] = cBoxes[0].copy().apply(t);
        }
    }
}

