/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.integration.BundledGatePart;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.transmission.BundledCableCommons;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BundledGateLogic
extends RedstoneGateLogic<BundledGatePart> {
    public BundledGatePart gate;

    public static BundledGateLogic create(BundledGatePart gate, int subID) {
        if (subID == 22) {
            return new BusTransceiver(gate);
        }
        return null;
    }

    public BundledGateLogic(BundledGatePart gate) {
        this.gate = gate;
    }

    @Override
    public boolean canConnectTo(BundledGatePart gate, IConnectable wire, int r) {
        if (super.canConnectTo(gate, wire, r)) {
            return true;
        }
        if (wire instanceof IBundledEmitter) {
            return this.canConnectBundled(gate, r);
        }
        return false;
    }

    public boolean canConnectBundled(BundledGatePart gate, int r) {
        return this.canConnectBundled(gate.shape(), r);
    }

    public boolean canConnectBundled(int shape, int r) {
        return ((this.bundledInputMask(shape) | this.bundledOutputMask(shape)) & 1 << r) != 0;
    }

    public int bundledInputMask(int shape) {
        return 0;
    }

    public int bundledOutputMask(int shape) {
        return 0;
    }

    @Override
    public int getOutput(BundledGatePart gate, int r) {
        return (gate.state & 16 << r) != 0 ? 15 : 0;
    }

    public byte[] getBundledOutput(BundledGatePart gate, int r) {
        return new byte[16];
    }

    @Override
    public void onChange(BundledGatePart gate) {
    }

    @Override
    public void scheduledTick(BundledGatePart gate) {
    }

    public void save(NBTTagCompound tag) {
    }

    public void load(NBTTagCompound tag) {
    }

    public void readDesc(MCDataInput packet) {
    }

    public void writeDesc(MCDataOutput packet) {
    }

    public void read(MCDataInput packet, int switch_key) {
    }

    public static class BusTransceiver
    extends BundledGateLogic {
        public byte[] input0 = new byte[16];
        public byte[] input2 = new byte[16];

        public BusTransceiver(BundledGatePart gate) {
            super(gate);
        }

        @Override
        public void save(NBTTagCompound tag) {
            tag.func_74773_a("in0", this.input0);
            tag.func_74773_a("in2", this.input2);
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.input0 = tag.func_74770_j("in0");
            this.input2 = tag.func_74770_j("in2");
        }

        @Override
        public void readDesc(MCDataInput packet) {
            this.unpackClientData(packet.readInt());
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            packet.writeInt(this.packClientData());
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 11) {
                this.unpackClientData(packet.readInt());
            }
        }

        public void sendClientUpdate() {
            this.gate.getWriteStream(11).writeInt(this.packClientData());
        }

        public int packClientData() {
            int packed = 0;
            for (int i = 0; i < 16; ++i) {
                if (this.input0[i] != 0) {
                    packed |= 1 << i;
                }
                if (this.input2[i] == 0) continue;
                packed |= 1 << i + 16;
            }
            return packed;
        }

        public void unpackClientData(int packed) {
            this.input0 = new byte[16];
            this.input2 = new byte[16];
            for (int i = 0; i < 16; ++i) {
                if ((packed & 1 << i) != 0) {
                    this.input0[i] = -1;
                }
                if ((packed & 1 << i + 16) == 0) continue;
                this.input2[i] = -1;
            }
        }

        @Override
        public int bundledInputMask(int shape) {
            return 5;
        }

        @Override
        public int bundledOutputMask(int shape) {
            return 5;
        }

        @Override
        public int inputMask(int shape) {
            return 10;
        }

        @Override
        public int outputMask(int shape) {
            return 0;
        }

        @Override
        public byte[] getBundledOutput(BundledGatePart gate, int r) {
            return r == gate.rotation() ? this.input0 : this.input2;
        }

        public byte[] getBundledInput(int input, int r) {
            byte[] signal = this.gate.getBundledInput(r);
            byte[] byArray = signal = signal == null ? new byte[16] : (byte[])signal.clone();
            if ((input & 1 << (r + 1) % 4) != 0) {
                signal = BundledCableCommons.raiseSignal(signal, this.getBundledOutput(this.gate, r));
            }
            return signal;
        }

        @Override
        public void onChange(BundledGatePart gate) {
            byte[] newInput2;
            byte[] newInput0;
            int oldInput = gate.state() & 0xF;
            int newInput = this.getInput(gate, 10);
            if (gate.shape() == 1) {
                newInput = GatePart.flipMaskZ(newInput);
            }
            if (oldInput != newInput) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
                gate.scheduleTick(2);
            }
            byte[] byArray = newInput0 = (newInput & 8) != 0 ? this.getBundledInput(newInput, 0) : new byte[16];
            if (!BundledCableCommons.signalsEqual(this.input0, newInput0)) {
                this.input0 = newInput0;
                gate.scheduleTick(2);
            }
            byte[] byArray2 = newInput2 = (newInput & 2) != 0 ? this.getBundledInput(newInput, 2) : new byte[16];
            if (!BundledCableCommons.signalsEqual(this.input2, newInput2)) {
                this.input2 = newInput2;
                gate.scheduleTick(2);
            }
        }

        @Override
        public void scheduledTick(BundledGatePart gate) {
            gate.onOutputChange(5);
            this.sendClientUpdate();
        }

        @Override
        public boolean cycleShape(BundledGatePart gate) {
            gate.setShape(gate.shape() == 0 ? 1 : 0);
            return true;
        }
    }
}

