/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.ArrayGatePart;
import mrtjp.projectred.integration.BundledGateLogic;
import mrtjp.projectred.integration.BundledGatePart;
import mrtjp.projectred.integration.ComponentStore;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.InstancedRsGateLogic;
import mrtjp.projectred.integration.InstancedRsGatePart;
import mrtjp.projectred.integration.RowGatePart;
import mrtjp.projectred.integration.SimpleGatePart;
import net.minecraft.client.renderer.texture.IconRegister;

public class RenderGate {
    public static GateRenderer[] renderers = new GateRenderer[]{new OR(), new NOR(), new NOT(), new AND(), new NAND(), new XOR(), new XNOR(), new Buffer(), new Multiplexer(), new Pulse(), new Repeater(), new Randomizer(), new RSLatch(), new ToggleLatch(), new TransparentLatch(), new LightSensor(), new RainSensor(), new Timer(), new Sequencer(), new Counter(), new StateCell(), new Synchronizer(), new BusXcvr(), new NullCell(), new InvertCell(), new BufferCell(), new Comparator(), new ANDCell()};

    public static void registerIcons(IconRegister r) {
        for (GateRenderer render : renderers) {
            render.registerIcons(r);
        }
    }

    public static void renderStatic(GatePart gate) {
        GateRenderer r = renderers[gate.subID & 0xFF];
        r.prepare(gate);
        r.renderStatic((Transformation)new Translation((double)gate.x(), (double)gate.y(), (double)gate.z()), gate.orientation & 0xFF);
    }

    public static void renderDynamic(GatePart gate, Vector3 pos, float frame) {
        GateRenderer r = renderers[gate.subID & 0xFF];
        if (r.hasSpecials()) {
            r.prepareDynamic(gate, frame);
            r.renderDynamic((Transformation)gate.rotationT().with((Transformation)pos.translation()));
        }
    }

    public static void renderInv(Transformation t, int id) {
        GateRenderer r = renderers[id];
        TextureUtils.bindAtlas((int)0);
        r.prepareInv();
        CCRenderState.startDrawing((int)7);
        r.renderStatic(t, 0);
        CCRenderState.draw();
        if (r.hasSpecials()) {
            r.renderDynamic(t);
        }
    }

    public static void spawnParticles(GatePart gate, Random rand) {
        renderers[gate.subID & 0xFF].spawnParticles(gate, rand);
    }

    public static class ANDCell
    extends GateRenderer<RowGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("ANDCELL", 2);
        ComponentStore.CellTopWireModel topWire = new ComponentStore.CellTopWireModel(ComponentStore.nullCellWireTop);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.FlippedRSTorchModel(8.0, 8.0)};

        public ANDCell() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.topWire);
            this.models.add(new ComponentStore.CellFrameModel());
        }

        @Override
        public void prepareInv() {
            this.topWire.signal = 0;
            this.topWire.invColour = true;
            this.topWire.conn = 0;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.wires[0].on = true;
            this.wires[1].on = false;
        }

        @Override
        public void prepare(RowGatePart part) {
            super.prepare(part);
            this.topWire.signal = part.signal;
            this.topWire.conn = ArrayCommons.topWireConn(part);
            this.topWire.invColour = false;
            this.torches[0].on = (part.state & 4) == 0;
            this.torches[1].on = (part.state & 0x10) != 0;
            this.torches[2].on = (part.state & 0xA) == 0;
            this.wires[0].on = this.torches[0].on || this.torches[2].on;
            this.wires[1].on = !this.torches[0].on;
        }
    }

    public static class Comparator
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("COMPARATOR", 4);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 2.0, 6);
        ComponentStore.OnOffModel[] chips = new ComponentStore.OnOffModel[]{new ComponentStore.MinusChipModel(5.0, 8.0), new ComponentStore.PlusChipModel(11.0, 8.0)};

        public Comparator() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.torch.on = false;
        }

        @Override
        public void prepare(InstancedRsGatePart gate) {
            this.reflect = gate.shape() != 0;
            this.wires[0].on = (gate.state & 0x10) == 0;
            this.wires[1].on = (gate.state & 2) != 0;
            this.wires[2].on = (gate.state & 4) != 0;
            this.wires[3].on = (gate.state & 8) != 0;
            this.chips[0].on = (gate.state & 1) != 0 && gate.shape == 1;
            this.chips[1].on = (gate.state & 1) != 0 && gate.shape != 1;
            boolean bl = this.torch.on = (gate.state & 0x10) != 0;
            if (gate.shape() != 0) {
                boolean a = this.wires[1].on;
                boolean b = this.wires[3].on;
                this.wires[3].on = a;
                this.wires[1].on = b;
            }
        }

        @Override
        public void renderModels(Transformation t, int orient) {
            super.renderModels(t, orient);
            this.chips[0].renderModel(t, orient % 24);
            this.chips[1].renderModel(t, orient % 24);
        }
    }

    public static class BufferCell
    extends ArrayCell {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("BUFFCELL", 2);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(11.0, 13.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6)};

        public BufferCell() {
            super(new ComponentStore.CellTopWireModel(ComponentStore.extendedCellWireTop), new ComponentStore.CellBottomWireModel(ComponentStore.extendedCellWireBottom));
            this.models.add(new ComponentStore.ExtendedCellBaseModel());
            this.models.add(new ComponentStore.CellPlateModel());
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            super.prepareInv();
            this.wires[0].on = false;
            this.wires[1].on = true;
            this.torches[0].on = true;
            this.torches[1].on = false;
        }

        @Override
        public void prepare(ArrayGatePart gate) {
            super.prepare(gate);
            this.torches[0].on = gate.signal1 == 0;
            this.torches[1].on = gate.signal1 != 0;
            this.wires[0].on = gate.signal1 != 0;
            this.wires[1].on = gate.signal1 == 0;
        }
    }

    public static class InvertCell
    extends ArrayCell {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("INVCELL", 1);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6);

        public InvertCell() {
            super(new ComponentStore.CellTopWireModel(ComponentStore.extendedCellWireTop), new ComponentStore.CellBottomWireModel(ComponentStore.extendedCellWireBottom));
            this.models.add(new ComponentStore.ExtendedCellBaseModel());
            this.models.add(new ComponentStore.CellPlateModel());
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            super.prepareInv();
            this.wires[0].on = false;
            this.torch.on = true;
        }

        @Override
        public void prepare(ArrayGatePart gate) {
            super.prepare(gate);
            this.torch.on = gate.signal1 == 0;
            this.wires[0].on = gate.signal1 != 0;
        }
    }

    public static class NullCell
    extends ArrayCell {
        public NullCell() {
            super(new ComponentStore.CellTopWireModel(ComponentStore.nullCellWireTop), new ComponentStore.CellBottomWireModel(ComponentStore.nullCellWireBottom));
            this.models.add(new ComponentStore.NullCellBaseModel());
        }
    }

    public static class ArrayCell
    extends GateRenderer<ArrayGatePart> {
        public ComponentStore.CellBottomWireModel bottomWire;
        public ComponentStore.CellTopWireModel topWire;

        public ArrayCell(ComponentStore.CellTopWireModel topWire, ComponentStore.CellBottomWireModel bottomWire) {
            this.topWire = topWire;
            this.bottomWire = bottomWire;
            this.models.clear();
            this.models.add(topWire);
            this.models.add(bottomWire);
            this.models.add(new ComponentStore.CellFrameModel());
        }

        @Override
        public void prepareInv() {
            this.bottomWire.signal = 0;
            this.bottomWire.invColour = true;
            this.topWire.signal = 0;
            this.topWire.invColour = true;
            this.topWire.conn = 0;
        }

        @Override
        public void prepare(ArrayGatePart part) {
            super.prepare(part);
            this.bottomWire.signal = part.signal1;
            this.bottomWire.invColour = false;
            this.topWire.signal = part.signal2;
            this.topWire.conn = ArrayCommons.topWireConn(part);
            this.topWire.invColour = false;
        }
    }

    public static class BusXcvr
    extends GateRenderer<BundledGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("BUSXCVR", 2);
        ComponentStore.BusXcvrCableModel cable = new ComponentStore.BusXcvrCableModel();
        ComponentStore.BusXcvrPanelModel[] panels = new ComponentStore.BusXcvrPanelModel[]{new ComponentStore.BusXcvrPanelModel(4.0, 8.0, false), new ComponentStore.BusXcvrPanelModel(12.0, 8.0, true)};

        public BusXcvr() {
            this.models.add(this.cable);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.panels));
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.panels[0].signal = 0;
            this.panels[1].signal = 0;
        }

        @Override
        public void prepare(BundledGatePart gate) {
            this.reflect = gate.shape() != 0;
            int state = gate.state();
            if (this.reflect) {
                state = GatePart.flipMaskZ(state);
            }
            this.wires[0].on = (gate.state() & 2) != 0;
            this.wires[1].on = (gate.state() & 8) != 0;
            BundledGateLogic.BusTransceiver logic = (BundledGateLogic.BusTransceiver)gate.getLogic();
            int packed = logic.packClientData();
            this.panels[0].signal = packed & 0xFFFF;
            this.panels[1].signal = packed >>> 16;
        }
    }

    public static class Synchronizer
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("SYNC", 6);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6);
        ComponentStore.RedChipModel[] chips = new ComponentStore.RedChipModel[]{new ComponentStore.RedChipModel(4.5, 9.0), new ComponentStore.RedChipModel(11.5, 9.0)};

        public Synchronizer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = true;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.torch.on = false;
        }

        @Override
        public void prepare(InstancedRsGatePart gate) {
            InstancedRsGateLogic.Synchronizer logic = (InstancedRsGateLogic.Synchronizer)gate.getLogic();
            this.wires[0].on = !logic.left();
            this.wires[1].on = !logic.right();
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[3].on = logic.left() && logic.right();
            this.wires[4].on = (gate.state() & 8) != 0;
            this.wires[5].on = (gate.state() & 2) != 0;
            this.chips[0].on = logic.left();
            this.chips[1].on = logic.right();
            this.torch.on = (gate.state() & 0x10) != 0;
        }
    }

    public static class StateCell
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("STATECELL", 5);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(10.0, 3.5, 6), new ComponentStore.RedstoneTorchModel(13.0, 8.0, 12)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(13.0, 8.0, 8.0);
        ComponentStore.RedChipModel chip = new ComponentStore.RedChipModel(6.5, 10.0);

        public StateCell() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.chip);
        }

        public InstancedRsGateLogic.StateCell getLogic(InstancedRsGatePart part) {
            return (InstancedRsGateLogic.StateCell)part.getLogic();
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
            this.chip.on = false;
            this.pointer.angle = -1.5707963267948966;
        }

        @Override
        public void prepare(InstancedRsGatePart part) {
            this.reflect = part.shape == 1;
            int state = part.state();
            if (this.reflect) {
                state = GatePart.flipMaskZ(state >> 4) << 4 | GatePart.flipMaskZ(state);
            }
            this.wires[0].on = (state & 0x10) != 0;
            this.wires[1].on = (state & 4) != 0;
            this.wires[2].on = this.getLogic((InstancedRsGatePart)part).state2 == 0 || (state & 4) != 0;
            this.wires[3].on = (state & 0x88) != 0;
            this.wires[4].on = (state & 2) != 0;
            this.torches[0].on = (state & 0x10) != 0;
            this.torches[1].on = this.getLogic((InstancedRsGatePart)part).pointer_start >= 0L;
            this.chip.on = this.getLogic((InstancedRsGatePart)part).state2 != 0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart part, float frame) {
            this.reflect = part.shape == 1;
            this.pointer.angle = (double)this.getLogic(part).interpPointer(frame) - 1.5707963267948966;
        }

        @Override
        public void renderDynamic(Transformation t) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(t, this.reflect ? 1 : 0);
            CCRenderState.draw();
        }
    }

    public static class Counter
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("COUNT", 2);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(11.0, 8.0, 12), new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(11.0, 8.0, 8.0, 1.2);

        public Counter() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.torches[0].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart gate) {
            this.reflect = gate.shape() == 1;
            this.wires[0].on = (gate.state() & 8) != 0;
            this.wires[1].on = (gate.state() & 2) != 0;
            this.torches[1].on = (gate.state() & 0x10) != 0;
            this.torches[2].on = (gate.state() & 0x40) != 0;
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.pointer.angle = 3.83972435438746;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart gate, float frame) {
            int max = ((InstancedRsGateLogic.Counter)gate.getLogic()).max;
            int val = ((InstancedRsGateLogic.Counter)gate.getLogic()).value;
            this.pointer.angle = ((double)val / (double)max * 120.0 + 210.0) * 0.017453292519943;
            if (gate.shape() == 1) {
                this.reflect = true;
            }
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void renderDynamic(Transformation t) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(t, this.reflect ? 1 : 0);
            CCRenderState.draw();
        }
    }

    public static class Sequencer
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 8.0, 12), new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(13.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6), new ComponentStore.RedstoneTorchModel(3.0, 8.0, 6)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(8.0, 8.0, 8.0);

        public Sequencer() {
            this.models.addAll(Arrays.asList(this.torches));
            this.torches[0].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart gate) {
            this.torches[1].on = (gate.state & 0x10) != 0;
            this.torches[2].on = (gate.state & 0x20) != 0;
            this.torches[3].on = (gate.state & 0x40) != 0;
            this.torches[4].on = (gate.state & 0x80) != 0;
        }

        @Override
        public void prepareInv() {
            this.torches[1].on = false;
            this.torches[2].on = false;
            this.torches[3].on = false;
            this.torches[4].on = false;
            this.pointer.angle = 0.0;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart gate, float frame) {
            int max = ((InstancedRsGateLogic.Sequencer)gate.getLogic()).pointer_max;
            this.pointer.angle = (double)(((float)(gate.world().func_72820_D() % (long)max) + frame) / (float)max * 2.0f) * Math.PI;
            if (gate.shape() == 1) {
                this.pointer.angle = -this.pointer.angle;
            }
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void renderDynamic(Transformation t) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(t, 0);
            CCRenderState.draw();
        }
    }

    public static class Timer
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("TIME", 3);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 12)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(8.0, 8.0, 8.0);

        public Timer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.torches[1].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart part) {
            this.torches[0].on = (part.state & 0x10) != 0;
            this.wires[0].on = (part.state & 0x88) != 0;
            this.wires[1].on = (part.state & 0x22) != 0;
            this.wires[2].on = (part.state & 4) != 0;
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.torches[0].on = false;
            this.pointer.angle = 0.0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart part, float frame) {
            this.pointer.angle = (double)((InstancedRsGateLogic.TimerGateLogic)part.getLogic()).interpPointer(frame) * Math.PI * 2.0;
        }

        @Override
        public void renderDynamic(Transformation t) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(t, 0);
            CCRenderState.draw();
        }
    }

    public static class RainSensor
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("RAINSENSOR", 1);
        ComponentStore.RainSensorModel solar = new ComponentStore.RainSensorModel(8.0, 6.0);

        public RainSensor() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.solar);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x44) != 0;
        }
    }

    public static class LightSensor
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("LIGHTSENSOR", 1);
        ComponentStore.SolarModel solar = new ComponentStore.SolarModel(8.0, 5.5);

        public LightSensor() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.solar);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.solar.state = 0;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0xF4) != 0;
            this.solar.state = part.shape();
        }
    }

    public static class TransparentLatch
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("TRANSLATCH", 5);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 12.5, 6), new ComponentStore.RedstoneTorchModel(4.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(14.0, 8.0, 8)};

        public TransparentLatch() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.torches[3].on = false;
            this.torches[4].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.reflect = part.shape() == 1;
            boolean on = (part.state & 0x10) != 0;
            this.wires[0].on = !on;
            this.wires[1].on = (part.state & 4) != 0;
            this.wires[2].on = (part.state & 4) == 0;
            this.wires[3].on = on;
            this.wires[4].on = (part.state & 0xA) != 0;
            this.torches[0].on = this.wires[2].on;
            this.torches[1].on = !this.wires[2].on && !this.wires[4].on;
            this.torches[2].on = !this.wires[1].on && !this.wires[3].on;
            this.torches[3].on = on;
            this.torches[4].on = on;
        }
    }

    public static class ToggleLatch
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("TOGLATCH", 2);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 4.0, 6), new ComponentStore.RedstoneTorchModel(4.0, 12.0, 6)};
        ComponentStore.LeverModel lever = new ComponentStore.LeverModel(11.0, 8.0);

        public ToggleLatch() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.lever);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.lever.state = 0;
        }

        @Override
        public void prepare(InstancedRsGatePart part) {
            this.wires[0].on = (part.state & 8) != 0;
            this.wires[1].on = (part.state & 2) != 0;
            this.torches[0].on = (part.state & 0x10) != 0;
            this.torches[1].on = (part.state & 0x40) != 0;
            this.lever.state = ((InstancedRsGateLogic.ExtraStateLogic)part.getLogic()).state2 != 0 ? 1 : 0;
        }
    }

    public static class RSLatch
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires1 = ComponentStore.generateWireModels("RSLATCH", 2);
        ComponentStore.WireComponentModel[] wires2 = ComponentStore.generateWireModels("RSLATCH2", 4);
        ComponentStore.RedstoneTorchModel[] torches1 = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6)};
        ComponentStore.RedstoneTorchModel[] torches2 = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(9.5, 3.0, 6), new ComponentStore.RedstoneTorchModel(6.5, 13.0, 6)};
        int type = 0;

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.type = 0;
            this.wires1[0].on = false;
            this.wires1[1].on = true;
            this.torches1[0].on = false;
            this.torches1[1].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart part) {
            this.reflect = (part.shape & 1) != 0;
            this.type = part.shape >> 1;
            int state = part.state();
            if (this.reflect) {
                state = GatePart.flipMaskZ(state >> 4) << 4 | GatePart.flipMaskZ(state);
            }
            if (this.type == 0) {
                this.wires1[0].on = (state & 0x88) != 0;
                this.wires1[1].on = (state & 0x22) != 0;
                this.torches1[0].on = (state & 0x10) != 0;
                this.torches1[1].on = (state & 0x40) != 0;
            } else {
                this.wires2[1].on = (state & 2) != 0;
                this.wires2[3].on = (state & 8) != 0;
                this.torches2[0].on = (state & 0x10) != 0;
                this.torches2[1].on = (state & 0x40) != 0;
                this.wires2[0].on = this.torches2[1].on;
                this.wires2[2].on = this.torches2[0].on;
            }
        }

        @Override
        public void renderModels(Transformation t, int orient) {
            super.renderModels(t, orient);
            for (ComponentStore.WireComponentModel wireComponentModel : this.type == 0 ? this.wires1 : this.wires2) {
                ((ComponentStore.ComponentModel)wireComponentModel).renderModel(t, orient);
            }
            for (ComponentStore.ComponentModel componentModel : this.type == 0 ? this.torches1 : this.torches2) {
                componentModel.renderModel(t, orient);
            }
        }

        @Override
        public void registerIcons(IconRegister r) {
            for (ComponentStore.WireComponentModel m : this.wires1) {
                ((ComponentStore.ComponentModel)m).registerTextures(r);
            }
            for (ComponentStore.WireComponentModel m : this.wires2) {
                ((ComponentStore.ComponentModel)m).registerTextures(r);
            }
        }
    }

    public static class Randomizer
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("RANDOM", 4);
        ComponentStore.YellowChipModel[] chips = new ComponentStore.YellowChipModel[]{new ComponentStore.YellowChipModel(8.0, 5.5), new ComponentStore.YellowChipModel(11.5, 12.0), new ComponentStore.YellowChipModel(4.5, 12.0)};

        public Randomizer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.chips[2].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[1].on = (part.state & 4) != 0;
            this.wires[0].on = (part.state & 0x11) != 0;
            this.wires[3].on = (part.state & 0x22) != 0;
            this.wires[2].on = (part.state & 0x88) != 0;
            this.chips[0].on = (part.state & 0x10) != 0;
            this.chips[1].on = (part.state & 0x20) != 0;
            this.chips[2].on = (part.state & 0x80) != 0;
        }
    }

    public static class Repeater
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("REPEATER", 2);
        ComponentStore.RedstoneTorchModel endtorch = new ComponentStore.RedstoneTorchModel(8.0, 2.0, 6);
        ComponentStore.RedstoneTorchModel[] vartorches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(12.5, 12.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 11.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 10.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 9.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 7.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 6.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 5.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 4.0, 6)};
        int shape = 0;

        public Repeater() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.endtorch);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.endtorch.on = true;
            this.shape = 0;
            this.vartorches[0].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x10) == 0;
            this.wires[1].on = (part.state & 4) != 0;
            this.endtorch.on = (part.state & 0x10) != 0;
            this.shape = part.shape();
            this.vartorches[this.shape].on = (part.state & 4) == 0;
        }

        @Override
        public void renderModels(Transformation t, int orient) {
            super.renderModels(t, orient);
            this.vartorches[this.shape].renderModel(t, orient);
        }
    }

    public static class Pulse
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("PULSE", 3);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 9.5, 6), new ComponentStore.RedstoneTorchModel(11.0, 9.5, 6), new ComponentStore.RedstoneTorchModel(8.0, 3.5, 8)};

        public Pulse() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 4) == 0;
            this.wires[1].on = (part.state & 4) != 0;
            this.wires[2].on = (part.state & 0x14) == 4;
            this.torches[0].on = this.wires[0].on;
            this.torches[1].on = this.wires[1].on;
            this.torches[2].on = (part.state & 0x10) != 0;
        }
    }

    public static class Multiplexer
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("MULTIPLEXER", 6);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(9.0, 10.5, 6), new ComponentStore.RedstoneTorchModel(4.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(11.5, 8.0, 6)};

        public Multiplexer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = true;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
            this.torches[2].on = false;
            this.torches[3].on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[2].on = (part.state & 4) == 0;
            this.wires[3].on = (part.state & 4) != 0;
            this.wires[4].on = (part.state & 8) != 0;
            this.wires[5].on = (part.state & 2) != 0;
            this.torches[0].on = (part.state & 0x10) != 0;
            this.torches[1].on = !this.wires[3].on;
            this.torches[2].on = (part.state & 8) == 0 && this.wires[3].on;
            this.torches[3].on = (part.state & 4) == 0 && !this.wires[5].on;
            this.wires[0].on = this.torches[2].on;
            this.wires[1].on = this.torches[1].on;
        }
    }

    public static class Buffer
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("BUFFER", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(8.0, 9.0, 6)};

        public Buffer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 4) == 0;
            this.wires[1].on = (part.state & 0x22) != 0;
            this.wires[2].on = (part.state & 0x44) != 0;
            this.wires[3].on = (part.state & 0x88) != 0;
            this.wires[1].disabled = (part.shape & 1) != 0;
            this.wires[3].disabled = (part.shape & 2) != 0;
            this.torches[0].on = (part.state & 4) != 0;
            this.torches[1].on = (part.state & 4) == 0;
        }
    }

    public static class XNOR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("XNOR", 5);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(4.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(11.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 12.0, 6)};

        public XNOR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[3].on = false;
            this.wires[2].on = false;
            this.wires[1].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
            this.torches[3].on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 2) != 0 && (part.state & 8) == 0;
            this.wires[1].on = (part.state & 8) != 0 && (part.state & 2) == 0;
            this.wires[2].on = (part.state & 8) != 0;
            this.wires[3].on = (part.state & 2) != 0;
            this.wires[4].on = !this.wires[3].on && !this.wires[2].on;
            this.torches[0].on = (part.state & 0x11) != 0;
            this.torches[1].on = !this.wires[4].on && (part.state & 8) == 0;
            this.torches[2].on = !this.wires[4].on && (part.state & 2) == 0;
            this.torches[3].on = (part.state & 2) == 0 && (part.state & 8) == 0;
        }
    }

    public static class XOR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("XOR", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(11.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 12.0, 6)};

        public XOR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[3].on = false;
            this.wires[2].on = false;
            this.wires[1].on = true;
            this.torches[0].on = false;
            this.torches[1].on = false;
            this.torches[2].on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x11) != 0;
            this.wires[3].on = (part.state & 2) != 0;
            this.wires[2].on = (part.state & 8) != 0;
            this.wires[1].on = !this.wires[3].on && !this.wires[2].on;
            this.torches[0].on = !this.wires[2].on && !this.wires[1].on;
            this.torches[1].on = !this.wires[3].on && !this.wires[1].on;
            this.torches[2].on = this.wires[1].on;
        }
    }

    public static class NAND
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("NAND", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(12.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6)};

        public NAND() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x11) != 0;
            this.wires[3].on = (part.state & 2) != 0;
            this.wires[1].on = (part.state & 4) != 0;
            this.wires[2].on = (part.state & 8) != 0;
            this.wires[3].disabled = (part.shape & 1) != 0;
            this.wires[1].disabled = (part.shape & 2) != 0;
            this.wires[2].disabled = (part.shape & 4) != 0;
            this.torches[0].on = !this.wires[2].on && !this.wires[2].disabled;
            this.torches[1].on = !this.wires[3].on && !this.wires[3].disabled;
            this.torches[2].on = !this.wires[1].on && !this.wires[1].disabled;
        }
    }

    public static class AND
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("AND", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(12.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8)};

        public AND() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = true;
            this.torches[3].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x11) == 0;
            this.wires[3].on = (part.state & 2) != 0;
            this.wires[1].on = (part.state & 4) != 0;
            this.wires[2].on = (part.state & 8) != 0;
            this.wires[3].disabled = (part.shape & 1) != 0;
            this.wires[1].disabled = (part.shape & 2) != 0;
            this.wires[2].disabled = (part.shape & 4) != 0;
            this.torches[2].on = !this.wires[1].on && !this.wires[1].disabled;
            this.torches[0].on = !this.wires[2].on && !this.wires[2].disabled;
            this.torches[1].on = !this.wires[3].on && !this.wires[3].disabled;
            this.torches[3].on = !this.wires[0].on;
        }
    }

    public static class NOT
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("NOT", 4);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6);

        public NOT() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = true;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[3].disabled = false;
            this.wires[0].disabled = false;
            this.wires[2].disabled = false;
            this.torch.on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x11) != 0;
            this.wires[3].on = (part.state & 0x22) != 0;
            this.wires[1].on = (part.state & 4) != 0;
            this.wires[2].on = (part.state & 0x88) != 0;
            this.wires[3].disabled = (part.shape & 1) != 0;
            this.wires[0].disabled = (part.shape & 2) != 0;
            this.wires[2].disabled = (part.shape & 4) != 0;
            this.torch.on = (part.state & 0xF0) != 0;
        }
    }

    public static class NOR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("OR", 4);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 9.0, 6);

        public NOR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torch.on = true;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x11) != 0;
            this.wires[1].on = (part.state & 2) != 0;
            this.wires[2].on = (part.state & 4) != 0;
            this.wires[3].on = (part.state & 8) != 0;
            this.wires[1].disabled = (part.shape & 1) != 0;
            this.wires[2].disabled = (part.shape & 2) != 0;
            this.wires[3].disabled = (part.shape & 4) != 0;
            this.torch.on = (part.state & 0xE) == 0;
        }
    }

    public static class OR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("OR", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 9.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.5, 8)};

        public OR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
        }

        @Override
        public void prepare(SimpleGatePart part) {
            this.wires[0].on = (part.state & 0x10) == 0;
            this.wires[1].on = (part.state & 2) != 0;
            this.wires[2].on = (part.state & 4) != 0;
            this.wires[3].on = (part.state & 8) != 0;
            this.wires[1].disabled = (part.shape & 1) != 0;
            this.wires[2].disabled = (part.shape & 2) != 0;
            this.wires[3].disabled = (part.shape & 4) != 0;
            this.torches[0].on = (part.state & 0xE) == 0;
            this.torches[1].on = !this.wires[0].on;
        }
    }

    public static abstract class GateRenderer<PartType extends GatePart> {
        public List<ComponentStore.ComponentModel> models = new LinkedList<ComponentStore.ComponentModel>();
        public boolean reflect = false;

        public GateRenderer() {
            this.models.add(new ComponentStore.BaseComponentModel());
        }

        public void registerIcons(IconRegister r) {
            for (ComponentStore.ComponentModel m : this.models) {
                if (m == null) continue;
                m.registerTextures(r);
            }
        }

        public final void renderStatic(Transformation t, int orient) {
            this.renderModels(t, this.reflect ? orient + 24 : orient);
        }

        public void renderModels(Transformation t, int orient) {
            for (ComponentStore.ComponentModel m : this.models) {
                m.renderModel(t, orient);
            }
        }

        public void renderDynamic(Transformation t) {
        }

        public void prepareInv() {
        }

        public void prepare(PartType part) {
        }

        public void prepareDynamic(PartType part, float frame) {
        }

        public boolean hasSpecials() {
            return false;
        }

        public void spawnParticles(PartType part, Random rand) {
            this.prepare(part);
            LinkedList<ComponentStore.RedstoneTorchModel> torches = new LinkedList<ComponentStore.RedstoneTorchModel>();
            for (ComponentStore.ComponentModel componentModel : this.models) {
                if (!(componentModel instanceof ComponentStore.RedstoneTorchModel)) continue;
                torches.add((ComponentStore.RedstoneTorchModel)componentModel);
            }
            for (ComponentStore.RedstoneTorchModel redstoneTorchModel : torches) {
                if (!redstoneTorchModel.on || rand.nextInt(torches.size()) != 0) continue;
                Vector3 pos = new Vector3((double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat()).add(-0.5).multiply(0.05, 0.1, 0.05);
                pos.add(redstoneTorchModel.lightPos);
                pos.apply(((GatePart)((Object)part)).rotationT()).add((double)part.x(), (double)part.y(), (double)part.z());
                part.world().func_72869_a("reddust", pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
    }
}

