/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.multipart.TMultiPart;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;

public class BundledCableCommons {
    public static byte[] tmpSignal = new byte[16];
    private static int propogatingMask = 65535;

    public static boolean signalsEqual(byte[] signal1, byte[] signal2) {
        if (signal1 == null) {
            return BundledCableCommons.isSignalZero(signal2);
        }
        if (signal2 == null) {
            return BundledCableCommons.isSignalZero(signal1);
        }
        return Arrays.equals(signal1, signal2);
    }

    public static boolean isSignalZero(byte[] signal) {
        if (signal == null) {
            return true;
        }
        for (int i = 0; i < 16; ++i) {
            if (signal[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignalZero(byte[] signal, int mask) {
        if (signal == null) {
            return true;
        }
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) == 0 || signal[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean dropSignalsLessThan(byte[] signal1, byte[] signal2) {
        boolean dropped = false;
        for (int i = 0; i < 16; ++i) {
            if ((signal2[i] & 0xFF) >= (signal1[i] & 0xFF)) continue;
            signal1[i] = 0;
            dropped = true;
        }
        return dropped;
    }

    public static void applyChangeMask(byte[] signal, byte[] newSignal, int mask) {
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) != 0) continue;
            newSignal[i] = signal[i];
        }
    }

    public static void updateAndPropogate(IBundledCablePart part, TMultiPart prev, int mode) {
        int mask = BundledCableCommons.getUpdateMask(part, prev, mode);
        if (mode == 1 && BundledCableCommons.isSignalZero(part.getBundledSignal(), mask)) {
            return;
        }
        byte[] newSignal = part.calculateSignal();
        BundledCableCommons.applyChangeMask(part.getBundledSignal(), newSignal, mask);
        propogatingMask = mask;
        if (BundledCableCommons.dropSignalsLessThan(part.getBundledSignal(), newSignal)) {
            part.propogate(prev, 1);
        } else if (!BundledCableCommons.signalsEqual(part.getBundledSignal(), newSignal)) {
            part.setSignal(newSignal);
            if (mode == 1) {
                part.propogate(null, 0);
            } else {
                part.propogate(prev, 0);
            }
        } else if (mode == 1) {
            part.propogateTo(prev, 0);
        } else if (mode == 2) {
            part.propogate(prev, 3);
        }
        propogatingMask = 65535;
    }

    public static int getUpdateMask(IBundledCablePart part, TMultiPart prev, int mode) {
        if (prev instanceof IInsulatedRedwirePart) {
            return 1 << ((IInsulatedRedwirePart)prev).getInsulatedColour();
        }
        if (prev instanceof IBundledCablePart) {
            byte[] osignal = ((IBundledCablePart)prev).getBundledSignal();
            if (mode == 1) {
                int m = 0;
                for (int i = 0; i < 16; ++i) {
                    if (osignal[i] != 0) continue;
                    m |= 1 << i;
                }
                return m;
            }
            if (mode == 0) {
                int m = 0;
                for (int i = 0; i < 16; ++i) {
                    if ((osignal[i] & 0xFF) <= (part.getBundledSignal()[i] & 0xFF)) continue;
                    m |= 1 << i;
                }
                return m;
            }
        }
        return 65535;
    }

    public static boolean shouldPropogate(IBundledCablePart bundled, TMultiPart part, int mode) {
        return !(part instanceof IInsulatedRedwirePart) || (propogatingMask & 1 << ((IInsulatedRedwirePart)part).getInsulatedColour()) != 0;
    }

    public static void calculatePartSignal(Object part, int r) {
        block4: {
            byte[] osignal;
            block5: {
                block3: {
                    if (!(part instanceof IBundledCablePart)) break block3;
                    byte[] osignal2 = ((IBundledCablePart)part).getBundledSignal();
                    for (int i = 0; i < 16; ++i) {
                        if ((osignal2[i] & 0xFF) - 1 <= (tmpSignal[i] & 0xFF)) continue;
                        BundledCableCommons.tmpSignal[i] = (byte)(osignal2[i] - 1);
                    }
                    break block4;
                }
                if (!(part instanceof IInsulatedRedwirePart)) break block5;
                IInsulatedRedwirePart insPart = (IInsulatedRedwirePart)part;
                int s = insPart.getRedwireSignal(r) - 1;
                if (s <= (tmpSignal[insPart.getInsulatedColour()] & 0xFF)) break block4;
                BundledCableCommons.tmpSignal[insPart.getInsulatedColour()] = (byte)s;
                break block4;
            }
            if (part instanceof IBundledEmitter && (osignal = ((IBundledEmitter)part).getBundledSignal(r)) != null) {
                for (int i = 0; i < 16; ++i) {
                    if ((osignal[i] & 0xFF) <= (tmpSignal[i] & 0xFF)) continue;
                    BundledCableCommons.tmpSignal[i] = osignal[i];
                }
            }
        }
    }

    public static byte[] raiseSignal(byte[] signal1, byte[] signal2) {
        if (signal2 == null) {
            return signal1;
        }
        if (signal1 == null) {
            signal1 = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            if ((signal1[i] & 0xFF) >= (signal2[i] & 0xFF)) continue;
            signal1[i] = signal2[i];
        }
        return signal1;
    }
}

