/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.ProjectRedTransmission;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumWire {
    RED_ALLOY("Red alloy wire", "pr_redwire", "pr_sredwire", 0, 0xC80000, "redalloy"),
    INSULATED_0("White insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/whiteoff", "insulated/whiteon"),
    INSULATED_1("Orange insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/orangeoff", "insulated/orangeon"),
    INSULATED_2("Magenta insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/magentaoff", "insulated/magentaon"),
    INSULATED_3("Light blue insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/lightblueoff", "insulated/lightblueon"),
    INSULATED_4("Yellow insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/yellowoff", "insulated/yellowon"),
    INSULATED_5("Lime insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/limeoff", "insulated/limeon"),
    INSULATED_6("Pink insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/pinkoff", "insulated/pinkon"),
    INSULATED_7("Grey insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/greyoff", "insulated/greyon"),
    INSULATED_8("Light grey insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/lightgreyoff", "insulated/lightgreyon"),
    INSULATED_9("Cyan insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/cyanoff", "insulated/cyanon"),
    INSULATED_10("Purple insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/purpleoff", "insulated/purpleon"),
    INSULATED_11("Blue insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/blueoff", "insulated/blueon"),
    INSULATED_12("Brown insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/brownoff", "insulated/brownon"),
    INSULATED_13("Green insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/greenoff", "insulated/greenon"),
    INSULATED_14("Red insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/redoff", "insulated/redon"),
    INSULATED_15("Black insulated wire", "pr_insulated", "pr_sinsulated", 1, 0xFFFFFF, "insulated/blackoff", "insulated/blackon"),
    BUNDLED_N("Bundled cable", "pr_bundled", "pr_sbundled", 2, 0xFFFFFF, "bundled/neutral"),
    BUNDLED_0("White Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/white"),
    BUNDLED_1("Orange Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/orange"),
    BUNDLED_2("Magenta Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/magenta"),
    BUNDLED_3("Light Blue Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/lightblue"),
    BUNDLED_4("Yellow Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/yellow"),
    BUNDLED_5("Lime Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/lime"),
    BUNDLED_6("Pink Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/pink"),
    BUNDLED_7("Grey Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/grey"),
    BUNDLED_8("Light Grey Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/lightgrey"),
    BUNDLED_9("Cyan Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/cyan"),
    BUNDLED_10("Purple Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/purple"),
    BUNDLED_11("Blue Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/blue"),
    BUNDLED_12("Brown Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/brown"),
    BUNDLED_13("Green Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/green"),
    BUNDLED_14("Red Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/red"),
    BUNDLED_15("Black Bundled cable", "pr_bundled", 2, 0xFFFFFF, "bundled/black");

    public static EnumWire[] VALID_WIRE;
    public static EnumWire[] INSULATED_WIRE;
    public static EnumWire[] BUNDLED_WIRE;
    public final String name;
    public final String wireType;
    public final String framedType;
    public final int thickness;
    public final int itemColour;
    public Icon[] wireSprites;
    public final String[] wireSpritePaths;
    public int meta = this.ordinal();
    public static final String oreDictDefinition = "projredWire";
    public static final String oreDictDefinitionInsulated = "projredInsulatedWire";
    public static final String oreDictDefinitionInsFramed = "projredInsFramedWire";
    public static final String oreDictDefinitionBundled = "projredBundledCable";

    private EnumWire(String name, String wireType, String framedType, int thickness, int itemColour, String ... textures) {
        this.name = name;
        this.wireType = wireType;
        this.framedType = framedType;
        this.thickness = thickness;
        this.itemColour = itemColour;
        this.wireSpritePaths = textures;
        this.wireSprites = new Icon[textures.length];
    }

    private EnumWire(String name, String wireType, int thickness, int itemColour, String ... textures) {
        this(name, wireType, null, thickness, itemColour, textures);
    }

    public boolean hasFramedForm() {
        return this.framedType != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void loadTextures(IconRegister reg) {
        if (this.wireSpritePaths.length > 0) {
            this.wireSprites = new Icon[this.wireSpritePaths.length];
            for (int i = 0; i < this.wireSpritePaths.length; ++i) {
                this.wireSprites[i] = reg.func_94245_a("projectred:wires/" + this.wireSpritePaths[i]);
            }
        }
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int i) {
        return new ItemStack((Item)ProjectRedTransmission.itemPartWire, i, this.meta);
    }

    public ItemStack getFramedItemStack() {
        return this.getFramedItemStack(1);
    }

    public ItemStack getFramedItemStack(int i) {
        if (!this.hasFramedForm()) {
            return null;
        }
        return new ItemStack((Item)ProjectRedTransmission.itemPartFramedWire, i, this.meta);
    }

    public static void initOreDictDefinitions() {
        for (EnumWire w : VALID_WIRE) {
            OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)w.getItemStack());
        }
        for (EnumWire w : INSULATED_WIRE) {
            if (w.hasFramedForm()) {
                OreDictionary.registerOre((String)oreDictDefinitionInsFramed, (ItemStack)w.getFramedItemStack());
            }
            OreDictionary.registerOre((String)oreDictDefinitionInsulated, (ItemStack)w.getItemStack());
        }
        for (EnumWire w : BUNDLED_WIRE) {
            OreDictionary.registerOre((String)oreDictDefinitionBundled, (ItemStack)w.getItemStack());
        }
    }

    static {
        VALID_WIRE = EnumWire.values();
        INSULATED_WIRE = new EnumWire[]{INSULATED_0, INSULATED_1, INSULATED_2, INSULATED_3, INSULATED_4, INSULATED_5, INSULATED_6, INSULATED_7, INSULATED_8, INSULATED_9, INSULATED_10, INSULATED_11, INSULATED_12, INSULATED_13, INSULATED_14, INSULATED_15};
        BUNDLED_WIRE = new EnumWire[]{BUNDLED_N, BUNDLED_0, BUNDLED_1, BUNDLED_2, BUNDLED_3, BUNDLED_4, BUNDLED_5, BUNDLED_6, BUNDLED_7, BUNDLED_8, BUNDLED_9, BUNDLED_10, BUNDLED_11, BUNDLED_12, BUNDLED_13, BUNDLED_14, BUNDLED_15};
    }
}

