/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.transmission.BundledCableCommons;
import mrtjp.projectred.transmission.EnumWire;
import mrtjp.projectred.transmission.FramedWirePart;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class FramedBundledCablePart
extends FramedWirePart
implements IBundledCablePart {
    public byte[] signal = new byte[16];

    public String getType() {
        return "pr_sbundled";
    }

    @Override
    public EnumWire getWireType() {
        return EnumWire.BUNDLED_N;
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74773_a("signal", this.signal);
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.signal = tag.func_74770_j("signal");
    }

    @Override
    public boolean canConnectToType(IConnectable wire) {
        return wire instanceof IInsulatedRedwirePart || wire instanceof IBundledEmitter;
    }

    @Override
    public void updateAndPropogate(TMultiPart prev, int mode) {
        BundledCableCommons.updateAndPropogate(this, prev, mode);
    }

    @Override
    public boolean propogateTo(TMultiPart part, int mode) {
        if (!BundledCableCommons.shouldPropogate(this, part, mode)) {
            return true;
        }
        return super.propogateTo(part, mode);
    }

    @Override
    public void setSignal(byte[] newSignal) {
        if (newSignal == null) {
            Arrays.fill(this.signal, (byte)0);
        } else {
            System.arraycopy(newSignal, 0, this.signal, 0, 16);
        }
    }

    @Override
    public byte[] calculateSignal() {
        Arrays.fill(BundledCableCommons.tmpSignal, (byte)0);
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            if ((this.connMap & 1 << s) != 0) {
                this.calculateStraightSignal(s);
                continue;
            }
            this.calculateInternalSignal(s);
        }
        return BundledCableCommons.tmpSignal;
    }

    public void calculateStraightSignal(int s) {
        BlockCoord pos = new BlockCoord(this.getTile()).offset(s);
        TileEntity t = this.world().func_72796_p(pos.x, pos.y, pos.z);
        if (t instanceof IBundledEmitter) {
            BundledCableCommons.calculatePartSignal(t, s ^ 1);
        } else if (t instanceof TileMultipart) {
            BundledCableCommons.calculatePartSignal(((TileMultipart)t).partMap(6), s ^ 1);
        }
    }

    public void calculateInternalSignal(int s) {
        BundledCableCommons.calculatePartSignal(this.tile().partMap(s), -1);
    }

    @Override
    public byte[] getBundledSignal() {
        return this.signal;
    }

    public byte[] getBundledSignal(int side) {
        return this.getBundledSignal();
    }

    @Override
    protected boolean test(EntityPlayer player, MovingObjectPosition hit) {
        if (BasicUtils.isServer((World)this.world())) {
            String s = "";
            for (int i = 0; i < 16; ++i) {
                byte x = this.getBundledSignal()[i];
                if (x == 0) continue;
                s = s + "[" + i + "]";
            }
            if (s == "") {
                s = "off";
            }
            PacketCustom packet = new PacketCustom(CoreSPH.channel, 2);
            packet.writeDouble((double)this.x() + 0.0);
            packet.writeDouble((double)this.y() + 0.5);
            packet.writeDouble((double)this.z() + 0.0);
            packet.writeString("/#f" + s);
            packet.sendToPlayer(player);
        }
        return true;
    }
}

