/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.microblock.ItemMicroPart;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.handler.MicroblockProxy;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.LinkedList;
import mrtjp.projectred.ProjectRedCore;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.transmission.EnumWire;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.RenderFramedWire;
import mrtjp.projectred.transmission.WirePart;
import mrtjp.projectred.transmission.WirePropogator;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class FramedWirePart
extends TMultiPart
implements IConnectable,
TSlottedPart,
JNormalOcclusion,
IWirePart,
IHollowConnect {
    public static Cuboid6[] boundingBoxes = new Cuboid6[7];
    private static int expandBounds = -1;
    public int connMap;
    public int material = 0;

    public void preparePlacement(int meta) {
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74768_a("connMap", this.connMap);
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.connMap = tag.func_74762_e("connMap");
        this.material = MicroMaterialRegistry.materialID((String)tag.func_74779_i("mat"));
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.clientConnMap());
        MicroMaterialRegistry.writePartID((MCDataOutput)packet, (int)this.material);
    }

    public void readDesc(MCDataInput packet) {
        this.connMap = packet.readUByte();
        this.material = MicroMaterialRegistry.readPartID((MCDataInput)packet);
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 0) {
            this.connMap = packet.readUByte();
            this.tile().markRender();
        } else if (switch_key == 1) {
            this.material = MicroMaterialRegistry.readPartID((MCDataInput)packet);
            this.tile().markRender();
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().field_72995_K) {
            WirePropogator.logCalculation();
            boolean changed = this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                changed |= this.updateExternalConnections();
            }
            if (changed) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            WirePropogator.logCalculation();
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onAdded() {
        if (!this.world().field_72995_K) {
            this.updateOpenConnections();
            boolean changed = this.updateInternalConnections();
            if (changed |= this.updateExternalConnections()) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            for (int s = 0; s < 6; ++s) {
                if ((this.connMap & 1 << s) == 0) continue;
                this.notifyStraightChange(s);
            }
        }
    }

    public void onChunkLoad() {
    }

    public void onWorldJoin() {
        this.onNeighborChanged();
    }

    public int clientConnMap() {
        return this.connMap & 0x3F | this.connMap >> 6 & 0x3F;
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeByte(this.clientConnMap());
    }

    public void sendMatUpdate() {
        MicroMaterialRegistry.writePartID((MCDataOutput)this.tile().getWriteStream((TMultiPart)this).writeByte(1), (int)this.material);
    }

    protected boolean updateExternalConnections() {
        int newConn = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskOpen(s) || !this.connectStraight(s)) continue;
            newConn |= 1 << s;
        }
        if (newConn != (this.connMap & 0x3F)) {
            this.connMap = this.connMap & 0xFFFFFFC0 | newConn;
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int newConn = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.connectInternal(s)) continue;
            newConn |= 1 << s + 6;
        }
        if (newConn != (this.connMap & 0xFC0)) {
            this.connMap = this.connMap & 0xFFFFF03F | newConn;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int newConn = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.connectionOpen(s)) continue;
            newConn |= 1 << s + 12;
        }
        if (newConn != (this.connMap & 0x3F000)) {
            this.connMap = this.connMap & 0xFFFC0FFF | newConn;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int s) {
        TMultiPart facePart = this.tile().partMap(s);
        if (facePart == null) {
            return true;
        }
        if (facePart instanceof WirePart && this.canConnectToType((WirePart)facePart)) {
            return false;
        }
        expandBounds = s;
        boolean fits = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        expandBounds = -1;
        return fits;
    }

    public boolean connectStraight(int s) {
        TMultiPart tp;
        BlockCoord pos = new BlockCoord(this.getTile()).offset(s);
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(6)) instanceof IConnectable) {
            return ((IConnectable)tp).connectStraight((IConnectable)this, s ^ 1);
        }
        return this.connectStraightOverride(s);
    }

    public boolean connectStraightOverride(int s) {
        return false;
    }

    public boolean connectInternal(int s) {
        TMultiPart tp = this.tile().partMap(s);
        if (tp instanceof IConnectable) {
            return ((IConnectable)tp).connectInternal((IConnectable)this, -1);
        }
        return this.connectInternalOverride(tp, s);
    }

    public boolean connectInternalOverride(TMultiPart p, int s) {
        return false;
    }

    public boolean connectStraight(IConnectable wire, int s) {
        if (this.canConnectToType(wire) && this.maskOpen(s)) {
            int oldConn = this.connMap;
            this.connMap |= 1 << s;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable wire, int s) {
        if (this.canConnectToType(wire)) {
            int oldConn = this.connMap;
            this.connMap |= 1 << s + 6;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectCorner(IConnectable wire, int r) {
        return false;
    }

    public boolean canConnectCorner(int r) {
        return false;
    }

    public abstract boolean canConnectToType(IConnectable var1);

    public void notifyStraightChange(int s) {
        BlockCoord pos = new BlockCoord(this.getTile()).offset(s);
        this.world().func_72821_m(pos.x, pos.y, pos.z, this.getTile().func_70311_o().field_71990_ca);
    }

    public boolean maskConnects(int s) {
        return (this.connMap & 65 << s) != 0;
    }

    public boolean maskOpen(int s) {
        return (this.connMap & 4096 << s) != 0;
    }

    public void propogate(TMultiPart prev, int mode) {
        if (mode != 3) {
            WirePropogator.addPartChange(this);
        }
        for (int s = 0; s < 6; ++s) {
            if ((this.connMap & 1 << s) != 0) {
                this.propogateStraight(s, prev, mode);
                continue;
            }
            if ((this.connMap & 1 << s + 6) == 0) continue;
            this.propogateInternal(s, prev, mode);
        }
    }

    public void propogateStraight(int s, TMultiPart prev, int mode) {
        BlockCoord pos = new BlockCoord(this.getTile()).offset(s);
        TileMultipart t = BasicUtils.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(6);
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public void propogateInternal(int s, TMultiPart prev, int mode) {
        TMultiPart tp = this.tile().partMap(s);
        if (tp == prev) {
            return;
        }
        this.propogateTo(tp, mode);
    }

    public boolean propogateTo(TMultiPart part, int mode) {
        if (part instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)part, this, mode);
            return true;
        }
        return false;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
    }

    @Override
    public boolean isWireSide(int side) {
        return true;
    }

    public EnumWire getWireType() {
        return null;
    }

    public int getThickness() {
        return this.getWireType().thickness;
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        if (this.material > 0) {
            return Math.min(4.0f, MicroMaterialRegistry.getMaterial((int)this.material).getStrength(player));
        }
        return 4.0f;
    }

    public ItemStack getItem() {
        return this.getWireType().getFramedItemStack();
    }

    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        items.add(this.getItem());
        if (this.material != 0) {
            items.add(ItemMicroPart.create((int)1, (int)this.material));
        }
        return items;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public int getSlotMask() {
        return 64;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        Iterable<Cuboid6> boxList = this.getCollisionBoxes();
        LinkedList<IndexedCuboid6> partList = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 c : boxList) {
            partList.add(new IndexedCuboid6((Object)0, c));
        }
        return partList;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        if (expandBounds >= 0) {
            return Arrays.asList(boundingBoxes[expandBounds]);
        }
        return Arrays.asList(boundingBoxes[6]);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> list = new LinkedList<Cuboid6>();
        list.add(boundingBoxes[6]);
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            list.add(boundingBoxes[s]);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return this.getWireType().wireSprites[0];
    }

    public int getColour() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0) {
            TextureUtils.bindAtlas((int)0);
            CCRenderState.reset();
            CCRenderState.setBrightness((IBlockAccess)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            CCRenderState.useModelColours((boolean)true);
            RenderFramedWire.render(this, olm);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(RenderBlocks renderBlocks) {
        CCRenderState.reset();
        RenderFramedWire.renderBreakingOverlay(renderBlocks.field_78664_d, this);
    }

    public boolean doesTick() {
        return false;
    }

    public int getHollowSize() {
        return 8;
    }

    public void dropMaterial(EntityPlayer player) {
        if (this.material > 0 && !player.field_71075_bZ.field_75098_d) {
            ItemStack drop = ItemMicroPart.create((int)1, (int)this.material);
            BasicUtils.dropItemFromLocation((World)this.world(), (ItemStack)drop, (boolean)false, (EntityPlayer)player, (int)-1, (int)0, (BlockCoord)new BlockCoord((TileEntity)this.tile()));
        }
    }

    protected abstract boolean test(EntityPlayer var1, MovingObjectPosition var2);

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            if (player.func_70093_af() && this.material > 0 && !this.world().field_72995_K) {
                this.dropMaterial(player);
                this.material = 0;
                this.sendMatUpdate();
            }
            return false;
        }
        if (held.func_77973_b() == MicroblockProxy.itemMicro() && held.func_77960_j() == 1 && ItemMicroPart.getMaterialID((ItemStack)held) != this.material) {
            if (!this.world().field_72995_K) {
                int newMaterialID = ItemMicroPart.getMaterialID((ItemStack)held);
                MicroMaterialRegistry.IMicroMaterial newMaterial = MicroMaterialRegistry.getMaterial((int)newMaterialID);
                if (newMaterial.isTransparent()) {
                    return false;
                }
                this.dropMaterial(player);
                this.material = newMaterialID;
                this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, newMaterial.getSound().func_82593_b(), (newMaterial.getSound().func_72677_b() + 1.0f) / 2.0f, newMaterial.getSound().func_72678_c() * 0.8f);
                this.sendMatUpdate();
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
            }
            return true;
        }
        if (held.field_77993_c == ProjectRedCore.itemWireDebugger.field_77779_bT) {
            held.func_77972_a(1, (EntityLivingBase)player);
            player.func_71038_i();
            return this.test(player, hit);
        }
        return false;
    }

    static {
        double w = 0.25;
        FramedWirePart.boundingBoxes[6] = new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w);
        for (int s = 0; s < 6; ++s) {
            FramedWirePart.boundingBoxes[s] = new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w).apply(Rotation.sideRotations[s].at(Vector3.center));
        }
    }
}

