/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import mrtjp.projectred.transmission.EnumWire;
import mrtjp.projectred.transmission.RedwirePart;
import mrtjp.projectred.transmission.WirePropogator;

public class RedAlloyWirePart
extends RedwirePart {
    public RedAlloyWirePart(int side) {
        super(side);
    }

    public String getType() {
        return "pr_redwire";
    }

    @Override
    public EnumWire getWireType() {
        return EnumWire.RED_ALLOY;
    }

    @Override
    public int getColour() {
        return (this.signal & 0xFF) / 2 + 60 << 24 | 0xFF;
    }

    @Override
    public int strongPowerLevel(int side) {
        if (side == this.side) {
            return this.rsLevel();
        }
        return 0;
    }

    @Override
    public int redstoneConductionMap() {
        return 31;
    }

    @Override
    public void propogateOther(int mode) {
        WirePropogator.addNeighborChange(new BlockCoord(this.getTile()).offset((int)this.side));
        WirePropogator.addNeighborChange(new BlockCoord(this.getTile()).offset(this.side ^ 1));
        for (int r = 0; r < 4; ++r) {
            if (this.maskConnects(r)) continue;
            WirePropogator.addNeighborChange(new BlockCoord(this.getTile()).offset(Rotation.rotateSide((int)this.side, (int)r)));
        }
        for (int s = 0; s < 6; ++s) {
            if (s == (this.side ^ 1)) continue;
            WirePropogator.addNeighborChange(new BlockCoord(this.getTile()).offset((int)this.side).offset(s));
        }
    }

    @Override
    public int calculateUndersideSignal() {
        BlockCoord pos = new BlockCoord(this.getTile()).offset((int)this.side);
        return this.world().func_72878_l(pos.x, pos.y, pos.z, (int)this.side) * 17;
    }
}

