/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.microblock.ItemMicroPart;
import cpw.mods.fml.common.registry.GameRegistry;
import mrtjp.projectred.core.AlloySmelterRecipe;
import mrtjp.projectred.core.ItemPart;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.ShapedOreNBTRecipe;
import mrtjp.projectred.core.ShapelessOreNBTRecipe;
import mrtjp.projectred.transmission.EnumWire;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TransmissionRecipes {
    public static void initTransmissionRecipes() {
        TransmissionRecipes.initWireRecipes();
        TransmissionRecipes.initPartRecipes();
        TransmissionRecipes.initAlloySmelterRecipes();
    }

    private static void initWireRecipes() {
        GameRegistry.addRecipe((ItemStack)EnumWire.RED_ALLOY.getItemStack(12), (Object[])new Object[]{" r ", " r ", " r ", Character.valueOf('r'), ItemPart.EnumPart.REDINGOT.getItemStack()});
        for (int i = 0; i < EnumWire.INSULATED_WIRE.length; ++i) {
            EnumWire w = EnumWire.INSULATED_WIRE[i];
            GameRegistry.addRecipe((ItemStack)w.getItemStack(12), (Object[])new Object[]{"WrW", "WrW", "WrW", Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, PRColors.get((int)i).woolId()), Character.valueOf('r'), ItemPart.EnumPart.REDINGOT.getItemStack()});
        }
        for (EnumWire w : EnumWire.INSULATED_WIRE) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(w.getItemStack(), new Object[]{PRColors.get((int)(w.meta - EnumWire.INSULATED_0.meta)).getOreDict(), "projredInsulatedWire", Item.field_77683_K}));
        }
        for (EnumWire w : EnumWire.INSULATED_WIRE) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreNBTRecipe(w.getFramedItemStack(), new Object[]{PRColors.get((int)(w.meta - EnumWire.INSULATED_0.meta)).getOreDict(), "projredInsFramedWire", ItemMicroPart.create((int)769, (String)Block.field_71951_J.func_71917_a())}).setCheckNBT());
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWire.BUNDLED_N.getItemStack(), new Object[]{"SWS", "WWW", "SWS", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('W'), "projredInsulatedWire"}));
        for (EnumWire w : EnumWire.BUNDLED_WIRE) {
            if (w == EnumWire.BUNDLED_N) continue;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(w.getItemStack(), new Object[]{PRColors.get((int)(w.meta - EnumWire.BUNDLED_0.meta)).getOreDict(), "projredBundledCable", Item.field_77683_K}));
        }
        for (EnumWire w : EnumWire.VALID_WIRE) {
            if (!w.hasFramedForm()) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedOreNBTRecipe(w.getFramedItemStack(), new Object[]{"sss", "sis", "sss", Character.valueOf('i'), w.getItemStack(), Character.valueOf('s'), ItemMicroPart.create((int)769, (String)Block.field_71951_J.func_71917_a())}).setCheckNBT());
        }
    }

    private static void initPartRecipes() {
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.WIREDPLATE.getItemStack(), (Object[])new Object[]{"r", "p", Character.valueOf('r'), EnumWire.RED_ALLOY.getItemStack(), Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.BUNDLEDPLATE.getItemStack(), (Object[])new Object[]{"r", "p", Character.valueOf('r'), EnumWire.BUNDLED_N.getItemStack(), Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
    }

    private static void initAlloySmelterRecipes() {
        AlloySmelterRecipe.add((AlloySmelterRecipe)new AlloySmelterRecipe(new ItemStack[]{EnumWire.RED_ALLOY.getItemStack(4)}, ItemPart.EnumPart.REDINGOT.getItemStack(), 50));
        AlloySmelterRecipe.add((AlloySmelterRecipe)new AlloySmelterRecipe(new ItemStack[]{EnumWire.BUNDLED_N.getItemStack(8)}, ItemPart.EnumPart.REDINGOT.getItemStack(5), 90));
        for (EnumWire w : EnumWire.INSULATED_WIRE) {
            AlloySmelterRecipe.add((AlloySmelterRecipe)new AlloySmelterRecipe(new ItemStack[]{w.getItemStack(4)}, ItemPart.EnumPart.REDINGOT.getItemStack(), 80));
        }
    }
}

