/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartProxy;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import mrtjp.projectred.core.CommandDebug;
import mrtjp.projectred.transmission.IWirePart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.world.World;

public class WirePropogator {
    private static Field wiresProvidePower = BlockRedstoneWire.class.getDeclaredFields()[0];
    public static boolean redwiresProvidePower = true;
    private static ThreadLocal<Boolean> redwiresConnectable = new ThreadLocal();
    private static TMultiPart notApart = new TMultiPart(){

        public String getType() {
            return null;
        }
    };
    private static Stack<PropogationRun> reusableRuns;
    private static PropogationRun currentRun;
    private static PropogationRun finishing;

    public static void setWiresProvidePower(boolean b) {
        try {
            wiresProvidePower.setBoolean(Block.field_72075_av, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean redwiresConnectable() {
        Boolean b = redwiresConnectable.get();
        return b == null ? true : b;
    }

    public static void setRedwiresConnectable(boolean b) {
        redwiresConnectable.set(b);
    }

    private static PropogationRun getRun() {
        if (reusableRuns.isEmpty()) {
            return new PropogationRun();
        }
        return reusableRuns.pop();
    }

    public static void addNeighborChange(BlockCoord pos) {
        currentRun.neighborChanges.add(pos);
    }

    public static void addPartChange(TMultiPart part) {
        currentRun.partChanges.put((Object)part.tile(), (Object)part);
    }

    public static void logCalculation() {
        if (finishing != null) {
            finishing.recalcs++;
        }
    }

    public static void propogateTo(IWirePart part, TMultiPart prev, int mode) {
        PropogationRun p = currentRun;
        if (p == null) {
            p = WirePropogator.getRun();
        }
        p.add(part, prev, mode);
        if (currentRun != p) {
            if (currentRun != null) {
                throw new RuntimeException("Report this to ProjectRed developers");
            }
            p.start(finishing, part.world());
        }
    }

    public static void propogateTo(IWirePart part, int mode) {
        WirePropogator.propogateTo(part, notApart, mode);
    }

    static {
        try {
            wiresProvidePower.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        reusableRuns = new Stack();
        currentRun = null;
        finishing = null;
    }

    private static class PropogationRun {
        private World world;
        private PropogationRun parent;
        private TMultiPart lastCaller;
        private int count;
        private int recalcs;
        private Multimap<TileMultipart, TMultiPart> partChanges = HashMultimap.create();
        private HashSet<BlockCoord> neighborChanges = new HashSet();
        private LinkedList<Propogation> propogationList = new LinkedList();
        private IWirePart first;

        private PropogationRun() {
        }

        public void clear() {
            this.partChanges.clear();
            this.neighborChanges.clear();
            this.count = 0;
            this.recalcs = 0;
            this.lastCaller = null;
            this.first = null;
            reusableRuns.add(this);
        }

        public void finish() {
            new Propogation(this.first, notApart, 0).propogate();
            currentRun = null;
            if (this.partChanges.isEmpty() && this.neighborChanges.isEmpty()) {
                finishing = this.parent;
                this.clear();
                return;
            }
            finishing = this;
            if (CommandDebug.WIRE_READING) {
                System.out.println("" + this.count + " propogations, " + this.partChanges.size() + " part changes, " + this.neighborChanges.size() + " block updates");
            }
            for (Map.Entry entry : this.partChanges.asMap().entrySet()) {
                Collection parts = (Collection)entry.getValue();
                for (TMultiPart part : parts) {
                    ((IWirePart)part).onSignalUpdate();
                }
                ((TileMultipart)entry.getKey()).multiPartChange(parts);
            }
            int blockID = ((Block)MultipartProxy.block()).field_71990_ca;
            for (BlockCoord b : this.neighborChanges) {
                this.world.func_72821_m(b.x, b.y, b.z, blockID);
            }
            finishing = this.parent;
            if (CommandDebug.WIRE_READING) {
                System.out.println("" + this.recalcs + " recalculations");
            }
            this.clear();
        }

        public void start(PropogationRun parent, World world) {
            this.world = world;
            this.parent = parent;
            currentRun = this;
            this.runLoop();
        }

        private void runLoop() {
            while (!this.propogationList.isEmpty()) {
                LinkedList<Propogation> list = this.propogationList;
                this.propogationList = new LinkedList();
                for (Propogation p : list) {
                    p.propogate();
                }
            }
            this.finish();
        }

        public void add(IWirePart part, TMultiPart prev, int mode) {
            if (prev != this.lastCaller) {
                this.lastCaller = prev;
                ++this.count;
            }
            if (this.first == null) {
                this.first = part;
            }
            this.propogationList.add(new Propogation(part, prev, mode));
        }

        public class Propogation {
            public IWirePart part;
            public TMultiPart prev;
            public int mode;

            public Propogation(IWirePart part, TMultiPart prev, int mode) {
                this.part = part;
                this.prev = prev;
                this.mode = mode;
            }

            public void propogate() {
                this.part.updateAndPropogate(this.prev, this.mode);
            }
        }
    }
}

