
/**
 * A template function for generating an UI element for a layout object.
 */
define('panels/keyboard_enabled_layouts/layout_template',['require'],function(require) {
  

  var layoutTemplate = function layoutTemplate(layout, recycled) {
    var container = null;
    var span;
    if (recycled) {
      container = recycled;
      span = container.querySelector('span');
    } else {
      container = document.createElement('li');
      span = document.createElement('span');
      container.appendChild(span);
    }
    var refreshName = function() {
      span.textContent = layout.appName + ': ' + layout.name;
    };
    refreshName();
    layout.observe('appName', refreshName);
    layout.observe('name', refreshName);
    return container;
  };

  return layoutTemplate;
});

/**
 * The module initializes a ListView displaying all enabled layouts.
 * Implementation details please refer to {@link KeyboardEnabledLayoutsCore}.
 *
 * @module keyboard_enabled_layouts/core
 */
define('panels/keyboard_enabled_layouts/core',['require','modules/mvvm/list_view'],function(require) {
  

  var ListView = require('modules/mvvm/list_view');

  /**
   * @alias module:keyboard_enabled_layouts/core
   * @class KeyboardEnabledLayoutsCore
   * @requires module:modules/mvvm/list_view
   * @param {KeyboardContext} context
                              The kyboard context providing enabled layouts.
   * @param {Function} template
                       The template function used to render a layout.
   * @returns {KeyboardEnabledLayoutsCore}
   */
  function KeyboardEnabledLayoutsCore(context, template) {
    this._enabled = false;
    this._listView = null;
    this._keyboardContext = context;
    this._layoutTemplate = template;
  }

  KeyboardEnabledLayoutsCore.prototype = {
    /**
     * The value indicates whether the module is responding. If it is false, the
     * UI stops reflecting the updates from the keyboard context.
     *
     * @access public
     * @memberOf KeyboardEnabledLayoutsCore.prototype
     * @type {Boolean}
     */
    get enabled() {
      return this._enabled;
    },

    set enabled(value) {
      this._enabled = value;
      if (this._listView) {
        this._listView.enabled = this._enabled;
      }
    },

    /**
     * @access private
     * @memberOf KeyboardAddLayoutsCore.prototype
     * @param {HTMLElement} listViewRoot
     * @param {ObservableArray} layouts
     * @param {Function} layoutTemplate
     */
    _initEnabledLayoutListView:
      function kepl_initListView(listViewRoot, layouts, layoutTemplate) {
      this._listView = ListView(listViewRoot, layouts, layoutTemplate);
    },

    /**
     * @access public
     * @memberOf KeyboardEnabledLayoutsCore.prototype
     * @param {Array} elements
     *                Elements needed by this module.
     * @param {HTMLElement} elements.listViewRoot
     *                      The root element for the list view displaying the
     *                      installed keyboards.
     */
    init: function kepl_onInit(elements) {
      var that = this;
      this._keyboardContext.init(function() {
        that._keyboardContext.enabledLayouts(function(layouts) {
          that._initEnabledLayoutListView(
            elements.listViewRoot, layouts, that._layoutTemplate);
          that.enabled = true;
        });
      });
    }
  };

  return function ctor_keplCore(context, template) {
    return new KeyboardEnabledLayoutsCore(context, template);
  };
});

/**
 * In the panels we initialize a ListView with the data provided by
 * KeyboardContext. Templates for generating UI elements are also defined
 * here.
 */
define('panels/keyboard_enabled_layouts/panel',['require','modules/settings_panel','modules/keyboard_context','panels/keyboard_enabled_layouts/layout_template','panels/keyboard_enabled_layouts/core'],function(require) {
  

  var SettingsPanel = require('modules/settings_panel');
  var KeyboardContext = require('modules/keyboard_context');
  var layoutTemplate =
    require('panels/keyboard_enabled_layouts/layout_template');
  var Core = require('panels/keyboard_enabled_layouts/core');

  return function ctor_enabledLayoutsPanel() {
    var core = Core(KeyboardContext, layoutTemplate);
    return SettingsPanel({
      onInit: function kelp_onInit(rootElement) {
        core.init({
          listViewRoot: rootElement.querySelector('.enabledKeyboardList')
        });
      },
      onBeforeShow: function kelp_onBeforeShow() {
        core.enabled = true;
      },
      onHide: function kelp_onHide() {
        core.enabled = false;
      }
    });
  };
});
