
/**
 * alameda 0.2.0 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/requirejs/alameda for details
 */
//Going sloppy to avoid 'use strict' string cost, but strict practices should
//be followed.
/*jslint sloppy: true, nomen: true, regexp: true */
/*global setTimeout, process, document, navigator, importScripts,
  setImmediate */

var requirejs, require, define;
(function (global, undef) {
    var prim, topReq, dataMain, src, subPath,
        bootstrapConfig = requirejs || require,
        hasOwn = Object.prototype.hasOwnProperty,
        contexts = {},
        queue = [],
        currDirRegExp = /^\.\//,
        urlRegExp = /^\/|\:|\?|\.js$/,
        commentRegExp = /(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/mg,
        cjsRequireRegExp = /[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g,
        jsSuffixRegExp = /\.js$/;

    if (typeof requirejs === 'function') {
        return;
    }

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    function getOwn(obj, prop) {
        return obj && hasProp(obj, prop) && obj[prop];
    }

    /**
     * Cycles over properties in an object and calls a function for each
     * property value. If the function returns a truthy value, then the
     * iteration is stopped.
     */
    function eachProp(obj, func) {
        var prop;
        for (prop in obj) {
            if (hasProp(obj, prop)) {
                if (func(obj[prop], prop)) {
                    break;
                }
            }
        }
    }

    /**
     * Simple function to mix in properties from source into target,
     * but only if target does not already have a property of the same name.
     */
    function mixin(target, source, force, deepStringMixin) {
        if (source) {
            eachProp(source, function (value, prop) {
                if (force || !hasProp(target, prop)) {
                    if (deepStringMixin && typeof value === 'object' && value &&
                        !Array.isArray(value) && typeof value !== 'function' &&
                        !(value instanceof RegExp)) {

                        if (!target[prop]) {
                            target[prop] = {};
                        }
                        mixin(target[prop], value, force, deepStringMixin);
                    } else {
                        target[prop] = value;
                    }
                }
            });
        }
        return target;
    }

    //Allow getting a global that expressed in
    //dot notation, like 'a.b.c'.
    function getGlobal(value) {
        if (!value) {
            return value;
        }
        var g = global;
        value.split('.').forEach(function (part) {
            g = g[part];
        });
        return g;
    }

    //START prim 0.0.6
    /**
     * Changes from baseline prim
     * - removed UMD registration
     */
    (function () {
        

        var waitingId, nextTick,
            waiting = [];

        function callWaiting() {
            waitingId = 0;
            var w = waiting;
            waiting = [];
            while (w.length) {
                w.shift()();
            }
        }

        function asyncTick(fn) {
            waiting.push(fn);
            if (!waitingId) {
                waitingId = setTimeout(callWaiting, 0);
            }
        }

        function syncTick(fn) {
            fn();
        }

        function isFunObj(x) {
            var type = typeof x;
            return type === 'object' || type === 'function';
        }

        //Use setImmediate.bind() because attaching it (or setTimeout directly
        //to prim will result in errors. Noticed first on IE10,
        //issue requirejs/alameda#2)
        nextTick = typeof setImmediate === 'function' ? setImmediate.bind() :
            (typeof process !== 'undefined' && process.nextTick ?
                process.nextTick : (typeof setTimeout !== 'undefined' ?
                    asyncTick : syncTick));

        function notify(ary, value) {
            prim.nextTick(function () {
                ary.forEach(function (item) {
                    item(value);
                });
            });
        }

        function callback(p, ok, yes) {
            if (p.hasOwnProperty('v')) {
                prim.nextTick(function () {
                    yes(p.v);
                });
            } else {
                ok.push(yes);
            }
        }

        function errback(p, fail, no) {
            if (p.hasOwnProperty('e')) {
                prim.nextTick(function () {
                    no(p.e);
                });
            } else {
                fail.push(no);
            }
        }

        prim = function prim(fn) {
            var promise, f,
                p = {},
                ok = [],
                fail = [];

            function makeFulfill() {
                var f, f2,
                    called = false;

                function fulfill(v, prop, listeners) {
                    if (called) {
                        return;
                    }
                    called = true;

                    if (promise === v) {
                        called = false;
                        f.reject(new TypeError('value is same promise'));
                        return;
                    }

                    try {
                        var then = v && v.then;
                        if (isFunObj(v) && typeof then === 'function') {
                            f2 = makeFulfill();
                            then.call(v, f2.resolve, f2.reject);
                        } else {
                            p[prop] = v;
                            notify(listeners, v);
                        }
                    } catch (e) {
                        called = false;
                        f.reject(e);
                    }
                }

                f = {
                    resolve: function (v) {
                        fulfill(v, 'v', ok);
                    },
                    reject: function(e) {
                        fulfill(e, 'e', fail);
                    }
                };
                return f;
            }

            f = makeFulfill();

            promise = {
                then: function (yes, no) {
                    var next = prim(function (nextResolve, nextReject) {

                        function finish(fn, nextFn, v) {
                            try {
                                if (fn && typeof fn === 'function') {
                                    v = fn(v);
                                    nextResolve(v);
                                } else {
                                    nextFn(v);
                                }
                            } catch (e) {
                                nextReject(e);
                            }
                        }

                        callback(p, ok, finish.bind(undefined, yes, nextResolve));
                        errback(p, fail, finish.bind(undefined, no, nextReject));

                    });
                    return next;
                },

                catch: function (no) {
                    return promise.then(null, no);
                }
            };

            try {
                fn(f.resolve, f.reject);
            } catch (e) {
                f.reject(e);
            }

            return promise;
        };

        prim.resolve = function (value) {
            return prim(function (yes) {
                yes(value);
            });
        };

        prim.reject = function (err) {
            return prim(function (yes, no) {
                no(err);
            });
        };

        prim.cast = function (x) {
            // A bit of a weak check, want "then" to be a function,
            // but also do not want to trigger a getter if accessing
            // it. Good enough for now.
            if (isFunObj(x) && 'then' in x) {
                return x;
            } else {
                return prim(function (yes, no) {
                    if (x instanceof Error) {
                        no(x);
                    } else {
                        yes(x);
                    }
                });
            }
        };

        prim.all = function (ary) {
            return prim(function (yes, no) {
                var count = 0,
                    length = ary.length,
                    result = [];

                function resolved(i, v) {
                    result[i] = v;
                    count += 1;
                    if (count === length) {
                        yes(result);
                    }
                }

                ary.forEach(function (item, i) {
                    prim.cast(item).then(function (v) {
                        resolved(i, v);
                    }, function (err) {
                        no(err);
                    });
                });
            });
        };

        prim.nextTick = nextTick;
    }());
    //END prim

    function newContext(contextName) {
        var req, main, makeMap, callDep, handlers, checkingLater, load, context,
            defined = {},
            waiting = {},
            config = {
                //Defaults. Do not set a default for map
                //config to speed up normalize(), which
                //will run faster if there is no default.
                waitSeconds: 7,
                baseUrl: './',
                paths: {},
                bundles: {},
                pkgs: {},
                shim: {},
                config: {}
            },
            mapCache = {},
            requireDeferreds = [],
            deferreds = {},
            calledDefine = {},
            calledPlugin = {},
            loadCount = 0,
            startTime = (new Date()).getTime(),
            errCount = 0,
            trackedErrors = {},
            urlFetched = {},
            bundlesMap = {};

        /**
         * Trims the . and .. from an array of path segments.
         * It will keep a leading path segment if a .. will become
         * the first path segment, to help with module name lookups,
         * which act like paths, but can be remapped. But the end result,
         * all paths that use this function should look normalized.
         * NOTE: this method MODIFIES the input array.
         * @param {Array} ary the array of path segments.
         */
        function trimDots(ary) {
            var i, part, length = ary.length;
            for (i = 0; i < length; i++) {
                part = ary[i];
                if (part === '.') {
                    ary.splice(i, 1);
                    i -= 1;
                } else if (part === '..') {
                    if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {
                        //End of the line. Keep at least one non-dot
                        //path segment at the front so it can be mapped
                        //correctly to disk. Otherwise, there is likely
                        //no path mapping for a path starting with '..'.
                        //This can still fail, but catches the most reasonable
                        //uses of ..
                        break;
                    } else if (i > 0) {
                        ary.splice(i - 1, 2);
                        i -= 2;
                    }
                }
            }
        }

        /**
         * Given a relative module name, like ./something, normalize it to
         * a real name that can be mapped to a path.
         * @param {String} name the relative name
         * @param {String} baseName a real name that the name arg is relative
         * to.
         * @param {Boolean} applyMap apply the map config to the value. Should
         * only be done if this normalization is for a dependency ID.
         * @returns {String} normalized name
         */
        function normalize(name, baseName, applyMap) {
            var pkgMain, mapValue, nameParts, i, j, nameSegment, lastIndex,
                foundMap, foundI, foundStarMap, starI,
                baseParts = baseName && baseName.split('/'),
                normalizedBaseParts = baseParts,
                map = config.map,
                starMap = map && map['*'];

            //Adjust any relative paths.
            if (name && name.charAt(0) === '.') {
                //If have a base name, try to normalize against it,
                //otherwise, assume it is a top-level require that will
                //be relative to baseUrl in the end.
                if (baseName) {
                    //Convert baseName to array, and lop off the last part,
                    //so that . matches that 'directory' and not name of the baseName's
                    //module. For instance, baseName of 'one/two/three', maps to
                    //'one/two/three.js', but we want the directory, 'one/two' for
                    //this normalization.
                    normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);
                    name = name.split('/');
                    lastIndex = name.length - 1;

                    // If wanting node ID compatibility, strip .js from end
                    // of IDs. Have to do this here, and not in nameToUrl
                    // because node allows either .js or non .js to map
                    // to same file.
                    if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                        name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
                    }

                    name = normalizedBaseParts.concat(name);
                    trimDots(name);
                    name = name.join('/');
                } else if (name.indexOf('./') === 0) {
                    // No baseName, so this is ID is resolved relative
                    // to baseUrl, pull off the leading dot.
                    name = name.substring(2);
                }
            }

            //Apply map config if available.
            if (applyMap && map && (baseParts || starMap)) {
                nameParts = name.split('/');

                outerLoop: for (i = nameParts.length; i > 0; i -= 1) {
                    nameSegment = nameParts.slice(0, i).join('/');

                    if (baseParts) {
                        //Find the longest baseName segment match in the config.
                        //So, do joins on the biggest to smallest lengths of baseParts.
                        for (j = baseParts.length; j > 0; j -= 1) {
                            mapValue = getOwn(map, baseParts.slice(0, j).join('/'));

                            //baseName segment has config, find if it has one for
                            //this name.
                            if (mapValue) {
                                mapValue = getOwn(mapValue, nameSegment);
                                if (mapValue) {
                                    //Match, update name to the new value.
                                    foundMap = mapValue;
                                    foundI = i;
                                    break outerLoop;
                                }
                            }
                        }
                    }

                    //Check for a star map match, but just hold on to it,
                    //if there is a shorter segment match later in a matching
                    //config, then favor over this star map.
                    if (!foundStarMap && starMap && getOwn(starMap, nameSegment)) {
                        foundStarMap = getOwn(starMap, nameSegment);
                        starI = i;
                    }
                }

                if (!foundMap && foundStarMap) {
                    foundMap = foundStarMap;
                    foundI = starI;
                }

                if (foundMap) {
                    nameParts.splice(0, foundI, foundMap);
                    name = nameParts.join('/');
                }
            }

            // If the name points to a package's name, use
            // the package main instead.
            pkgMain = getOwn(config.pkgs, name);

            return pkgMain ? pkgMain : name;
        }

        function makeShimExports(value) {
            function fn() {
                var ret;
                if (value.init) {
                    ret = value.init.apply(global, arguments);
                }
                return ret || (value.exports && getGlobal(value.exports));
            }
            return fn;
        }

        function takeQueue(anonId) {
            var i, id, args, shim;
            for (i = 0; i < queue.length; i += 1) {
                //Peek to see if anon
                if (typeof queue[i][0] !== 'string') {
                    if (anonId) {
                        queue[i].unshift(anonId);
                        anonId = undef;
                    } else {
                        //Not our anon module, stop.
                        break;
                    }
                }
                args = queue.shift();
                id = args[0];
                i -= 1;

                if (!hasProp(defined, id) && !hasProp(waiting, id)) {
                    if (hasProp(deferreds, id)) {
                        main.apply(undef, args);
                    } else {
                        waiting[id] = args;
                    }
                }
            }

            //if get to the end and still have anonId, then could be
            //a shimmed dependency.
            if (anonId) {
                shim = getOwn(config.shim, anonId) || {};
                main(anonId, shim.deps || [], shim.exportsFn);
            }
        }

        function makeRequire(relName, topLevel) {
            var req = function (deps, callback, errback, alt) {
                var name, cfg;

                if (topLevel) {
                    takeQueue();
                }

                if (typeof deps === "string") {
                    if (handlers[deps]) {
                        return handlers[deps](relName);
                    }
                    //Just return the module wanted. In this scenario, the
                    //deps arg is the module name, and second arg (if passed)
                    //is just the relName.
                    //Normalize module name, if it contains . or ..
                    name = makeMap(deps, relName, true).id;
                    if (!hasProp(defined, name)) {
                        throw new Error('Not loaded: ' + name);
                    }
                    return defined[name];
                } else if (deps && !Array.isArray(deps)) {
                    //deps is a config object, not an array.
                    cfg = deps;
                    deps = undef;

                    if (Array.isArray(callback)) {
                        //callback is an array, which means it is a dependency list.
                        //Adjust args if there are dependencies
                        deps = callback;
                        callback = errback;
                        errback = alt;
                    }

                    if (topLevel) {
                        //Could be a new context, so call returned require
                        return req.config(cfg)(deps, callback, errback);
                    }
                }

                //Support require(['a'])
                callback = callback || function () {};

                //Simulate async callback;
                prim.nextTick(function () {
                    //Grab any modules that were defined after a
                    //require call.
                    takeQueue();
                    main(undef, deps || [], callback, errback, relName);
                });

                return req;
            };

            req.isBrowser = typeof document !== 'undefined' &&
                typeof navigator !== 'undefined';

            req.nameToUrl = function (moduleName, ext, skipExt) {
                var paths, syms, i, parentModule, url,
                    parentPath, bundleId,
                    pkgMain = getOwn(config.pkgs, moduleName);

                if (pkgMain) {
                    moduleName = pkgMain;
                }

                bundleId = getOwn(bundlesMap, moduleName);

                if (bundleId) {
                    return req.nameToUrl(bundleId, ext, skipExt);
                }

                //If a colon is in the URL, it indicates a protocol is used and it is just
                //an URL to a file, or if it starts with a slash, contains a query arg (i.e. ?)
                //or ends with .js, then assume the user meant to use an url and not a module id.
                //The slash is important for protocol-less URLs as well as full paths.
                if (urlRegExp.test(moduleName)) {
                    //Just a plain path, not module name lookup, so just return it.
                    //Add extension if it is included. This is a bit wonky, only non-.js things pass
                    //an extension, this method probably needs to be reworked.
                    url = moduleName + (ext || '');
                } else {
                    //A module that needs to be converted to a path.
                    paths = config.paths;

                    syms = moduleName.split('/');
                    //For each module name segment, see if there is a path
                    //registered for it. Start with most specific name
                    //and work up from it.
                    for (i = syms.length; i > 0; i -= 1) {
                        parentModule = syms.slice(0, i).join('/');

                        parentPath = getOwn(paths, parentModule);
                        if (parentPath) {
                            //If an array, it means there are a few choices,
                            //Choose the one that is desired
                            if (Array.isArray(parentPath)) {
                                parentPath = parentPath[0];
                            }
                            syms.splice(0, i, parentPath);
                            break;
                        }
                    }

                    //Join the path parts together, then figure out if baseUrl is needed.
                    url = syms.join('/');
                    url += (ext || (/^data\:|\?/.test(url) || skipExt ? '' : '.js'));
                    url = (url.charAt(0) === '/' || url.match(/^[\w\+\.\-]+:/) ? '' : config.baseUrl) + url;
                }

                return config.urlArgs ? url +
                                        ((url.indexOf('?') === -1 ? '?' : '&') +
                                         config.urlArgs) : url;
            };

            /**
             * Converts a module name + .extension into an URL path.
             * *Requires* the use of a module name. It does not support using
             * plain URLs like nameToUrl.
             */
            req.toUrl = function (moduleNamePlusExt) {
                var ext,
                    index = moduleNamePlusExt.lastIndexOf('.'),
                    segment = moduleNamePlusExt.split('/')[0],
                    isRelative = segment === '.' || segment === '..';

                //Have a file extension alias, and it is not the
                //dots from a relative path.
                if (index !== -1 && (!isRelative || index > 1)) {
                    ext = moduleNamePlusExt.substring(index, moduleNamePlusExt.length);
                    moduleNamePlusExt = moduleNamePlusExt.substring(0, index);
                }

                return req.nameToUrl(normalize(moduleNamePlusExt, relName), ext, true);
            };

            req.defined = function (id) {
                return hasProp(defined, makeMap(id, relName, true).id);
            };

            req.specified = function (id) {
                id = makeMap(id, relName, true).id;
                return hasProp(defined, id) || hasProp(deferreds, id);
            };

            return req;
        }

        function resolve(name, d, value) {
            if (name) {
                defined[name] = value;
                if (requirejs.onResourceLoad) {
                    requirejs.onResourceLoad(context, d.map, d.deps);
                }
            }
            d.finished = true;
            d.resolve(value);
        }

        function reject(d, err) {
            d.finished = true;
            d.rejected = true;
            d.reject(err);
        }

        function makeNormalize(relName) {
            return function (name) {
                return normalize(name, relName, true);
            };
        }

        function defineModule(d) {
            var name = d.map.id,
                ret = d.factory.apply(defined[name], d.values);

            if (name) {
                // Favor return value over exports. If node/cjs in play,
                // then will not have a return value anyway. Favor
                // module.exports assignment over exports object.
                if (ret === undef) {
                    if (d.cjsModule) {
                        ret = d.cjsModule.exports;
                    } else if (d.usingExports) {
                        ret = defined[name];
                    }
                }
            } else {
                //Remove the require deferred from the list to
                //make cycle searching faster. Do not need to track
                //it anymore either.
                requireDeferreds.splice(requireDeferreds.indexOf(d), 1);
            }
            resolve(name, d, ret);
        }

        //This method is attached to every module deferred,
        //so the "this" in here is the module deferred object.
        function depFinished(val, i) {
            if (!this.rejected && !this.depDefined[i]) {
                this.depDefined[i] = true;
                this.depCount += 1;
                this.values[i] = val;
                if (!this.depending && this.depCount === this.depMax) {
                    defineModule(this);
                }
            }
        }

        function makeDefer(name) {
            var d = {};
            d.promise = prim(function (resolve, reject) {
                d.resolve = resolve;
                d.reject = reject;
            });
            d.map = name ? makeMap(name, null, true) : {};
            d.depCount = 0;
            d.depMax = 0;
            d.values = [];
            d.depDefined = [];
            d.depFinished = depFinished;
            if (d.map.pr) {
                //Plugin resource ID, implicitly
                //depends on plugin. Track it in deps
                //so cycle breaking can work
                d.deps = [makeMap(d.map.pr)];
            }
            return d;
        }

        function getDefer(name) {
            var d;
            if (name) {
                d = hasProp(deferreds, name) && deferreds[name];
                if (!d) {
                    d = deferreds[name] = makeDefer(name);
                }
            } else {
                d = makeDefer();
                requireDeferreds.push(d);
            }
            return d;
        }

        function makeErrback(d, name) {
            return function (err) {
                if (!d.rejected) {
                    if (!err.dynaId) {
                        err.dynaId = 'id' + (errCount += 1);
                        err.requireModules = [name];
                    }
                    reject(d, err);
                }
            };
        }

        function waitForDep(depMap, relName, d, i) {
            d.depMax += 1;

            //Do the fail at the end to catch errors
            //in the then callback execution.
            callDep(depMap, relName).then(function (val) {
                d.depFinished(val, i);
            }, makeErrback(d, depMap.id)).catch(makeErrback(d, d.map.id));
        }

        function makeLoad(id) {
            var fromTextCalled;
            function load(value) {
                //Protect against older plugins that call load after
                //calling load.fromText
                if (!fromTextCalled) {
                    resolve(id, getDefer(id), value);
                }
            }

            load.error = function (err) {
                getDefer(id).reject(err);
            };

            load.fromText = function (text, textAlt) {
                /*jslint evil: true */
                var d = getDefer(id),
                    map = makeMap(makeMap(id).n),
                   plainId = map.id;

                fromTextCalled = true;

                //Set up the factory just to be a return of the value from
                //plainId.
                d.factory = function (p, val) {
                    return val;
                };

                //As of requirejs 2.1.0, support just passing the text, to reinforce
                //fromText only being called once per resource. Still
                //support old style of passing moduleName but discard
                //that moduleName in favor of the internal ref.
                if (textAlt) {
                    text = textAlt;
                }

                //Transfer any config to this other module.
                if (hasProp(config.config, id)) {
                    config.config[plainId] = config.config[id];
                }

                try {
                    req.exec(text);
                } catch (e) {
                    reject(d, new Error('fromText eval for ' + plainId +
                                    ' failed: ' + e));
                }

                //Execute any waiting define created by the plainId
                takeQueue(plainId);

                //Mark this as a dependency for the plugin
                //resource
                d.deps = [map];
                waitForDep(map, null, d, d.deps.length);
            };

            return load;
        }

        load = typeof importScripts === 'function' ?
                function (map) {
                    var url = map.url;
                    if (urlFetched[url]) {
                        return;
                    }
                    urlFetched[url] = true;

                    //Ask for the deferred so loading is triggered.
                    //Do this before loading, since loading is sync.
                    getDefer(map.id);
                    importScripts(url);
                    takeQueue(map.id);
                } :
                function (map) {
                    var script,
                        id = map.id,
                        url = map.url;

                    if (urlFetched[url]) {
                        return;
                    }
                    urlFetched[url] = true;

                    script = document.createElement('script');
                    script.setAttribute('data-requiremodule', id);
                    script.type = config.scriptType || 'text/javascript';
                    script.charset = 'utf-8';
                    script.async = true;

                    loadCount += 1;

                    script.addEventListener('load', function () {
                        loadCount -= 1;
                        takeQueue(id);
                    }, false);
                    script.addEventListener('error', function () {
                        loadCount -= 1;
                        var err,
                            pathConfig = getOwn(config.paths, id),
                            d = getOwn(deferreds, id);
                        if (pathConfig && Array.isArray(pathConfig) && pathConfig.length > 1) {
                            script.parentNode.removeChild(script);
                            //Pop off the first array value, since it failed, and
                            //retry
                            pathConfig.shift();
                            d.map = makeMap(id);
                            load(d.map);
                        } else {
                            err = new Error('Load failed: ' + id + ': ' + script.src);
                            err.requireModules = [id];
                            getDefer(id).reject(err);
                        }
                    }, false);

                    script.src = url;

                    document.head.appendChild(script);
                };

        function callPlugin(plugin, map, relName) {
            plugin.load(map.n, makeRequire(relName), makeLoad(map.id), {});
        }

        callDep = function (map, relName) {
            var args, bundleId,
                name = map.id,
                shim = config.shim[name];

            if (hasProp(waiting, name)) {
                args = waiting[name];
                delete waiting[name];
                main.apply(undef, args);
            } else if (!hasProp(deferreds, name)) {
                if (map.pr) {
                    //If a bundles config, then just load that file instead to
                    //resolve the plugin, as it is built into that bundle.
                    if ((bundleId = getOwn(bundlesMap, name))) {
                        map.url = req.nameToUrl(bundleId);
                        load(map);
                    } else {
                        return callDep(makeMap(map.pr)).then(function (plugin) {
                            //Redo map now that plugin is known to be loaded
                            var newMap = makeMap(name, relName, true),
                                newId = newMap.id,
                                shim = getOwn(config.shim, newId);

                            //Make sure to only call load once per resource. Many
                            //calls could have been queued waiting for plugin to load.
                            if (!hasProp(calledPlugin, newId)) {
                                calledPlugin[newId] = true;
                                if (shim && shim.deps) {
                                    req(shim.deps, function () {
                                        callPlugin(plugin, newMap, relName);
                                    });
                                } else {
                                    callPlugin(plugin, newMap, relName);
                                }
                            }
                            return getDefer(newId).promise;
                        });
                    }
                } else if (shim && shim.deps) {
                    req(shim.deps, function () {
                        load(map);
                    });
                } else {
                    load(map);
                }
            }

            return getDefer(name).promise;
        };

        //Turns a plugin!resource to [plugin, resource]
        //with the plugin being undefined if the name
        //did not have a plugin prefix.
        function splitPrefix(name) {
            var prefix,
                index = name ? name.indexOf('!') : -1;
            if (index > -1) {
                prefix = name.substring(0, index);
                name = name.substring(index + 1, name.length);
            }
            return [prefix, name];
        }

        /**
         * Makes a name map, normalizing the name, and using a plugin
         * for normalization if necessary. Grabs a ref to plugin
         * too, as an optimization.
         */
        makeMap = function (name, relName, applyMap) {
            if (typeof name !== 'string') {
                return name;
            }

            var plugin, url, parts, prefix, result,
                cacheKey = name + ' & ' + (relName || '') + ' & ' + !!applyMap;

            parts = splitPrefix(name);
            prefix = parts[0];
            name = parts[1];

            if (!prefix && hasProp(mapCache, cacheKey)) {
                return mapCache[cacheKey];
            }

            if (prefix) {
                prefix = normalize(prefix, relName, applyMap);
                plugin = hasProp(defined, prefix) && defined[prefix];
            }

            //Normalize according
            if (prefix) {
                if (plugin && plugin.normalize) {
                    name = plugin.normalize(name, makeNormalize(relName));
                } else {
                    name = normalize(name, relName, applyMap);
                }
            } else {
                name = normalize(name, relName, applyMap);
                parts = splitPrefix(name);
                prefix = parts[0];
                name = parts[1];

                url = req.nameToUrl(name);
            }

            //Using ridiculous property names for space reasons
            result = {
                id: prefix ? prefix + '!' + name : name, //fullName
                n: name,
                pr: prefix,
                url: url
            };

            if (!prefix) {
                mapCache[cacheKey] = result;
            }

            return result;
        };

        handlers = {
            require: function (name) {
                return makeRequire(name);
            },
            exports: function (name) {
                var e = defined[name];
                if (typeof e !== 'undefined') {
                    return e;
                } else {
                    return (defined[name] = {});
                }
            },
            module: function (name) {
                return {
                    id: name,
                    uri: '',
                    exports: handlers.exports(name),
                    config: function () {
                        return getOwn(config.config, name) || {};
                    }
                };
            }
        };

        function breakCycle(d, traced, processed) {
            var id = d.map.id;

            traced[id] = true;
            if (!d.finished && d.deps) {
                d.deps.forEach(function (depMap) {
                    var depId = depMap.id,
                        dep = !hasProp(handlers, depId) && getDefer(depId);

                    //Only force things that have not completed
                    //being defined, so still in the registry,
                    //and only if it has not been matched up
                    //in the module already.
                    if (dep && !dep.finished && !processed[depId]) {
                        if (hasProp(traced, depId)) {
                            d.deps.forEach(function (depMap, i) {
                                if (depMap.id === depId) {
                                    d.depFinished(defined[depId], i);
                                }
                            });
                        } else {
                            breakCycle(dep, traced, processed);
                        }
                    }
                });
            }
            processed[id] = true;
        }

        function check(d) {
            var err,
                notFinished = [],
                waitInterval = config.waitSeconds * 1000,
                //It is possible to disable the wait interval by using waitSeconds of 0.
                expired = waitInterval && (startTime + waitInterval) < (new Date()).getTime();

            if (loadCount === 0) {
                //If passed in a deferred, it is for a specific require call.
                //Could be a sync case that needs resolution right away.
                //Otherwise, if no deferred, means a nextTick and all
                //waiting require deferreds should be checked.
                if (d) {
                    if (!d.finished) {
                        breakCycle(d, {}, {});
                    }
                } else if (requireDeferreds.length) {
                    requireDeferreds.forEach(function (d) {
                        breakCycle(d, {}, {});
                    });
                }
            }

            //If still waiting on loads, and the waiting load is something
            //other than a plugin resource, or there are still outstanding
            //scripts, then just try back later.
            if (expired) {
                //If wait time expired, throw error of unloaded modules.
                eachProp(deferreds, function (d) {
                    if (!d.finished) {
                        notFinished.push(d.map.id);
                    }
                });
                err = new Error('Timeout for modules: ' + notFinished);
                err.requireModules = notFinished;
                req.onError(err);
            } else if (loadCount || requireDeferreds.length) {
                //Something is still waiting to load. Wait for it, but only
                //if a later check is not already scheduled.
                if (!checkingLater) {
                    checkingLater = true;
                    prim.nextTick(function () {
                        checkingLater = false;
                        check();
                    });
                }
            }
        }

        //Used to break out of the promise try/catch chains.
        function delayedError(e) {
            prim.nextTick(function () {
                if (!e.dynaId || !trackedErrors[e.dynaId]) {
                    trackedErrors[e.dynaId] = true;
                    req.onError(e);
                }
            });
        }

        main = function (name, deps, factory, errback, relName) {
            //Only allow main calling once per module.
            if (name && hasProp(calledDefine, name)) {
                return;
            }
            calledDefine[name] = true;

            var d = getDefer(name);

            //This module may not have dependencies
            if (deps && !Array.isArray(deps)) {
                //deps is not an array, so probably means
                //an object literal or factory function for
                //the value. Adjust args.
                factory = deps;
                deps = [];
            }

            d.promise.catch(errback || delayedError);

            //Use name if no relName
            relName = relName || name;

            //Call the factory to define the module, if necessary.
            if (typeof factory === 'function') {

                if (!deps.length && factory.length) {
                    //Remove comments from the callback string,
                    //look for require calls, and pull them into the dependencies,
                    //but only if there are function args.
                    factory
                        .toString()
                        .replace(commentRegExp, '')
                        .replace(cjsRequireRegExp, function (match, dep) {
                            deps.push(dep);
                        });

                    //May be a CommonJS thing even without require calls, but still
                    //could use exports, and module. Avoid doing exports and module
                    //work though if it just needs require.
                    //REQUIRES the function to expect the CommonJS variables in the
                    //order listed below.
                    deps = (factory.length === 1 ?
                            ['require'] :
                            ['require', 'exports', 'module']).concat(deps);
                }

                //Save info for use later.
                d.factory = factory;
                d.deps = deps;

                d.depending = true;
                deps.forEach(function (depName, i) {
                    var depMap;
                    deps[i] = depMap = makeMap(depName, relName, true);
                    depName = depMap.id;

                    //Fast path CommonJS standard dependencies.
                    if (depName === "require") {
                        d.values[i] = handlers.require(name);
                    } else if (depName === "exports") {
                        //CommonJS module spec 1.1
                        d.values[i] = handlers.exports(name);
                        d.usingExports = true;
                    } else if (depName === "module") {
                        //CommonJS module spec 1.1
                        d.values[i] = d.cjsModule = handlers.module(name);
                    } else if (depName === undefined) {
                        d.values[i] = undefined;
                    } else {
                        waitForDep(depMap, relName, d, i);
                    }
                });
                d.depending = false;

                //Some modules just depend on the require, exports, modules, so
                //trigger their definition here if so.
                if (d.depCount === d.depMax) {
                    defineModule(d);
                }
            } else if (name) {
                //May just be an object definition for the module. Only
                //worry about defining if have a module name.
                resolve(name, d, factory);
            }

            startTime = (new Date()).getTime();

            if (!name) {
                check(d);
            }
        };

        req = makeRequire(null, true);

        /*
         * Just drops the config on the floor, but returns req in case
         * the config return value is used.
         */
        req.config = function (cfg) {
            if (cfg.context && cfg.context !== contextName) {
                return newContext(cfg.context).config(cfg);
            }

            //Since config changed, mapCache may not be valid any more.
            mapCache = {};

            //Make sure the baseUrl ends in a slash.
            if (cfg.baseUrl) {
                if (cfg.baseUrl.charAt(cfg.baseUrl.length - 1) !== '/') {
                    cfg.baseUrl += '/';
                }
            }

            //Save off the paths and packages since they require special processing,
            //they are additive.
            var primId,
                shim = config.shim,
                objs = {
                    paths: true,
                    bundles: true,
                    config: true,
                    map: true
                };

            eachProp(cfg, function (value, prop) {
                if (objs[prop]) {
                    if (!config[prop]) {
                        config[prop] = {};
                    }
                    mixin(config[prop], value, true, true);
                } else {
                    config[prop] = value;
                }
            });

            //Reverse map the bundles
            if (cfg.bundles) {
                eachProp(cfg.bundles, function (value, prop) {
                    value.forEach(function (v) {
                        if (v !== prop) {
                            bundlesMap[v] = prop;
                        }
                    });
                });
            }

            //Merge shim
            if (cfg.shim) {
                eachProp(cfg.shim, function (value, id) {
                    //Normalize the structure
                    if (Array.isArray(value)) {
                        value = {
                            deps: value
                        };
                    }
                    if ((value.exports || value.init) && !value.exportsFn) {
                        value.exportsFn = makeShimExports(value);
                    }
                    shim[id] = value;
                });
                config.shim = shim;
            }

            //Adjust packages if necessary.
            if (cfg.packages) {
                cfg.packages.forEach(function (pkgObj) {
                    var location, name;

                    pkgObj = typeof pkgObj === 'string' ? { name: pkgObj } : pkgObj;

                    name = pkgObj.name;
                    location = pkgObj.location;
                    if (location) {
                        config.paths[name] = pkgObj.location;
                    }

                    //Save pointer to main module ID for pkg name.
                    //Remove leading dot in main, so main paths are normalized,
                    //and remove any trailing .js, since different package
                    //envs have different conventions: some use a module name,
                    //some use a file name.
                    config.pkgs[name] = pkgObj.name + '/' + (pkgObj.main || 'main')
                                 .replace(currDirRegExp, '')
                                 .replace(jsSuffixRegExp, '');
                });
            }

            //If want prim injected, inject it now.
            primId = config.definePrim;
            if (primId) {
                waiting[primId] = [primId, [], function () { return prim; }];
            }

            //If a deps array or a config callback is specified, then call
            //require with those args. This is useful when require is defined as a
            //config object before require.js is loaded.
            if (cfg.deps || cfg.callback) {
                req(cfg.deps, cfg.callback);
            }

            return req;
        };

        req.onError = function (err) {
            throw err;
        };

        context = {
            id: contextName,
            defined: defined,
            waiting: waiting,
            config: config,
            deferreds: deferreds
        };

        contexts[contextName] = context;

        return req;
    }

    requirejs = topReq = newContext('_');

    if (typeof require !== 'function') {
        require = topReq;
    }

    /**
     * Executes the text. Normally just uses eval, but can be modified
     * to use a better, environment-specific call. Only used for transpiling
     * loader plugins, not for plain JS modules.
     * @param {String} text the text to execute/evaluate.
     */
    topReq.exec = function (text) {
        /*jslint evil: true */
        return eval(text);
    };

    topReq.contexts = contexts;

    define = function () {
        queue.push([].slice.call(arguments, 0));
    };

    define.amd = {
        jQuery: true
    };

    if (bootstrapConfig) {
        topReq.config(bootstrapConfig);
    }

    //data-main support.
    if (topReq.isBrowser && !contexts._.config.skipDataMain) {
        dataMain = document.querySelectorAll('script[data-main]')[0];
        dataMain = dataMain && dataMain.getAttribute('data-main');
        if (dataMain) {
            //Strip off any trailing .js since dataMain is now
            //like a module name.
            dataMain = dataMain.replace(jsSuffixRegExp, '');

            if (!bootstrapConfig || !bootstrapConfig.baseUrl) {
                //Pull off the directory of data-main for use as the
                //baseUrl.
                src = dataMain.split('/');
                dataMain = src.pop();
                subPath = src.length ? src.join('/')  + '/' : './';

                topReq.config({baseUrl: subPath});
            }

            topReq([dataMain]);
        }
    }
}(this));

define("vendor/alameda", function(){});

define('debug',['require','exports','module'],function(require, exports, module) {


/**
* Expose `debug()` as the module.
*/

module.exports = debug;

/**
* Create a debugger with the given `name`.
*
* @param {String} name
* @return {Type}
*/

function debug(name) {
  if (!debug.enabled(name)) return function() {};

  return function(fmt) {
    fmt = coerce(fmt);

    var curr = new Date;
    var ms = curr - (debug[name] || curr);
    debug[name] = curr;

    fmt = '[' + name + '] ' + fmt + ' +' + debug.humanize(ms);

    // This hackery is required for IE8
    // where `console.log` doesn't have 'apply'
    window.console && console.log &&
      Function.prototype.apply.call(console.log, console, arguments);
  }
}

/**
* The currently active debug mode names.
*/

debug.names = [];
debug.skips = [];

/**
* Enables a debug mode by name. This can include modes
* separated by a colon and wildcards.
*
* @param {String} name
*/

debug.enable = function(name) {
  try {
    localStorage.debug = name;
  } catch (e) {}

  var split = (name || '').split(/[\s,]+/);
  var len = split.length;

  for (var i = 0; i < len; i++) {
    name = split[i].replace('*', '.*?');
    if (name[0] === '-') {
      debug.skips.push(new RegExp('^' + name.substr(1) + '$'));
    }
    else {
      debug.names.push(new RegExp('^' + name + '$'));
    }
  }
};

/**
* Disable debug output.
*
*/

debug.disable = function() {
  debug.enable('');
};

/**
* Humanize the given `ms`.
*
* @param {Number} m
* @return {String}
*/

debug.humanize = function(ms) {
  var sec = 1000;
  var min = 60 * 1000;
  var hour = 60 * min;

  if (ms >= hour) return (ms / hour).toFixed(1) + 'h';
  if (ms >= min) return (ms / min).toFixed(1) + 'm';
  if (ms >= sec) return (ms / sec | 0) + 's';
  return ms + 'ms';
};

/**
* Returns true if the given mode name is enabled, false otherwise.
*
* @param {String} name
* @return {Boolean}
*/

debug.enabled = function(name) {
  for (var i = 0, len = debug.skips.length; i < len; i++) {
    if (debug.skips[i].test(name)) {
      return false;
    }
  }
  for (var i = 0, len = debug.names.length; i < len; i++) {
    if (debug.names[i].test(name)) {
      return true;
    }
  }
  return false;
};

/**
* Coerce `val`.
*/

function coerce(val) {
  if (val instanceof Error) return val.stack || val.message;
  return val;
}

// persist

try {
  if (window.localStorage) debug.enable(localStorage.debug);
} catch (e) {}

});


/**
 * Event
 *
 * A super lightweight
 * event emitter library.
 *
 * @version 0.3.3
 * @author Wilson Page <wilson.page@me.com>
 */

;(function() {

/**
 * Locals
 */

var proto = Events.prototype;
var slice = [].slice;

/**
 * Creates a new event emitter
 * instance, or if passed an
 * object, mixes the event logic
 * into it.
 *
 * @param  {Object} obj
 * @return {Object}
 */
function Events(obj) {
  if (!(this instanceof Events)) { return new Events(obj); }
  if (obj) { return mixin(obj, proto); }
}

/**
 * Registers a callback
 * with an event name.
 *
 * @param  {String}   name
 * @param  {Function} cb
 * @return {Event}
 */
proto.on = function(name, cb) {
  this._cbs = this._cbs || {};
  (this._cbs[name] || (this._cbs[name] = [])).push(cb);
  return this;
};

proto.once = function(name, cb) {
  this.on(name, one);
  function one() {
    cb.apply(this, arguments);
    this.off(name, one);
  }
};

/**
 * Removes a single callback,
 * or all callbacks associated
 * with the passed event name.
 *
 * @param  {String}   name
 * @param  {Function} cb
 * @return {Event}
 */
proto.off = function(name, cb) {
  this._cbs = this._cbs || {};

  if (!name) { this._cbs = {}; return; }
  if (!cb) { return delete this._cbs[name]; }

  var cbs = this._cbs[name] || [];
  var i;

  while (cbs && ~(i = cbs.indexOf(cb))) { cbs.splice(i, 1); }
  return this;
};

/**
 * Fires an event, triggering
 * all callbacks registered on this
 * event name.
 *
 * @param  {String} name
 * @return {Event}
 */
proto.fire = proto.emit = function(options) {
  var cbs = this._cbs = this._cbs || {};
  var name = options.name || options;
  var batch = (cbs[name] || []).concat(cbs['*'] || []);
  var ctx = options.ctx || this;

  if (batch.length) {
    this._fireArgs = arguments;
    var args = slice.call(arguments, 1);
    while (batch.length) {
      batch.shift().apply(ctx, args);
    }
  }

  return this;
};

proto.firer = function(name) {
  var self = this;
  return function() {
    var args = slice.call(arguments);
    args.unshift(name);
    self.fire.apply(self, args);
  };
};

/**
 * Util
 */

/**
 * Mixes in the properties
 * of the second object into
 * the first.
 *
 * @param  {Object} a
 * @param  {Object} b
 * @return {Object}
 */
function mixin(a, b) {
  for (var key in b) { a[key] = b[key]; }
  return a;
}

/**
 * Expose 'Event' (UMD)
 */

if (typeof exports === 'object') {
  module.exports = Events;
} else if (typeof define === 'function' && define.amd) {
  define('vendor/evt',[],function(){ return Events; });
} else {
  window.evt = Events;
}

})();
define('lib/setting-alias',['require','exports','module','debug','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('setting-alias');
var evt = require('vendor/evt');

/**
 * Locals
 */

var off = evt.prototype.off;
var on = evt.prototype.on;
var forwardMethods = [
  'filterOptions',
  'resetOptions',
  'supported',
  'selected',
  'select',
  'next',
  'get',
  'set'
];

/**
 * Exports
 */

module.exports = SettingAlias;

// Mixin emitter
evt(SettingAlias.prototype);

/**
 * Initialize a new `SettingsAlias`
 *
 * @param {Object} options
 */
function SettingAlias(options) {
  debug('initialize');
  this.settings = options.settings;
  this.key = options.key;
  this.map = options.map || {};
  this.setting = options.get.bind(this);
  forwardMethods.forEach(this.forward, this);
  this.propagate = this.propagator();
  debug('initialized');
}

/**
 * Attaches a method that forwards
 * the call onto the current
 * matching setting.
 *
 * @param  {String} method
 */
SettingAlias.prototype.forward = function(method) {
  this[method] = function() {
    var setting = this.setting();
    return setting[method].apply(setting, arguments);
  };
};

/**
 * Attach a pseudo callback that
 * fires when the same event fires
 * on the currently active setting.
 *
 * @param  {String}   name
 * @param  {Function} fn
 */
SettingAlias.prototype.on = function(name, fn) {
  on.call(this, name, fn);
  for (var key in this.map) {
    var setting = this.settings[this.map[key]];
    setting.on(name, this.propagate);
  }
};

/**
 * Remove pseudo callback.
 *
 * @param  {String}   name
 * @param  {Function} fn
 */
SettingAlias.prototype.off = function(name, fn) {
  off.call(this, name, fn);
  for (var key in this.map) {
    var setting = this.settings[this.map[key]];
    setting.off(name, this.propagate);
  }
};

/**
 * Returns a function that when
 * attached as a callback to
 * another event handler, will
 * fire the same event on itself.
 *
 * `this._fireArgs` is the original
 * list of arguments passed when the
 * event was fired.
 *
 * Access to this allows use to re-fire
 * the event on another emitter in exactly
 * the same way it was originally fired.
 *
 * @param  {String}   name
 * @param  {Function} fn
 */
SettingAlias.prototype.propagator = function() {
  var alias = this;
  return function() {
    if (this.key === alias.get().key) {
      alias.fire.apply(alias, this._fireArgs);
    }
  };
};

});

define('vendor/model',['require','exports','module','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var events = require('vendor/evt');

/**
 * Exports
 */

module.exports = Model;

function Model(obj) {
  if (!(this instanceof Model)) { return mix(obj, Model.prototype); }
  this.reset(obj, { silent: true });
  this.id = obj.id || obj.key;
}

Model.prototype = events({
  get: function(key) {
    var data = this._getData();
    return key ? data[key] : mix({}, data);
  },

  set: function(key, value, options) {
    options = typeof key === 'object' ? value : options;
    var silent = options && options.silent;
    var data = this._getData();
    var keys;

    switch (typeof key) {
      case 'string':
        data[key] = value;
        if (!silent) {
          this.onKeyChange(key);
          this.emit('change', [key]);
        }
        return;
      case 'object':
        mix(data, key);
        if (!silent) {
          keys = Object.keys(key);
          keys.forEach(this.onKeyChange, this);
          this.emit('change', keys);
        }
        return;
    }
  },

  setter: function(key, value1) {
    return (function(value2) { this.set(key, value1 || value2); }).bind(this);
  },

  reset: function(data, options) {
    if (!data) { return; }
    var silent = options && options.silent;
    var isArray = data instanceof Array;
    this._data = !isArray ? mix({}, data) : data;
    if (!silent) { this.emit('reset'); }
  },

  onKeyChange: function(key) {
    var data = this._getData();
    this.emit('change:' + key, data[key]);
  },

  _getData: function() {
    this._data = this._data || {};
    return this._data;
  }
});

function mix(a, b) {
  for (var key in b) { a[key] = b[key]; }
  return a;
}

});

define('lib/setting',['require','exports','module','debug','vendor/model'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('setting');
var model = require('vendor/model');

/**
 * Exports
 */

module.exports = Setting;

/**
 * Mixin `Model` methods
 */

model(Setting.prototype);

/**
 * Initialize a new `Setting`.
 *
 * @param {Object} data
 */
function Setting(data) {
  this.key = data.key;
  this.storage = data.storage || localStorage;
  this.reset(data, { silent: true });
  this.select = this.select.bind(this);
  this.next = this.next.bind(this);
  this.configure(data);
  if (data.persistent) { this.on('change:selected', this.save); }
}

Setting.prototype.configure = function(data) {
  var optionsDefined = !!(data.options && data.options.length);
  this.options = { defined: optionsDefined };
  this.resetOptions(data.options);
};

Setting.prototype.resetOptions = function(list) {
  list = list || [];

  var hash = this.optionsToHash(list);
  this.options.all = hash;
  this.options.available = hash;

  this.set('options', list, { silent: true });
  this.updateSelected({ silent: true });
};

Setting.prototype.filterOptions = function(keys, options) {
  var available = this.options.available = {};
  var hash = this.options.all;
  var filtered = [];

  (keys || []).forEach(function(key) {
    var option = hash[key];
    if (option !== undefined) {
      filtered.push(option);
      available[key] = option;
    }
  });

  this.sortByIndex(filtered);
  this.set('options', filtered, options);
  this.updateSelected({ silent: true });
};

/**
 * Convert this Setting's `options` array as defined
 * in config/app.js into an object as key/value pairs.
 * This allows us to look up an option by its `key`.
 *
 * e.g.: [ { key: 'a', title: 'A' }, ... ] ->
 *       { a: { key: 'a', title: 'A' }, ... }
 *
 * We use this hash to validate
 * incoming options and ot mixin
 * config data with dynamic options.
 *
 * @param  {Array} options
 * @return {undefined|Object}
 */
Setting.prototype.optionsToHash = function(options) {
  var hash = {};
  options.forEach(function(option, index) {
    option.index = index;
    hash[option.key] = option;
  });
  return hash;
};

/**
 * Get the selected option,
 * or just a particular key
 * if given.
 *
 * @param  {String} key
 * @return {Object|*}
 */
Setting.prototype.selected = function(key) {
  var hash = this.options.available;
  var option = hash[this.get('selected')];
  return key ? option && option[key] : option;
};

/**
 * Select an option.
 *
 * Accepts an string key to select,
 * or an integer index relating to
 * the current options list.
 *
 * Options:
 *
 *  - {Boolean} silent
 *
 * @param {String|Number} key
 * @param {Object} opts  Model#set() options
 */
Setting.prototype.select = function(key, options) {
  var isIndex = typeof key === 'number';
  var list = this.get('options');
  var available = this.options.available;
  var selected = isIndex ? list[key] : available[key];

  // If there are no options, exit
  if (!list.length) { return; }

  // If an option was not found,
  // default to selecting the first.
  if (!selected) { return this.select(0, options); }

  // Store the new choice
  this.set('selected', selected.key, options);
};

/**
 * Sorts the current options list
 * by their originally defined
 * index in the config JSON.
 *
 * @private
 */
Setting.prototype.sortByIndex = function(list) {
  return list.sort(function(a, b) { return a.index - b.index; });
};

/**
 * Silently updates the `selected`
 * property of the Setting.
 *
 * If no selected key is present
 * we attempt to select the last
 * fetched persited selection.
 *
 * @private
 */
Setting.prototype.updateSelected = function(options) {
  this.select(this.get('selected') || this.fetched, options);
};

/**
 * Set the `selected` option to
 * the next option in the list.
 *
 * First option is chosen if
 * there is no next option.
 *
 * @public
 */
Setting.prototype.next = function() {
  var options = this.get('options');
  var selected = this.selected();
  var index = options.indexOf(selected);
  var newIndex = (index + 1) % options.length;
  this.select(newIndex);
  debug('set \'%s\' to index: %s', this.key, newIndex);
};

/**
 * Persists the current selection
 * to storage for retreval in the
 * next session.
 *
 * We're using localStorage as performance
 * vastly outweighed indexedBD (asyncStorage)
 * by 1ms/500ms on Hamachi device.
 *
 * @public
 */
Setting.prototype.save = function() {
  var selected = this.get('selected');
  debug('saving key: %s, selected: %s', this.key, selected);
  this.storage.setItem('setting:' + this.key, selected);
  debug('saved key: %s', selected);
};

/**
 * Fetches the persisted selection
 * from storage, updating the
 * `selected` key.
 *
 * We're using localStorage, as performance
 * vastly outweighed indexedBD (asyncStorage)
 * by 1ms/500ms on Hamachi device.
 *
 * Leaving in the `done` callback in-case
 * storage goes async again in future.
 *
 * @param  {Function} done
 * @public
 */
Setting.prototype.fetch = function() {
  if (!this.get('persistent')) { return; }
  debug('fetch value key: %s', this.key);
  this.fetched = this.storage.getItem('setting:' + this.key);
  debug('fetched %s value: %s', this.key, this.fetched);
  if (this.fetched) { this.select(this.fetched, { silent: true }); }
};

/**
 * States whether this setting
 * is currently supported.
 *
 * 'Supported' means, it's not been
 * disabled, and there are options
 * to be chosen from.
 *
 * @return {Boolean}
 */
Setting.prototype.supported = function() {
  return this.enabled() && !!this.get('options').length;
};


/**
 * Check if this setting is not
 * marked as disabled.
 *
 * @return {Boolean}
 */
Setting.prototype.enabled = function() {
  return !this.get('disabled');
};

});

define('lib/settings',['require','exports','module','./setting-alias','debug','./setting','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var SettingAlias = require('./setting-alias');
var debug = require('debug')('settings');
var Setting = require('./setting');
var evt = require('vendor/evt');

/**
 * Mixin emitter
 */

evt(Settings.prototype);

/**
 * Exports
 */

module.exports = Settings;

/**
 * Initialize a new 'Setting'
 *
 * @param {Object} items
 */
function Settings(items) {
  this.ids = {};
  this.items = [];
  this.aliases = {};
  this.SettingAlias = SettingAlias; // Test hook
  this.dontSave = this.dontSave.bind(this);
  this.addEach(items);
}

Settings.prototype.addEach = function(items) {
  if (!items) { return; }
  var item;
  var key;

  for (key in items) {
    item = items[key];
    item.key = item.key || key;
    this.add(items[key]);
  }
};

Settings.prototype.add = function(data) {
  var setting = new Setting(data);
  this.items.push(setting);
  this.ids[setting.key] = this[setting.key] = setting;
  debug('added setting: %s', setting.key);
};

Settings.prototype.fetch = function(done) {
  this.items.forEach(function(setting) { setting.fetch(); });
};

/**
 * Prevent all settings from saving
 * when they are changed.
 *
 * This is used in activity sessions
 * whereby we don't want any settings
 * changes to persist to future camera
 * sessions.
 *
 * @public
 */
Settings.prototype.dontSave = function() {
  this.items.forEach(function(setting) {
    setting.off('change:selected', setting.save);
  });
};

Settings.prototype.alias = function(key, options) {
  options.settings = this;
  options.key = key;
  var alias = new this.SettingAlias(options);
  this.aliases[key] = alias;
  this[key] = alias;
};

Settings.prototype.removeAlias = function(key) {
  // TODO: Implement
};

});

define('lib/geo-location',['require','exports','module','debug'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('geolocation');

/**
 * Locals
 */

var geolocation = navigator.geolocation;

/**
 * Exports
 */

module.exports = GeoLocation;

/**
 * Interface to the
 * geolocation API.
 *
 * @constructor
 */
function GeoLocation() {
  this.watcher = null;
  this.position = null;
  this.setPosition = this.setPosition.bind(this);
  this.watch = this.watch.bind(this);
}

/**
 * Watches device location.
 *
 * @public
 */
GeoLocation.prototype.watch = function() {
  if (!this.watcher) {
    this.watcher = geolocation.watchPosition(this.setPosition);
    debug('started watching');
  }
};

/**
 * Stops watching
 * device location.
 *
 * @public
 */
GeoLocation.prototype.stopWatching = function() {
  geolocation.clearWatch(this.watcher);
  this.watcher = null;
  debug('stopped watching');
};

/**
 * Updates the stored
 * position object.
 *
 * @private
 */
GeoLocation.prototype.setPosition = function(position) {
  this.position = {
    timestamp: position.timestamp,
    altitude: position.coords.altitude,
    latitude: position.coords.latitude,
    longitude: position.coords.longitude
  };
};

});

define('config/config',['require','exports','module'],function(require, exports, module) {


module.exports = {
  // This remaining globals are required by external dependencies of camera.
  // shared/js/media/jpeg_metadata_parser.js
  // shared/js/media/media_frame.js
  globals : {
    // The maximum picture size that camera is allowed to take
    CONFIG_MAX_IMAGE_PIXEL_SIZE: 5242880,
    CONFIG_MAX_SNAPSHOT_PIXEL_SIZE: 5242880,

    // Size of the exif preview embeded in images taken by camera
    CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH: 0,
    CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT: 0
  },

  zoom: {
    disabled: false,

    // The viewfinder preview stream should automatically
    // reflect the current zoom value. However, on some
    // devices, the viewfinder needs to be scaled by the
    // application. Set this flag if the preview stream
    // does not visually reflect the zoom value properly.
    useZoomPreviewAdjustment: false
  },

  focus: {
    // Set this properties to false if you
    // want to disable focus modes
    // even on hardware that supports them
    // -----------------------------------
    // The camera will be continously focusing
    // on a point of the scene. It is the center of the image
    // unless touch to focus is enabled and the user selects a
    // different region.
    continuousAutoFocus: true,
    // The user can select the area of the image
    // where the camera is going to try to focus the scene.
    touchFocus: true,
    // The camera detects faces and tries to focus
    // on them.
    faceDetection: true
  },

  previewGallery: {

    // Flag for determining if the preview should limit the
    // image size to the value of CONFIG_MAX_IMAGE_PIXEL_SIZE
    // (enable for devices with limited memory)
    limitMaxPreviewSize: false,

    // Dimensions for thumbnail image (will automatically be
    // multiplied by the devicePixelRatio)
    thumbnailWidth: 54,
    thumbnailHeight: 54
  },

  viewfinder: {
    scaleType: 'fill',
    // Used to adjust sensitivity for pinch-to-zoom gesture
    // (smaller values = more sensitivity)
    zoomGestureSensitivity: 0.425
  },

  battery: {
    levels: {
      low: 15,
      verylow: 10,
      critical: 6,
      shutdown: 5,
      healthy: 100
    }
  },

  sounds: {
    list: [
      {
        name: 'shutter',
        url: './resources/sounds/shutter.ogg',
        setting: 'camera.sound.enabled'
      },
      {
        name: 'timer',
        url: './resources/sounds/timer.ogg',
        setting: 'camera.sound.enabled'
      },
      {
        name: 'recordingStart',
        url: './resources/sounds/camcorder_start.opus',
        setting: 'camera.sound.enabled'
      },
      {
        name: 'recordingEnd',
        url: './resources/sounds/camcorder_end.opus',
        setting: 'camera.sound.enabled'
      }
    ]
  },

  activity: {

    // The amount to scale pixelSize derived from
    // 'pick' activities that define `width` or `height`
    // parameters. The larger the scale factor, the larger
    // the activity `maxPixelSize` icreasing the probability
    // that a larger pictureSize will be chosen for the activity.
    maxPixelSizeScaleFactor: 2.5,

    // Reduce the size of images returned by pick activities.
    // A pick activity can specify its own maximum size. However,
    // this setting can lower that pixel size limitation even
    // further. To prevent further limiting the pixel size for
    // pick activities, set this value to `0`.
    // (useful for devices with limited memory)
    maxPickPixelSize: 0,

    // Reduce the size of images returned by share activities.
    // To prevent resizing images that are shared, set this
    // value to `0`.
    // (useful for devices with limited memory)
    maxSharePixelSize: 0
  },

  loadingScreen: {
    delay: 600
  },

  mode: {
    options: [
      {
        key: 'picture'
      },
      {
        key: 'video'
      }
    ],
    persistent: false
  },

  isoModes: {
    disabled: false,
    options: [
      {
        key: 'auto'
      }
    ],
    selected:'auto'
  },

  whiteBalance: {
    disabled: false,
    options: [
      {
        key: 'auto'
      }
    ],
    selected:'auto'
  },

  cameras: {
    options: [
      {
        key: 'back'
      },
      {
        key: 'front'
      }
    ],
    persistent: false
  },

  pictureSizesFront: {
    title: 'camera-resolution',
    header: 'camera-resolution-header',
    icon: 'icon-picture-size',
    options: [
      // {
      //   key: '2048x1536'
      // }
    ],
    exclude: {
      aspects: ['5:3', '11:9', '16:9']
    },
    persistent: true,
    optionsLocalizable: false,
  },

  pictureSizesBack: {
    title: 'camera-resolution',
    header: 'camera-resolution-header',
    icon: 'icon-picture-size',
    options: [
      // {
      //   key: '2048x1536'
      // }
    ],
    exclude: {
      keys: ['1920x1088'],
      aspects: ['5:3', '11:9', '16:9'],
    },
    persistent: true,
    optionsLocalizable: false,
  },

  recorderProfilesBack: {
    title: 'video-resolution',
    header: 'video-resolution-header',
    icon: 'icon-video-size',
    options: [],
    exclude: ['high', '1080p'],
    persistent: true,
    optionsLocalizable: false,
  },

  recorderProfilesFront: {
    title: 'video-resolution',
    header: 'video-resolution-header',
    icon: 'icon-video-size',
    options: [],
    persistent: true,
    optionsLocalizable: false,
  },

  flashModesPicture: {
    title: 'flash',
    options: [
      {
        key: 'auto',
        icon: 'icon-flash-auto',
        title: 'flash-auto'
      },
      {
        key: 'on',
        icon: 'icon-flash-on',
        title: 'flash-on'
      },
      {
        key: 'off',
        icon: 'icon-flash-off',
        title: 'flash-off'
      }
    ],
    persistent: true
  },

  flashModesVideo: {
    title: 'flash',
    options: [
      {
        key: 'off',
        icon: 'icon-flash-off',
        title: 'flash-off'
      },
      {
        key: 'torch',
        icon: 'icon-flash-on',
        title: 'flash-on'
      }
    ],
    persistent: true
  },

  timer: {
    title: 'self-timer',
    header: 'self-timer-header',
    icon: 'icon-self-timer',
    options: [
      {
        key: 'off',
        title: 'self-timer-off',
        value: 0
      },
      {
        key: 'secs2',
        value: 2,
        title: 'self-timer-2-seconds'
      },
      {
        key: 'secs5',
        value: 5,
        title: 'self-timer-5-seconds'
      },
      {
        key: 'secs10',
        value: 10,
        title: 'self-timer-10-seconds'
      }
    ],
    persistent: false,
  },

  hdr: {
    title: 'hdr',
    header: 'hdr-header',
    icon: 'icon-hdr-menu',
    disabled: false,
    options: [
      {
        key: 'off',
        title: 'hdr-off'
      },
      {
        key: 'on',
        title: 'hdr-on'
      }
    ],
    persistent: true
  },

  scene: {
    title: 'scene-mode',
    header: 'scene-mode-header',
    icon: 'icon-scene',
    options: [
      {
        key: 'normal',
        title: 'scene-mode-normal'
      },
      {
        key: 'pano',
        title: 'scene-mode-panorama'
      },
      {
        key: 'beauty',
        title: 'scene-mode-beauty'
      }
    ],
    persistent: true,
  },

  grid: {
    title: 'grid',
    header: 'grid-header',
    icon: 'icon-grid',
    options: [
      {
        key: 'off',
        title: 'grid-off'
      },
      {
        key: 'on',
        title: 'grid-on'
      }
    ],
    selected: 'off',
    persistent: true,
    notifications: false
  },

  settingsMenu: {
    items: [
      // {
      //   key: 'scene'
      // },
      {
        key: 'hdr'
      },
      {
        key: 'timer'
      },
      // {
      //   key: 'pictureSizes'
      // },
      // {
      //   key: 'recorderProfiles'
      // },
      {
        key: 'grid'
      }
    ]
  }
};

});

define('lib/camera-utils',['require','debug'],function(require) {
  /*jshint maxlen:false*/
  

  var debug = require('debug')('camera-utils');

  var CameraUtils = function CameraUtils() {};

  CameraUtils.scaleSizeToFitViewport = function(viewportSize, imageSize) {
    var sw = viewportSize.width / imageSize.width,
        sh = viewportSize.height / imageSize.height,
        scale;

    // Select the smaller scale to fit image completely within the viewport
    scale = Math.min(sw, sh);

    return {
      width: imageSize.width * scale,
      height: imageSize.height * scale
    };
  };

  CameraUtils.scaleSizeToFillViewport = function(viewportSize, imageSize) {
    var sw = viewportSize.width / imageSize.width,
        sh = viewportSize.height / imageSize.height,
        scale;

    // Select the larger scale to fill and overflow viewport with image
    scale = Math.max(sw, sh);

    return {
      width: imageSize.width * scale,
      height: imageSize.height * scale
    };
  };

  /**
   * This implementation is loosely based around AOSP's
   * Camera.Util.getOptimalPreviewSize() method:
   *
   * http://androidxref.com/4.0.4/xref/packages/apps/Camera/src/com/android/camera/Util.java#374
   *
   * NOTE: All sizes are in *device* pixels. If passing a
   * `viewportSize`, be sure to specify it in device pixels.
   * Otherwise, the `viewportSize` will be determined by:
   *
   * window.innerWidth * window.devicePixelRatio
   *
   * @param  {Array} previewSizes
   * @param  {Object} targetSize
   * @param  {Object} viewportSize
   * @return {Object}
   */
  CameraUtils.getOptimalPreviewSize =
    function(previewSizes, targetSize, viewportSize) {

      // Use a very small tolerance because we want an exact match.
      const ASPECT_TOLERANCE = 0.001;
      
      if (!previewSizes || previewSizes.length === 0) {
        return null;
      }

      var optimalSize;
      var minDiff = Number.MAX_VALUE;

      // If no viewport size is specified, use screen height
      var screenHeight = window.innerWidth * window.devicePixelRatio;
      var targetHeight = viewportSize ?
        Math.min(viewportSize.height, viewportSize.width) : screenHeight;

      if (targetHeight <= 0) {
        targetHeight = screenHeight;
      }

      var targetRatio = targetSize.width / targetSize.height;

      // Try to find an size match aspect ratio and size
      previewSizes.forEach(function(previewSize) {
        var ratio = previewSize.width / previewSize.height;
        var diff;

        if (Math.abs(ratio - targetRatio) <= ASPECT_TOLERANCE) {
          // Use Math.sqrt() to err on the side of a slightly larger
          // preview size in the event of a tie.
          diff = Math.abs(
            Math.sqrt(previewSize.height) - Math.sqrt(targetHeight));

          if (diff < minDiff) {
            optimalSize = previewSize;
            minDiff = diff;
          }
        }
      });

      // Cannot find the one match the aspect ratio. This should not happen.
      // Ignore the requirement.
      if (!optimalSize) {
        debug('No preview size to match the aspect ratio');
        minDiff = Number.MAX_VALUE;

        previewSizes.forEach(function(previewSize) {

          // Use Math.sqrt() to err on the side of a slightly larger
          // preview size in the event of a tie.
          var diff = Math.abs(
            Math.sqrt(previewSize.height) - Math.sqrt(targetHeight));

          if (diff < minDiff) {
            optimalSize = previewSize;
            minDiff = diff;
          }
        });
      }

      return optimalSize;
    };

  /**
   * Get the maximum preview size (in terms of area) from a list of
   * possible preview sizes.
   *
   * NOTE: If an `aspectRatio` value is provided, the search will be
   * constrained to only accept preview sizes matching that aspect
   * ratio.
   *
   * @param  {Array} previewSizes
   * @param  {Number} aspectRatio
   * @return {Object}
   */
  CameraUtils.getMaximumPreviewSize = function(previewSizes, aspectRatio) {

    // Use a very small tolerance because we want an exact match if we are
    // constraining to only include specific aspect ratios.
    const ASPECT_TOLERANCE = 0.001;

    var maximumArea = 0;
    var maximumPreviewSize = null;
    previewSizes.forEach(function(previewSize) {
      var area = previewSize.width * previewSize.height;

      if (aspectRatio) {
        var ratio = previewSize.width / previewSize.height;
        if (Math.abs(ratio - aspectRatio) > ASPECT_TOLERANCE) {
          return;
        }
      }

      if (area > maximumArea) {
        maximumArea = area;
        maximumPreviewSize = previewSize;
      }
    });

    return maximumPreviewSize;
  };

  CameraUtils.prototype = {
    constructor: CameraUtils
  };

  return CameraUtils;
});

/* exported BlobView */


var BlobView = (function() {
  function fail(msg) {
    throw Error(msg);
  }

  // This constructor is for internal use only.
  // Use the BlobView.get() factory function or the getMore instance method
  // to obtain a BlobView object.
  function BlobView(blob, sliceOffset, sliceLength, slice,
                    viewOffset, viewLength, littleEndian)
  {
    this.blob = blob;                  // The parent blob that the data is from
    this.sliceOffset = sliceOffset;    // The start address within the blob
    this.sliceLength = sliceLength;    // How long the slice is
    this.slice = slice;                // The ArrayBuffer of slice data
    this.viewOffset = viewOffset;      // The start of the view within the slice
    this.viewLength = viewLength;      // The length of the view
    this.littleEndian = littleEndian;  // Read little endian by default?

    // DataView wrapper around the ArrayBuffer
    this.view = new DataView(slice, viewOffset, viewLength);

    // These fields mirror those of DataView
    this.buffer = slice;
    this.byteLength = viewLength;
    this.byteOffset = viewOffset;

    this.index = 0;   // The read methods keep track of the read position
  }

  // Async factory function
  BlobView.get = function(blob, offset, length, callback, littleEndian) {
    if (offset < 0) {
      fail('negative offset');
    }
    if (length < 0) {
      fail('negative length');
    }
    if (offset > blob.size) {
      fail('offset larger than blob size');
    }
    // Don't fail if the length is too big; just reduce the length
    if (offset + length > blob.size) {
      length = blob.size - offset;
    }
    var slice = blob.slice(offset, offset + length);
    var reader = new FileReader();
    reader.readAsArrayBuffer(slice);
    reader.onloadend = function() {
      var result = null;
      if (reader.result) {
        result = new BlobView(blob, offset, length, reader.result,
                              0, length, littleEndian || false);
      }
      callback(result, reader.error);
    };
  };

  BlobView.prototype = {
    constructor: BlobView,

    // This instance method is like the BlobView.get() factory method,
    // but it is here because if the current buffer includes the requested
    // range of bytes, they can be passed directly to the callback without
    // going back to the blob to read them
    getMore: function(offset, length, callback) {
      if (offset >= this.sliceOffset &&
          offset + length <= this.sliceOffset + this.sliceLength) {
        // The quick case: we already have that region of the blob
        callback(new BlobView(this.blob,
                              this.sliceOffset, this.sliceLength, this.slice,
                              offset - this.sliceOffset, length,
                              this.littleEndian));
      }
      else {
        // Otherwise, we have to do an async read to get more bytes
        BlobView.get(this.blob, offset, length, callback, this.littleEndian);
      }
    },

    // Set the default endianness for the other methods
    littleEndian: function() {
      this.littleEndian = true;
    },
    bigEndian: function() {
      this.littleEndian = false;
    },

    // These "get" methods are just copies of the DataView methods, except
    // that they honor the default endianness
    getUint8: function(offset) {
      return this.view.getUint8(offset);
    },
    getInt8: function(offset) {
      return this.view.getInt8(offset);
    },
    getUint16: function(offset, le) {
      return this.view.getUint16(offset,
                                 le !== undefined ? le : this.littleEndian);
    },
    getInt16: function(offset, le) {
      return this.view.getInt16(offset,
                                le !== undefined ? le : this.littleEndian);
    },
    getUint32: function(offset, le) {
      return this.view.getUint32(offset,
                                 le !== undefined ? le : this.littleEndian);
    },
    getInt32: function(offset, le) {
      return this.view.getInt32(offset,
                                le !== undefined ? le : this.littleEndian);
    },
    getFloat32: function(offset, le) {
      return this.view.getFloat32(offset,
                                  le !== undefined ? le : this.littleEndian);
    },
    getFloat64: function(offset, le) {
      return this.view.getFloat64(offset,
                                  le !== undefined ? le : this.littleEndian);
    },

    // These "read" methods read from the current position in the view and
    // update that position accordingly
    readByte: function() {
      return this.view.getInt8(this.index++);
    },
    readUnsignedByte: function() {
      return this.view.getUint8(this.index++);
    },
    readShort: function(le) {
      var val = this.view.getInt16(this.index,
                                   le !== undefined ? le : this.littleEndian);
      this.index += 2;
      return val;
    },
    readUnsignedShort: function(le) {
      var val = this.view.getUint16(this.index,
                                    le !== undefined ? le : this.littleEndian);
      this.index += 2;
      return val;
    },
    readInt: function(le) {
      var val = this.view.getInt32(this.index,
                                   le !== undefined ? le : this.littleEndian);
      this.index += 4;
      return val;
    },
    readUnsignedInt: function(le) {
      var val = this.view.getUint32(this.index,
                                    le !== undefined ? le : this.littleEndian);
      this.index += 4;
      return val;
    },
    readFloat: function(le) {
      var val = this.view.getFloat32(this.index,
                                     le !== undefined ? le : this.littleEndian);
      this.index += 4;
      return val;
    },
    readDouble: function(le) {
      var val = this.view.getFloat64(this.index,
                                     le !== undefined ? le : this.littleEndian);
      this.index += 8;
      return val;
    },

    // Methods to get and set the current position
    tell: function() {
      return this.index;
    },
    remaining: function() {
      return this.byteLength - this.index;
    },
    seek: function(index) {
      if (index < 0) {
        fail('negative index');
      }
      if (index > this.byteLength) {
        fail('index greater than buffer size');
      }
      this.index = index;
    },
    advance: function(n) {
      var index = this.index + n;
      if (index < 0) {
        fail('advance past beginning of buffer');
      }
      // It's usual that when we finished reading one target view,
      // the index is advanced to the start(previous end + 1) of next view,
      // and the new index will be equal to byte length(the last index + 1),
      // we will not fail on it because it means the reading is finished,
      // or do we have to warn here?
      if (index > this.byteLength) {
        fail('advance past end of buffer');
      }
      this.index = index;
    },

    // Additional methods to read other useful things
    getUnsignedByteArray: function(offset, n) {
      return new Uint8Array(this.buffer, offset + this.viewOffset, n);
    },

    // Additional methods to read other useful things
    readUnsignedByteArray: function(n) {
      var val = new Uint8Array(this.buffer, this.index + this.viewOffset, n);
      this.index += n;
      return val;
    },

    getBit: function(offset, bit) {
      var byte = this.view.getUint8(offset);
      return (byte & (1 << bit)) !== 0;
    },

    getUint24: function(offset, le) {
      var b1, b2, b3;
      if (le !== undefined ? le : this.littleEndian) {
        b1 = this.view.getUint8(offset);
        b2 = this.view.getUint8(offset + 1);
        b3 = this.view.getUint8(offset + 2);
      }
      else {    // big end first
        b3 = this.view.getUint8(offset);
        b2 = this.view.getUint8(offset + 1);
        b1 = this.view.getUint8(offset + 2);
      }

      return (b3 << 16) + (b2 << 8) + b1;
    },

    readUint24: function(le) {
      var value = this.getUint24(this.index, le);
      this.index += 3;
      return value;
    },

    // There are lots of ways to read strings.
    // ASCII, UTF-8, UTF-16.
    // null-terminated, character length, byte length
    // I'll implement string reading methods as needed

    getASCIIText: function(offset, len) {
      var bytes = new Uint8Array(this.buffer, offset + this.viewOffset, len);
      return String.fromCharCode.apply(String, bytes);
    },

    readASCIIText: function(len) {
      var bytes = new Uint8Array(this.buffer,
                                 this.index + this.viewOffset,
                                 len);
      this.index += len;
      return String.fromCharCode.apply(String, bytes);
    },

    // Replace this with the StringEncoding API when we've got it.
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=764234
    getUTF8Text: function(offset, len) {
      function fail() { throw new Error('Illegal UTF-8'); }

      var pos = offset;         // Current position in this.view
      var end = offset + len;   // Last position
      var charcode;             // Current charcode
      var s = '';               // Accumulate the string
      var b1, b2, b3, b4;       // Up to 4 bytes per charcode

      // See http://en.wikipedia.org/wiki/UTF-8
      while (pos < end) {
        var b1 = this.view.getUint8(pos);
        if (b1 < 128) {
          s += String.fromCharCode(b1);
          pos += 1;
        }
        else if (b1 < 194) {
          // unexpected continuation character...
          fail();
        }
        else if (b1 < 224) {
          // 2-byte sequence
          if (pos + 1 >= end) {
            fail();
          }
          b2 = this.view.getUint8(pos + 1);
          if (b2 < 128 || b2 > 191) {
            fail();
          }
          charcode = ((b1 & 0x1f) << 6) + (b2 & 0x3f);
          s += String.fromCharCode(charcode);
          pos += 2;
        }
        else if (b1 < 240) {
          // 3-byte sequence
          if (pos + 2 >= end) {
            fail();
          }
          b2 = this.view.getUint8(pos + 1);
          if (b2 < 128 || b2 > 191) {
            fail();
          }
          b3 = this.view.getUint8(pos + 2);
          if (b3 < 128 || b3 > 191) {
            fail();
          }
          charcode = ((b1 & 0x0f) << 12) + ((b2 & 0x3f) << 6) + (b3 & 0x3f);
          s += String.fromCharCode(charcode);
          pos += 3;
        }
        else if (b1 < 245) {
          // 4-byte sequence
          if (pos + 3 >= end) {
            fail();
          }
          b2 = this.view.getUint8(pos + 1);
          if (b2 < 128 || b2 > 191) {
            fail();
          }
          b3 = this.view.getUint8(pos + 2);
          if (b3 < 128 || b3 > 191) {
            fail();
          }
          b4 = this.view.getUint8(pos + 3);
          if (b4 < 128 || b4 > 191) {
            fail();
          }
          charcode = ((b1 & 0x07) << 18) +
            ((b2 & 0x3f) << 12) +
            ((b3 & 0x3f) << 6) +
            (b4 & 0x3f);

          // Now turn this code point into two surrogate pairs
          charcode -= 0x10000;
          s += String.fromCharCode(0xd800 + ((charcode & 0x0FFC00) >>> 10));
          s += String.fromCharCode(0xdc00 + (charcode & 0x0003FF));

          pos += 4;
        }
        else {
          // Illegal byte
          fail();
        }
      }

      return s;
    },

    readUTF8Text: function(len) {
      try {
        return this.getUTF8Text(this.index, len);
      }
      finally {
        this.index += len;
      }
    },

    // Read 4 bytes, ignore the high bit and combine them into a 28-bit
    // big-endian unsigned integer.
    // This format is used by the ID3v2 metadata.
    getID3Uint28BE: function(offset) {
      var b1 = this.view.getUint8(offset) & 0x7f;
      var b2 = this.view.getUint8(offset + 1) & 0x7f;
      var b3 = this.view.getUint8(offset + 2) & 0x7f;
      var b4 = this.view.getUint8(offset + 3) & 0x7f;
      return (b1 << 21) | (b2 << 14) | (b3 << 7) | b4;
    },

    readID3Uint28BE: function() {
      var value = this.getID3Uint28BE(this.index);
      this.index += 4;
      return value;
    },

    // Read bytes up to and including a null terminator, but never
    // more than size bytes.  And return as a Latin1 string
    readNullTerminatedLatin1Text: function(size) {
      var s = '';
      for (var i = 0; i < size; i++) {
        var charcode = this.view.getUint8(this.index + i);
        if (charcode === 0) {
          i++;
          break;
        }
        s += String.fromCharCode(charcode);
      }
      this.index += i;
      return s;
    },

    // Read bytes up to and including a null terminator, but never
    // more than size bytes.  And return as a UTF8 string
    readNullTerminatedUTF8Text: function(size) {
      for (var len = 0; len < size; len++) {
        if (this.view.getUint8(this.index + len) === 0) {
          break;
        }
      }
      var s = this.readUTF8Text(len);
      if (len < size) {    // skip the null terminator if we found one
        this.advance(1);
      }
      return s;
    },

    // Read UTF16 text.  If le is not specified, expect a BOM to define
    // endianness.  If le is true, read UTF16LE, if false, UTF16BE
    // Read until we find a null-terminator, but never more than size bytes
    readNullTerminatedUTF16Text: function(size, le) {
      if (le == null) {
        var BOM = this.readUnsignedShort();
        size -= 2;
        if (BOM === 0xFEFF) {
          le = false;
        } else {
          le = true;
        }
      }

      var s = '';
      for (var i = 0; i < size; i += 2) {
        var charcode = this.getUint16(this.index + i, le);
        if (charcode === 0) {
          i += 2;
          break;
        }
        s += String.fromCharCode(charcode);
      }
      this.index += i;
      return s;
    }
  };

  // We don't want users of this library to accidentally call the constructor
  // instead of using the factory function, so we return a dummy object
  // instead of the real constructor. If someone really needs to get at the
  // real constructor, the contructor property of the prototype refers to it.
  return { get: BlobView.get };
}());

define("BlobView", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.BlobView;
    };
}(this)));



//
// Given an MP4/Quicktime based video file as a blob, read through its
// atoms to find the track header "tkhd" atom and extract the rotation
// matrix from it. Convert the matrix value to rotation in degrees and
// pass that number to the specified callback function. If no value is
// found but the video file is valid, pass null to the callback. If
// any errors occur, pass an error message (a string) callback.
//
// See also:
// http://androidxref.com/4.0.4/xref/frameworks/base/media/libstagefright/MPEG4Writer.cpp
// https://developer.apple.com/library/mac/#documentation/QuickTime/QTFF/QTFFChap2/qtff2.html
//
function getVideoRotation(blob, rotationCallback) {

  // A utility for traversing the tree of atoms in an MP4 file
  function MP4Parser(blob, handlers) {
    // Start off with a 1024 chunk from the start of the blob.
    BlobView.get(blob, 0, Math.min(1024, blob.size), function(data, error) {
      // Make sure that the blob is, in fact, some kind of MP4 file
      if (data.byteLength <= 8 || data.getASCIIText(4, 4) !== 'ftyp') {
        handlers.errorHandler('not an MP4 file');
        return;
      }
      parseAtom(data);
    });

    // Call this with a BlobView object that includes the first 16 bytes of
    // an atom. It doesn't matter whether the body of the atom is included.
    function parseAtom(data) {
      var offset = data.sliceOffset + data.viewOffset; // atom position in blob
      var size = data.readUnsignedInt();               // atom length
      var type = data.readASCIIText(4);                // atom type
      var contentOffset = 8;                           // position of content

      if (size === 0) {
        // Zero size means the rest of the file
        size = blob.size - offset;
      }
      else if (size === 1) {
        // A size of 1 means the size is in bytes 8-15
        size = data.readUnsignedInt() * 4294967296 + data.readUnsignedInt();
        contentOffset = 16;
      }

      var handler = handlers[type] || handlers.defaultHandler;
      if (typeof handler === 'function') {
        // If the handler is a function, pass that function a
        // DataView object that contains the entire atom
        // including size and type.  Then use the return value
        // of the function as instructions on what to do next.
        data.getMore(data.sliceOffset + data.viewOffset, size, function(atom) {
          // Pass the entire atom to the handler function
          var rv = handler(atom);

          // If the return value is 'done', stop parsing.
          // Otherwise, continue with the next atom.
          // XXX: For more general parsing we need a way to pop some
          // stack levels.  A return value that is an atom name should mean
          // pop back up to this atom type and go on to the next atom
          // after that.
          if (rv !== 'done') {
            parseAtomAt(data, offset + size);
          }
        });
      }
      else if (handler === 'children') {
        // If the handler is this string, then assume that the atom is
        // a container atom and do its next child atom next
        var skip = (type === 'meta') ? 4 : 0; // special case for meta atoms
        parseAtomAt(data, offset + contentOffset + skip);
      }
      else if (handler === 'skip' || !handler) {
        // Skip the atom entirely and go on to the next one.
        // If there is no next one, call the eofHandler or just return
        parseAtomAt(data, offset + size);
      }
      else if (handler === 'done') {
        // Stop parsing
        return;
      }
    }

    function parseAtomAt(data, offset) {
      if (offset >= blob.size) {
        if (handlers.eofHandler)
          handlers.eofHandler();
        return;
      }
      else {
        data.getMore(offset, 16, parseAtom);
      }
    }
  }

  // We want to loop through the top-level atoms until we find the 'moov'
  // atom. Then, within this atom, there are one or more 'trak' atoms.
  // Each 'trak' should begin with a 'tkhd' atom. The tkhd atom has
  // a transformation matrix at byte 48.  The matrix is 9 32 bit integers.
  // We'll interpret those numbers as a rotation of 0, 90, 180 or 270.
  // If the video has more than one track, we expect all of them to have
  // the same rotation, so we'll only look at the first 'trak' atom that
  // we find.
  MP4Parser(blob, {
    errorHandler: function(msg) { rotationCallback(msg); },
    eofHandler: function() { rotationCallback(null); },
    defaultHandler: 'skip',  // Skip all atoms other than those listed below
    moov: 'children',        // Enumerate children of the moov atom
    trak: 'children',        // Enumerate children of the trak atom
    tkhd: function(data) {   // Pass the tkhd atom to this function
      // The matrix begins at byte 48
      data.advance(48);

      var a = data.readUnsignedInt();
      var b = data.readUnsignedInt();
      data.advance(4); // we don't care about this number
      var c = data.readUnsignedInt();
      var d = data.readUnsignedInt();

      if (a === 0 && d === 0) { // 90 or 270 degrees
        if (b === 0x00010000 && c === 0xFFFF0000)
          rotationCallback(90);
        else if (b === 0xFFFF0000 && c === 0x00010000)
          rotationCallback(270);
        else
          rotationCallback('unexpected rotation matrix');
      }
      else if (b === 0 && c === 0) { // 0 or 180 degrees
        if (a === 0x00010000 && d === 0x00010000)
          rotationCallback(0);
        else if (a === 0xFFFF0000 && d === 0xFFFF0000)
          rotationCallback(180);
        else
          rotationCallback('unexpected rotation matrix');
      }
      else {
        rotationCallback('unexpected rotation matrix');
      }
      return 'done';
    }
  });
}
;
define("getVideoRotation", ["BlobView"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.getVideoRotation;
    };
}(this)));

define('lib/get-video-meta-data',['require','exports','module','getVideoRotation'],function(require, exports, module) {


/**
 * Module Dependencies
 */

var getVideoRotation = require('getVideoRotation');

/**
 * Given the filename of a newly
 * recorded video, create a poster
 * image for it, and save that
 * poster as a jpeg file.
 *
 * When done, pass the video blob
 * and the poster blob to the
 * done function along with the
 * video dimensions and rotation.
 *
 * @param  {Blob}   blob
 * @param  {String}   filename
 * @param  {Function} done
 */
module.exports = createVideoPosterImage;


function createVideoPosterImage(blob, done) {
  var URL = window.URL;

  getVideoRotation(blob, onGotVideoRotation);

  function onGotVideoRotation(rotation) {
    if (typeof rotation !== 'number') {
      console.warn('Unexpected rotation:', rotation);
      rotation = 0;
    }

    var offscreenVideo = document.createElement('video');
    var url = URL.createObjectURL(blob);

    offscreenVideo.preload = 'metadata';
    offscreenVideo.src = url;
    offscreenVideo.onerror = onError;
    offscreenVideo.onloadedmetadata = onLoadedMetaData;

    function onLoadedMetaData() {
      var videowidth = offscreenVideo.videoWidth;
      var videoheight = offscreenVideo.videoHeight;

      // First, create a full-size
      // unrotated poster image
      var postercanvas = document.createElement('canvas');
      var postercontext = postercanvas.getContext('2d');
      postercanvas.width = videowidth;
      postercanvas.height = videoheight;
      postercontext.drawImage(offscreenVideo, 0, 0);

      // We're done with the
      // offscreen video element now
      URL.revokeObjectURL(url);
      offscreenVideo.removeAttribute('src');
      offscreenVideo.load();

      postercanvas.toBlob(function(imageBlob) {
        done(null, {
          width: videowidth,
          height: videoheight,
          rotation: rotation,
          poster: {
            blob: imageBlob
          }
        });
      }, 'image/jpeg');
    }

    function onError() {
      URL.revokeObjectURL(url);
      offscreenVideo.removeAttribute('src');
      offscreenVideo.load();
      console.warn('not a video file delete it!');
      done('error');
    }
  }
}

});

define('vendor/orientation',[],function() {
  

  // The time interval is allowed between two orientation change event
  const ORIENTATION_CHANGE_INTERVAL = 300;

  // The maximum sample inter-arrival time in milliseconds. If the acceleration
  // samples are further apart than this amount in time, we reset the state of
  // the low-pass filter and orientation properties.  This helps to handle
  // boundary conditions when the app becomes invisisble, wakes from suspend or
  // there is a significant gap in samples.
  const MAX_MOTION_FILTER_TIME = 1000;

  // Filtering adds latency proportional the time constant (inversely
  // proportional to the cutoff frequency) so we don't want to make the time
  // constant too large or we can lose responsiveness.  Likewise we don't want
  // to make it too small or we do a poor job suppressing acceleration spikes.
  // Empirically, 100ms seems to be too small and 500ms is too large. Android
  // default is 200. The original version is from:
  // http://mxr.mozilla.org/mozilla-central/source/widget/gonk/
  //                                                      ProcessOrientation.cpp
  const MOTION_FILTER_TIME_CONSTANT = 200;

  var lastMotionFilteredTime = 0;
  var lastMotionData = {x: 0, y: 0, z: 0, t: 0};
  var pendingOrientation = null;
  var orientationChangeTimer = 0;
  var eventListeners = {'orientation': []};

  function applyFilter(x, y, z) {
    var now = new Date().getTime();
    var filterReset = false;
    // The motion event is too far from last filtered data, reset the data.
    // This may be the case of hide app and go back.
    if (now > lastMotionData.t + MAX_MOTION_FILTER_TIME) {
      // clear data to re-initialize it.
      lastMotionData.x = 0;
      lastMotionData.y = 0;
      lastMotionData.z = 0;
      filterReset = true;
    }
    // applying the exponential moving average to x, y, z, when we already have
    // value of it.
    if (lastMotionData.x || lastMotionData.y || lastMotionData.z) {
      // use time to calculate alpha
      var diff = now - lastMotionFilteredTime;
      var alpha = diff / (MOTION_FILTER_TIME_CONSTANT + diff);

      // weight the x, y, z with alpha
      x = alpha * (x - lastMotionData.x) + lastMotionData.x;
      y = alpha * (y - lastMotionData.y) + lastMotionData.y;
      z = alpha * (z - lastMotionData.z) + lastMotionData.z;
    }

    // update the filter state.
    lastMotionData.x = x;
    lastMotionData.y = y;
    lastMotionData.z = z;
    lastMotionData.t = now;
    return filterReset;
  }

  function calcOrientation(x, y) {
    // use atan2(-x, y) to calculate the rotation on z axis.
    var orientationAngle = (Math.atan2(-x, y) * 180 / Math.PI);
    // The value range of atan2 is [-180, 180]. To have the [0, 360] value
    // range, we need to add 360 degrees when the angle is less than 0.
    if (orientationAngle < 0) {
      orientationAngle += 360;
    }

    // find the nearest orientation.
    // If an angle is >= 45 degrees, we view it as 90 degrees. If an angle is <
    // 45, we view it as 0 degree.
    var orientation = (((orientationAngle + 45) / 90) >> 0) % 4 * 90;
    return orientation;
  }

  function handleMotionEvent(e) {
    if (!e.accelerationIncludingGravity) {
      return;
    }

    var filterReset = applyFilter(e.accelerationIncludingGravity.x,
                                  e.accelerationIncludingGravity.y,
                                  e.accelerationIncludingGravity.z);

    // We don't need to process the event when filter is reset or no data.
    if (filterReset) {
      return;
    }

    var x = lastMotionData.x;
    var y = lastMotionData.y;
    var z = lastMotionData.z;

    // We only want to measure gravity, so ignore events when there is
    // significant acceleration in addition to gravity because this means the
    // user is moving the phone.
    if ((x * x + y * y + z * z) > 110) {
      return;
    }
    // If the camera is close to horizontal (pointing up or down) then we can't
    // tell what orientation the user intends, so we just return now without
    // changing the orientation. The constant 9.2 is the force of gravity (9.8)
    // times the cosine of 20 degrees. So if the phone is within 20 degrees of
    // horizontal, we will never change the orientation.
    if (z > 9.2 || z < -9.2) {
      return;
    }

    var orientation = calcOrientation(x, y);

    if (orientation === pendingOrientation) {
      return;
    }

    // When phone keeps the same orientation for ORIENTATION_CHANGE_INTERVAL
    // time interval, we change the orientation. Otherwrise the change is
    // cancelled. This may be that user rotates phone rapidly but captured by
    // device motion.
    if (orientationChangeTimer) {
      window.clearTimeout(orientationChangeTimer);
    }

    // If we don't have any current orientation, then send an event right away
    // Otherwise, wait to make sure we're stable before sending it.
    if (pendingOrientation === null) {
      pendingOrientation = orientation;
      fireOrientationChangeEvent(pendingOrientation);
    }
    else {
      // create timer for waiting to rotate the phone
      pendingOrientation = orientation;
      orientationChangeTimer = window.setTimeout(function doOrient() {
        fireOrientationChangeEvent(pendingOrientation);
        orientationChangeTimer = 0;
      }, ORIENTATION_CHANGE_INTERVAL);
    }
  }

  function start() {
    // Reset our state so that the first devicemotion event we get
    // will always generate an orientation event.
    pendingOrientation = null;
    window.addEventListener('devicemotion', handleMotionEvent);
  }

  function stop() {
    window.removeEventListener('devicemotion', handleMotionEvent);
    if (orientationChangeTimer) {
      clearTimeout(orientationChangeTimer);
      orientationChangeTimer = 0;
    }
  }

  function addEventListener(type, listener) {
    if (eventListeners[type] && listener) {
      eventListeners[type].push(listener);
    }
  }

  function removeEventListener(type, listener) {
    if (!eventListeners[type]) {
      return;
    }
    var idx = eventListeners[type].indexOf(listener);
    if (idx > -1) {
      eventListeners.slice(idx, 1);
    }
  }

  function fireOrientationChangeEvent(orientation) {
    eventListeners.orientation.forEach(function(listener) {
      if (listener.handleEvent) {
        listener.handleEvent(orientation);
      } else if ((typeof listener) === 'function') {
        listener(orientation);
      }
    });
  }

  return {
    start: start,
    stop: stop,
    on: addEventListener,
    off: removeEventListener
  };

});

define('lib/orientation',['require','exports','module','vendor/orientation'],function(require, exports, module) {
  

  var listener = require('vendor/orientation');
  var body = document.body;
  var classes = body.classList;
  var current = 0;

  listener.on('orientation', onOrientationChange);
  listener.start();

  function onOrientationChange(degrees) {
    classes.remove('deg' + current);
    classes.add('deg' + degrees);
    current = degrees;
  }

  // Camera normally has its orientation locked to portrait mode.
  // But we unlock orientation when displaying image and video previews.
  // When orientation is unlocked, we call listener.stop().
  // We calls call stop() when recording a video, and then restart
  // when recording is done. If our app ever changes so that we can call
  // unlock while the orientation listener is in the stopped state, then
  // we would need to modify the lock() function so that it did not
  // restart the listener. That is not needed now, however and is omitted.

  function unlock() {
    screen.mozUnlockOrientation();
    listener.stop();
  }

  function lock() {
    screen.mozLockOrientation('portrait-primary');
    listener.start();
  }

  /**
   * Exports
   */

  module.exports = {
    on: listener.on,
    off: listener.off,
    start: listener.start,
    stop: listener.stop,
    unlock: unlock,
    lock: lock,
    get: function() {
      return current;
    }
  };
});

define('lib/debounce',['require','exports','module'],function(require, exports, module) {


module.exports = function(func, wait, immediate) {
  var timeout;
  return function() {
    var context = this, args = arguments;
    var later = function() {
      timeout = null;
      if (!immediate) { func.apply(context, args); }
    };
    var callNow = immediate && !timeout;
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
    if (callNow) { func.apply(context, args); }
  };
};

});
define('lib/bind-all',['require','exports','module'],function(require, exports, module) {


module.exports = function(object) {
  var key;
  var fn;
  for (key in object) {
    fn = object[key];
    if (typeof fn === 'function') {
      object[key] = fn.bind(object);
    }
  }
};

});

define('lib/mixin',['require','exports','module'],function(require, exports, module) {
  

  module.exports = function(a, b) {
    for (var key in b) { a[key] = b[key]; }
    return a;
  };
});

define('lib/camera/focus',['require','exports','module','lib/bind-all'],function(require, exports, module) {


/**
 * Module Dependencies
 */

var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = Focus;

/**
 * Options:
 *
 *   - {Boolean} `continousAutoFocus`
 *   - {Boolean} `touchFocus`
 *   - {Boolean} `faceDetection`
 */
function Focus(options) {
  bindAll(this);
  this.userPreferences = options || {};
  this.detectedFaces = [];
}

Focus.prototype.configure = function(mozCamera, focusMode) {
  var focusModes = mozCamera.capabilities.focusModes;
  this.mozCamera = mozCamera;
  this.configureFocusModes();

  // User preferences override defaults
  if (focusMode === 'continuous-picture' ||
      focusMode === 'continuous-video') {
    if (!this.continuousAutoFocus) {
      focusMode = 'auto';
    }
  }

  // auto is the default focus mode
  focusMode = focusMode || 'auto';

  // If auto or passed mode is not supported we pick the
  // first available in the hardware list
  if (focusModes.indexOf(focusMode) === -1) {
    focusMode = focusModes[0];
  }

  mozCamera.focusMode = this.mode = focusMode;
};

Focus.prototype.getMode = function() {
  return this.mode;
};


/**
 *  Configures focus modes based on user preferences
 *  and hardware availability
 */
Focus.prototype.configureFocusModes = function() {
  var userPreferences = this.userPreferences;
  var continuousAutoFocusUserEnabled =
    userPreferences.continuousAutoFocus !== false;
  var touchFocusUserEnabled = userPreferences.touchFocus;
  var touchFocusSupported = this.isTouchFocusSupported();
  var faceDetectionUserEnabled = userPreferences.faceDetection;
  var faceDetectionSupported = this.isFaceDetectionSupported();
  // User preferences override defaults
  this.touchFocus = touchFocusUserEnabled && touchFocusSupported;
  this.faceDetection = faceDetectionUserEnabled && faceDetectionSupported;
  this.continuousAutoFocus = continuousAutoFocusUserEnabled;
  if (this.faceDetection) {
    this.startFaceDetection();
  }
  this.mozCamera.onAutoFocusMoving = this.onAutoFocusMoving;
};

Focus.prototype.startFaceDetection = function() {
  if (this.faceDetection) {
    this.mozCamera.onFacesDetected = this.focusOnLargestFace;
    this.mozCamera.startFaceDetection();
  }
};

Focus.prototype.stopFaceDetection = function() {
  // Clear suspenstion timers
  clearTimeout(this.faceDetectionSuspended);
  clearTimeout(this.faceDetectionSuspensionTimer);
  if (this.faceDetection) {
    this.mozCamera.stopFaceDetection();
    this.clearFaceDetection();
  }
};

Focus.prototype.clearFaceDetection = function() {
  if (this.faceDetection) {
    this.focusOnLargestFace([]);
  }
};

Focus.prototype.suspendFaceDetection = function(ms, delay) {
  var self = this;
  clearTimeout(this.faceDetectionSuspended);
  clearTimeout(this.faceDetectionSuspensionTimer);
  this.faceDetectionSuspensionTimer = setTimeout(suspendFaceDetection, delay);
  function suspendFaceDetection() {
    self.faceDetectionSuspended = setTimeout(clearTimer, ms);
  }
  function clearTimer() {
    self.faceFocused = false;
    self.faceDetectionSuspended = undefined;
  }
};

Focus.prototype.stopContinuousFocus = function() {
  var focusMode = this.mozCamera.focusMode;
  // Clear suspension timers
  clearTimeout(this.continuousModeTimer);
  if (focusMode === 'continuous-picture' || focusMode === 'continuous-video') {
    this.mode = focusMode;
    this.mozCamera.focusMode = 'auto';
  }
};

Focus.prototype.resumeContinuousFocus = function() {
  this.mozCamera.focusMode = this.mode;
  this.mozCamera.resumeContinuousFocus();
};

Focus.prototype.suspendContinuousFocus = function(ms) {
  clearTimeout(this.continuousModeTimer);
  this.stopContinuousFocus();
  this.continuousModeTimer = setTimeout(this.resumeContinuousFocus, ms);
};

Focus.prototype.onAutoFocusMoving = function(state) {
  if (state) {
    this.onAutoFocusChanged(state);
  }
};

Focus.prototype.onAutoFocusChanged = function(state) {
  // NO OP by default
};

/**
 * Callback invoked when faces are detected
 * It's no op by default and it's meant to be overriden by
 * the user of the module in order to be informed about detected faces
 */
Focus.prototype.onFacesDetected = function(faces) {
  // NO OP by default
};

Focus.prototype.facesAlreadyDetected = function(faces) {
  return faces.length === this.detectedFaces.length;
};

/**
 * It filters out the faces that have low likelihood of being a face
 * mozCamera API provides a faceScore for each face (0-100)
 * It also sorts the faces by area on the screen (largest is first)
 */
Focus.prototype.filterAndSortDetectedFaces = function(faces) {
  var maxArea = -1;
  var minFaceScore = 60;
  var area;
  var detectedFaces = [];

  faces.forEach(function(face, index) {
    if (face.score < minFaceScore) {
      return;
    }
    area = face.bounds.width * face.bounds.height;
    if (area > maxArea) {
      maxArea = area;
      detectedFaces.unshift(face);
    } else {
      detectedFaces.push(face);
    }
  });

  return detectedFaces;
};

Focus.prototype.focusOnLargestFace = function(faces) {
  var self = this;
  var detectedFaces = this.filterAndSortDetectedFaces(faces);
  var facesAlreadyDetected = this.facesAlreadyDetected(detectedFaces);

  // It touch to focus is not available we cannot focus on the face area
  if (!this.touchFocus) {
    return;
  }

  if (this.faceDetectionSuspended || detectedFaces.length === 0) {
    this.onFacesDetected([]);
    return;
  }

  if (!facesAlreadyDetected) {
    this.detectedFaces = detectedFaces;
    this.suspendFaceDetection(2000, 2000);
    if (!this.faceFocused) {
      this.stopContinuousFocus();
      // First face in the array is the one we focus on (largest area on image)
      this.updateFocusArea(detectedFaces[0].bounds, focusDone);
    }
  }
  this.onFacesDetected(detectedFaces);

  function focusDone(error) {
    self.faceFocused = true;
    self.suspendContinuousFocus(4000);
  }

};

/**
 * Focus the camera, invoke the callback asynchronously when done.
 *
 * If we only have fixed focus, then we call the callback right away
 * (but still asynchronously). Otherwise, we call autoFocus to focus
 * the camera and call the callback when focus is complete. In C-AF mode
 * this process should be fast. In manual AF mode, focusing takes about
 * a second and causes a noticeable delay before the picture is taken.
 *
 * @param  {Function} done
 * @private
 */
Focus.prototype.focus = function(done) {
  var self = this;
  this.suspendContinuousFocus(10000);
  if (this.mozCamera.focusMode !== 'auto') {
    done();
    return;
  }

  //
  // In either focus mode, we call autoFocus() to ensure that the user gets
  // a sharp picture. The difference between the two modes is that if
  // C-AF is on, it is likely that the camera is already focused, so the
  // call to autoFocus() invokes its callback very quickly and we get much
  // better response time.
  //
  // In either case, the callback is passed a boolean specifying whether
  // focus was successful or not, and we display a green or red focus ring
  // then call the done callback, which takes the picture and clears
  // the focus ring.
  //
  this.mozCamera.autoFocus(onFocused);

  // This is fixed focus: there is nothing we can do here so we
  // should just call the callback and take the photo. No focus
  // happens so we don't display a focus ring.
  function onFocused(success) {
    if (success) {
      self.focused = true;
      done();
    } else {
      self.focused = false;
      done('failed');
    }
  }
};

/**
 * Resets focus regions
 */
Focus.prototype.reset = function() {
  if (!this.touchFocus) {
    return;
  }
  this.mozCamera.setFocusAreas([]);
  this.mozCamera.setMeteringAreas([]);
};

Focus.prototype.stop = function() {
  this.stopContinuousFocus();
  this.stopFaceDetection();
};

Focus.prototype.resume = function() {
  this.resumeContinuousFocus();
  this.startFaceDetection();
};

/**
 *  Check if the hardware supports touch to focus
 */
Focus.prototype.isTouchFocusSupported = function() {
  var maxFocusAreas = this.mozCamera.capabilities.maxFocusAreas;
  var maxMeteringAreas = this.mozCamera.capabilities.maxMeteringAreas;
  return maxFocusAreas > 0 && maxMeteringAreas > 0;
};

/**
 * Check if hardware supports face detection
 */
Focus.prototype.isFaceDetectionSupported = function() {
  var cameraDetectsFaces = this.mozCamera.capabilities.maxDetectedFaces > 0;
  var apiAvailable = !!this.mozCamera.startFaceDetection;
  this.maxDetectedFaces = this.mozCamera.capabilities.maxDetectedFaces;
  return cameraDetectsFaces && apiAvailable;
};

Focus.prototype.updateFocusArea = function(rect, done) {
  var previousFlashMode = this.mozCamera.flashMode;
  done = done || function() {};
  var self = this;
  if (!this.touchFocus) {
    done('touchToFocusNotAvailable');
    return;
  }

  this.stopFaceDetection();
  this.mozCamera.setFocusAreas([rect]);
  this.mozCamera.setMeteringAreas([rect]);
  if (this.mozCamera.focusMode === 'continuous-picture') {
    this.mozCamera.resumeContinuousFocus();
  }
  // Disables flash temporarily so it doesn't go off while focusing
  this.mozCamera.flashMode = 'off';
  // Call auto focus to focus on focus area.
  this.focus(focusDone);
  function focusDone(state) {
    self.startFaceDetection();
    self.suspendFaceDetection(2000, 0);
    // Restores previous flash mode
    self.mozCamera.flashMode = previousFlashMode;
    done(state);
  }

};

});
define('lib/camera/camera',['require','exports','module','lib/camera-utils','lib/get-video-meta-data','lib/orientation','debug','lib/debounce','lib/bind-all','vendor/model','lib/mixin','lib/camera/focus'],function(require, exports, module) {


/**
 * Module Dependencies
 */

var CameraUtils = require('lib/camera-utils');
var getVideoMetaData = require('lib/get-video-meta-data');
var orientation = require('lib/orientation');
var debug = require('debug')('camera');
var debounce = require('lib/debounce');
var bindAll = require('lib/bind-all');
var model = require('vendor/model');
var mix = require('lib/mixin');
var Focus = require('lib/camera/focus');

/**
 * Mixin `Model` API (inc. events)
 */

model(Camera.prototype);

/**
 * Exports
 */

module.exports = Camera;

/**
 * Initialize a new 'Camera'
 *
 * Options:
 *
 *   - {object} `focus`
 *
 * @param {Object} options
 */
function Camera(options) {
  debug('initializing');
  bindAll(this);

  // Options
  options = options || {};

  // mozCamera config is cached by default
  this.cacheConfig = options.cacheConfig !== false;

  // Minimum video duration length for creating a
  // video that contains at least few samples, see bug 899864.
  this.minRecordingTime = options.minRecordingTime  || 1000;

  // Number of bytes left on disk to let us stop recording.
  this.recordSpacePadding = options.recordSpacePadding || 1024 * 1024 * 1;

  // The minimum available disk space to start recording a video.
  this.recordSpaceMin = options.recordSpaceMin || 1024 * 1024 * 2;

  // Test hooks
  this.getVideoMetaData = options.getVideoMetaData || getVideoMetaData;
  this.orientation = options.orientation || orientation;
  this.storage = options.storage || localStorage;

  this.cameraList = navigator.mozCameras.getListOfCameras();
  this.mozCamera = null;

  // Video config
  this.video = {
    storage: navigator.getDeviceStorage('videos'),
    filepath: null,
    minSpace: this.recordSpaceMin,
    spacePadding : this.recordSpacePadding
  };

  this.focus = new Focus(options.focus);

  // Indicate this first
  // load hasn't happened yet.
  this.isFirstLoad = true;

  // Always boot in 'picture' mode
  // with 'back' camera. This may need
  // to be configurable at some point.
  this.mode = 'picture';
  this.selectedCamera = 'back';

  // Allow `configure` to be called multiple
  // times in the same frame, but only ever run once.
  this.configure = debounce(this.configure);

  debug('initialized');
}

/**
 * Loads the currently selected camera.
 *
 * There are cases whereby the camera
 * may still be 'releasing' its hardware.
 * If this is the case we wait for the
 * release process to finish, then attempt
 * to load again.
 *
 * @public
 */
Camera.prototype.load = function() {
  debug('load camera');

  // First load is different as we
  // fetch the mozCameraConfig from
  // the previous session and boot
  // with that to optimize startup.
  if (this.isFirstLoad) {
    this.firstLoad();
    return;
  }

  var loadingNewCamera = this.selectedCamera !== this.lastLoadedCamera;
  var self = this;

  // If hardware is still being released
  // we're not allowed to request the camera.
  if (this.releasing) {
    debug('wait for camera release');
    this.once('released', function() { self.load(); });
    return;
  }

  // Don't re-load hardware if selected camera is the same.
  if (this.mozCamera && !loadingNewCamera) {
    this.setupNewCamera(this.mozCamera);
    debug('camera not changed');
    return;
  }

  // If a camera is already loaded,
  // it must be 'released' first.
  // We also discard the `mozCameraConfig`
  // as the previous camera config
  // won't apply to the new camera.
  if (this.mozCamera) {
    this.mozCameraConfig = null;
    this.release(ready);
  } else {
    ready();
  }

  // Once ready we request the camera
  // with the currently `selectedCamera`
  // and any `mozCameraConfig` that may
  // be in memory.
  //
  // The only time there should be a
  // valid `mozCameraConfig` in memory
  // is when the app becomes visible again
  // after being hidden. and we wish to
  // request the camera again in exactly
  // the same state it was previously in.
  function ready() {
    self.requestCamera(self.selectedCamera, self.mozCameraConfig);
    self.lastLoadedCamera = self.selectedCamera;
  }
};

/**
 * When the camera is loaded for the first
 * time run this specially optimized load path.
 *
 * We fetch the a previous camera config from storage
 * and request the camera *with* a configuration.
 *
 * This means that we get back a pre-configured
 * mozCamera and we don't have to run `.configure()`
 * on the critical path. This saves us ~400ms.
 *
 * @private
 */
Camera.prototype.firstLoad = function() {
  debug('first load');

  var config = this.fetchBootConfig() || {};
  var self = this;

  // Save this to memory so that we can re-request
  // the camera quickly after it has been .release()'d.
  this.mozCameraConfig = config.mozCameraConfig;

  // Request the camera, passing in the config.
  // If this is the first time the camera app
  // has been used `mozCameraConfig` will be undefined.
  this.requestCamera(this.selectedCamera, this.mozCameraConfig);

  // Set the pictureSize and recorderProfile
  // as soon as we get the camera hardware.
  // Set the `pictureSize` and `recorderProfile`
  // from the cache so that any subsequent requests
  // to `setPictureSize` and `setRecorderProfile`
  // don't trigger slow hardware configuration.
  this.once('newcamera', function() {
    var noConfigure = { configure: false };
    self.setPictureSize(config.pictureSize, noConfigure);
    self.setRecorderProfile(config.recorderProfile, noConfigure);
  });

  // First load is done.
  this.isFirstLoad = false;
};

/**
 * Save the current camera configuration
 * to persistent storage.
 *
 * This configuration is later used by
 * `.firstLoad()` to optimize the
 * first camera request.
 *
 * We only save the config if the camera
 * is using the 'back' camera in 'picture'
 * mode, as this is the mode we boot
 * the camera in. If partners have issues
 * with this, perhap we can make this
 * configurable.
 *
 * We're using localStorage because it's
 * currently the fastest option.
 *
 * @private
 */
Camera.prototype.saveBootConfig = function() {
  if (!this.cacheConfig) { return; }
  if (this.selectedCamera !== 'back') { return; }
  if (this.mode !== 'picture') { return; }
  // Store the things we need for quickLoad
  var json = {
    mozCameraConfig: this.mozCameraConfig,
    recorderProfile: this.recorderProfile,
    pictureSize: this.pictureSize
  };

  this.storage.setItem('cameraBootConfig', JSON.stringify(json));
  debug('saved camera config', json);
};

/**
 * Fetch the boot config from storage.
 *
 * We use this config to optimize the
 * first load of the camera on the
 * app's critical path.
 *
 * @return {Object}
 */
Camera.prototype.fetchBootConfig = function() {
  var string = this.storage.getItem('cameraBootConfig');
  var json = string && JSON.parse(string);
  debug('got camera config', json);
  return json;
};

/**
 * Requests the mozCamera object,
 * then configures it.
 *
 * @private
 */
Camera.prototype.requestCamera = function(camera, config) {
  debug('request camera', camera, config);
  if (this.isBusy) { return; }
  var self = this;

  // Indicate 'busy'
  this.busy();

  // If a config was passed we assume
  // the camera has been configured.
  this.configured = !!config;

  navigator.mozCameras.getCamera(camera, config || {}, onSuccess, onError);
  debug('camera requested', camera, config);

  function onSuccess(mozCamera) {
    debug('successfully got mozCamera');
    self.setupNewCamera(mozCamera);
    self.configureFocus();
    self.emit('focusconfigured', {
      mode: self.mozCamera.focusMode,
      touchFocus: self.focus.touchFocus,
      faceDetection: self.focus.faceDetection,
      maxDetectedFaces: self.focus.maxDetectedFaces
    });

    // If the camera was configured in the
    // `mozCamera.getCamera()` call, we can
    // fire the 'configured' event now.
    if (self.configured) { self.emit('configured'); }
    self.ready();
  }

  function onError(err) {
    debug('error requesting camera', err);
    self.ready();
  }
};

/**
 * Configures the newly recieved
 * mozCamera object.
 *
 * Setting the 'cababilities' key
 * triggers 'change' callback inside
 * the CameraController that sets the
 * app up for the new camera.
 *
 * @param  {MozCamera} mozCamera
 * @private
 */
Camera.prototype.setupNewCamera = function(mozCamera) {
  debug('configuring camera');
  var capabilities = mozCamera.capabilities;
  this.mozCamera = mozCamera;

  // Bind to some events
  this.mozCamera.onShutter = this.onShutter;
  this.mozCamera.onPreviewStateChange = this.onPreviewStateChange;
  this.mozCamera.onRecorderStateChange = this.onRecorderStateChange;

  this.capabilities = this.formatCapabilities(capabilities);

  this.emit('newcamera', this.capabilities);
  debug('configured new camera');
};

/**
 * Camera capablities need to be in
 * a consistent format.
 *
 * We shallow clone to make sure the
 * app doesnt' make changes to the
 * original `capabilities` object.
 *
 * @param  {Object} capabilities
 * @return {Object}
 */
Camera.prototype.formatCapabilities = function(capabilities) {
  var hasHDR = capabilities.sceneModes.indexOf('hdr') > -1;
  var hdr = hasHDR ? ['on', 'off'] : undefined;
  return mix({ hdr: hdr }, capabilities);
};

/**
 * Configure the camera hardware
 * with the current `mode`, `previewSize`
 * and `recorderProfile`.
 *
 * @private
 */
Camera.prototype.configure = function() {
  debug('configuring hardware...');
  var self = this;

  // As soon as a request to configure
  // comes in, the confuguration is now
  // dirty (out-of-date), and the hardware
  // must be reconfigured at some point.
  this.configured = false;

  // Ensure that any requests that
  // come in whilst busy get run once
  // camera is ready again.
  if (this.isBusy) {
    debug('defering configuration');
    this.once('ready', this.configure);
    return;
  }

  // Exit here if there is no camera
  if (!this.mozCamera) {
    debug('no mozCamera');
    return;
  }

  // Indicate 'busy'
  this.busy();

  // Create a new `mozCameraConfig`
  this.mozCameraConfig = {
    mode: this.mode,
    previewSize: this.previewSize(),
    recorderProfile: this.recorderProfile
  };

  // Configure the camera hardware
  this.mozCamera.setConfiguration(this.mozCameraConfig, onSuccess, onError);
  debug('mozCamera configuring', this.mozCameraConfig);

  function onSuccess() {
    debug('configuration success');
    if (!self.mozCamera) { return; }
    self.configureFocus();
    self.resumeFocus();
    self.configured = true;
    self.saveBootConfig();
    self.emit('configured');
    self.ready();
  }

  function onError() {
    console.log('Error configuring camera');
    self.configured = true;
    self.ready();
  }
};

Camera.prototype.configureFocus = function() {
  var focusMode;
  // Determines focus mode based on camera mode
  // If we're taking still pictures, and C-AF is enabled
  if (this.mode === 'picture') {
    focusMode = 'continuous-picture';
  } else if (this.mode === 'video'){
    focusMode = 'continuous-video';
  }
  this.focus.configure(this.mozCamera, focusMode);
  this.focus.onFacesDetected = this.onFacesDetected;
  this.focus.onAutoFocusChanged = this.onAutoFocusChanged;
};

Camera.prototype.onAutoFocusChanged = function() {
  this.set('focus', 'autofocus');
};

Camera.prototype.onFacesDetected = function(faces) {
  this.emit('facesdetected', faces);
};

/**
 * Plugs Video Stream into Video Element.
 *
 * @param  {Elmement} videoElement
 * @public
 */
Camera.prototype.loadStreamInto = function(videoElement) {
  debug('loading stream into element');
  if (!this.mozCamera) {
    debug('error - `mozCamera` is undefined or null');
    return;
  }

  // REVIEW: Something is wrong if we are
  // calling this without a video element.
  if (!videoElement) {
    debug('error - `videoElement` is undefined or null');
    return;
  }

  // Don't load the same camera stream again
  var isCurrent = videoElement.mozSrcObject === this.mozCamera;
  if (isCurrent) { return debug('camera didn\'t change'); }

  videoElement.mozSrcObject = this.mozCamera;
  videoElement.play();
  debug('stream loaded into video');
};

/**
 * Return available preview sizes.
 *
 * @return {Array}
 * @private
 */
Camera.prototype.previewSizes = function() {
  if (!this.mozCamera) { return; }
  return this.mozCamera.capabilities.previewSizes;
};

/**
 * Return the current optimal preview size.
 *
 * @return {Object}
 * @private
 */
Camera.prototype.previewSize = function() {
  var sizes = this.previewSizes();
  var profile = this.resolution();
  var size = CameraUtils.getOptimalPreviewSize(sizes, profile);
  debug('get optimal previewSize', size);
  return size;
};

/**
 * Get the current recording resolution.
 *
 * @return {Object}
 */
Camera.prototype.resolution = function() {
  switch (this.mode) {
    case 'picture': return this.pictureSize;
    case 'video': return this.getRecorderProfile().video;
  }
};

/**
 * Set the picture size.
 *
 * If the given size is the same as the
 * currently set pictureSize then no
 * action is taken.
 *
 * The camera is 'configured' a soon as the
 * pictureSize is changed. `.configure` is
 * debounced so it will only ever run once
 * per turn.
 *
 * Options:
 *
 *   - {Boolean} `configure`
 *
 * @param {Object} size
 */
Camera.prototype.setPictureSize = function(size, options) {
  debug('set picture size', size);
  if (!size) { return; }

  // Configure unless `false`
  var configure = !(options && options.configure === false);

  // Don't do waste time re-configuring the
  // hardware if the pictureSize hasn't changed.
  if (this.pictureSize) {
    var sameWidth = size.width === this.pictureSize.width;
    var sameHeight = size.height === this.pictureSize.height;
    if (sameWidth && sameHeight) {
      debug('pictureSize didn\'t change');
      return;
    }
  }

  this.mozCamera.setPictureSize(size);
  this.pictureSize = size;
  this.setThumbnailSize();

  // Configure the hardware only when required
  if (configure) { this.configure(); }

  debug('pictureSize changed');
  return this;
};

/**
 * Set the recorder profile.
 *
 * If the given profile is the same as
 * the current profile, no action is
 * taken.
 *
 * The camera is 'configured' a soon as the
 * recorderProfile is changed (`.configure()` is
 * debounced so it will only ever run once
 * per turn).
 *
 * Options:
 *
 *   - {Boolean} `configure`
 *
 * @param {String} key
 */
Camera.prototype.setRecorderProfile = function(key, options) {
  debug('set recorderProfile: %s', key);
  if (!key) { return; }

  // Configure unless `false`
  var configure = !(options && options.configure === false);

  // Exit if not changed
  if (this.recorderProfile === key) {
    debug('recorderProfile didn\'t change');
    return;
  }

  this.recorderProfile = key;
  if (configure) { this.configure(); }

  debug('recorderProfile changed: %s', key);
  return this;
};

/**
 * Returns the full profile of the
 * currently set recordrProfile.
 *
 * @return {Object}
 */
Camera.prototype.getRecorderProfile = function() {
  var key = this.recorderProfile;
  return this.mozCamera.capabilities.recorderProfiles[key];
};

Camera.prototype.setThumbnailSize = function() {
  var sizes = this.mozCamera.capabilities.thumbnailSizes;
  var pictureSize = this.mozCamera.getPictureSize();
  var picked = this.pickThumbnailSize(sizes, pictureSize);
  if (picked) { this.mozCamera.setThumbnailSize(picked); }
};

/**
 * Sets the current flash mode,
 * both on the Camera instance
 * and on the cameraObj hardware.
 *
 * @param {String} key
 */
Camera.prototype.setFlashMode = function(key) {
  if (this.mozCamera) {
    // If no key was provided, set it to 'off' which is
    // a valid flash mode.
    key = key || 'off';

    this.mozCamera.flashMode = key;
    debug('flash mode set: %s', key);
  }

  return this;
};

/**
 * Releases the camera hardware.
 *
 * @param  {Function} done
 */
Camera.prototype.release = function(done) {
  debug('release');
  done = done || function() {};
  var self = this;

  // Ignore if there is no loaded camera
  if (!this.mozCamera) {
    done();
    return;
  }

  this.busy();
  this.stopRecording();
  this.focus.stopFaceDetection();
  this.set('focus', 'none');
  this.mozCamera.release(onSuccess, onError);
  this.releasing = true;
  this.mozCamera = null;

  function onSuccess() {
    debug('successfully released');
    self.releasing = false;
    self.ready();
    self.emit('released');
    done();
  }

  function onError(err) {
    debug('failed to release hardware');
    self.releasing = false;
    self.ready();
    done(err);
  }
};

// TODO: Perhaps this function should be moved into a separate lib
Camera.prototype.pickThumbnailSize = function(thumbnailSizes, pictureSize) {
  var screenWidth = window.innerWidth * window.devicePixelRatio;
  var screenHeight = window.innerHeight * window.devicePixelRatio;
  var pictureAspectRatio = pictureSize.width / pictureSize.height;
  var currentThumbnailSize;
  var i;

  // Coping the array to not modify the original
  thumbnailSizes = thumbnailSizes.slice(0);
  if (!thumbnailSizes || !pictureSize) {
    return;
  }

  function imageSizeFillsScreen(pixelsWidth, pixelsHeight) {
    return ((pixelsWidth >= screenWidth || // portrait
             pixelsHeight >= screenHeight) &&
            (pixelsWidth >= screenHeight || // landscape
             pixelsHeight >= screenWidth));
  }

  // Removes the sizes with the wrong aspect ratio
  thumbnailSizes = thumbnailSizes.filter(function(thumbnailSize) {
    var thumbnailAspectRatio = thumbnailSize.width / thumbnailSize.height;
    return Math.abs(thumbnailAspectRatio - pictureAspectRatio) < 0.05;
  });

  if (thumbnailSizes.length === 0) {
    console.error('Error while selecting thumbnail size. ' +
      'There are no thumbnail sizes that match the ratio of ' +
      'the selected picture size: ' + JSON.stringify(pictureSize));
    return;
  }

  // Sorting the array from smaller to larger sizes
  thumbnailSizes.sort(function(a, b) {
    return a.width * a.height - b.width * b.height;
  });

  for (i = 0; i < thumbnailSizes.length; ++i) {
    currentThumbnailSize = thumbnailSizes[i];
    if (imageSizeFillsScreen(currentThumbnailSize.width,
                             currentThumbnailSize.height)) {
      return currentThumbnailSize;
    }
  }

  return thumbnailSizes[thumbnailSizes.length - 1];
};

/**
 * Takes a photo, or begins/ends
 * a video capture session.
 *
 * Options:
 *
 *   - `position` {Object} - geolocation to store in EXIF
 *
 * @param  {Object} options
 *  public
 */
Camera.prototype.capture = function(options) {
  switch (this.mode) {
    case 'picture': this.takePicture(options); break;
    case 'video': this.toggleRecording(options); break;
  }
};

/**
 * Take a picture.
 *
 * Options:
 *
 *   - {Number} `position` - geolocation to store in EXIF
 *
 * @param  {Object} options
 */
Camera.prototype.takePicture = function(options) {
  debug('take picture');
  this.busy();

  var rotation = orientation.get();
  var selectedCamera = this.selectedCamera;
  var self = this;
  var position = options && options.position;
  var config = {
    rotation: rotation,
    dateTime: Date.now() / 1000,
    pictureSize: self.pictureSize,
    fileFormat: 'jpeg'
  };

  // If position has been passed in,
  // add it to the config object.
  if (position) {
    config.position = position;
  }

  // Front camera is inverted, so flip rotation
  rotation = selectedCamera === 'front' ? -rotation : rotation;

  // If the camera focus is 'continuous' or 'infinity'
  // we can take the picture straight away.
  if (this.focus.getMode() === 'auto') {
    this.set('focus', 'focusing');
    this.focus.focus(onFocused);
  } else {
    takePicture();
  }

  function onFocused(err) {
    var focus = err ? 'fail' : 'focused';
    self.set('focus', focus);
    takePicture();
  }

  function takePicture() {
    self.emit('takingpicture');
    self.mozCamera.takePicture(config, onSuccess, onError);
  }

  function onError(error) {
    var title = navigator.mozL10n.get('error-saving-title');
    var text = navigator.mozL10n.get('error-saving-text');

    // if taking a picture fails because there's
    // already a picture being taken we ignore it.
    if (error === 'TakePictureAlreadyInProgress') {
      complete();
    } else {
      alert(title + '. ' + text);
      debug('error taking picture');
      complete();
    }
  }

  function onSuccess(blob) {
    var image = { blob: blob };
    self.resumePreview();
    self.set('focus', 'none');
    self.emit('newimage', image);
    debug('success taking picture');
    complete();
  }

  function complete() {
    // If we are in C-AF mode, we have
    // to call resume() in order to get
    // the camera to resume focusing
    // on what we point it at.
    self.resumeFocus();
    self.set('focus', 'none');
    self.ready();
  }
};

Camera.prototype.updateFocusArea = function(rect, done) {
  var self = this;
  this.set('focus', 'focusing');
  this.focus.updateFocusArea(rect, focusDone);
  function focusDone(error) {
    if (error) {
      self.set('focus', 'fail');
    } else {
      self.set('focus', 'focused');
    }
    if (done) {
      done(error);
    }
  }
};

Camera.prototype.stopFocus = function() {
  this.focus.stop();
};

Camera.prototype.resumeFocus = function() {
  this.focus.resume();
};

/**
 * Start/stop recording.
 *
 * @param  {Object} options
 */
Camera.prototype.toggleRecording = function(options) {
  var recording = this.get('recording');
  if (recording) { this.stopRecording(); }
  else { this.startRecording(options); }
};

/**
 * Start recording a video.
 *
 * @public
 */
Camera.prototype.startRecording = function(options) {
  debug('start recording');
  var frontCamera = this.selectedCamera === 'front';
  var rotation = this.orientation.get();
  var storage = this.video.storage;
  var video = this.video;
  var self = this;

  // Rotation is flipped for front camera
  if (frontCamera) { rotation = -rotation; }

  this.busy();

  // Lock orientation during video recording
  //
  // REVIEW: This should *not* be here. This
  // is an App concern and should live in
  // the `CameraController`.
  this.orientation.stop();

  // First check if there is enough free space
  this.getFreeVideoStorageSpace(gotStorageSpace);

  function gotStorageSpace(err, freeBytes) {
    if (err) { return self.onRecordingError(); }

    var notEnoughSpace = freeBytes < self.video.minSpace;
    var remaining = freeBytes - self.video.spacePadding;
    var targetFileSize = self.get('maxFileSizeBytes');
    var maxFileSizeBytes = targetFileSize || remaining;

    // Don't continue if there
    // is not enough space
    if (notEnoughSpace) {
      self.onRecordingError('nospace2');
      return;
    }

    // TODO: Callee should
    // pass in orientation
    var config = {
      rotation: rotation,
      maxFileSizeBytes: maxFileSizeBytes
    };

    self.createVideoFilepath(function(filepath) {
      video.filepath = filepath;
      self.emit('willrecord');
      self.mozCamera.startRecording(
        config,
        storage,
        filepath,
        onSuccess,
        self.onRecordingError);
    });
  }

  function onSuccess() {
    self.set('recording', true);
    self.startVideoTimer();
    self.ready();

    // User closed app while
    // recording was trying to start
    //
    // TODO: Not sure this should be here
    if (document.hidden) {
      self.stopRecording();
    }
  }
};

/**
 * Stop recording the video.
 *
 * Once we have told the camera to stop recording
 * the video we attach a 'change' listener to the
 * video storage and wait. Once the listener fires
 * we know that the video file has been saved.
 *
 * At this point we fetch the file Blob from
 * storage and then call the `.onNewVideo()`
 * method to handle the final stages.
 *
 * @public
 */
Camera.prototype.stopRecording = function() {
  debug('stop recording');

  var notRecording = !this.get('recording');
  var filepath = this.video.filepath;
  var storage = this.video.storage;
  var self = this;

  if (notRecording) { return; }

  this.busy();
  this.stopVideoTimer();
  this.mozCamera.stopRecording();
  this.set('recording', false);

  // Unlock orientation when stopping video recording.
  // REVIEW:WP This logic is out of scope of the
  // Camera hardware. Only the App should be
  // making such high level decicions.
  this.orientation.start();

  // Register a listener for writing
  // completion of current video file
  storage.addEventListener('change', onStorageChange);

  function onStorageChange(e) {
    debug('video file ready', e.path);
    var matchesFile = e.path.indexOf(filepath) > -1;

    // Regard the modification as video file writing
    // completion if e.path matches current video
    // filename. Note e.path is absolute path.
    if (e.reason !== 'modified' || !matchesFile) { return; }

    // We don't need the listener anymore.
    storage.removeEventListener('change', onStorageChange);

    // Re-fetch the blob from storage
    var req = storage.get(filepath);
    req.onerror = self.onRecordingError;
    req.onsuccess = onSuccess;

    function onSuccess() {
      debug('got video blob');
      self.onNewVideo({
        blob: req.result,
        filepath: filepath
      });
    }
  }
};

/**
 * Once we have got the new video blob
 * from storage we assemble the video
 * object and then get video meta data
 * to add to it.
 *
 * If the video was too short, we delete
 * it from storage and abort to prevent
 * the app from ever knowing a new
 * (potentially corrupted) video file
 * was recorded.
 *
 * @param  {Object} video
 * @private
 */
Camera.prototype.onNewVideo = function(video) {
  debug('got new video', video);

  var elapsedTime = this.get('videoElapsed');
  var tooShort = elapsedTime < this.minRecordingTime;
  var self = this;

  // Discard videos that are too
  // short and possibly corrupted.
  if (tooShort) {
    debug('video too short, deleting...');
    this.video.storage.delete(video.filepath);
    this.ready();
    return;
  }

  // Finally extract some metadata before
  // telling the app the new video is ready.
  this.getVideoMetaData(video.blob, gotVideoMetaData);

  function gotVideoMetaData(error, data) {
    if (error) {
      self.onRecordingError();
      return;
    }

    // Bolt on additional metadata
    video.poster = data.poster;
    video.width = data.width;
    video.height = data.height;
    video.rotation = data.rotation;

    // Tell the app the new video is ready
    self.emit('newvideo', video);
    self.ready();
  }
};

// TODO: This is UI stuff, so
// shouldn't be handled in this file.
Camera.prototype.onRecordingError = function(id) {
  id = id && id !== 'FAILURE' ? id : 'error-recording';
  var title = navigator.mozL10n.get(id + '-title');
  var text = navigator.mozL10n.get(id + '-text');
  alert(title + '. ' + text);
  this.ready();
};

/**
 * Emit a 'shutter' event so that
 * app UI can respond with shutter
 * animations and sounds effects.
 *
 * @private
 */
Camera.prototype.onShutter = function() {
  this.emit('shutter');
};

/**
 * The preview state change events come
 * from the camera hardware. If 'stopped'
 * or 'paused' the camera must not be used.
 *
 * @param  {String} state
 * @private
 */
Camera.prototype.onPreviewStateChange = function(state) {
  debug('preview state change: %s', state);
  var busy = state === 'stopped' || state === 'paused';
  if (busy) { this.busy(); }
  else { this.ready(); }
};

/**
 * Emit useful event hook.
 *
 * @param  {String} msg
 * @private
 */
Camera.prototype.onRecorderStateChange = function(msg) {
  if (msg === 'FileSizeLimitReached') {
    this.emit('filesizelimitreached');
  }
};

/**
 * Get the number of remaining
 * bytes in video storage.
 *
 * @param  {Function} done
 * @async
 * @private
 */
Camera.prototype.getFreeVideoStorageSpace = function(done) {
  debug('get free storage space');

  var storage = this.video.storage;
  var req = storage.freeSpace();
  req.onerror = onError;
  req.onsuccess = onSuccess;

  function onSuccess() {
    var freeBytes = req.result;
    debug('%d free space found', freeBytes);
    done(null, freeBytes);
  }

  function onError() {
    done('error');
  }
};

/**
 * Get a unique video filepath
 * to record a new video to.
 *
 * Your application can overwrite
 * this method with something
 * so that you can record directly
 * to final location. We do this
 * in CameraController.
 *
 * Callback function signature used
 * so that an async override can
 * be used if you wish.
 *
 * @param  {Function} done
 */
Camera.prototype.createVideoFilepath = function(done) {
  done(Date.now() + '_tmp.3gp');
};

/**
 * Resume the preview stream.
 *
 * After a photo has been taken the
 * preview stream freezes on the
 * taken frame. We call this function
 * to start the stream flowing again.
 *
 * @private
 */
Camera.prototype.resumePreview = function() {
  this.mozCamera.resumePreview();
  this.emit('previewresumed');
};

/**
 * Sets the selected camera to the
 * given string and then reloads
 * the camera.
 *
 * If the given camera is already
 * selected, no action is taken.
 *
 * @param {String} camera 'front'|'back'
 * @public
 */
Camera.prototype.setCamera = function(camera) {
  debug('set camera: %s', camera);
  if (this.selectedCamera === camera) { return; }
  this.selectedCamera = camera;
  this.load();
};

/**
 * Toggles between 'picture'
 * and 'video' capture modes.
 *
 * @return {String}
 * @public
 */
Camera.prototype.setMode = function(mode) {
  debug('setting mode to: %s', mode);
  if (this.mode === mode) { return; }
  this.mode = mode;
  this.configure();
  return this;
};

/**
 * Sets a start time and begins
 * updating the elapsed time
 * every second.
 *
 * @private
 */
Camera.prototype.startVideoTimer = function() {
  this.set('videoStart', new Date().getTime());
  this.videoTimer = setInterval(this.updateVideoElapsed, 1000);
  this.updateVideoElapsed();
};

/**
 * Clear the video timer interval.
 *
 * @private
 */
Camera.prototype.stopVideoTimer = function() {
  clearInterval(this.videoTimer);
  this.videoTimer = null;
};

/**
 * Calculates the elapse time
 * and updateds the 'videoElapsed'
 * value.
 *
 * We listen for the 'change:'
 * event emitted elsewhere to
 * update the UI accordingly.
 *
 */
Camera.prototype.updateVideoElapsed = function() {
  var now = new Date().getTime();
  var start = this.get('videoStart');
  this.set('videoElapsed', (now - start));
};

/**
 * Set ISO value.
 *
 * @param {String} value
 * @public
 */
Camera.prototype.setISOMode = function(value) {
  var isoModes = this.mozCamera.capabilities.isoModes;
  if (isoModes && isoModes.indexOf(value) > -1) {
    this.mozCamera.isoMode = value;
  }
};

/**
 * Set the mozCamera white-balance value.
 *
 * @param {String} value
 * @public
 */
Camera.prototype.setWhiteBalance = function(value){
  var capabilities = this.mozCamera.capabilities;
  var modes = capabilities.whiteBalanceModes;
  if (modes && modes.indexOf(value) > -1) {
    this.mozCamera.whiteBalanceMode = value;
  }
};

/**
 * Set HDR mode.
 *
 * HDR is a scene mode, so we
 * transform the hdr value to
 * the appropriate scene value.
 *
 * @param {String} value
 * @public
 */
Camera.prototype.setHDR = function(value){
  debug('set hdr: %s', value);
  if (!value) { return; }
  var scene = value === 'on' ? 'hdr' : 'auto';
  this.setSceneMode(scene);
};

/**
 * Set scene mode.
 *
 * @param {String} value
 * @public
 */
Camera.prototype.setSceneMode = function(value){
  var modes = this.mozCamera.capabilities.sceneModes;
  if (modes.indexOf(value) > -1) {
    this.mozCamera.sceneMode = value;
  }
};

/**
 * Check if the hardware supports zoom.
 *
 * @return {Boolean}
 */
Camera.prototype.isZoomSupported = function() {
  return this.mozCamera.capabilities.zoomRatios.length > 1;
};

Camera.prototype.configureZoom = function() {
  var previewSize = this.previewSize();
  var maxPreviewSize =
    CameraUtils.getMaximumPreviewSize(this.previewSizes());

  // Calculate the maximum amount of zoom that the hardware will
  // perform. This calculation is determined by taking the maximum
  // supported preview size *width* and dividing by the current preview
  // size *width*.
  var maxHardwareZoom = maxPreviewSize.width / previewSize.width;
  this.set('maxHardwareZoom', maxHardwareZoom);

  this.setZoom(this.getMinimumZoom());
  this.emit('zoomconfigured');
  return this;
};

Camera.prototype.getMinimumZoom = function() {
  var zoomRatios = this.mozCamera.capabilities.zoomRatios;
  if (zoomRatios.length === 0) {
    return 1.0;
  }

  return zoomRatios[0];
};

Camera.prototype.getMaximumZoom = function() {
  var zoomRatios = this.mozCamera.capabilities.zoomRatios;
  if (zoomRatios.length === 0) {
    return 1.0;
  }

  return zoomRatios[zoomRatios.length - 1];
};

Camera.prototype.getZoom = function() {
  return this.mozCamera.zoom;
};

Camera.prototype.setZoom = function(zoom) {
  this.mozCamera.zoom = zoom;
  this.emit('zoomchanged', zoom);
};

Camera.prototype.getZoomPreviewAdjustment = function() {
  var zoom = this.mozCamera.zoom;
  var maxHardwareZoom = this.get('maxHardwareZoom');
  if (zoom <= maxHardwareZoom) {
    return 1.0;
  }

  return zoom / maxHardwareZoom;
};

/**
 * Retrieves the angle of orientation of the camera hardware's
 * image sensor. This value is calculated as the angle that the
 * camera image needs to be rotated (clockwise) so that it appears
 * correctly on the display in the device's natural (portrait)
 * orientation
 *
 * Reference:
 * http://developer.android.com/reference/android/hardware/Camera.CameraInfo.html#orientation
 *
 * @return {Number}
 * @public
 */
Camera.prototype.getSensorAngle = function() {
  return this.mozCamera && this.mozCamera.sensorAngle;
};

/**
 * A central place to indicate
 * the camera is 'busy'.
 *
 * @private
 */
Camera.prototype.busy = function() {
  debug('busy');
  this.isBusy = true;
  this.emit('busy');
};

/**
 * A central place to indicate
 * the camera is 'ready'.
 *
 * @private
 */
Camera.prototype.ready = function() {
  debug('ready');
  this.isBusy = false;
  this.emit('ready');
};

});



(function(window) {

  function dispatch(name) {
    if (!window.mozPerfHasListener) {
      return;
    }

    var now = window.performance.now();

    setTimeout(function() {
      var detail = {
        name: name,
        timestamp: now
      };
      var event = new CustomEvent('x-moz-perf', { detail: detail });

      window.dispatchEvent(event);
    });
  }

  [
    'moz-chrome-dom-loaded',
    'moz-chrome-interactive',
    'moz-app-visually-complete',
    'moz-content-interactive',
    'moz-app-loaded'
  ].forEach(function(eventName) {
      window.addEventListener(eventName, function mozPerfLoadHandler() {
        dispatch(eventName);
      }, false);
    });

  window.PerformanceTestingHelper = {
    dispatch: dispatch
  };

})(window);

define("performance-testing-helper", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.PerformanceTestingHelper;
    };
}(this)));

define('vendor/view',['require','exports','module','lib/bind-all','vendor/evt','lib/mixin'],function(require, exports, module) {
  

  /**
   * Dependencies
   */

  var bindAll = require('lib/bind-all');
  var events = require('vendor/evt');
  var mixin = require('lib/mixin');

  /**
   * Locals
   */

  var counter = 1;
  var noop = function() {};

  /**
   * Exports
   */

  module.exports = View;

  /**
   * Base view class. Accepts
   * or creates a root element
   * which we template into.
   *
   * @constructor
   */
  function View(options) {
    options = options || {};
    this.el = options.el || this.el || document.createElement(this.tag);
    this.el.id = this.el.id || ('view' + counter++);
    this.name = options.name || this.name;
    this.els = {};

    if (!this.el.className) {
      if (this.name) this.el.className = this.name;
      if (this.className) this.el.className += ' ' + this.className;
    }

    bindAll(this);
    this.initialize.apply(this, arguments);
  }

  /**
   * Base view prototype,
   * mixed in event emitter.
   *
   * @type {Object}
   */
  events(View.prototype);

  // Allow for 'emit' or
  // 'fire' to trigger events
  View.prototype.fire = View.prototype.fire || View.prototype.emit;

  /**
   * Default tagName
   *
   * @type {String}
   */
  View.prototype.tag = 'div';
  View.prototype.name = 'noname';

  /**
   * Appends the root element
   * to the given parent.
   *
   * @param  {Element} parent
   * @return {View}
   */
  View.prototype.appendTo = function(parent) {
    if (!parent) return this;
    parent.appendChild(this.el);
    this.fire('inserted');
    return this;
  };

  /**
   * Prepends the root element
   * to the given parent.
   *
   * @param  {Element} parent
   * @return {View}
   */
  View.prototype.prependTo = function(parent) {
    if (!parent) return this;
    var first = parent.firstChild;

    if (first) parent.insertBefore(this.el, first);
    else this.appendTo(parent);

    this.fire('inserted');
    return this;
  };

  /**
   * Convenient shorthand
   * querySelector.
   *
   * @param  {String} query
   * @return { Element | null}
   */
  View.prototype.find = function(query) {
    return this.el.querySelector(query);
  };

  /**
   * Removes the element from
   * its current DOM location.
   *
   * @param  {Object} options
   * @return {View}
   */
  View.prototype.remove = function(options) {
    var silent = options && options.silent;
    var parent = this.el.parentNode;
    if (!parent) return this;
    parent.removeChild(this.el);
    if (!silent) this.fire('remove');
    return this;
  };

  View.prototype.set = function(key, value) {
    value = value === undefined ? '' : value;
    this.el.setAttribute(toDashed(key), value);
  };

  View.prototype.get = function(key) {
    return this.el.getAttribute(key);
  };

  /**
   * Returns a function that when called
   * will .set() the given key.
   *
   * If a value is passed to .setter(),
   * that value will always be used
   * when the returned function is called.
   * Else the value passed to the given
   * function will be used.
   *
   * Example:
   *
   * var setter = this.setter('key', 'value');
   * setter(); //=> this.set('key', 'value');
   * setter('value2'); //=> this.set('key', 'value');
   *
   * var setter = this.setter('key');
   * setter('value'); //=> this.set('key', 'value');
   * setter(); //=> this.set('key');
   *
   * @param  {String} key
   * @param  {*} value
   * @return {Function}
   */
  View.prototype.setter = function(key, forced) {
    var self = this;
    return function(passed) {
      var value = forced !== undefined ? forced : passed;
      self.set(key, value);
    };
  };

  View.prototype.enable = function(key, value) {
    switch(arguments.length) {
      case 0:
        value = true;
        key = 'enabled';
        break;
      case 1:
        if (typeof key === 'boolean') {
          value = key;
          key = 'enabled';
        } else {
          value = true;
          key = key ? key + '-enabled' : 'enabled';
        }
        break;
      default:
        key = key ? key + '-enabled' : 'enabled';
    }
    this.set(key, !!value);
  };

  View.prototype.disable = function(key) {
    this.enable(key, false);
  };

  View.prototype.enabler = function(key) {
    return (function(value) { this.enable(key, value); }).bind(this);
  };

  View.prototype.hide = function(key) {
    this.toggle(key, false);
  };

  View.prototype.show =  function(key) {
    this.toggle(key, true);
  };

  View.prototype.toggle = function(key, value) {
    if (arguments.length === 1 && typeof key === 'boolean') {
      value = key;
      key = '';
    } else {
      key = key ? key + '-' : '';
    }

    this.el.classList.toggle(key + 'hidden', !value);
    this.el.classList.toggle(key + 'visible', value);
  };

  /**
   * Removes the element from
   * it's current context, firing
   * a 'destroy' event to allow
   * views to perform cleanup.
   *
   * Then clears any internal
   * references to aid GC.
   *
   * @return {[type]} [description]
   */
  View.prototype.destroy = function(options) {
    var noRemove = options && options.noRemove;
    if (!noRemove) this.remove();
    this.fire('destroy');
    this.el = null;
  };

  View.prototype.toString = function() {
    return '[object View]';
  };

  // Overwrite as required
  View.prototype.initialize = noop;
  View.prototype.template = function() { return ''; };

  /**
   * Extends the base view
   * class with the given
   * properties.
   *
   * TODO: Pull this out to
   * standalone module.
   *
   * @param  {Object} properties
   * @return {Function}
   */
  View.extend = function(props) {
    var Parent = this;

    // The extended constructor
    // calls the parent constructor
    var Child = function() {
      Parent.apply(this, arguments);
    };

    Child.prototype = Object.create(Parent.prototype);
    Child.extend = View.extend;
    mixin(Child.prototype, props);

    return Child;
  };

  function toDashed(s) {
    return s.replace(/\W+/g, '-')
      .replace(/([a-z\d])([A-Z])/g, '$1-$2')
      .toLowerCase();
  }
});

define('views/notification',['require','exports','module','vendor/view','lib/mixin'],function(require, exports, module) {


/**
* Dependencies
*/

var View = require('vendor/view');
var mix = require('lib/mixin');

/**
 * Exports
 */

module.exports = View.extend({
  name:'notification',
  tag: 'ul',
  time: 3000,

  initialize: function() {
    this.counter = 0;
    this.hash = {};
  },

  /**
   * Display a new notification.
   *
   * Options:
   *
   *   - `text {String}`
   *   - `className {String}`
   *   - `persistent {Boolean}`
   *
   * @param  {Object} options
   * @return {Number} id for clearing
   * @public
   */
  display: function(options) {
    var item = mix({}, options);
    var id = ++this.counter;
    var self = this;

    item.el = document.createElement('li');
    item.el.className = options.className || '';
    item.el.innerHTML = '<span>' + options.text + '</span>';
    this.el.appendChild(item.el);

    // Remove last temporary
    // notification in the way
    this.clear(this.temporary);

    // Remove non-persistent
    // messages after 3s
    if (!item.persistent) {
      this.temporary = id;
      this.hide(this.persistent);
      item.clearTimeout = setTimeout(function() {
        self.clear(id);
      }, this.time);
    }

    // Remove previous persistent
    if (item.persistent) {
      this.clear(this.persistent);
      this.persistent = id;
    }

    // Store and return
    this.hash[id] = item;
    return id;
  },

  /**
   * Clear notfication by id.
   *
   * Remove the notification from the DOM,
   * clear any existing `clearTimeout` that
   * may have been installed on creation.
   *
   * @param  {Number} item
   * @public
   */
  clear: function(id) {
    var item = this.hash[id];
    if (!item || item.cleared) { return; }

    this.el.removeChild(item.el);
    clearTimeout(item.clearTimeout);
    item.cleared = true;

    // Clear references
    if (item === this.temporary) { this.temporary = null; }
    if (item === this.persistent) { this.persistent = null; }
    delete this.hash[id];

    // Show persistent notification
    // (if there still is one)
    this.show(this.persistent);
  },

  /**
   * Hide a notification.
   *
   * @param  {Number} id
   * @private
   */
  hide: function(id) {
    var item = this.hash[id];
    if (!item) { return; }
    item.el.classList.add('hidden');
  },

  /**
   * Show a hidden notification.
   *
   * @param  {Number} id
   * @private
   */
  show: function(id) {
    var item = this.hash[id];
    if (!item) { return; }
    item.el.classList.remove('hidden');
  }
});

});
define('views/loading-screen',['require','exports','module','vendor/view'],function(require, exports, module) {


var View = require('vendor/view');

module.exports = View.extend({
  name: 'loading-screen',
  fadeTime: 300,

  initialize: function() {
    this.el.innerHTML = this.template;
  },

  show: function(done) {
    this.reflow = this.el.offsetTop;
    View.prototype.show.call(this);
  },

  hide: function(done) {
    View.prototype.hide.call(this);
    if (done) { setTimeout(done, this.fadeTime); }
  },

  template: '<progress></progress>'
});

});
define('lib/bind',['require','exports','module'],function(require, exports, module) {


/**
 * Exports
 */

exports = module.exports = bind;

/**
 * addEventListener shorthand.
 * @param  {Element}   el
 * @param  {String}   name
 * @param  {Function} fn
 */
function bind(el, name, fn, capture) {
  el.addEventListener(name, fn, capture || false);
}

/**
 * removeEventListener shorthand.
 * @param  {Element}   el
 * @param  {String}   name
 * @param  {Function} fn
 */
exports.unbind = function(el, name, fn, capture) {
  el.removeEventListener(name, fn, capture || false);
};

});

define('views/viewfinder',['require','exports','module','lib/bind','lib/camera-utils','debug','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var bind = require('lib/bind');
var CameraUtils = require('lib/camera-utils');
var debug = require('debug')('view:viewfinder');
var View = require('vendor/view');

/**
 * Locals
 */

var isZoomEnabled = false;
var scaleSizeTo = {
  fill: CameraUtils.scaleSizeToFillViewport,
  fit: CameraUtils.scaleSizeToFitViewport
};

var clamp = function(value, minimum, maximum) {
  return Math.min(Math.max(value, minimum), maximum);
};

module.exports = View.extend({
  name: 'viewfinder',
  className: 'js-viewfinder',
  fadeTime: 200,

  initialize: function() {
    this.render();

    bind(this.el, 'click', this.onClick);
    bind(this.el, 'animationend', this.onShutterEnd);

    this.getSize();
  },

  render: function() {
    this.el.innerHTML = this.template();
    // Find elements
    this.els.frame = this.find('.js-frame');
    this.els.video = this.find('.js-video');
    this.els.videoContainer = this.find('.js-video-container');
  },

  /**
   * Stores the container size.
   *
   * We're using window dimensions
   * here to avoid causing costly
   * reflows.
   *
   * @public
   */
  getSize: function() {
    this.width = window.innerWidth;
    this.height = window.innerHeight;
    return {
      width: this.width,
      height: this.height
    };
  },

  onClick: function(e) {
    this.emit('click', e);
  },

  enableZoom: function(minimumZoom, maximumZoom) {
    if (minimumZoom) {
      this._minimumZoom = minimumZoom;
    }

    if (maximumZoom) {
      this._maximumZoom = maximumZoom;
    }

    isZoomEnabled = true;
  },

  disableZoom: function() {
    this._minimumZoom = 1.0;
    this._maximumZoom = 1.0;

    this.setZoom(1.0);

    isZoomEnabled = false;
  },

  _minimumZoom: 1.0,

  setMinimumZoom: function(minimumZoom) {
    this._minimumZoom = minimumZoom;
  },

  _maximumZoom: 1.0,

  setMaximumZoom: function(maximumZoom) {
    this._maximumZoom = maximumZoom;
  },

  _zoom: 1.0,

  /**
   * Update the internal state of the view so that any future
   * pinch-to-zoom gestures can correctly adjust the current zoom
   * level in the event that the zoom level is changed outside of
   * the pinch-to-zoom gesture (e.g.: ZoomBar). This gets called
   * when the `Camera` emits a `zoomchanged` event.
   */
  setZoom: function(zoom) {
    if (!isZoomEnabled) {
      return;
    }

    this._zoom = clamp(zoom, this._minimumZoom, this._maximumZoom);
  },

  _useZoomPreviewAdjustment: false,

  enableZoomPreviewAdjustment: function() {
    this._useZoomPreviewAdjustment = true;
  },

  disableZoomPreviewAdjustment: function() {
    this._useZoomPreviewAdjustment = false;
  },

  /**
   * Adjust the scale of the <video/> tag to compensate for the inability
   * of the Camera API to zoom the preview stream beyond a certain point.
   * This gets called when the `Camera` emits a `zoomchanged` event and is
   * calculated by `Camera.prototype.getZoomPreviewAdjustment()`.
   */
  setZoomPreviewAdjustment: function(zoomPreviewAdjustment) {
    if (this._useZoomPreviewAdjustment) {
      this.els.video.style.transform = 'scale(' + zoomPreviewAdjustment + ')';
    }
  },

  stopStream: function() {
    this.els.video.mozSrcObject = null;
  },

  fadeOut: function(done) {
    debug('fade-out');
    this.el.classList.remove('visible');
    if (done) { setTimeout(done, this.fadeTime);}
  },

  fadeIn: function(done) {
    debug('fade-in');
    this.el.classList.add('visible');
    if (done) { setTimeout(done, this.fadeTime); }
  },

  /**
   * Triggers a quick shutter style animation.
   *
   * @private
   */
  shutter: function() {
    this.el.classList.add('shutter');
  },

  /**
   * Force a reflow before removing
   * the shutter class so that it
   * doesn't impact the animation.
   *
   * @private
   */
  onShutterEnd: function() {
    this.reflow = this.el.offsetTop;
    this.el.classList.remove('shutter');
  },

  /**
   * Sizes and positions the preview stream.
   *
   * @param  {Object} preview
   * @param  {Number} sensorAngle
   * @param  {Boolean} mirrored
   */
  updatePreview: function(preview, sensorAngle, mirrored) {
    if (!preview) { return; }
    var aspect;

    // Invert dimensions if the camera's `sensorAngle` is
    // 0 or 180 degrees.
    if (sensorAngle % 180 === 0) {
      this.container = {
        width: this.width,
        height: this.height,
        aspect: this.width / this.height
      };

      aspect = preview.height / preview.width;
    } else {
      this.container = {
        width: this.height,
        height: this.width,
        aspect: this.height / this.width
      };

      aspect = preview.width / preview.height;
    }

    var shouldFill = aspect > this.container.aspect;
    var scaleType = this.scaleType || (shouldFill ? 'fill' : 'fit');

    this.updatePreviewMetrics(preview, sensorAngle, mirrored, scaleType);
  },

  /**
   * Calculates the correct sizing
   * depending on the chosen 'scaleType'.
   *
   * 'scale-type' attribute set as a styling hook.
   *
   * @param  {Object} preview
   * @param  {Number} sensorAngle
   * @param  {Boolean} mirrored
   * @param  {String} scaleType 'fill'|'fit'
   */
  updatePreviewMetrics: function(preview, sensorAngle, mirrored, scaleType) {
    debug('update preview scaleType: %s', scaleType, preview);

    // Calculate the correct scale to apply to the
    // preview to either 'fill' or 'fit' the viewfinder
    // container (always preserving the aspect ratio).
    var landscape = scaleSizeTo[scaleType](this.container, preview);
    var portrait = { width: landscape.height, height: landscape.width };

    // Set the size of the frame to match 'portrait' dimensions
    this.els.frame.style.width = portrait.width + 'px';
    this.els.frame.style.height = portrait.height + 'px';

    var transform = '';
    if (mirrored) {
      transform += 'scale(-1, 1) ';
    }

    transform += 'rotate(' + sensorAngle + 'deg)';

    // Set the size of the video container to match the
    // 'landscape' dimensions (CSS is used to rotate
    // the 'landscape' video stream to 'portrait')
    this.els.videoContainer.style.width = landscape.width + 'px';
    this.els.videoContainer.style.height = landscape.height + 'px';
    this.els.videoContainer.style.transform = transform;

    // CSS aligns the contents slightly
    // differently depending on the scaleType
    this.set('scaleType', scaleType);

    debug('updated preview size/position', landscape);
  },

  template: function() {
    return '<div class="viewfinder-frame js-frame">' +
        '<div class="viewfinder-video-container js-video-container">' +
          '<video class="viewfinder-video js-video"></video>' +
        '</div>' +
        '<div class="viewfinder-grid">' +
          '<div class="row"></div>' +
          '<div class="row middle"></div>' +
          '<div class="row"></div>' +
          '<div class="column left">' +
            '<div class="cell top"></div>' +
            '<div class="cell middle"></div>' +
            '<div class="cell bottom"></div>' +
          '</div>' +
          '<div class="column middle">' +
            '<div class="cell top"></div>' +
            '<div class="cell middle"></div>' +
            '<div class="cell bottom"></div>' +
          '</div>' +
          '<div class="column right">' +
           '<div class="cell top"></div>' +
           '<div class="cell middle"></div>' +
           '<div class="cell bottom"></div>' +
          '</div>' +
          '</div>' +
        '</div>' +
    '</div>';
  }
});

});

define('views/zoom-bar',['require','exports','module','vendor/view','lib/bind','lib/orientation'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');
var bind = require('lib/bind');
var orientation = require('lib/orientation');

/**
 * Locals
 */

var lastTouch = null;

var clamp = function(value, minimum, maximum) {
  return Math.min(Math.max(value, minimum), maximum);
};

module.exports = View.extend({
  name: 'zoom-bar',

  initialize: function() {
    this.render();

    this._orientation = orientation.get();

    // Amount (%) to adjust the Zoom Bar by when tapping the min/max indicators
    this.zoomBarIndicatorInterval = 10;

    // Amount of inactivity time (in milliseconds) to hide the Zoom Bar
    this.zoomBarInactivityTimeout = 3000;

    // Bind events
    bind(this.els.scrubber, 'touchstart', this.onTouchStart);
    bind(this.els.scrubber, 'touchmove', this.onTouchMove);
    bind(this.els.scrubber, 'touchend', this.onTouchEnd);
    bind(this.els.maxIndicator, 'click', this.onIncrement);
    bind(this.els.minIndicator, 'click', this.onDecrement);
    orientation.on('orientation', this.setOrientation);
  },

  render: function() {
    this.el.innerHTML = this.template();

    // Find elements
    this.els.maxIndicator = this.find('.zoom-bar-max-indicator');
    this.els.minIndicator = this.find('.zoom-bar-min-indicator');
    this.els.inner = this.find('.zoom-bar-inner');
    this.els.track = this.find('.zoom-bar-track');
    this.els.scrubber = this.find('.zoom-bar-scrubber');
  },

  template: function() {
    return '<div class="zoom-bar-max-indicator"></div>' +
      '<div class="zoom-bar-inner">' +
        '<div class="zoom-bar-track"></div>' +
        '<div class="zoom-bar-scrubber"></div>' +
      '</div>' +
      '<div class="zoom-bar-min-indicator"></div>';
  },

  onTouchStart: function(evt) {
    lastTouch = evt.touches[0];
    this.resetInactivityTimeout();
    this.setScrubberActive(true);
    this._innerHeight = this.els.inner.offsetHeight;

    evt.stopPropagation();
  },

  onTouchMove: function(evt) {
    if (!lastTouch) {
      return;
    }

    var touch = evt.touches[0];
    var deltaX = lastTouch.pageX - touch.pageX;
    var deltaY = lastTouch.pageY - touch.pageY;

    var scale = 100 / this._innerHeight;

    deltaX *= scale;
    deltaY *= scale;

    switch (this._orientation) {
      case 0:
        this.setValue(this._value + deltaY, true);
        break;
      case 90:
        this.setValue(this._value + deltaX, true);
        break;
      case 180:
        this.setValue(this._value - deltaY, true);
        break;
      case 270:
        this.setValue(this._value - deltaX, true);
        break;
    }

    lastTouch = touch;
  },

  onTouchEnd: function(evt) {
    if (!lastTouch) {
      return;
    }

    lastTouch = null;
    this.resetInactivityTimeout();
    this.setScrubberActive(false);
  },

  onIncrement: function(evt) {
    this.setValue(this._value + this.zoomBarIndicatorInterval, true);
    this.flashScrubberActive();
    evt.stopPropagation();
  },

  onDecrement: function(evt) {
    this.setValue(this._value - this.zoomBarIndicatorInterval, true);
    this.flashScrubberActive();
    evt.stopPropagation();
  },

  _orientation: 0,

  setOrientation: function(orientation) {
    var el = this.el;
    el.classList.remove('zooming');

    // Force ZoomBar to hide *immediately* on orientation change
    window.requestAnimationFrame(function() {
      el.style.transitionDuration = '0ms';
      window.requestAnimationFrame(function() {
        el.style.transitionDuration = '';
      });
    });

    this._orientation = orientation;
  },

  _value: 0,

  setValue: function(value, emitChange) {
    this.resetInactivityTimeout();

    var lastValue = this._value;
    this._value = clamp(value, 0, 100);
    if (this._value === lastValue) {
      return;
    }

    if (this._value === 0) {
      this.els.minIndicator.classList.add('active');
    } else {
      this.els.minIndicator.classList.remove('active');
    }

    if (this._value === 100) {
      this.els.maxIndicator.classList.add('active');
    } else {
      this.els.maxIndicator.classList.remove('active');
    }

    var self = this;
    window.requestAnimationFrame(function() {
      self.els.track.style.top = (100 - self._value) + '%';
      self.els.scrubber.style.bottom = self._value + '%';
    });

    if (emitChange) {
      this.emit('change', this._value);
    }
  },

  setScrubberActive: function(active) {
    window.clearTimeout(this._scrubberTimeout);

    if (active) {
      this.els.scrubber.classList.add('active');
    } else {
      this.els.scrubber.classList.remove('active');
    }
  },

  flashScrubberActive: function() {
    this.setScrubberActive(true);
    var self = this;
    this._scrubberTimeout = window.setTimeout(function() {
      self.setScrubberActive(false);
    }, 150);
  },

  resetInactivityTimeout: function() {
    window.clearTimeout(this._inactivityTimeout);

    this.show();

    var self = this;
    this._inactivityTimeout = window.setTimeout(function() {
      self.hide();
    }, this.zoomBarInactivityTimeout);
  },

  show: function() {
    this.el.classList.add('zooming');
  },

  hide: function() {
    this.el.classList.remove('zooming');
  }
});

});

define('views/hud',['require','exports','module','vendor/view','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'hud',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.flash = this.find('.js-flash');
    this.els.camera = this.find('.js-camera');
    this.els.settings = this.find('.js-settings');
    bind(this.els.flash, 'click', this.onFlashClick);
    bind(this.els.camera, 'click', this.onCameraClick);
    bind(this.els.settings, 'click', this.onSettingsClick, true);
  },

  setFlashMode: function(mode) {
    if (!mode) { return; }
    var classes = this.els.flash.classList;
    var oldIcon = this.flashMode && this.flashMode.icon;
    if (oldIcon) { classes.remove(oldIcon); }
    classes.add(mode.icon);
    this.flashMode = mode;
  },

  onFlashClick: function(event) {
    event.stopPropagation();
    this.emit('click:flash');
  },

  onCameraClick: function(event) {
    event.stopPropagation();
    this.emit('click:camera');
  },

  onSettingsClick: function(event) {
    event.stopPropagation();
    this.emit('click:settings');
  },

  template: function() {
    /*jshint maxlen:false*/
    return '<div class="hud_btn hud_camera rotates icon-toggle-camera test-camera-toggle js-camera"></div>' +
    '<div class="hud_btn hud_flash rotates test-flash-button js-flash"></div>' +
    '<div class="hud_btn hud_settings rotates icon-settings test-settings-toggle js-settings">' +
    '</div>';
  }
});

});

define('lib/pinch',['require','exports','module','lib/bind','lib/bind','lib/bind-all','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var bind = require('lib/bind');
var unbind = require('lib/bind').unbind;
var bindAll = require('lib/bind-all');
var events = require('vendor/evt');

/**
 * Mixin event emitter
 */

events(Pinch.prototype);

/**
 * Exports
 */

module.exports = Pinch;

/**
 * Initialize a new `Pinch` interface.
 *
 * @constructor
 */
function Pinch(el) {
  bindAll(this);
  this.attach(el);
}

Pinch.prototype.attach = function(el) {
  this.el = el;

  bind(this.el, 'touchstart', this.onTouchStart);
  bind(window, 'touchmove', this.onTouchMove);
  bind(window, 'touchend', this.onTouchEnd);
};

Pinch.prototype.detach = function() {
  unbind(this.el, 'touchstart', this.onTouchStart);
  unbind(window, 'touchmove', this.onTouchMove);
  unbind(window, 'touchend', this.onTouchEnd);

  this.el = null;
};

Pinch.prototype.onTouchStart = function(evt) {
  if (evt.touches.length !== 2) {
    return;
  }

  this.lastTouchA = evt.touches[0];
  this.lastTouchB = evt.touches[1];
  this.isPinching = true;
  this.emit('pinchstarted');
};

Pinch.prototype.onTouchMove = function(evt) {
  if (!this.isPinching) {
    return;
  }

  var touchA = getNewTouchA(this, evt.touches);
  var touchB = getNewTouchB(this, evt.touches);
  var deltaPinch = getDeltaPinch(this, touchA, touchB);

  this.emit('pinchchanged', deltaPinch);

  this.lastTouchA = touchA;
  this.lastTouchB = touchB;
};

Pinch.prototype.onTouchEnd = function(evt) {
  if (!this.isPinching) {
    return;
  }

  if (evt.touches.length < 2) {
    this.isPinching = false;
    this.emit('pinchended');
  }
};

function getNewTouchA(pinch, touches) {
  if (!pinch.lastTouchA) {
    return null;
  }

  for (var i = 0, length = touches.length, touch; i < length; i++) {
    touch = touches[i];
    if (touch.identifier === pinch.lastTouchA.identifier) {
      return touch;
    }
  }
  return null;
}

function getNewTouchB(pinch, touches) {
  if (!pinch.lastTouchB) {
    return null;
  }

  for (var i = 0, length = touches.length, touch; i < length; i++) {
    touch = touches[i];
    if (touch.identifier === pinch.lastTouchB.identifier) {
      return touch;
    }
  }
  return null;
}

function getDeltaPinch(pinch, touchA, touchB) {
  var lastTouchA = pinch.lastTouchA;
  var lastTouchB = pinch.lastTouchB;
  if (!touchA || !lastTouchA || !touchB || !lastTouchB) {
    return 0;
  }

  var oldDistance = Math.sqrt(
    Math.pow(lastTouchB.pageX - lastTouchA.pageX, 2) +
    Math.pow(lastTouchB.pageY - lastTouchA.pageY, 2));
  var newDistance = Math.sqrt(
    Math.pow(touchB.pageX - touchA.pageX, 2) +
    Math.pow(touchB.pageY - touchA.pageY, 2));
  return newDistance - oldDistance;
}

});

define('app',['require','exports','module','performance-testing-helper','views/notification','views/loading-screen','views/viewfinder','lib/orientation','views/zoom-bar','lib/bind-all','vendor/model','debug','views/hud','lib/pinch','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var PerformanceTestingHelper = require('performance-testing-helper');
var NotificationView = require('views/notification');
var LoadingView = require('views/loading-screen');
var ViewfinderView = require('views/viewfinder');
var orientation = require('lib/orientation');
var ZoomBarView = require('views/zoom-bar');
var bindAll = require('lib/bind-all');
var model = require('vendor/model');
var debug = require('debug')('app');
var HudView = require('views/hud');
var Pinch = require('lib/pinch');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = App;

/**
 * Mixin `Model` API
 */

model(App.prototype);

/**
 * Initialize a new `App`
 *
 * Options:
 *
 *   - `root` The node to inject content into
 *
 * @param {Object} options
 * @constructor
 */
function App(options) {
  debug('initialize');
  var self = this;
  bindAll(this);
  this.views = {};
  this.el = options.el;
  this.win = options.win;
  this.doc = options.doc;
  this.require = options.require || window.requirejs;
  this.LoadingView = options.LoadingView || LoadingView; // test hook
  this.inSecureMode = (this.win.location.hash === '#secure');
  this.controllers = options.controllers;
  this.geolocation = options.geolocation;
  this.settings = options.settings;
  this.camera = options.camera;
  this.activity = {};

  //
  // If the system app is opening an attention screen (because
  // of an incoming call or an alarm, e.g.) and if we are
  // currently recording a video then we need to stop recording
  // before the ringer or alarm starts sounding. We will be sent
  // to the background shortly after this and will stop recording
  // when that happens, but by that time it is too late and we
  // have already recorded some sound. See bugs 995540 and 1006200.
  //
  // XXX We're abusing the settings API here to allow the system app
  // to broadcast a message to any certified apps that care. There
  // ought to be a better way, but this is a quick and easy way to
  // fix a last-minute release blocker.
  //
  navigator.mozSettings.addObserver(
    'private.broadcast.attention_screen_opening',
    function(event) {
      // If event.settingValue is true, then an attention screen will
      // soon appear. If it is false, then the attention screen is
      // going away.
      if (event.settingValue) {
        self.emit('attentionscreenopened');
      }
  });

  debug('initialized');
}

/**
 * Runs all the methods to boot the app.
 *
 * The loading screen is shown until the
 * camera is 'ready', then it is taken down.
 *
 * @public
 */
App.prototype.boot = function() {
  debug('boot');
  if (this.booted) { return; }
  this.bindEvents();
  this.initializeViews();
  this.runControllers();
  this.injectViews();
  this.showLoading();
  this.booted = true;
  debug('booted');
};

/**
 * Runs controllers to glue all
 * the parts of the app together.
 *
 * @private
 */
App.prototype.runControllers = function() {
  debug('run controllers');
  this.controllers.settings(this);
  this.controllers.activity(this);
  this.controllers.camera(this);
  this.controllers.viewfinder(this);
  this.controllers.recordingTimer(this);
  this.controllers.indicators(this);
  this.controllers.controls(this);
  this.controllers.overlay(this);
  this.controllers.hud(this);
  this.controllers.zoomBar(this);
  debug('controllers run');
};

/**
 * Lazy load and run a controller.
 *
 * @param  {String} path
 */
App.prototype.loadController = function(path) {
  this.require([path], function(controller) { controller(this); }.bind(this));
};

/**
 * Initialize views.
 *
 * @private
 */
App.prototype.initializeViews = function() {
  debug('initializing views');
  this.views.viewfinder = new ViewfinderView();
  this.views.hud = new HudView();
  this.views.zoomBar = new ZoomBarView();
  this.views.notification = new NotificationView();
  debug('views initialized');
};

/**
 * Put views in the DOM.
 *
 * @private
 */
App.prototype.injectViews = function() {
  debug('injecting views');
  this.views.viewfinder.appendTo(this.el);
  this.views.hud.appendTo(this.el);
  this.views.zoomBar.appendTo(this.el);
  this.views.notification.appendTo(this.el);
  debug('views injected');
};

/**
 * Attaches event handlers.
 *
 * @private
 */
App.prototype.bindEvents = function() {
  debug('binding events');

  // App
  this.once('viewfinder:visible', this.onCriticalPathDone);
  this.once('storage:checked:healthy', this.geolocationWatch);
  this.on('camera:takingpicture', this.showLoading);
  this.on('camera:ready', this.clearLoading);
  this.on('visible', this.onVisible);
  this.on('hidden', this.onHidden);

  // DOM
  bind(this.doc, 'visibilitychange', this.onVisibilityChange);

  // we bind to window.onlocalized in order not to depend
  // on l10n.js loading (which is lazy). See bug 999132
  bind(this.win, 'localized', this.firer('localized'));
  bind(this.win, 'beforeunload', this.onBeforeUnload);
  bind(this.el, 'click', this.onClick);

  // Pinch
  this.pinch = new Pinch(this.el);
  this.pinch.on('pinchchanged', this.firer('pinchchanged'));

  debug('events bound');
};

/**
 * Tasks to run when the
 * app becomes visible.
 *
 * Check the storage again as users
 * may have made changes since the
 * app was minimised
 */
App.prototype.onVisible = function() {
  this.geolocationWatch();
  orientation.start();
  debug('visible');
};

/**
 * Tasks to run when the
 * app is minimised/hidden.
 *
 * @private
 */
App.prototype.onHidden = function() {
  this.geolocation.stopWatching();
  orientation.stop();
  debug('hidden');
};

/**
 * Emit a click event that other
 * modules can listen to.
 *
 * @private
 */
App.prototype.onClick = function() {
  debug('click');
  this.emit('click');
};

/**
 * Log when critical path has completed.
 *
 * @private
 */
App.prototype.onCriticalPathDone = function() {
  var start = window.performance.timing.domLoading;
  var took = Date.now() - start;

  // Indicate critical path is done to help track performance
  PerformanceTestingHelper.dispatch('startup-path-done');
  console.log('critical-path took %s', took + 'ms');

  // Load non-critical modules
  this.loadController(this.controllers.previewGallery);
  this.loadController(this.controllers.storage);
  this.loadController(this.controllers.confirm);
  this.loadController(this.controllers.battery);
  this.loadController(this.controllers.sounds);
  this.loadController(this.controllers.timer);
  this.loadL10n();

  this.criticalPathDone = true;
  this.emit('criticalpathdone');
};

/**
 * Begins watching location if not within
 * a pending activity and the app isn't
 * currently hidden.
 *
 * Watching is delayed by the `promptDelay`
 * defined in settings.
 *
 * @private
 */
App.prototype.geolocationWatch = function() {
  var shouldWatch = !this.activity.pick && !this.hidden;
  if (shouldWatch) { this.geolocation.watch(); }
};

/**
 * Responds to the `visibilitychange`
 * event, emitting useful app events
 * that allow us to perform relate
 * work elsewhere.
 *
 * @private
 */
App.prototype.onVisibilityChange = function() {
  this.hidden = this.doc.hidden;
  this.emit(this.hidden ? 'hidden' : 'visible');
};

/**
 * Runs just before the
 * app is destroyed.
 *
 * @private
 */
App.prototype.onBeforeUnload = function() {
  this.views.viewfinder.stopStream();
  this.emit('beforeunload');
  debug('beforeunload');
};

/**
 * Initialize l10n 'localized' listener.
 *
 * Sometimes it may have completed
 * before we reach this point, meaning
 * we will have missed the 'localized'
 * event. In this case, we emit the
 * 'localized' event manually.
 *
 * @private
 */
App.prototype.loadL10n = function() {
  this.require(['l10n']);
};

/**
 * States whether localization
 * has completed or not.
 *
 * @return {Boolean}
 * @public
 */
App.prototype.localized = function() {
  var l10n = navigator.mozL10n;
  return l10n && l10n.readyState === 'complete';
};

/**
 * Central place to localize a string.
 *
 * @param  {String} key
 * @public
 */
App.prototype.l10nGet = function(key) {
  var l10n = navigator.mozL10n;
  if (l10n) {
    return l10n.get(key);
  }

  // in case we don't have mozL10n loaded yet, we want to
  // return the key. See bug 999132
  return key;
};

/**
 * Shows the loading screen after the
 * number of ms defined in config.js
 *
 * @private
 */
App.prototype.showLoading = function() {
  debug('show loading');
  var ms = this.settings.loadingScreen.get('delay');
  var self = this;
  clearTimeout(this.loadingTimeout);
  this.loadingTimeout = setTimeout(function() {
    self.views.loading = new self.LoadingView();
    self.views.loading.appendTo(self.el).show();
    debug('loading shown');
  }, ms);
};

/**
 * Clears the loadings screen, or
 * any pending loading screen.
 *
 * @private
 */
App.prototype.clearLoading = function() {
  debug('clear loading');
  var view = this.views.loading;
  clearTimeout(this.loadingTimeout);
  if (!view) { return; }
  view.hide(view.destroy);
  this.views.loading = null;
};

});

define('controllers/hud',['require','exports','module','debug','lib/debounce','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:hud');
var debounce = require('lib/debounce');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new HudController(app); };
module.exports.HudController = HudController;

/**
 * Initialize a new `HudController`
 *
 * @param {AppController} app
 * @constructor
 *
 */
function HudController(app) {
  bindAll(this);
  this.app = app;
  this.hud = app.views.hud;
  this.settings = app.settings;
  this.l10nGet = app.l10nGet;
  this.notification = app.views.notification;
  this.configure();
  this.bindEvents();
  debug('initialized');
}

/**
 * Initially configure state.
 *
 * @private
 */
HudController.prototype.configure = function() {
  var hasDualCamera = this.settings.cameras.get('options').length > 1;
  this.hud.enable('camera', hasDualCamera);

  // Disable flash button until we
  // know whether the hardware has flash
  this.hud.enable('flash', false);
};

/**
 * Bind callbacks to events.
 *
 * @return {HudController} for chaining
 * @private
 */
HudController.prototype.bindEvents = function() {
  this.app.settings.flashModes.on('change:selected', this.updateFlashMode);
  this.app.settings.mode.on('change:selected', this.updateFlashMode);
  this.app.on('settings:configured', this.updateFlashSupport);
  this.app.once('criticalpathdone', this.hud.show);

  // We 'debouce' some UI callbacks to prevent
  // thrashing the hardware when a user taps repeatedly.
  // This means the first calback will fire instantly but
  // subsequent events will be blocked for given time period.
  this.hud.on('click:camera', debounce(this.onCameraClick, 500, true));
  this.hud.on('click:settings', this.app.firer('settings:toggle'));
  this.hud.on('click:flash', this.onFlashClick);

  // Camera
  this.app.on('camera:ready', this.hud.setter('camera', 'ready'));
  this.app.on('camera:busy', this.hud.setter('camera', 'busy'));
  this.app.on('change:recording', this.hud.setter('recording'));

  // Timer
  this.app.on('timer:cleared', this.hud.setter('timer', 'inactive'));
  this.app.on('timer:started', this.hud.setter('timer', 'active'));
  this.app.on('timer:ended', this.hud.setter('timer', 'inactive'));

  // Settings
  this.app.on('settings:opened', this.hud.hide);
  this.app.on('settings:closed', this.hud.show);
};

HudController.prototype.onSettingsConfigured = function() {
  this.updateFlashSupport();
};

HudController.prototype.onModeChange = function() {
  this.clearNotifications();
  this.updateFlashMode();
};

HudController.prototype.onCameraClick = function() {
  debug('camera clicked');
  this.clearNotifications();
  this.app.settings.cameras.next();
};

HudController.prototype.clearNotifications = function() {
  this.notification.clear(this.flashNotification);
};

/**
 * Cycle to the next available flash
 * option, update the HUD view and
 * show a change notification.
 *
 * @private
 */
HudController.prototype.onFlashClick = function() {
  var setting = this.settings.flashModes;
  var ishdrOn = this.settings.hdr.selected('key') === 'on';

  setting.next();
  this.hud.set('flashMode' , setting.selected('key'));
  this.notify(setting, ishdrOn);
};

/**
 * Display a notifcation showing the
 * current state of the given setting.
 *
 * @param  {Setting} setting
 * @private
 */
HudController.prototype.notify = function(setting, hdrDeactivated) {
  var optionTitle = this.l10nGet(setting.selected('title'));
  var title = this.l10nGet(setting.get('title'));
  var html;

  // Check if the `hdr` setting is going to be deactivated as part
  // of the change in the `flashMode` setting and display a specialized
  // notification if that is the case
  if (hdrDeactivated) {
    html = title + ' ' + optionTitle + '<br/>' +
      this.l10nGet('hdr-deactivated');
  } else {
    html = title + '<br/>' + optionTitle;
  }

  this.flashNotification = this.notification.display({ text: html });
};

HudController.prototype.updateFlashMode = function() {
  var selected = this.settings.flashModes.selected();
  if (!selected) { return; }
  this.hud.setFlashMode(selected);
  debug('updated flash mode: %s', selected.key);
};

HudController.prototype.updateFlashSupport = function() {
  var supported = this.settings.flashModes.supported();
  this.hud.enable('flash', supported);
  this.updateFlashMode();
  debug('flash supported: %s', supported);
};

});

;(function() {


/**
 * Namespace to store
 * references under on root
 */

var ns = '_attach';

/**
 * Normalize `matchesSelector`
 */

var proto = Element.prototype;
var matches = proto.matchesSelector ||
  proto.webkitMatchesSelector ||
  proto.mozMatchesSelector ||
  proto.msMatchesSelector ||
  proto.oMatchesSelector;

/**
 * Bind an event listener
 * to the given element.
 *
 * Example:
 *
 *   attach(myEl, 'click', '.my-class', function(event, el) {
 *     // Do stuff
 *   });
 *
 * @param  {Element}  root
 * @param  {String}   type
 * @param  {String}   selector (optional)
 * @param  {Function} fn
 * @param  {Object}   ctx (optional)
 */
function attach(root, type, selector, fn, ctx) {
  if (arguments.length === 1) {
    return attach.many.apply(null, arguments);
  }

  // `selector` is optional
  if (typeof selector === 'function') {
    ctx = fn;
    fn = selector;
    selector = null;
  }

  // We use the key 'null' to
  // indicate that we are binding
  // an event handler to the root.
  selector = selector || 'null';

  var store = getStore(root);
  var master = store.master[type];
  var delegates = store.delegates[type] = (store.delegates[type] || {});

  // Add the function to the delegates
  delegates[selector] = fn;

  // Only one master event listener
  // is needed per event type.
  if (master) { return; }

  // Add the master callbak to the
  // root node and to the store.
  master = store.master[type] = callback;
  root.addEventListener(type, master);

  /**
   * The master callback passed
   * to `addEventListener`.
   *
   * @param  {Event}   event
   */
  function callback(e) {
    var el = e.target;
    var selector;
    var matched;
    var out;
    var fn;

    // Walk up the DOM tree
    // until we hit the root
    while (el) {

      // Loop over each selector
      // bound to this e type.
      for (selector in delegates) {
        fn = delegates[selector];

        // There are two types of match. A
        // 'null' selector at the root node,
        // or a selector match on the current el.
        matched = (el === root && selector === 'null') ||
          matches.call(el, selector);

        if (matched) {
          out = fn.call(ctx || el, e, el);

          // Stop propagation if the
          // user returns false from the
          // callback. Ideally we would
          // use .stopPropagation, but I
          // don't know of any way to detect
          // if this has been called.
          if (out === false) { return e.stopPropagation(); }
        }
      }

      // Don't go any higher
      // than the root element.
      if (el == root) break;

      // Move on up!
      el = el.parentNode;
    }
  }
}

attach.on = attach;

/**
 * Unbind an event attach
 * from the given root element.
 *
 * If no selector if given, all
 * callbacks for the given event
 * type are removed.
 *
 * Example:
 *
 *   // Remove one
 *   attach.off(myEl, 'click', '.my-class');
 *
 *   // Remove all
 *   attach.off(myEl, 'click');
 *
 * @param  {Element} root
 * @param  {String} type (optional)
 * @param  {String} selector (optional)
 */
attach.off = function(root, type, selector) {
  var store = getStore(root);
  var master = store.master[type];
  var delegates = store.delegates[type];

  // Remove just one
  if (type && selector) {
    delete delegates[selector];
  }

  // Remove all of type
  else if (type) {
    delete store.delegates[type];
  }

  // Remove all
  else {
    for (type in store.master) {
      attach.off(root, type);
    }
  }

  // If there aren't any callbacks
  // of this type left, remove the master.
  if (isEmpty(store.delegates[type])) {
    root.removeEventListener(type, master);
    delete store.master[type];
  }
};

/**
 * Handles Backbone style
 * shorthand event binding.
 *
 * Example:
 *
 *   attach(myElement, {
 *     'click .foo': onFooClick,
 *     'click .bar': onBarClick
 *   });
 *
 * @param  {element} root
 * @param  {Object} config
 * @param  {Object} ctx
 */
attach.many = function(root, config, ctx) {
  var parts;
  var key;

  for (key in config) {
    parts = key.split(' ');
    attach.on(
      root,
      parts[0],
      parts[1],
      config[key],
      ctx);
  }
};

/**
 * Gets the reference store
 * attached to the given node.
 *
 * If one is not found, we
 * create a fresh one.
 *
 * @param  {Element} el
 * @return {Object}
 */
function getStore(el) {
  return el[ns] || createStore(el);
}

/**
 * Creates a fresh reference
 * store on the given element.
 *
 * @param  {Element} el
 * @return {Object}
 */
function createStore(el) {
  el[ns] = { master: {}, delegates: {} };
  return el[ns];
}

/**
 * Checks if the given
 * element has no keys.
 *
 * @param  {Object}  ob
 * @return {Boolean}
 */
function isEmpty(ob) {
  for (var key in ob) { return false; }
  return true;
}

/**
 * Expose 'attach' (UMD)
 */

if (typeof exports === "object") {
  module.exports = attach;
} else if (typeof define === "function" && define.amd) {
  define('vendor/attach',[],function(){ return attach; });
} else {
  window.attach = attach;
}

})();
define('views/controls',['require','exports','module','debug','vendor/attach','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:controls');
var attach = require('vendor/attach');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'controls',
  className: 'test-controls',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.thumbnail = this.find('.js-thumbnail');

    // Bind events
    attach.on(this.el, 'click', '.js-btn', this.onButtonClick);
    attach.on(this.el, 'click', '.js-switch', this.onButtonClick);
    debug('rendered');
  },

  onButtonClick: function(e, el) {
    var name = el.getAttribute('name');
    var enabled = this.get('data-enabled');
    e.stopPropagation();
    if (enabled === 'true') {
      this.emit('click:' + name, e);
    }
  },

  template: function() {
    /*jshint maxlen:false*/
    return '<div class="controls-left">' +
      '<div class="controls-button controls-thumbnail-button js-thumbnail js-btn rotates" name="thumbnail"></div>' +
      '<div class="controls-button controls-cancel-pick-button test-cancel-pick icon-pick-cancel js-btn rotates" name="cancel"></div>' +
    '</div>' +
    '<div class="controls-middle">' +
      '<div class="capture-button test-capture js-btn rotates" name="capture">' +
        '<div class="circle outer-circle"></div>' +
        '<div class="circle inner-circle"></div>' +
        '<div class="center icon"></div>' +
      '</div>' +
    '</div>' +
    '<div class="controls-right">' +
      '<div class="mode-switch test-switch js-switch" name="switch">' +
        '<div class="mode-icon icon rotates"></div>' +
        '<div class="selected-mode">' +
          '<div class="selected-mode-icon icon rotates"></div>' +
        '</div>' +
      '</div>' +
    '</div>';
  },

  setThumbnail: function(blob) {
    if (!this.els.image) {
      this.els.image = new Image();
      this.els.image.classList.add('test-thumbnail');
      this.els.thumbnail.appendChild(this.els.image);
      this.set('thumbnail', true);
    } else {
      window.URL.revokeObjectURL(this.els.image.src);
    }

    this.els.image.src = window.URL.createObjectURL(blob);
  },

  removeThumbnail: function() {
    if (this.els.image) {
      this.els.thumbnail.removeChild(this.els.image);
      window.URL.revokeObjectURL(this.els.image.src);
      this.els.image = null;
    }

    this.set('thumbnail', false);
  },

  /**
   * NOTE: The below functions are a first
   * attempt at replacing the default View
   * `.set()`, `.enable()` and `.disable()` APIs
   * to avoid having to use attributes to style
   * state in our CSS.
   */

  set: function(key, value) {
    if (typeof key !== 'string') { return; }
    if (arguments.length === 1) { value = true; }
    if (!value) { return this.unset(key); }

    var attr = 'data-' + key;
    var oldValue = this.el.getAttribute(attr);
    var oldClass = oldValue && classFrom(key, oldValue);
    var newClass = classFrom(key, value);

    if (oldClass) { this.el.classList.remove(oldClass); }
    if (newClass) { this.el.classList.add(newClass); }

    this.el.setAttribute(attr, value);
    debug('remove: %s, add: %s', oldClass, newClass);
    debug('attr key: %s, value: %s', attr, value);
  },

  unset: function(key) {
    var attr = 'data-' + key;
    var value = this.el.getAttribute(attr);
    this.el.classList.remove(classFrom(key, value));
    this.el.removeAttribute(attr);
  },

  enable: function(key) {
    this.set(key ? key + '-enabled' : 'enabled');
    this.unset(key ? key + '-disabled' : 'disabled');
  },

  disable: function(key) {
    this.set(key ? key + '-disabled' : 'disabled');
    this.unset(key ? key + '-enabled' : 'enabled');
  }
});

/**
 * Examples:
 *
 *   this.classFrom('recording', true); //=> 'recording'
 *   this.classFrom('flash', 'on'); //=> 'flash-on'
 *   this.classFrom('recording', false); //=> ''
 *   this.classFrom('recording'); //=> 'recording'
 *   this.classFrom('recording', 'true'); //=> 'recording'
 *   this.classFrom('recording', 'false'); //=> ''
 *
 * @param  {String} key
 * @param  {*} value
 * @return {String}
 */
function classFrom(key, value) {
  value = detectBooleans(value);
  if (typeof value === 'boolean') {
    return value ? key : '';
  } else if (value) {
    return key + '-' + value ;
  } else {
    return key;
  }
}

function detectBooleans(value) {
  if (typeof value === 'boolean') { return value; }
  else if (value === 'true') { return true; }
  else if (value === 'false') { return false; }
  else { return value; }
}

});

define('controllers/controls',['require','exports','module','debug','views/controls','lib/bind-all'],function(require, exports, module) {


/**
 * TODO: Controllers should create views
 */

/**
 * Dependencies
 */

var debug = require('debug')('controller:controls');
var ControlsView = require('views/controls');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new ControlsController(app); };
module.exports.ControlsController = ControlsController;

/**
 * Initialize a new `ControlsController`
 *
 * @param {App} app
 */
function ControlsController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.activity = app.activity;
  this.view = app.views.controls || new ControlsView();
  this.app.views.controls = this.view;
  this.bindEvents();
  this.configure();
  debug('initialized');
}

/**
 * Event bindings.
 *
 * @private
 */
ControlsController.prototype.bindEvents = function() {
  this.app.settings.mode.on('change:selected', this.view.setter('mode'));
  this.app.settings.mode.on('change:options', this.configureMode);

  // App
  this.app.on('change:recording', this.onRecordingChange);
  this.app.on('camera:shutter', this.captureHighlightOff);
  this.app.on('camera:busy', this.view.disable);
  this.app.on('timer:started', this.onTimerStarted);
  this.app.on('newthumbnail', this.onNewThumbnail);
  this.app.on('timer:cleared', this.restore);
  this.app.on('camera:ready', this.restore);

  // View
  this.view.on('click:thumbnail', this.app.firer('preview'));
  this.view.on('click:switch', this.onSwitchButtonClick);
  this.view.on('click:cancel', this.onCancelButtonClick);
  this.view.on('click:capture', this.onCaptureClick);

  debug('events bound');
};

/**
 * Initial configuration.
 *
 * @private
 */
ControlsController.prototype.configure = function() {
  var initialMode = this.app.settings.mode.selected('key');
  var isCancellable = !!this.app.activity.pick;

  // The gallery button should not
  // be shown if an activity is pending
  // or the application is in 'secure mode'.
  this.view.set('cancel', isCancellable);
  this.view.set('mode', initialMode);

  // Disable view until camera
  // 'ready' enables it.
  this.view.set('faded');
  this.view.disable();

  this.configureMode();

  // Put it in the DOM
  this.view.appendTo(this.app.el);

  debug('cancelable: %s', isCancellable);
  debug('mode: %s', initialMode);
};

ControlsController.prototype.configureMode = function() {
  var isSwitchable = this.app.settings.mode.get('options').length > 1;
  this.view.set('switchable', isSwitchable);
};

/**
 * Keep capture button pressed and
 * fire the `capture` event to allow
 * the camera to repond.
 *
 * When the 'camera:shutter' event fires
 * we remove the capture butter pressed
 * state so that it times with the
 * capture sound effect.
 *
 * @private
 */
ControlsController.prototype.onCaptureClick = function() {
  this.captureHighlightOn();
  this.app.emit('capture');
};

/**
 * Set the recording attribute on
 * the view to allow it to style
 * accordingly.
 *
 * @param  {Boolean} recording
 * @private
 */
ControlsController.prototype.onRecordingChange = function(recording) {
  this.view.set('recording', recording);
  if (!recording) { this.onRecordingEnd(); }
};

/**
 * Remove the capture highlight,
 * once recording has finished.
 *
 * @private
 */
ControlsController.prototype.onRecordingEnd = function() {
  this.captureHighlightOff();
};

/**
 * When the thumbnail changes, update it in the view.
 * This method is triggered by the 'newthumbnail' event.
 * That event is emitted by the preview gallery controller when the a new
 * photo or video is added, or when the preview is closed and the first
 * photo or video has changed (because of a file deletion).
 */
ControlsController.prototype.onNewThumbnail = function(thumbnailBlob) {
  if (thumbnailBlob) {
    this.view.setThumbnail(thumbnailBlob);
  } else {
    this.view.removeThumbnail();
  }
};

/**
 * Forces the capture button to
 * look pressed while the timer is
 * counting down and disables buttons.
 *
 * @private
 */
ControlsController.prototype.onTimerStarted = function() {
  this.captureHighlightOn();
  this.view.disable();
};

/**
 * Restores the capture button to its
 * unpressed state and re-enables buttons.
 *
 * @private
 */
ControlsController.prototype.restore = function() {
  this.captureHighlightOff();
  this.view.unset('faded');
  this.view.enable();
};

/**
 * Make the capture button
 * appear pressed.
 *
 * @private
 */
ControlsController.prototype.captureHighlightOn = function() {
  this.view.set('capture-active');
};

/**
 * Remove the pressed apperance
 * from the capture button.
 *
 * @private
 */
ControlsController.prototype.captureHighlightOff = function() {
  this.view.unset('capture-active');
};

/**
 * Switch to the next capture
 * mode: 'picture' or 'video'.
 *
 * @private
 */
ControlsController.prototype.onSwitchButtonClick = function() {
  this.view.disable();
  this.app.settings.mode.next();
};


ControlsController.prototype.onCancelButtonClick = function() {
  this.app.emit('activitycanceled');
};

/**
 * Open the gallery app when the
 * gallery button is pressed.
 *
 * @private
 */
ControlsController.prototype.onGalleryButtonClick = function(event) {
  event.stopPropagation();
  var MozActivity = window.MozActivity;

  // Can't launch the gallery if the lockscreen is locked.
  // The button shouldn't even be visible in this case, but
  // let's be really sure here.
  if (this.app.inSecureMode) { return; }

  // Launch the gallery with an activity
  this.mozActivity = new MozActivity({
    name: 'browse',
    data: { type: 'photos' }
  });

  // Wait 2000ms before re-enabling the
  // Gallery to be launched (Bug 957709)
  this.view.disable();
  setTimeout(this.view.enable, 2000);
};

});

/*global define*/

define('lib/find',['require'],function(require) {
  

  return function(query, el) {
    el = el || document;
    return el.querySelector(query);
  };
});

define('views/focus',['require','exports','module','vendor/view','lib/find'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');
var find = require('lib/find');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'focus',
  fadeTime: 500,

  initialize: function() {
    this.render();
    this.setFocusState('none');
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.focus = find('.js-focus', this.el);
  },

  setFocusState: function(state) {
    this.set('state', state);
    if (state !== 'focusing') {
      this.fadeOut();
    }
  },

  setFocusMode: function(mode) {
    this.reset();
    this.set('mode', mode);
  },

  setPosition: function(x, y) {
    this.el.style.left = x + 'px';
    this.el.style.top = y + 'px';
  },

  reset: function() {
    this.el.style.left = '50%';
    this.el.style.top = '50%';
    this.set('state', 'none');
  },

  fadeOut: function() {
    var self = this;
    if (this.fadeOutTimer) {
      clearTimeout(this.fadeOutTimer);
    }
    this.fadeOutTimer = setTimeout(hide, this.fadeTime);
    function hide() {
      self.reset();
    }
  },

  template: function() {
    return '<div class="focus-ring icon-focus-locking js-focus"></div>';
  }

});

});

define('views/face',['require','exports','module','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'face',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.el.classList.add('js-face');
  },

  setPosition: function(x, y) {
    this.el.style.left = x + 'px';
    this.el.style.top = y + 'px';
  },

  setDiameter: function(diameter) {
    this.el.style.width = diameter + 'px';
    this.el.style.height = diameter + 'px';
  }

});

});

define('views/faces',['require','exports','module','vendor/view','views/face'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');
var FaceView = require('views/face');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'faces',
  faces: [],

  initialize: function(options) {
    options = options || {};
    this.el.innerHTML = this.template();
    this.FaceView = options.FaceView || FaceView;
  },

  // It creates the DOM elements that will display circles
  // around the detected faces.
  configure: function(maxNumberFaces) {
    var faceView;
    var i;
    for(i = 0; i < maxNumberFaces; ++i) {
      faceView = new this.FaceView();
      faceView.hide();
      this.faces.push(faceView);
      faceView.appendTo(this.el);
    }
  },

  render: function(faces) {
    var self = this;
    this.hideFaces();
    faces.forEach(function(face, index) {
      var faceView = self.faces[index];
      self.renderFace(face, faceView);
    });
  },

  renderFace: function(face, faceView) {
    // Maximum diameter is 300px as in the visual spec
    var diameter = Math.min(300, face.diameter);
    faceView.setPosition(face.x, face.y);
    faceView.setDiameter(diameter);
    faceView.show();
  },

  hideFaces: function() {
    this.faces.forEach(function(faceView) {
      faceView.hide();
    });
  },

  clear: function() {
    var self = this;
    this.faces.forEach(function(faceView) {
      self.el.removeChild(faceView.el);
    });
    this.faces = [];
  }

});

});

define('lib/calculate-focus-area',['require','exports','module'],function(require, exports, module) {


/**
 * Given a position in camera coordinates
 * it clamps the value into the available range
 */
var clamp = function(position) {
  if (position < 0) {
    position = 0;
  } else if (position > 2000) {
    position = 2000;
  }
  return position;
};

/**
 * Exports
 */

/**
 *  Given a point in screen pixel coordinates
 *  a viewport width/height and an area
 *  size in pixel units it returns an
 *  area in android camera coordinates (-1000, 1000)
 *  -----------------------------------------------
 *  ---------------- IMPORTANT --------------------
 *  -----------------------------------------------
 *  The vieport size in DOM coordinates is reported with
 *  origin on the top-left corner of the screen with the
 *  device in portrait orientation. Camera coordinates
 *  use the top-left corner on landscape orientation
 *  The transformation of the coordinates take into account
 *  the different origins of coordinates.
 *
 *    Portrait           Landscape
 *  P ........ C     C ...............
 *    .      .         .             .
 *    .      .         .             .
 *    .      .         .             .
 *    .      .       P ...............
 *    ........
 *  P = Origin of Pixel Coordinates
 *  C = Origin of Camera Coordinates
 */
module.exports = function(x, y, viewportWidth, viewportHeight, focusAreaSide) {
  // In camera coordinate system, (-1000, -1000) represents the
  // top-left of the camera field of view, and (1000, 1000) represents
  // the bottom-right of the field of view. So, the Focus area should
  // start at -1000 and end at 1000.
  // For the convenience of avoiding negative values
  // we assume that coordinates go from 0 to 2000
  // We correct by substracting 1000 before returning the final value
  var cameraRange = 2000;

  // Using Square Focus area. In pixels
  var focusAreaHalfSide = focusAreaSide? focusAreaSide / 2 : 10;

  // How many camera units is one pixel?
  var cameraUnitsPerPixelWidth = cameraRange / viewportWidth;
  var cameraUnitsPerPixelHeight = cameraRange / viewportHeight;

  // Converts position to camera coordinates
  // Due to different origin of coordinates x in pixel coordinates
  // is the oposite in camera coordinates
  var xCameraCoordinates = cameraRange - x * cameraUnitsPerPixelWidth;
  var yCameraCoordinates = y * cameraUnitsPerPixelHeight;

  // Converts area size from pixel to camera units
  // Units break down below (do you remember your physics lectures?)
  // screen-pixels * (camera-units / screen-pixels) = camera-units
  var horizontalMargin = focusAreaHalfSide * cameraUnitsPerPixelWidth;
  var verticalMargin = focusAreaHalfSide * cameraUnitsPerPixelHeight;

  // Returns the area in camera coordinates after checking boundary conditions
  // This takes into account the different origins of coordinates as
  // described above
  return {
    left: clamp(yCameraCoordinates - verticalMargin) - 1000,
    right: clamp(yCameraCoordinates + verticalMargin) - 1000,
    top: clamp(xCameraCoordinates - horizontalMargin) - 1000,
    bottom: clamp(xCameraCoordinates + horizontalMargin) - 1000
  };

};

});

define('lib/convert-face-to-pixel-coordinates',['require','exports','module'],function(require, exports, module) {


/**
 * Exports
 */

/**
 *  Given a face coordinates as provided by camera controller and
 *  a viewport width and height it returns the face coordinates, diameter
 *  and area in pixel coordinates
 */
module.exports = function(face, viewportWidth, viewportHeight) {
  // In camera coordinate system, (-1000, -1000) represents the
  // top-left of the camera field of view, and (1000, 1000) represents
  // the bottom-right of the field of view.
  // For convenience we assume that coordinates go from 0-2000
  var cameraCoordinatesRange = 2000;

  var pixelsPerCameraUnitWidth = viewportWidth / cameraCoordinatesRange;
  var pixelsPerCameraUnitHeight = viewportHeight / cameraCoordinatesRange;
  var faceWidth = face.bounds.width * pixelsPerCameraUnitHeight;
  var faceHeight = face.bounds.height * pixelsPerCameraUnitWidth;
  var xCameraCoordinates = cameraCoordinatesRange - (face.bounds.bottom + 1000);
  var yCameraCoordinates = face.bounds.left + 1000;
  var xPixelCoordinates = xCameraCoordinates * pixelsPerCameraUnitWidth;
  var yPixelCoordinates = yCameraCoordinates * pixelsPerCameraUnitHeight;
  var diameter = Math.round(Math.max(faceWidth, faceHeight));
  return {
    x: xPixelCoordinates,
    y: yPixelCoordinates,
    diameter: diameter
  };

};

});

define('controllers/viewfinder',['require','exports','module','debug','lib/bind-all','views/focus','views/faces','lib/calculate-focus-area','lib/convert-face-to-pixel-coordinates'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:viewfinder');
var bindAll = require('lib/bind-all');
var FocusView = require('views/focus');
var FacesView = require('views/faces');
var calculateFocusArea = require('lib/calculate-focus-area');
var convertFaceToPixels = require('lib/convert-face-to-pixel-coordinates');

/**
 * Exports
 */

module.exports = function(app) { return new ViewfinderController(app); };
module.exports.ViewfinderController = ViewfinderController;

/**
 * Initialize a new `ViewfinderController`
 *
 * @param {App} app
 */
function ViewfinderController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.views = {};
  this.camera = app.camera;
  this.activity = app.activity;
  this.settings = app.settings;
  this.views.viewfinder = app.views.viewfinder;
  // Append focus ring to viewfinder
  this.views.focus = new FocusView();
  this.views.focus.appendTo(this.views.viewfinder.el);
  this.views.faces = new FacesView();
  this.views.faces.appendTo(this.views.viewfinder.el);
  this.bindEvents();
  this.configure();
  debug('initialized');
}

/**
 * Initial configuration.
 *
 * @private
 */
ViewfinderController.prototype.configure = function() {
  var settings = this.app.settings;
  var zoomSensitivity = settings.viewfinder.get('zoomGestureSensitivity');
  this.sensitivity = zoomSensitivity * window.innerWidth;
  this.configureScaleType();
  this.configureGrid();
};

/**
 * Configure the viewfinder scale type,
 * aspect fill/fit, depending on setting.
 *
 * @private
 */
ViewfinderController.prototype.configureScaleType = function() {
  var scaleType = this.app.settings.viewfinder.get('scaleType');
  this.views.viewfinder.scaleType = scaleType;
  debug('set scale type: %s', scaleType);
};

/**
 * Show/hide grid depending on currently
 * selected option.
 *
 * @private
 */
ViewfinderController.prototype.configureGrid = function() {
  var grid = this.app.settings.grid.selected('key');
  this.views.viewfinder.set('grid', grid);
};

/**
 * Hides the viewfinder frame-grid.
 *
 * @private
 */
ViewfinderController.prototype.hideGrid = function() {
  this.views.viewfinder.set('grid', 'off');
};

/**
 * Bind to relavant events.
 *
 * @private
 */
ViewfinderController.prototype.bindEvents = function() {
  this.app.settings.grid.on('change:selected',
    this.views.viewfinder.setter('grid'));

  this.views.viewfinder.on('click', this.app.firer('viewfinder:click'));
  this.views.viewfinder.on('click', this.onViewfinderClicked);

  this.camera.on('zoomchanged', this.onZoomChanged);
  this.camera.on('zoomconfigured', this.onZoomConfigured);
  this.app.on('camera:autofocuschanged', this.views.focus.showAutoFocusRing);
  this.app.on('camera:focusconfigured', this.onFocusConfigured);
  this.app.on('camera:focusstatechanged', this.views.focus.setFocusState);
  this.app.on('camera:facesdetected', this.onFacesDetected);
  this.app.on('camera:shutter', this.views.viewfinder.shutter);
  this.app.on('camera:busy', this.views.viewfinder.disable);
  this.app.on('camera:ready', this.views.viewfinder.enable);
  this.app.on('previewgallery:closed', this.onPreviewGalleryClosed);
  this.app.on('camera:configured', this.onCameraConfigured);
  this.app.on('previewgallery:opened', this.stopStream);
  this.app.on('settings:closed', this.configureGrid);
  this.app.on('settings:opened', this.hideGrid);
  this.app.on('hidden', this.stopStream);
  this.app.on('pinchchanged', this.onPinchChanged);
};

/**
 * Perform required viewfinder configuration
 * once the camera has configured.
 *
 * @private
 */
ViewfinderController.prototype.onCameraConfigured = function() {
  debug('configuring');
  this.startStream();
  this.configurePreview();

  // BUG: We have to use a 300ms timeout here
  // to conceal a Gecko rendering bug whereby the
  // video element appears not to have painted the
  // newly set dimensions before fading in.
  // https://bugzilla.mozilla.org/show_bug.cgi?id=982230
  if (!this.app.criticalPathDone) { this.show(); }
  else { setTimeout(this.show, 280); }
};

ViewfinderController.prototype.show = function() {
  this.views.viewfinder.fadeIn();
  this.app.emit('viewfinder:visible');
};

/**
 *  Sets appropiate flags when the camera focus is configured
 */
ViewfinderController.prototype.onFocusConfigured = function(config) {
  this.views.focus.setFocusMode(config.mode);
  this.touchFocusEnabled = config.touchFocus;
  this.views.faces.clear();
  if (config.maxDetectedFaces > 0) {
    this.views.faces.configure(config.maxDetectedFaces);
  }
};

ViewfinderController.prototype.onFacesDetected = function(faces) {
  var faceInPixels;
  var facesInPixels = [];
  var viewfinderSize =  this.views.viewfinder.getSize();
  var viewportHeight = viewfinderSize.height;
  var viewportWidth = viewfinderSize.width;

  faces.forEach(function(face, index) {
    // Face comes in camera coordinates from gecko
    faceInPixels = convertFaceToPixels(face, viewportWidth, viewportHeight);
    facesInPixels.push(faceInPixels);
  });
  this.views.faces.show();
  this.views.faces.render(facesInPixels);
};

/**
 * Starts the stream, only if
 * the app is currently visible.
 *
 * @private
 */
ViewfinderController.prototype.onPreviewGalleryClosed = function() {
  if (this.app.hidden) { return; }
  this.startStream();
};

/**
 * Start the viewfinder stream flowing
 * with the current camera configuration.
 *
 * This indirectly enforces a screen wakelock,
 * meaning the device is unable to go to sleep.
 *
 * We don't want the stream to start flowing if
 * the preview-gallery is open, as this prevents
 * the device falling asleep.
 *
 * @private
 */
ViewfinderController.prototype.startStream = function() {
  if (this.app.get('previewGalleryOpen')) { return; }
  this.camera.loadStreamInto(this.views.viewfinder.els.video);
  debug('stream started');
};

/**
 * Stop the preview stream flowing.
 *
 * This indirectly removes the wakelock
 * that is magically enforced by the
 * flowing camera stream. Meaning the
 * device is able to go to sleep.
 *
 * @private
 */
ViewfinderController.prototype.stopStream = function() {
  this.views.viewfinder.stopStream();
  debug('stream stopped');
};

/**
 * Configure the size and postion
 * of the preview video stream.
 *
 * @private
 */
ViewfinderController.prototype.configurePreview = function() {
  var camera = this.app.settings.cameras.selected('key');
  var isFrontCamera = camera === 'front';
  var sensorAngle = this.camera.getSensorAngle();
  var previewSize = this.camera.previewSize();

  this.views.viewfinder.updatePreview(previewSize, sensorAngle, isFrontCamera);
};

/**
 * Configures the viewfinder
 * to the current camera.
 *
 * @private
 */
ViewfinderController.prototype.onZoomConfigured = function() {
  var zoomSupported = this.camera.isZoomSupported();
  var zoomEnabled = this.app.settings.zoom.enabled();
  var enableZoom = zoomSupported && zoomEnabled;

  if (!enableZoom) {
    this.views.viewfinder.disableZoom();
    return;
  }

  if (this.app.settings.zoom.get('useZoomPreviewAdjustment')) {
    this.views.viewfinder.enableZoomPreviewAdjustment();
  } else {
    this.views.viewfinder.disableZoomPreviewAdjustment();
  }

  var minimumZoom = this.camera.getMinimumZoom();
  var maximumZoom = this.camera.getMaximumZoom();

  this.views.viewfinder.enableZoom(minimumZoom, maximumZoom);
};

/**
 * Updates the zoom level on the camera
 * when the pinch changes.
 *
 * @private
 */
ViewfinderController.prototype.onPinchChanged = function(deltaPinch) {
  var zoom = this.views.viewfinder._zoom *
    (1 + (deltaPinch / this.sensitivity));
  this.views.viewfinder.setZoom(zoom);
  this.camera.setZoom(zoom);
};

/**
 * Responds to changes of the `zoom` value on the Camera to update the
 * view's internal state so that the pinch-to-zoom gesture can resume
 * zooming from the updated value. Also, updates the CSS scale transform
 * on the <video/> tag to compensate for zooming beyond the
 * `maxHardwareZoom` value.
 *
 * @param {Number} zoom
 */
ViewfinderController.prototype.onZoomChanged = function(zoom) {
  var zoomPreviewAdjustment = this.camera.getZoomPreviewAdjustment();
  this.views.viewfinder.setZoomPreviewAdjustment(zoomPreviewAdjustment);
  this.views.viewfinder.setZoom(zoom);
};

ViewfinderController.prototype.onViewfinderClicked = function(e) {
  if (!this.touchFocusEnabled) {
    return;
  }
  var focusPoint = {
    x: e.pageX,
    y: e.pageY
  };
  this.views.faces.hide();
  focusPoint.area = calculateFocusArea(
    focusPoint.x, focusPoint.y,
    this.views.viewfinder.el.clientWidth,
    this.views.viewfinder.el.clientHeight);
  this.views.focus.setPosition(focusPoint.x, focusPoint.y);
  this.app.emit('viewfinder:focuspointchanged', focusPoint);
};

});
/* exported Format */


/**
 * format.js: simple formatters and string utilities.
 */

var Format = {

  /**
   * Pads a string to the number of characters specified.
   * @param {String} input value to add padding to.
   * @param {Integer} len length to pad to.
   * @param {String} padWith char to pad with (defaults to " ").
   */
  padLeft: function(input, len, padWith) {
    padWith = padWith || ' ';

    var pad = len - (input + '').length;
    while (--pad > -1) {
      input = padWith + input;
    }
    return input;
  }
};

define("format", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.Format;
    };
}(this)));

define('lib/format-timer',['require','exports','module','format'],function(require, exports, module) {


var format = require('format');

/**
 * Dependencies
 */

function digits(value) {
  return format.padLeft(value, 2, '0');
}

/**
 * Exports
 */

module.exports = function(ms) {
  var totalSeconds = ms / 1000;
  var seconds = Math.round(totalSeconds % 60);
  var minutes = Math.floor(totalSeconds / 60);
  var hours;

  if (minutes < 60) {
    return digits(minutes) + ':' + digits(seconds);
  } else {
    hours = Math.floor(minutes / 60);
    minutes = Math.round(minutes % 60);
    return hours + ':' + digits(minutes) + ':' + digits(seconds);
  }

  return '';
};

});

define('views/recording-timer',['require','exports','module','debug','lib/format-timer','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:recording-timer');
var formatTimer = require('lib/format-timer');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'recording-timer',

  initialize: function() {
    this.value(0);
  },

  value: function(value) {
    this.el.textContent = formatTimer(value);
    debug('set value: %s', value);
  }
});

});

define('controllers/recording-timer',['require','exports','module','debug','views/recording-timer'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:recording-timer');
var RecordingTimerView = require('views/recording-timer');

/**
 * Exports
 */

module.exports = function(app) { return new RecordingTimerController(app); };
module.exports.RecordingTimerController = RecordingTimerController;

/**
 * Initialize a new `RecordingTimerController`
 *
 * Allow `this.view` to be mocked for testing
 *
 * @param {App} app
 */
function RecordingTimerController(app) {
  debug('initializing');
  this.onRecordingChange = this.onRecordingChange.bind(this);
  this.view = app.view || new RecordingTimerView();
  this.app = app;
  this.setup();
  this.bindEvents();
  debug('initialized');
}

/**
 * Inject the view into the app.
 *
 * @private
 */
RecordingTimerController.prototype.setup = function() {
  this.view.appendTo(this.app.el);
};

/**
 * Listen to relevant events.
 *
 * Toggle the visibility when
 * recording starts/stops.
 *
 * Update the time value when camera
 * recording time updates.
 *
 * @private
 */
RecordingTimerController.prototype.bindEvents = function() {
  this.app.on('change:recording', this.onRecordingChange);
  this.app.on('camera:recorderTimeUpdate', this.view.value);
  debug('events bound');
};

/**
 * Show the view when recording,
 * hide it when not.
 *
 * @param  {Boolean} recording
 * @private
 */
RecordingTimerController.prototype.onRecordingChange = function(recording) {
  debug('recording: %s', recording);
  if (!recording) {
    this.view.hide();
    return;
  }

  this.view.value(0);
  this.view.show();
};

});

define('views/overlay',['require','exports','module','vendor/view','lib/find','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');
var find = require('lib/find');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  className: 'overlay',

  initialize: function(options) {
    this.model = options.data;
    this.data('type', options.type);
    this.data('closable', options.closable);
    this.render();
  },

  render: function() {

    // Inject HTML
    this.el.innerHTML = this.template(this.model);

    // Pick out elements
    this.els.buttons = {
      close: find('.js-close-btn', this.el)
    };

    // Attach event listeners
    bind(this.els.buttons.close, 'click', this.onButtonClick);
  },

  template: function(data) {
    /*jshint maxlen:false*/
    return '<form role="dialog" data-type="confirm">' +
      '<section>' +
        '<h1 class="overlay-title">' + data.title + '</h1>' +
        '<p id="overlay-text">' + data.body + '</p>' +
      '</section>' +
      '<menu class="overlay-menu-close">' +
        '<button class="full js-close-btn" type="button" name="close-btn">' +
        data.closeButtonText + '</button>' +
      '</menu>' +
    '</form>';
  },

  data: function(key, value) {
    switch (arguments.length) {
      case 1: return this.el.getAttribute('data-' + key);
      case 2: this.el.setAttribute('data-' + key, value);
    }
  },

  onButtonClick: function(event) {
    var el = event.currentTarget;
    var name = el.getAttribute('name');
    this.emit('click:' + name);
  }
});

});

define('controllers/overlay',['require','exports','module','debug','views/overlay','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:overlay');
var Overlay = require('views/overlay');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new OverlayController(app); };
module.exports.OverlayController = OverlayController;

/**
 * Initialize a new `OverlayController`
 *
 * @param {App} app
 */
function OverlayController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.activity = app.activity;
  this.l10nGet = app.l10nGet;
  this.batteryOverlay = null;
  this.storageOverlay = null;
  this.bindEvents();
  debug('initialized');
}

OverlayController.prototype.bindEvents = function() {
  this.app.on('storage:changed', this.onStorageChanged);
  this.app.on('change:batteryStatus', this.onBatteryChanged);
};

/**
 * Respond to storage `statechange`
 * events by inserting or destroying
 * overlays from the app.
 *
 * @param  {String} value  ['nospace'|'shared'|'unavailable'|'available']
 */
OverlayController.prototype.onStorageChanged = function(state) {
  debug('storage changed: \'%s\'', state);

  if (this.storageOverlay) {
    this.storageOverlay.destroy();
    this.storageOverlay = null;
  }

  if (state !== 'available') {
    this.storageOverlay = this.createOverlay(state);
  }
};

/**
 * Respond to battery `statuschange`
 * events by inserting or destroying
 * overlays from the app.
 *
 * @param  {String} status  ['shutdown'|'critical'|'verylow'|'low']
 */
OverlayController.prototype.onBatteryChanged = function(state) {
  debug('battery state change: \'%s\'', state);

  if (this.batteryOverlay) {
    this.batteryOverlay.destroy();
    this.batteryOverlay = null;
  }

  if (state === 'shutdown') {
    this.batteryOverlay = this.createOverlay(state);
  }
};

OverlayController.prototype.createOverlay = function(type) {
  var data = this.getOverlayData(type);
  var self = this;

  if (!data) { return; }

  var isClosable = this.activity.pick;
  var overlay = new Overlay({
    type: type,
    closable: isClosable,
    data: data
  });

  overlay
    .appendTo(document.body)
    .on('click:close-btn', function() {
      self.app.emit('activitycanceled');
    });

  debug('inserted \'%s\' overlay', type);
  return overlay;
};

/**
 * Get the overlay data required
 * to render a specific type of overlay.
 *
 * @param  {String} type
 * @return {Object}
 */
OverlayController.prototype.getOverlayData = function(type) {
  var data = {};

  switch (type) {
    case 'unavailable':
      data.title = this.l10nGet('nocard2-title');
      data.body = this.l10nGet('nocard3-text');
    break;
    case 'nospace':
      data.title = this.l10nGet('nospace2-title');
      data.body = this.l10nGet('nospace2-text');
    break;
    case 'shared':
      data.title = this.l10nGet('pluggedin2-title');
      data.body = this.l10nGet('pluggedin2-text');
    break;
    case 'shutdown':
      data.title = this.l10nGet('battery-shutdown-title');
      data.body = this.l10nGet('battery-shutdown-text');
    break;
    default:
      return false;
  }

  data.closeButtonText = this.l10nGet('close-button');

  return data;
};

});

define('lib/format-recorder-profiles',['require','exports','module'],function(require, exports, module) {


/**
 * Returns a formatted list of recorder
 * profiles ready to be set as setting options.
 *
 * Options:
 *
 *   - `exclude {Array}`
 *
 * @param  {Object} profiles
 * @param  {Object} options
 * @return {Array}
 */
module.exports = function(profiles, options) {
  var exclude = options && options.exclude || [];
  var formatted = [];
  var pixelSize;
  var profile;
  var video;

  for (var key in profiles) {
    profile = profiles[key];
    video = profile.video;

    // Don't include profile if marked as excluded
    if (exclude.indexOf(key) > -1) { continue; }

    pixelSize = video.width * video.height;

    formatted.push({
      key: key,
      title: key + ' ' + video.width + 'x' + video.height,
      pixelSize: pixelSize,
      raw: profile
    });
  }

  formatted.sort(function(a, b) { return b.pixelSize - a.pixelSize; });
  return formatted;
};

});

define('lib/format-picture-sizes',['require','exports','module'],function(require, exports, module) {


/**
 * Returns a formatted list of picture
 * sizes ready to be set as setting options.
 *
 * Options:
 *
 *   - `maxPixelSize {Number}`
 *   - `exclude {Array}`
 *
 * @param  {Array} sizes
 * @param  {Object} options
 * @return {Array}
 */
module.exports = function(sizes, options) {
  var maxPixelSize = options && options.maxPixelSize;
  var exclude = options && options.exclude || {};
  var formatted = [];

  exclude.aspects = exclude.aspects || [];
  exclude.keys = exclude.keys || [];

  sizes.forEach(function(size) {
    var w = size.width;
    var h = size.height;
    var key = w + 'x' + h;
    var pixelSize = w * h;

    size.aspect = getAspect(w, h);

    // Don't include pictureSizes above the maxPixelSize limit
    if (maxPixelSize && pixelSize > maxPixelSize) { return; }

    // Don't include picture size if marked as excluded
    if (exclude.keys.indexOf(key) > -1) { return; }
    if (exclude.aspects.indexOf(size.aspect) > -1) { return; }


    size.mp = getMP(w, h);

    formatted.push({
      key: key,
      pixelSize: pixelSize,
      data: size
    });
  });

  // Sort by pixel size
  formatted.sort(function(a, b) { return b.pixelSize - a.pixelSize; });
  return formatted;
};

/**
 * Returns rounded mega-pixel value.
 *
 * @param  {Number} w
 * @param  {Number} h
 * @return {Number}
 */
function getMP(w, h) {
  return Math.round((w * h) / 1000000);
}

/**
 * Returns aspect ratio string.
 *
 * Makes use of Euclid's GCD algorithm,
 * http://en.wikipedia.org/wiki/Euclidean_algorithm
 *
 * @param  {Number} w
 * @param  {Number} h
 * @return {String}
 */
function getAspect(w, h) {
  var gcd = function(a, b) { return (b === 0) ? a : gcd(b, a % b); };
  var divisor = gcd(w, h);
  return (w / divisor) + ':' + (h / divisor);
}

});

define('views/setting-options',['require','exports','module','debug','vendor/attach','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:setting-options');
var attach = require('vendor/attach');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'setting-options',

  initialize: function(options) {
    this.model = options.model;
    this.l10n = options.l10n || navigator.mozL10n;
    this.on('destroy', this.onDestroy);
    attach(this.el, 'click', 'li', this.onOptionClick);
    attach(this.el, 'click', '.js-back', this.firer('click:back'));
    this.model.on('change:selected', this.onSelectedChange);
    debug('initialized');
  },

  onDestroy: function() {
    this.model.off('change:selected', this.onSelectedChange);
  },

  onOptionClick: function(event, el) {
    var key = el.getAttribute('data-key');
    this.emit('click:option', key, this.model);
  },

  onSelectedChange: function(key) {
    var next = this.els[key];
    this.els.selected.classList.remove('selected');
    next.classList.add('selected');
    this.els.selected = next;
  },

  render: function() {
    var data = this.model.get();
    this.selectedKey = data.selected;
    this.el.innerHTML = this.template(data);
    this.els.ul = this.find('.js-list');

    // we need to pass a boolean flag indicating if the 
    // options should be localized
    var localizable = data.optionsLocalizable === false ? false : true;
    data.options.forEach(this.renderOption.bind(this, localizable));
    return this;
  },

  renderOption: function(localizable, option) {
    var li = document.createElement('li');
    var isSelected = option.key === this.selectedKey;

    li.textContent = localizable ? this.l10n.get(option.title) : option.title;
    li.setAttribute('data-key', option.key);
    li.className = 'setting-option icon-tick';
    this.els.ul.appendChild(li);
    this.els[option.key] = li;

    if (isSelected) {
      li.classList.add('selected');
      this.els.selected = li;
    }
  },

  template: function(data) {
    return '<div class="inner">' +
      '<h2 class="settings_title">' +
      '<button class="settings-back-btn icon-back-arrow js-back">' +
      '</button>' +
      this.l10n.get(data.header) + '</h2>' +
      '<div class="settings_items"><ul class="inner js-list"></ul></div>' +
    '</div>';
  }
});

});

define('views/setting',['require','exports','module','debug','vendor/view','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:setting');
var View = require('vendor/view');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  tag: 'li',
  name: 'setting',

  initialize: function(options) {
    this.l10n = options.l10n || navigator.mozL10n;
    this.model = options.model;
    this.model.on('change', this.render);
    this.on('destroy', this.onDestroy);
    this.el.classList.add(this.model.get('icon'));
    this.el.classList.add('test-' + this.model.get('title') + '-setting');
    bind(this.el, 'click', this.onClick);
  },

  onClick: function() {
    this.emit('click', this);
  },

  onDestroy: function() {
    this.model.off('change', this.render);
  },

  render: function() {
    var data = this.model.get();

    data.selected = this.model.selected();
    data.value = data.selected && data.selected.title;

    this.el.innerHTML = this.template(data);
    debug('rendered item %s', data.key);
    return this;
  },

  template: function(data) {
    var value;

    // some data items are not to be localized
    if (data.optionsLocalizable === false) {
      value = data.value;
    } else {
      value = this.l10n.get(data.value);
    }

    return '<div class="setting_text">' +
      '<h4 class="setting_title">' + this.l10n.get(data.title) + '</h4>' +
      '<h5 class="setting_value">' + value + '</h5>' +
    '</div>';
  },
});

});

define('views/settings',['require','exports','module','views/setting-options','debug','views/setting','vendor/view','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var OptionsView = require('views/setting-options');
var debug = require('debug')('view:settings');
var SettingView = require('views/setting');
var View = require('vendor/view');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'settings',

  initialize: function(options) {
    this.OptionsView = options.OptionsView || OptionsView;
    this.l10n = options.l10n || navigator.mozL10n;
    this.items = options.items;
    this.children = [];
    this.on('destroy', this.onDestroy);
    bind(this.el, 'click', this.onClick);
  },

  onClick: function(e) {
    e.stopPropagation();
  },

  onItemClick: function(view) {
    this.showSetting(view.model);
  },

  showSetting: function(model) {
    this.optionsView = new this.OptionsView({ model: model })
      .render()
      .appendTo(this.els.pane2)
      .on('click:option', this.firer('click:option'))
      .on('click:back', this.goBack);

    this.showPane(2);
  },

  onDestroy: function() {
    this.children.forEach(this.destroyChild);
    this.destroyOptionsView();
    debug('destroyed');
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.items = this.find('.js-items');
    this.els.pane2 = this.find('.js-pane-2');
    this.els.close = this.find('.js-close');
    bind(this.els.close, 'click', this.firer('click:close'));
    this.items.forEach(this.addItem);
    debug('rendered');
    return this;
  },

  goBack: function() {
    this.showPane(1);
    this.destroyOptionsView();
  },

  destroyChild: function(view) {
    view.destroy();
    debug('destroyed child');
  },

  destroyOptionsView: function() {
    if (this.optionsView) {
      this.optionsView.destroy();
      this.optionsView = null;
      debug('options view destroyed');
    }
  },

  addItem: function(model) {
    var setting = new SettingView({ model: model })
      .render()
      .appendTo(this.els.items)
      .on('click', this.onItemClick);

    this.children.push(setting);
    debug('add item key: %s', model.key);
  },

  showPane: function(name) {
    this.el.setAttribute('show-pane', 'pane-' + name);
  },

  template: function() {
    return '<div class="pane pane-1">' +
      '<div class="inner">' +
        '<div class="settings_inner">' +
          '<h2 class="settings_title">' + this.l10n.get('options') + '</h2>' +
          '<div class="settings_items"><ul class="inner js-items"></ul></div>' +
        '</div>' +
      '</div>' +
    '</div>' +
    '<div class="pane pane-2">' +
      '<div class="inner js-pane-2"></div>' +
    '</div>' +
    '<div class="settings_close icon-settings js-close"></div>';
  }
});

});

define('controllers/settings',['require','exports','module','lib/format-recorder-profiles','lib/format-picture-sizes','debug','views/settings','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var formatRecorderProfiles = require('lib/format-recorder-profiles');
var formatPictureSizes = require('lib/format-picture-sizes');
var debug = require('debug')('controller:settings');
var SettingsView = require('views/settings');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new SettingsController(app); };
module.exports.SettingsController = SettingsController;

/**
 * Initialize a new `SettingsController`
 *
 * @constructor
 * @param {App} app
 */
function SettingsController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.settings = app.settings;
  this.activity = app.activity;
  this.notification = app.views.notification;
  this.l10nGet = app.l10nGet;

  // Allow test stubs
  this.nav = app.nav || navigator;
  this.SettingsView = app.SettingsView || SettingsView;
  this.formatPictureSizes = app.formatPictureSizes || formatPictureSizes;
  this.formatRecorderProfiles = app.formatRecorderProfiles ||
    formatRecorderProfiles;

  this.configure();
  this.bindEvents();
  debug('initialized');
}

/**
 * Registers settings 'aliases' that provide
 * a single interface for settings such as
 * `flashModes` where we have `flashModesPicture`
 * and `flashModesVideo`.
 *
 * This means that we can just use settings.flashModes,
 * and be confident that it will interface with the
 * correct setting depending on the value of `mode`.
 *
 * You can always use the underlying settings
 * directly if you need that kind of control.
 * @return {[type]} [description]
 */
SettingsController.prototype.configure = function() {
  this.settings.alias('recorderProfiles', this.aliases.recorderProfiles);
  this.settings.alias('pictureSizes', this.aliases.pictureSizes);
  this.settings.alias('flashModes', this.aliases.flashModes);
};

/**
 * Bind to app events.
 *
 * @private
 */
SettingsController.prototype.bindEvents = function() {
  this.app.on('localized', this.formatPictureSizeTitles);
  this.app.on('settings:toggle', this.toggleSettings);
  this.app.on('camera:newcamera', this.onNewCamera);
  this.app.on('activity:pick', this.onPickActivity);
};

/**
 * Toggle the settings menu open/closed.
 *
 * @private
 */
SettingsController.prototype.toggleSettings = function() {
  if (this.view) { this.closeSettings(); }
  else { this.openSettings(); }
};

/**
 * Render and display the settings menu.
 *
 * We use settings.menu() to retrieve
 * and ordered list of settings that
 * have a `menu` property.
 *
 * @private
 */
SettingsController.prototype.openSettings = function() {
  debug('open settings');
  if (this.view) { return; }

  var items = this.menuItems();
  this.view = new this.SettingsView({ items: items })
    .render()
    .appendTo(this.app.el)
    .on('click:close', this.closeSettings)
    .on('click:option', this.onOptionTap);

  this.app.emit('settings:opened');
  debug('settings opened');
};

/**
 * Destroy the settings menu.
 *
 * @private
 */
SettingsController.prototype.closeSettings = function() {
  debug('close settings');
  if (!this.view) { return; }
  this.view.destroy();
  this.view = null;
  this.app.emit('settings:closed');
  debug('settings closed');
};

/**
 * Selects the option that was
 * clicked on the setting.
 *
 * @param  {String} key
 * @param  {Setting} setting
 * @private
 */
SettingsController.prototype.onOptionTap = function(key, setting) {
  var flashMode = this.settings.flashModesPicture.selected('key');
  var ishdrOn = setting.key === 'hdr' && key === 'on';
  var flashDeactivated = flashMode !== 'off' && ishdrOn;

  setting.select(key);
  this.closeSettings();
  this.notify(setting, flashDeactivated);
};

/**
 * Adjusts settings to meet requirements
 * on new pick activity.
 *
 * @param  {Object} data
 * @private
 */
SettingsController.prototype.onPickActivity = function(data) {
  debug('pick activity', data);

  var maxFileSize = data.maxFileSizeBytes;
  var maxPixelSize = data.maxPixelSize;

  // Settings changes made in 'pick'
  // sessions shouldn't persist.
  this.settings.dontSave();

  if (maxPixelSize) {
    this.settings.pictureSizesFront.set('maxPixelSize', maxPixelSize);
    this.settings.pictureSizesBack.set('maxPixelSize', maxPixelSize);
    debug('set maxPixelSize: %s', maxPixelSize);
  }

  if (maxFileSize) {
    this.settings.recorderProfilesFront.set('maxFileSizeBytes', maxFileSize);
    this.settings.recorderProfilesBack.set('maxFileSizeBytes', maxFileSize);
    debug('set maxFileSize: %s', maxFileSize);
  }
};

/**
 * Display a notifcation showing the
 * current state of the given setting.
 *
 * If `notification` is `false in config
 * for a setting then we don't show one.
 *
 * @param  {Setting} setting
 * @private
 */
SettingsController.prototype.notify = function(setting, flashDeactivated) {
  var dontNotify = setting.get('notifications') === false;
  if (dontNotify) { return; }

  var optionTitle = this.l10nGet(setting.selected('title'));
  var title = this.l10nGet(setting.get('title'));
  var html;

  // Check if the `flashMode` setting is going to be deactivated as part
  // of the change in the `hdr` setting and display a specialized
  // notification if that is the case
  if (flashDeactivated) {
    html = title + ' ' + optionTitle + '<br/>' +
      this.l10nGet('flash-deactivated');
  } else {
    html = title + '<br/>' + optionTitle;
  }

  this.notification.display({ text: html });
};

/**
 * When the hardware capabilities change
 * we update the available options for
 * each setting to match what is available.
 *
 * The rest of the app should listen for
 * the 'settings:configured' event as an
 * indication to update UI etc.
 *
 * @param  {Object} capabilities
 */
SettingsController.prototype.onNewCamera = function(capabilities) {
  debug('new capabilities');

  this.settings.hdr.filterOptions(capabilities.hdr);
  this.settings.flashModesPicture.filterOptions(capabilities.flashModes);
  this.settings.flashModesVideo.filterOptions(capabilities.flashModes);

  this.configurePictureSizes(capabilities.pictureSizes);
  this.configureRecorderProfiles(capabilities.recorderProfiles);

  // Let the rest of the app know we're good to go.
  this.app.emit('settings:configured');
  debug('settings configured to new capabilities');
};

/**
 * Formats the raw pictureSizes into
 * a format that Setting class can
 * work with, then resets the pictureSize
 * options.
 *
 * @param  {Array} sizes
 */
SettingsController.prototype.configurePictureSizes = function(sizes) {
  debug('configuring picture sizes');
  var setting = this.settings.pictureSizes;
  var maxPixelSize = window.CONFIG_MAX_IMAGE_PIXEL_SIZE;
  var exclude = setting.get('exclude');
  var options = {
    exclude: exclude,
    maxPixelSize: maxPixelSize
  };

  var formatted = this.formatPictureSizes(sizes, options);
  setting.resetOptions(formatted);
  this.formatPictureSizeTitles();
  debug('configured pictureSizes', setting.selected('key'));
};

/**
 * Formats the raw recorderProfiles
 * into a format that Setting class can
 * work with, then resets the recorderProfile
 * options.
 *
 * @param  {Array} sizes
 */
SettingsController.prototype.configureRecorderProfiles = function(sizes) {
  var setting = this.settings.recorderProfiles;
  var maxFileSize = setting.get('maxFileSizeBytes');
  var exclude = setting.get('exclude');
  var options = { exclude: exclude };
  var formatted = this.formatRecorderProfiles(sizes, options);

  // If a file size limit has been imposed,
  // pick the lowest-res (last) profile only.
  if (maxFileSize) { formatted = [formatted[formatted.length - 1]]; }

  setting.resetOptions(formatted);
};

/**
 * Creates a localized `title` property
 * on each pictureSize option. This is
 * used within the settings-menu.
 *
 * This is run each time `configurePictureSizes`
 * is run and each time the app recieves a
 * 'localized' event.
 *
 * If the app isn't 'localized' yet, we don't do
 * anything and wait for the 'localized'
 * event binding to run the function.
 *
 * @private
 */
SettingsController.prototype.formatPictureSizeTitles = function() {
  if (!this.app.localized()) { return; }
  var options = this.settings.pictureSizes.get('options');
  var MP = this.l10nGet('mp');

  options.forEach(function(size) {
    var data = size.data;
    var mp = data.mp ? data.mp + MP + ' ' : '';
    size.title = mp + data.width + 'x' + data.height + ' ' + data.aspect;
  });

  debug('picture size titles formatted');
};

/**
 * Returns a list of settings
 * based on the `settingsMenu`
 * configuration.
 *
 * @return {Array}
 */
SettingsController.prototype.menuItems = function() {
  var items = this.settings.settingsMenu.get('items');
  return items.filter(this.validMenuItem, this)
    .map(function(item) { return this.settings[item.key]; }, this);
};

/**
 * Tests if the passed `settingsMenu`
 * item is allowed in the settings menu.
 *
 * @param  {Object} item
 * @return {Boolean}
 */
SettingsController.prototype.validMenuItem = function(item) {
  var setting = this.settings[item.key];
  return !!setting && setting.supported();
};

/**
 * Settings aliases provide
 * convenient pointers to
 * specific settings based on
 * the state of other settings.
 *
 * @type {Object}
 */
SettingsController.prototype.aliases = {
  recorderProfiles: {
    map: {
      back: 'recorderProfilesBack',
      front: 'recorderProfilesFront'
    },
    get: function() {
      var camera = this.settings.cameras.selected('key');
      return this.settings[this.map[camera]];
    }
  },
  pictureSizes: {
    map: {
      back: 'pictureSizesBack',
      front: 'pictureSizesFront'
    },
    get: function() {
      var camera = this.settings.cameras.selected('key');
      return this.settings[this.map[camera]];
    }
  },
  flashModes: {
    map: {
      video: 'flashModesVideo',
      picture: 'flashModesPicture'
    },
    get: function() {
      var mode = this.settings.mode.selected('key');
      return this.settings[this.map[mode]];
    }
  }
};

});

define('lib/bytes-to-pixels',['require','exports','module'],function(require, exports, module) {


module.exports = function(bytes) {
  var bytesPerPixel = 3;
  var avgJpegCompression = window.CONFIG_AVG_JPEG_COMPRESSION_RATIO || 8;
  var uncompressedBytes = bytes * avgJpegCompression;
  return Math.round(uncompressedBytes / bytesPerPixel);
};

});
/* globals indexedDB */
/**
 * This file defines an asynchronous version of the localStorage API, backed by
 * an IndexedDB database.  It creates a global asyncStorage object that has
 * methods like the localStorage object.
 *
 * To store a value use setItem:
 *
 *   asyncStorage.setItem('key', 'value');
 *
 * If you want confirmation that the value has been stored, pass a callback
 * function as the third argument:
 *
 *  asyncStorage.setItem('key', 'newvalue', function() {
 *    console.log('new value stored');
 *  });
 *
 * To read a value, call getItem(), but note that you must supply a callback
 * function that the value will be passed to asynchronously:
 *
 *  asyncStorage.getItem('key', function(value) {
 *    console.log('The value of key is:', value);
 *  });
 *
 * Note that unlike localStorage, asyncStorage does not allow you to store and
 * retrieve values by setting and querying properties directly. You cannot just
 * write asyncStorage.key; you have to explicitly call setItem() or getItem().
 *
 * removeItem(), clear(), length(), and key() are like the same-named methods of
 * localStorage, but, like getItem() and setItem() they take a callback
 * argument.
 *
 * The asynchronous nature of getItem() makes it tricky to retrieve multiple
 * values. But unlike localStorage, asyncStorage does not require the values you
 * store to be strings.  So if you need to save multiple values and want to
 * retrieve them together, in a single asynchronous operation, just group the
 * values into a single object. The properties of this object may not include
 * DOM elements, but they may include things like Blobs and typed arrays.
 *
 * Unit tests are in apps/gallery/test/unit/asyncStorage_test.js
 */

this.asyncStorage = (function() {
  

  var DBNAME = 'asyncStorage';
  var DBVERSION = 1;
  var STORENAME = 'keyvaluepairs';
  var db = null;

  function withDatabase(f) {
    if (db) {
      f();
    } else {
      var openreq = indexedDB.open(DBNAME, DBVERSION);
      openreq.onerror = function withStoreOnError() {
        console.error('asyncStorage: can\'t open database:',
            openreq.error.name);
      };
      openreq.onupgradeneeded = function withStoreOnUpgradeNeeded() {
        // First time setup: create an empty object store
        openreq.result.createObjectStore(STORENAME);
      };
      openreq.onsuccess = function withStoreOnSuccess() {
        db = openreq.result;
        f();
      };
    }
  }

  function withStore(type, callback, oncomplete) {
    withDatabase(function() {
      var transaction = db.transaction(STORENAME, type);
      if (oncomplete) {
        transaction.oncomplete = oncomplete;
      }
      callback(transaction.objectStore(STORENAME));
    });
  }

  function getItem(key, callback) {
    var req;
    withStore('readonly', function getItemBody(store) {
      req = store.get(key);
      req.onerror = function getItemOnError() {
        console.error('Error in asyncStorage.getItem(): ', req.error.name);
      };
    }, function onComplete() {
      var value = req.result;
      if (value === undefined) {
        value = null;
      }
      callback(value);
    });
  }

  function setItem(key, value, callback) {
    withStore('readwrite', function setItemBody(store) {
      var req = store.put(value, key);
      req.onerror = function setItemOnError() {
        console.error('Error in asyncStorage.setItem(): ', req.error.name);
      };
    }, callback);
  }

  function removeItem(key, callback) {
    withStore('readwrite', function removeItemBody(store) {
      var req = store.delete(key);
      req.onerror = function removeItemOnError() {
        console.error('Error in asyncStorage.removeItem(): ', req.error.name);
      };
    }, callback);
  }

  function clear(callback) {
    withStore('readwrite', function clearBody(store) {
      var req = store.clear();
      req.onerror = function clearOnError() {
        console.error('Error in asyncStorage.clear(): ', req.error.name);
      };
    }, callback);
  }

  function length(callback) {
    var req;
    withStore('readonly', function lengthBody(store) {
      req = store.count();
      req.onerror = function lengthOnError() {
        console.error('Error in asyncStorage.length(): ', req.error.name);
      };
    }, function onComplete() {
      callback(req.result);
    });
  }

  function key(n, callback) {
    if (n < 0) {
      callback(null);
      return;
    }

    var req;
    withStore('readonly', function keyBody(store) {
      var advanced = false;
      req = store.openCursor();
      req.onsuccess = function keyOnSuccess() {
        var cursor = req.result;
        if (!cursor) {
          // this means there weren't enough keys
          return;
        }
        if (n === 0 || advanced) {
          // Either 1) we have the first key, return it if that's what they
          // wanted, or 2) we've got the nth key.
          return;
        }

        // Otherwise, ask the cursor to skip ahead n records
        advanced = true;
        cursor.advance(n);
      };
      req.onerror = function keyOnError() {
        console.error('Error in asyncStorage.key(): ', req.error.name);
      };
    }, function onComplete() {
      var cursor = req.result;
      callback(cursor ? cursor.key : null);
    });
  }

  return {
    getItem: getItem,
    setItem: setItem,
    removeItem: removeItem,
    clear: clear,
    length: length,
    key: key
  };
}());


define("asyncStorage", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.asyncStorage;
    };
}(this)));

define('lib/dcf',['require','exports','module','asyncStorage','debug','format'],function(require, exports, module) {


// This handles the logic pertaining to the naming of files according
// to the Design rule for Camera File System
// * http://en.wikipedia.org/wiki/Design_rule_for_Camera_File_system

/**
 * Dependencies
 */

var asyncStorage = require('asyncStorage');
var debug = require('debug')('dcf');
var format = require('format');

/**
 * Locals
 */

var dcfConfigLoaded = false;
var deferredArgs = null;
var defaultSeq = {file: 1, dir: 100};
var dcfConfig = {
  key: 'dcf_key',
  seq: null,
  postFix: 'MZLLA',
  prefix: {video: 'VID_', image: 'IMG_'},
  ext: {video: '3gp', image: 'jpg'}
};

exports.init = function() {
  debug('initializing');
  asyncStorage.getItem(dcfConfig.key, function(value) {
    dcfConfigLoaded = true;
    dcfConfig.seq = value ? value : defaultSeq;

    // We have a previous call to createDCFFilename that is waiting for
    // a response, fire it again
    if (deferredArgs) {
      var args = deferredArgs;
      exports.createDCFFilename(args.storage, args.type, args.callback);
      deferredArgs = null;
    }

    debug('initialized');
  });
};

exports.createDCFFilename = function(storage, type, callback) {

  // We havent loaded the current counters from indexedDB yet, defer
  // the call
  if (!dcfConfigLoaded) {
    deferredArgs = {storage: storage, type: type, callback: callback};
    return;
  }

  var dir = 'DCIM/' + dcfConfig.seq.dir + dcfConfig.postFix + '/';
  var filename = dcfConfig.prefix[type] +
    format.padLeft(dcfConfig.seq.file, 4, '0') + '.' +
    dcfConfig.ext[type];
  var filepath = dir + filename;

  // A file with this name may have been written by the user or
  // our indexeddb sequence tracker was cleared, check we wont overwrite
  // anything
  var req = storage.get(filepath);

  // A file existed, we bump the directory then try to generate a
  // new filename
  req.onsuccess = function() {
    dcfConfig.seq.file = 1;
    dcfConfig.seq.dir += 1;
    asyncStorage.setItem(dcfConfig.key, dcfConfig.seq, function() {
      exports.createDCFFilename(storage, type, callback);
    });
  };

  // No file existed, we are good to go
  req.onerror = function() {
    if (dcfConfig.seq.file < 9999) {
      dcfConfig.seq.file += 1;
    } else {
      dcfConfig.seq.file = 1;
      dcfConfig.seq.dir += 1;
    }
    asyncStorage.setItem(dcfConfig.key, dcfConfig.seq, function() {
      callback(filepath, filename, dir);
    });
  };
};

});

define('lib/storage',['require','exports','module','debug','lib/bind-all','vendor/evt','lib/dcf'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('storage');
var bindAll = require('lib/bind-all');
var events = require('vendor/evt');
var dcf = require('lib/dcf');

/**
 * Locals
 */

var createFilename = dcf.createDCFFilename;

/**
 * Expose `Storage`
 */

module.exports = Storage;

/**
 * Mixin event emitter
 */

events(Storage.prototype);

/**
 * Initialize a new `Storage`.
 *
 * @param {Object} options
 */
function Storage(options) {
  bindAll(this);
  this.maxFileSize = 0;
  options = options || {};
  this.video = navigator.getDeviceStorage('videos');
  this.picture = navigator.getDeviceStorage('pictures');
  this.picture.addEventListener('change', this.onStorageChange);
  this.createFilename = options.createFilename || createFilename; // test hook
  dcf.init();
  debug('initialized');
}

/**
 * Save the image Blob to DeviceStorage
 * then lookup the File reference and
 * return that in the callback as well
 * as the resulting paths.
 *
 * You always want to forget about the
 * Blob you told us about and use the
 * File instead since otherwise you
 * are wasting precious memory.
 *
 * @param {Object} [options]
 * @param {String} options.filepath
 *   The path to save the image to.
 */
Storage.prototype.addPicture = function(blob, options, done) {
  if (typeof options === 'function') {
    done = options;
    options = {};
  }

  done = done || function() {};
  var filepath = options && options.filepath;
  var self = this;
  debug('add picture', filepath);

  // Create a filepath if
  // one hasn't been given.
  if (!filepath) {
    debug('creating filename');
    this.createFilename(this.picture, 'image', onCreated);
  } else {
    onCreated(filepath);
  }

  function onCreated(filepath) {
    var req = self.picture.addNamed(blob, filepath);
    req.onerror = function() { self.emit('error'); };
    req.onsuccess = function(e) {
      debug('image stored', filepath);
      var absolutePath = e.target.result;

      // `addNamed` does not give us a File
      // handle so we need to get() it again.
      refetchFile(filepath, absolutePath);
    };
  }

  function refetchFile(filepath, absolutePath) {
    var req = self.picture.get(filepath);
    req.onerror = function() { self.emit('error'); };
    req.onsuccess = function(e) {
      debug('image file blob handle retrieved');
      var fileBlob = e.target.result;
      done(filepath, absolutePath, fileBlob);
    };
  }
};

/**
 * Create a new video filepath.
 *
 * The CameraControl API will not
 * automatically create directories
 * for the new file if they do not
 * exist.
 *
 * So we write a dummy file to the
 * same directory via DeviceStorage
 * to ensure that the directory exists
 * before attempting to record to this
 * filepath.
 *
 * @param  {Function} done
 * @public
 */
Storage.prototype.createVideoFilepath = function(done) {
  var videoStorage = this.video;
  this.createFilename(this.video, 'video', function(filepath) {
    var dummyFilepath = getDir(filepath) + 'tmp.3gp';
    var blob = new Blob([''], { type: 'video/3gpp' });
    var req = videoStorage.addNamed(blob, dummyFilepath);
    req.onsuccess = function(e) {
      videoStorage.delete(e.target.result);
      done(filepath);
    };
  });
};

Storage.prototype.onStorageChange = function(e) {
  debug('state change: %s', e.reason);
  var value = e.reason;

  // Emit an `itemdeleted` event to
  // allow parts of the UI to update.
  if (value === 'deleted') {
    var filepath = this.checkFilepath(e.path);
    this.emit('itemdeleted', { path: filepath });
  } else {
    this.setState(value);
  }

  // Check storage
  // has spare capacity
  this.check();
};

Storage.prototype.checkFilepath = function(filepath) {
  var startString = filepath.indexOf('DCIM/');

  if (startString < -1) { return; }
  else if (startString > 0) {
    filepath = filepath.substr(startString);
  }

  // Check whether filepath is a video poster image or not. If filepath
  // contains 'VID' and ends with '.jpg', consider it a video poster
  // image and get the video filepath by changing '.jpg' to '.3gp'
  if (filepath.indexOf('VID') != -1 &&
      filepath.lastIndexOf('.jpg') === filepath.length - 4) {
    filepath = filepath.replace('.jpg', '.3gp');
  }

  return filepath;
};

Storage.prototype.setState = function(value) {
  this.state = value;
  debug('set state: %s', value);
  this.emit('changed', value);
};

Storage.prototype.setMaxFileSize = function(maxFileSize) {
  this.maxFileSize = maxFileSize;
  this.check();
  debug('max file size set: %d', maxFileSize);
};

/**
 * Run a full storage check.
 *
 * @param  {Function} done
 * @public
 */
Storage.prototype.check = function(done) {
  debug('check');

  var self = this;
  done = done || function() {};

  this.getState(function(result) {
    self.setState(result);

    if (!self.available()) {
      onComplete('unhealthy');
      return;
    }

    self.isSpace(function(result) {
      if (!result) { self.setState('nospace'); }
      onComplete('healthy');
    });
  });

  function onComplete(state) {
    self.emit('checked', state);
  }
};

/**
 * Checks if there is enough space to
 * accomdate the current `maxFileSize`.
 *
 * @param  {Function} done
 */
Storage.prototype.isSpace = function(done) {
  var maxFileSize = this.maxFileSize;
  this.picture
    .freeSpace()
    .onsuccess = function(e) {
      var freeSpace = e.target.result;
      var result = freeSpace > maxFileSize;
      debug('is space: %s', result, freeSpace, maxFileSize);
      done(result);
    };
};

/**
 * Get current storage state.
 *
 * @param  {Function} done
 */
Storage.prototype.getState = function(done) {
  this.picture
    .available()
    .onsuccess = function(e) {
      done(e.target.result);
    };
};

/**
 * States if sotrage is available.
 *
 * @return {Boolean}
 */
Storage.prototype.available = function() {
  return this.state === 'available';
};

/**
 * Delete a picture.
 *
 * @param  {String} filepath
 */
Storage.prototype.deletePicture = function(filepath) {
  this.picture.delete(filepath).onerror = function(e) {
    console.warn(
      'Failed to delete', filepath,
      'from DeviceStorage:', e.target.error);
  };
};

/**
 * Delete a video and accompanying
 * poster image.
 *
 * @param  {String} filepath
 */
Storage.prototype.deleteVideo = function(filepath) {
  var poster = filepath.replace('.3gp', '.jpg');

  this.video.delete(filepath).onerror = function(e) {
    console.warn(
      'Failed to delete', filepath,
      'from DeviceStorage:', e.target.error);
  };

  this.picture.delete(poster).onerror = function(e) {
    console.warn(
      'Failed to delete poster image', poster,
      'for video', filepath,
      'from DeviceStorage:', e.target.error);
  };
};

/**
 * Get the directory from a filepath.
 *
 * @param  {String} filepath
 * @return {String}
 */
function getDir(filepath) {
  var index = filepath.lastIndexOf('/') + 1;
  return index ? filepath.substring(0, index) : '';
}

});



//
// This file defines a single function that asynchronously reads a
// JPEG file (or blob) to determine its width and height and find the
// location and size of the embedded preview image, if it has one. If
// it succeeds, it passes an object containing this data to the
// specified callback function. If it fails, it passes an error message
// to the specified error function instead.
//
// This function is capable of parsing and returning EXIF data for a
// JPEG file, but for speed, it ignores all EXIF data except the embedded
// preview image and the image orientation.
//
// This function requires the BlobView utility class
//
function parseJPEGMetadata(file, metadataCallback, metadataError) {
  // This is the object we'll pass to metadataCallback
  var metadata = {};

  // Start off reading a 16kb slice of the JPEG file.
  // Hopefully, this will be all we need and everything else will
  // be synchronous
  BlobView.get(file, 0, Math.min(16 * 1024, file.size), function(data) {
    if (data.byteLength < 2 ||
        data.getUint8(0) !== 0xFF ||
        data.getUint8(1) !== 0xD8) {
      metadataError('Not a JPEG file');
      return;
    }

    // Now start reading JPEG segments
    // getSegment() and segmentHandler() are defined below.
    getSegment(data, 2, segmentHandler);
  });

  // Read the JPEG segment at the specified offset and
  // pass it to the callback function.
  // Offset is relative to the current data offsets.
  // We assume that data has enough data in it that we can
  // can determine the size of the segment, and we guarantee that
  // we read extra bytes so the next call works
  function getSegment(data, offset, callback) {
    try {
      var header = data.getUint8(offset);
      if (header !== 0xFF) {
        metadataError('Malformed JPEG file: bad segment header');
        return;
      }

      var type = data.getUint8(offset + 1);
      var size = data.getUint16(offset + 2) + 2;

      // the absolute position of the segment
      var start = data.sliceOffset + data.viewOffset + offset;
      // If this isn't the last segment in the file, add 4 bytes
      // so we can read the size of the next segment
      var isLast = (start + size >= file.size);
      var length = isLast ? size : size + 4;

      data.getMore(start, length,
                   function(data) {
                     callback(type, size, data, isLast);
                   });
    }
    catch (e) {
      metadataError(e.toString() + '\n' + e.stack);
    }
  }

  // This is a callback function for getNextSegment that handles the
  // various types of segments we expect to see in a jpeg file
  function segmentHandler(type, size, data, isLastSegment) {
    try {
      switch (type) {
      case 0xC0:  // Some actual image data, including image dimensions
      case 0xC1:
      case 0xC2:
      case 0xC3:
        // Get image dimensions
        metadata.height = data.getUint16(5);
        metadata.width = data.getUint16(7);

        // We're done. All the EXIF data will come before this segment
        // So call the callback
        metadataCallback(metadata);
        break;

      case 0xE1:  // APP1 segment. Probably holds EXIF metadata
        parseAPP1(data);
        /* fallthrough */

      default:
        // A segment we don't care about, so just go on and read the next one
        if (isLastSegment) {
          metadataError('unexpected end of JPEG file');
          return;
        }
        getSegment(data, size, segmentHandler);
      }
    }
    catch (e) {
      metadataError(e.toString() + '\n' + e.stack);
    }
  }

  function parseAPP1(data) {
    if (data.getUint32(4, false) === 0x45786966) { // "Exif"
      var exif = parseEXIFData(data);

      if (exif.THUMBNAIL && exif.THUMBNAILLENGTH) {
        var start = data.sliceOffset + data.viewOffset + 10 + exif.THUMBNAIL;
        metadata.preview = {
          start: start,
          end: start + exif.THUMBNAILLENGTH
        };
      }

      // map exif orientation flags for easy transforms
      switch (exif.ORIENTATION) {
        case undefined:
        case 1:
          metadata.rotation = 0;
          metadata.mirrored = false;
          break;
        case 2:
          metadata.rotation = 0;
          metadata.mirrored = true;
          break;
        case 3:
          metadata.rotation = 180;
          metadata.mirrored = false;
          break;
        case 4:
          metadata.rotation = 180;
          metadata.mirrored = true;
          break;
        case 5:
          metadata.rotation = 90;
          metadata.mirrored = true;
          break;
        case 6:
          metadata.rotation = 90;
          metadata.mirrored = false;
          break;
        case 7:
          metadata.rotation = 270;
          metadata.mirrored = true;
          break;
        case 8:
          metadata.rotation = 270;
          metadata.mirrored = false;
          break;
        default:
          throw Error('Unknown Exif code for orientation');
      }
    }
  }

  // Parse an EXIF segment from a JPEG file and return an object
  // of metadata attributes. The argument must be a DataView object
  function parseEXIFData(data) {
    var exif = {};

    var byteorder = data.getUint8(10);
    if (byteorder === 0x4D) {  // big endian
      byteorder = false;
    } else if (byteorder === 0x49) {  // little endian
      byteorder = true;
    } else {
      throw Error('invalid byteorder in EXIF segment');
    }

    if (data.getUint16(12, byteorder) !== 42) { // magic number
      throw Error('bad magic number in EXIF segment');
    }

    var offset = data.getUint32(14, byteorder);

     // This is how we would parse all EXIF metadata more generally.
     // Especially need for iamge orientation
    parseIFD(data, offset + 10, byteorder, exif, true);

    // I'm leaving this code in as a comment in case we need other EXIF
    // data in the future.
    // if (exif.EXIFIFD) {
    //   parseIFD(data, exif.EXIFIFD + 10, byteorder, exif);
    //   delete exif.EXIFIFD;
    // }

    // if (exif.GPSIFD) {
    //   parseIFD(data, exif.GPSIFD + 10, byteorder, exif);
    //   delete exif.GPSIFD;
    // }

    // Instead of a general purpose EXIF parse, we're going to drill
    // down directly to the thumbnail image.
    // We're in IFD0 here. We want the offset of IFD1
    var ifd0entries = data.getUint16(offset + 10, byteorder);
    var ifd1 = data.getUint32(offset + 12 + 12 * ifd0entries, byteorder);
    // If there is an offset for IFD1, parse that
    if (ifd1 !== 0)
      parseIFD(data, ifd1 + 10, byteorder, exif, true);

    return exif;
  }

  function parseIFD(data, offset, byteorder, exif, onlyParseOne) {
    var numentries = data.getUint16(offset, byteorder);
    for (var i = 0; i < numentries; i++) {
      parseEntry(data, offset + 2 + 12 * i, byteorder, exif);
    }

    if (onlyParseOne)
      return;

    var next = data.getUint32(offset + 2 + 12 * numentries, byteorder);
    if (next !== 0 && next < file.size) {
      parseIFD(data, next + 10, byteorder, exif);
    }
  }

  // size, in bytes, of each TIFF data type
  var typesize = [
    0,   // Unused
    1,   // BYTE
    1,   // ASCII
    2,   // SHORT
    4,   // LONG
    8,   // RATIONAL
    1,   // SBYTE
    1,   // UNDEFINED
    2,   // SSHORT
    4,   // SLONG
    8,   // SRATIONAL
    4,   // FLOAT
    8    // DOUBLE
  ];

  // This object maps EXIF tag numbers to their names.
  // Only list the ones we want to bother parsing and returning.
  // All others will be ignored.
  var tagnames = {
    /*
     * We don't currently use any of these EXIF tags for anything.
     *
     *
     '256': 'ImageWidth',
     '257': 'ImageHeight',
     '40962': 'PixelXDimension',
     '40963': 'PixelYDimension',
     '306': 'DateTime',
     '315': 'Artist',
     '33432': 'Copyright',
     '36867': 'DateTimeOriginal',
     '33434': 'ExposureTime',
     '33437': 'FNumber',
     '34850': 'ExposureProgram',
     '34867': 'ISOSpeed',
     '37377': 'ShutterSpeedValue',
     '37378': 'ApertureValue',
     '37379': 'BrightnessValue',
     '37380': 'ExposureBiasValue',
     '37382': 'SubjectDistance',
     '37383': 'MeteringMode',
     '37384': 'LightSource',
     '37385': 'Flash',
     '37386': 'FocalLength',
     '41986': 'ExposureMode',
     '41987': 'WhiteBalance',
     '41991': 'GainControl',
     '41992': 'Contrast',
     '41993': 'Saturation',
     '41994': 'Sharpness',
    // These are special tags that we handle internally
     '34665': 'EXIFIFD',         // Offset of EXIF data
     '34853': 'GPSIFD',          // Offset of GPS data
    */
    '274' : 'ORIENTATION',
    '513': 'THUMBNAIL',         // Offset of thumbnail
    '514': 'THUMBNAILLENGTH'    // Length of thumbnail
  };

  function parseEntry(data, offset, byteorder, exif) {
    var tag = data.getUint16(offset, byteorder);
    var tagname = tagnames[tag];

    // If we don't know about this tag type or already processed it, skip it
    if (!tagname || exif[tagname])
      return;

    var type = data.getUint16(offset + 2, byteorder);
    var count = data.getUint32(offset + 4, byteorder);

    var total = count * typesize[type];
    var valueOffset = total <= 4 ? offset + 8 :
      data.getUint32(offset + 8, byteorder);
    exif[tagname] = parseValue(data, valueOffset, type, count, byteorder);
  }

  function parseValue(data, offset, type, count, byteorder) {
    if (type === 2) { // ASCII string
      var codes = [];
      for (var i = 0; i < count - 1; i++) {
        codes[i] = data.getUint8(offset + i);
      }
      return String.fromCharCode.apply(String, codes);
    } else {
      if (count == 1) {
        return parseOneValue(data, offset, type, byteorder);
      } else {
        var values = [];
        var size = typesize[type];
        for (var i = 0; i < count; i++) {
          values[i] = parseOneValue(data, offset + size * i, type, byteorder);
        }
        return values;
      }
    }
  }

  function parseOneValue(data, offset, type, byteorder) {
    switch (type) {
    case 1: // BYTE
    case 7: // UNDEFINED
      return data.getUint8(offset);
    case 2: // ASCII
      // This case is handed in parseValue
      return null;
    case 3: // SHORT
      return data.getUint16(offset, byteorder);
    case 4: // LONG
      return data.getUint32(offset, byteorder);
    case 5: // RATIONAL
      return data.getUint32(offset, byteorder) /
        data.getUint32(offset + 4, byteorder);
    case 6: // SBYTE
      return data.getInt8(offset);
    case 8: // SSHORT
      return data.getInt16(offset, byteorder);
    case 9: // SLONG
      return data.getInt32(offset, byteorder);
    case 10: // SRATIONAL
      return data.getInt32(offset, byteorder) /
        data.getInt32(offset + 4, byteorder);
    case 11: // FLOAT
      return data.getFloat32(offset, byteorder);
    case 12: // DOUBLE
      return data.getFloat64(offset, byteorder);
    }
    return null;
  }
}
;
define("jpegMetaDataParser", ["BlobView"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.parseJPEGMetadata;
    };
}(this)));

/* exported getImageSize */
/* global BlobView */
/* global parseJPEGMetadata */

/*
 * Determine the pixel dimensions of an image without actually
 * decoding the image. Passes an object of metadata to the callback
 * function on success or an error message to the error function on
 * failure. The metadata object will include type, width and height
 * properties. Supported image types are GIF, PNG and JPEG. JPEG
 * metadata may also include information about an EXIF preview image.
 *
 * Because of shortcomings in the way Gecko handles images, the
 * Gallery app will crash with an OOM error if it attempts to decode
 * and display an image that is too big. Images require 4 bytes per
 * pixel, so a 10 megapixel photograph requires 40 megabytes of image
 * memory. This function gives the gallery app a way to reject images
 * that are too large.
 *
 * Requires the BlobView class from shared/js/blobview.js and the
 * parseJPEGMetadata() function from shared/js/media/jpeg_metadata_parser.js
 */
function getImageSize(blob, callback, error) {
  

  BlobView.get(blob, 0, Math.min(1024, blob.size), function(data) {
    // Make sure we are at least 8 bytes long before reading the first 8 bytes
    if (data.byteLength <= 8) {
      error('corrupt image file');
      return;
    }
    var magic = data.getASCIIText(0, 8);
    if (magic.substring(0, 4) === 'GIF8') {
      try {
        callback({
          type: 'gif',
          width: data.getUint16(6, true),
          height: data.getUint16(8, true)
        });
      }
      catch (e) {
        error(e.toString());
      }
    }
    else if (magic.substring(0, 8) === '\x89PNG\r\n\x1A\n') {
      try {
        callback({
          type: 'png',
          width: data.getUint32(16, false),
          height: data.getUint32(20, false)
        });
      }
      catch (e) {
        error(e.toString());
      }
    }
    else if (magic.substring(0, 2) === '\xFF\xD8') {
      parseJPEGMetadata(blob,
                        function(metadata) {
                          metadata.type = 'jpeg';
                          callback(metadata);
                        },
                        error);
    }
    else {
      error('unknown image type');
    }
  });
}
;
define("getImageSize", ["BlobView","jpegMetaDataParser"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.getImageSize;
    };
}(this)));

// downsample.js
//
// This module defines a single global Downsample object with static
// methods that return objects representing media fragments for
// downsampling images while they are decoded. The current implementation
// is based on the #-moz-samplesize media fragment. But because of
// problems with that fragment (see bug 1004908) it seems likely that a
// new syntax or new fragment will be introduced. If that happens, we can
// just change this module and not have to change anything else that
// depends on it.
//
// The method Downsample.areaAtLeast(scale) returns an object
// representing a media fragment to use to decode an image downsampled by
// at least as much as the specified scale.  If you are trying to preview
// an 8mp image and don't want to use more than 2mp of image memory, for
// example, you would pass a scale of .25 (2mp/8mp) here, and the
// resulting media fragment could be appended to the url to make the
// image decode at a size equal to or smaller than 2mp.
//
// The method Downsample.sizeNoMoreThan(scale) returns a media fragment
// object that you can use to reduce the dimensions of an image as much
// as possible without exceeding the specified scale. If you have a
// 1600x1200 image and want to decode it to produce an image that is as
// small as possible but at least 160x120, you would pass a scale of 0.1.
//
// The returned objects have a dimensionScale property that specifies how
// they affect the dimensions of the image and an areaScale property that
// specifies how much they affect the area (number of pixels) in an
// image. (The areaScale is just the square of the scale.) To avoid
// floating-point rounding issues, the values of these scale properties
// are rounded to the nearest hundredth.
//
// The returned objects also have a scale() method that scales a
// dimension with proper rounding (it rounds up to the nearest integer
// just as libjpeg does).
//
// Each object also has a toString() method that returns the required
// media fragment (including the hash mark) so you can simply use
// string concatentation to append one of these objects to the URL of
// the image you want to decode.
//
// Downsample.NONE is a no-op media fragment object with scale set to
// 1, and a toString() method that returns the empty string.
//
(function(exports) {
  

  // Round to the nearest hundredth to combat floating point rounding errors
  function round(x) {
    return Math.round(x * 100) / 100;
  }


  //
  // A factory method for returning an object that represents a
  // #-moz-samplesize media fragment. The use of Math.ceil() in the
  // scale method is from jpeg_core_output_dimensions() in
  // media/libjpeg/jdmaster.c and jdiv_round_up() in media/libjpeg/jutils.c
  //
  function MozSampleSize(n, scale) {
    return Object.freeze({
      dimensionScale: round(scale),
      areaScale: round(scale * scale),
      toString: function() { return '#-moz-samplesize=' + n; },
      scale: function(x) { return Math.ceil(x * scale); }
    });
  }

  // A fragment object that represents no downsampling with no fragment
  var NONE = Object.freeze({
    dimensionScale: 1,
    areaScale: 1,
    toString: function() { return ''; },
    scale: function(x) { return x; }
  });

  //
  // The five possible #-moz-samplesize values.
  // The mapping from sample size to scale comes from:
  // the moz-samplesize code in /image/decoders/nsJPEGDecoder.cpp and
  // the jpeg_core_output_dimensions() function in media/libjpeg/jdmaster.c
  //
  var fragments = [
    NONE,
    MozSampleSize(2, 1 / 2), // samplesize=2 reduces size by 1/2 and area by 1/4
    MozSampleSize(3, 3 / 8), // etc.
    MozSampleSize(4, 1 / 4),
    MozSampleSize(8, 1 / 8)
  ];

  // Return the fragment object that has the largest scale and downsamples the
  // dimensions of an image at least as much as the specified scale.
  // If none of the choices scales enough, return the one that comes closest
  function sizeAtLeast(scale) {
    scale = round(scale);
    for (var i = 0; i < fragments.length; i++) {
      var f = fragments[i];
      if (f.dimensionScale <= scale) {
        return f;
      }
    }
    return fragments[fragments.length - 1];
  }

  // Return the fragment object that downsamples an image as far as possible
  // without going beyond the specified scale. This might return NONE.
  function sizeNoMoreThan(scale) {
    scale = round(scale);
    for (var i = fragments.length - 1; i >= 0; i--) {
      var f = fragments[i];
      if (f.dimensionScale >= scale) {
        return f;
      }
    }
    return NONE;
  }

  // Return the fragment object that has the largest scale and downsamples the
  // area of an image at least as much as the specified scale.
  // If none of the choices scales enough, return the one that comes closest
  function areaAtLeast(scale) {
    scale = round(scale);
    for (var i = 0; i < fragments.length; i++) {
      var f = fragments[i];
      if (f.areaScale <= scale) {
        return f;
      }
    }
    return fragments[fragments.length - 1];
  }

  // Return the fragment object that downsamples the area of an image
  // as far as possible without going beyond the specified scale. This
  // might return NONE.
  function areaNoMoreThan(scale) {
    scale = round(scale);
    for (var i = fragments.length - 1; i >= 0; i--) {
      var f = fragments[i];
      if (f.areaScale >= scale) {
        return f;
      }
    }
    return NONE;
  }

  exports.Downsample = {
    sizeAtLeast: sizeAtLeast,
    sizeNoMoreThan: sizeNoMoreThan,
    areaAtLeast: areaAtLeast,
    areaNoMoreThan: areaNoMoreThan,
    NONE: NONE,
    MAX_SIZE_REDUCTION: 1 / fragments[fragments.length - 1].dimensionScale,
    MAX_AREA_REDUCTION: 1 / fragments[fragments.length - 1].areaScale
  };
}(window));

define("downsample", function(){});

/* exported cropResizeRotate */
/* global getImageSize */
/* global Downsample */

//
// Given a blob that represents an encoded image, decode the image, crop it,
// rotate it, resize it, encode it again and pass the encoded blob to the
// callback.
//
// If the image includes EXIF orientation information, it will be
// rotated and/or mirrored so that the proper side is up and EXIF
// orientation information will not be needed in the output blob. The
// blob will not include any EXIF data.
//
// The cropRegion argument is optional. If specfied, it should be an
// object with left, top, width and height properties that specify the
// region of interest in the image. These coordinates should be
// specified as if the image has already been rotated and mirrored. If
// this argument is not specified, then no cropping is done and the
// entire image is returned.
//
// The outputSize argument specifies the desired size of the output
// image.  If not specified, then the image is returned full-size. If
// this argument is specified, then it should be an object with width
// and height properties or a single number.  If outputSize is an
// object, then the returned image will have the specified size or
// smaller. If the aspect ratio of the output size does not match the
// aspect ratio of the original image or of the crop region, then the
// largest area of the input region that fits the output size without
// letterboxing will be used. If the output size is larger than the
// crop region, then the output size is reduced to match the crop
// region.
//
// If outputSize is a number, then the #-moz-samplesize media fragment
// will be used, if necessary, to ensure that the input image is
// decoded at the specified size or smaller. Note that this media
// fragment gives only coarse control over image size, so passing a
// number for this argument can result in the image being decoded at a
// size substantially smaller than the specified value. If outputSize
// is a number and a crop region is specified, the image will
// typically be downsampled and then cropped, further reducing the
// size of the resulting image. On the other hand, if the crop region
// is small enough, then the function may be able to use the #xywh=
// media fragment to extract just the desired region of the rectangle
// without downsampling. Whichever approach requires less image memory
// is used.
//
// The outputType argument specifies the type of the output image. Legal
// values are "image/jpeg" and "image/png". If not specified, and if the
// input image does not need to be cropped resized or rotated, then it
// will be returned unchanged regardless of the type. If no output type
// is specified and a new blob needs to be created then "image/jpeg" will
// be used. If a type is explicitly specified, and does not match the type
// of the input image, then a new blob will be created even if no other
// changes to the image are necessary.
//
// The optional metadata argument provides a way to pass in image size and
// rotation metadata if you already have it. If this argument is omitted
// or null, getImageSize() will be used to compute the metadata. But if you
// have already called getImageSize() on the blob, you can provide the
// metadata you have and avoid having to reparse the blob.
//
// The callback argument should be a function that expects two arguments.
// If the image is successfully processed, the first argument will be null
// and the second will be a blob.  If there was an error, the first argument
// will be an error message and the second argument will be undefined.
//
// If no cropRegion and no outputSize are specified, if the type of the
// input blob matches the requested outputType, and if the image does not
// require any rotation, then this function will not do any work and will
// simply pass the input blob to the callback.
//
// This function requires other shared JS files:
//
//    shared/js/blobview.js
//    shared/js/media/image_size.js
//    shared/js/media/jpeg_metadata_parser.js
//    shared/js/media/downsample.js
//
function cropResizeRotate(blob, cropRegion, outputSize, outputType,
                          metadata, callback)
{
  

  const JPEG = 'image/jpeg';
  const PNG = 'image/png';

  // The 2nd, 3rd, 4th and 5th arguments are optional, so fix things up if we're
  // called with fewer than 6 args. The last argument is always the callback.
  switch (arguments.length) {
  case 2:
    callback = cropRegion;
    cropRegion = outputSize = outputType = metadata = null;
    break;

  case 3:
    callback = outputSize;
    outputSize = outputType = metadata = null;
    break;

  case 4:
    callback = outputType;
    outputType = metadata = null;
    break;

  case 5:
    callback = metadata;
    metadata = null;
    break;

  case 6:
    // everything fine. do nothing here
    break;

  default:
    throw new Error('wrong number of arguments: ' + arguments.length);
  }

  // If we were passed a metadata object, pass it to gotSize. Otherwise,
  // find the metadata object first and then pass it.
  if (metadata) {
    gotSize(metadata);
  }
  else {
    getImageSize(blob, gotSize, function(msg) { callback(msg); });
  }

  function gotSize(metadata) {
    // This is the full size of the image in the input coordiate system
    var rawImageWidth = metadata.width;
    var rawImageHeight = metadata.height;
    var fullsize = rawImageWidth * rawImageHeight;
    var rotation = metadata.rotation || 0;
    var mirrored = metadata.mirrored || false;

    // Compute the full size of the image in the output coordinate system
    // I.e. if the image is sideways, swap the width and height
    var rotatedImageWidth, rotatedImageHeight;
    if (rotation === 0 || rotation === 180) {
      rotatedImageWidth = rawImageWidth;
      rotatedImageHeight = rawImageHeight;
    }
    else {
      rotatedImageWidth = rawImageHeight;
      rotatedImageHeight = rawImageWidth;
    }

    // If there is no crop region, use the full, rotated image.
    // If there is a crop region, make sure it fits inside the image.
    if (!cropRegion) {
      cropRegion = {
        left: 0,
        top: 0,
        width: rotatedImageWidth,
        height: rotatedImageHeight
      };
    }
    else {
      if (cropRegion.left < 0 || cropRegion.top < 0 ||
          (cropRegion.left + cropRegion.width > rotatedImageWidth) ||
          (cropRegion.top + cropRegion.height > rotatedImageHeight)) {
        callback('crop region does not fit inside image');
        return;
      }
    }

    // If there is no output size, use the size of the crop region.
    // If there is an output size make sure it is smaller than the crop region
    // and then adjust the crop region as needed so that the aspect ratios
    // match
    if (outputSize === null || outputSize === undefined) {
      outputSize = {
        width: cropRegion.width,
        height: cropRegion.height
      };
    }
    else if (typeof outputSize === 'number') {
      if (outputSize <= 0) {
        callback('outputSize must be positive');
        return;
      }

      if (cropRegion.width * cropRegion.height < outputSize) {
        // If the image (or cropped region of the image) is smaller than
        // the maximum size then we can just use the crop region at full size.
        outputSize = {
          width: cropRegion.width,
          height: cropRegion.height
        };
      }
      else {
        // In this case we need to specify an output size that is small
        // enough that we will be forced below to use #-moz-samplesize
        // to downsample the image while decoding it.
        // Note that we base this samplesize computation on the full size
        // of the image, because we can't use the #-moz-samplesize media
        // fragment along with the #xywh media fragment, so if we're using
        // samplesize we're going to have to decode the full image.
        var ds = Downsample.areaAtLeast(outputSize / fullsize);

        // Now that we've figured out how much the full image will be
        // downsampled, scale the crop region to match.
        outputSize = {
          width: ds.scale(cropRegion.width),
          height: ds.scale(cropRegion.height)
        };
      }
    }

    if (!(outputSize.width > 0 && outputSize.height > 0)) {
      callback('outputSize width and height must be positive');
      return;
    }

    // If the outputSize is bigger than the crop region, just adjust
    // the output size to match.
    if (outputSize.width > cropRegion.width) {
      outputSize.width = cropRegion.width;
    }
    if (outputSize.height > cropRegion.height) {
      outputSize.height = cropRegion.height;
    }

    // How much do we have to scale the crop region in X and Y dimensions
    // to match the output size?
    var scaleX = outputSize.width / cropRegion.width;
    var scaleY = outputSize.height / cropRegion.height;

    // We now adjust the crop region to match the output size. For
    // example if the outputSize is 200x200 and the cropRegion is
    // 600x400, then scaleX is .33 and scaleY is .5. In this case we can
    // leave the height of the crop region alone, but we need to reduce
    // the width of the crop region and adjust the left of the crop region

    if (scaleY > scaleX) {   // adjust width of crop region
      var oldCropWidth = cropRegion.width;
      cropRegion.width = Math.round(outputSize.width / scaleY);
      cropRegion.left += (oldCropWidth - cropRegion.width) >> 1;
    }
    else if (scaleX > scaleY) { // adjust height of crop region
      var oldCropHeight = cropRegion.height;
      cropRegion.height = Math.round(outputSize.height / scaleX);
      cropRegion.top += (oldCropHeight - cropRegion.height) >> 1;
    }

    // Make sure the outputType is valid, if one was specified
    if (outputType && outputType !== JPEG && outputType !== PNG) {
      callback('unsupported outputType: ' + outputType);
      return;
    }

    // Now that we've done these computations, we can pause for a moment
    // to see if there is actually any work that needs doing here. If not
    // we can just pass the input blob unchanged through to the callback
    if (rotation === 0 &&                      // No need to rotate
        !mirrored &&                           // or to mirror the image.
        (!outputType ||                        // Don't care about output type
         blob.type === outputType) &&          // or type is unchanged.
        outputSize.width === rawImageWidth &&  // Doesn't need crop or resize.
        outputSize.height == rawImageHeight) {
      callback(null, blob);
      return;
    }

    // The crop region we've been working with so far is in the output
    // coordinate system: it assumes that any required rotation has been done.
    // In order to know exactly which pixels to extract from the image we
    // need to convert to the unrotated, unmirrored input coordinate system.
    var inputCropRegion;

    // First, handle rotation
    switch (rotation) {
      case 180:
      // The image is upside down. The width and height are the same but
      // the top and left have to change.
      inputCropRegion = {
        left: rawImageWidth - cropRegion.left - cropRegion.width,
        top: rawImageHeight - cropRegion.top - cropRegion.height,
        width: cropRegion.width,
        height: cropRegion.height
      };
      break;

      case 90:
      // sideways: swap width and height and adjust top and left
      inputCropRegion = {
        left: cropRegion.top,
        top: rawImageHeight - cropRegion.left - cropRegion.width,
        width: cropRegion.height,
        height: cropRegion.width
      };
      break;

      case 270:
      // sideways: swap width and height and adjust top and left
      inputCropRegion = {
        left: rawImageWidth - cropRegion.top - cropRegion.height,
        top: cropRegion.left,
        width: cropRegion.height,
        height: cropRegion.width
      };
      break;

      default:
      // the crop region is the same in this case
      inputCropRegion = {
        left: cropRegion.left,
        top: cropRegion.top,
        width: cropRegion.width,
        height: cropRegion.height
      };
      break;
    }

    // Next, adjust for mirroring
    if (mirrored) {
      if (rotation === 90 || rotation === 270) {
        inputCropRegion.top =
          rawImageHeight - inputCropRegion.top - inputCropRegion.height;
      }
      else {
        inputCropRegion.left =
          rawImageWidth - inputCropRegion.left - inputCropRegion.width;
      }
    }

    // In order to decode the image, we create a blob:// URL for it
    var baseURL = URL.createObjectURL(blob);

    // Decoding an image takes a lot of memory and we want to minimize
    // that.  Gecko  allows us to use media fragments with our
    // image URL to specify that we do not want it to decode all of
    // the pixels in the image. The #xywh= media fragment allows us to
    // specify a crop region.  And the #-moz-samplesize= fragment
    // allows us to specify the image should be downsampled while
    // it is decoded (but only works for jpeg images). Unfortunately
    // we can't use both, so we need to decide which one gives us the
    // best memory savings.
    var croppedsize = cropRegion.width * cropRegion.height;
    var sampledsize;
    var downsample;

    // If we decode the image with a #-moz-samplesize media fragment, both
    // the x and y dimensions are reduced by the sample size, so the total
    // number of pixels is reduced by the square of the sample size.
    if (blob.type === JPEG) {
      // What media fragment can we use to downsample the crop region
      // so that it is as small as possible without being smaller than
      // the output size? We know that the output size and crop
      // region have the same aspect ratio now, so we only have to
      // consider one dimension. If we passed in a single number outputSize
      // up above then we Downsample.areaAtLeast() to compute the outputSize.
      // We should now get the same media fragment value here.
      downsample =
        Downsample.sizeNoMoreThan(outputSize.width / cropRegion.width);

      // And if apply that media fragment to the entire image, how big is
      // the result?
      sampledsize = downsample.scale(rawImageWidth) *
        downsample.scale(rawImageHeight);
    }
    else {
      downsample = Downsample.NONE;
      sampledsize = fullsize;
    }

    // Now add the appropriate media fragments to the url
    var url;
    var croppedWithMediaFragment = false, resizedWithMediaFragment = false;
    if (sampledsize === fullsize && croppedsize === fullsize) {
      // No media fragments in this case
      url = baseURL;
    }
    else if (croppedsize < sampledsize) {
      // Use a #xywh media fragment to crop while decoding
      url = baseURL + '#xywh=' +
        inputCropRegion.left + ',' +
        inputCropRegion.top + ',' +
        inputCropRegion.width + ',' +
        inputCropRegion.height;

      croppedWithMediaFragment = true;
    }
    else {
      // Use a #-moz-samplesize media fragment to downsample while decoding
      url = baseURL + downsample;
      resizedWithMediaFragment = true;
    }

    // Now we've done our calculations and we have an image URL to decode
    var offscreenImage = new Image();
    offscreenImage.src = url;
    offscreenImage.onerror = function() {
      callback('error decoding image: ' + url);
    };
    offscreenImage.onload = gotImage;

    // Called when the image has loaded
    function gotImage() {
      // If we used a media fragment on the image url, we can now
      // check whether the image we got has the expected size. And if it
      // does, we need to adjust the crop region to match the cropped or
      // resized image.
      if (croppedWithMediaFragment) {
        if (offscreenImage.width === inputCropRegion.width &&
            offscreenImage.height === inputCropRegion.height) {
          // We got the cropped size we asked for, so adjust the inputCropRegion
          // so that we don't crop again
          inputCropRegion.left = inputCropRegion.top = 0;
        }
      }
      else if (resizedWithMediaFragment) {
        if (offscreenImage.width < rawImageWidth ||
            offscreenImage.height < rawImageHeight) {
          // If we got an image that is smaller than full size, then the image
          // was downsampled while decoding, but it may still need cropping.
          // We reduce the crop region proportionally to the downsampling.
          var sampleSizeX = rawImageWidth / offscreenImage.width;
          var sampleSizeY = rawImageHeight / offscreenImage.height;
          inputCropRegion.left =
            Math.round(inputCropRegion.left / sampleSizeX);
          inputCropRegion.top =
            Math.round(inputCropRegion.top / sampleSizeY);
          inputCropRegion.width =
            Math.round(inputCropRegion.width / sampleSizeX);
          inputCropRegion.height =
            Math.round(inputCropRegion.height / sampleSizeY);
        }
      }

      // We've decoded the image now, so create a canvas we can copy it into
      var canvas = document.createElement('canvas');
      var destWidth = canvas.width = outputSize.width;
      var destHeight = canvas.height = outputSize.height;

      // Since we're only using the canvas as a way to encode the image
      // we set this willReadFrequently flag as a hint so that we avoid
      // copying the image data to and from the GPU since we don't do any
      // GPU operations on it
      var context = canvas.getContext('2d', { willReadFrequently: true });

      // If the image needs to be rotated or mirrored we have to establish
      // an appropriate transform on the context
      if (rotation || mirrored) {
        // translate so we're rotating around the center
        context.translate(canvas.width / 2, canvas.height / 2);

        if (mirrored) {
          context.scale(-1, 1);
        }

        // rotate
        switch (rotation) {
        case 90:
          context.rotate(Math.PI / 2);
          destWidth = canvas.height;
          destHeight = canvas.width;
          break;
        case 180:
          context.rotate(Math.PI);
          break;
        case 270:
          context.rotate(-Math.PI / 2);
          destWidth = canvas.height;
          destHeight = canvas.width;
          break;
        }

        // And translate back
        if (rotation === 90 || rotation === 270) {
          // For the 90 and 270 case we swap width and height
          context.translate(-canvas.height / 2, -canvas.width / 2);
        }
        else {
          context.translate(-canvas.width / 2, -canvas.height / 2);
        }
      }

      // Now we copy the image into the canvas
      context.drawImage(offscreenImage,
                        // What part of the image we're drawing
                        inputCropRegion.left, inputCropRegion.top,
                        inputCropRegion.width, inputCropRegion.height,
                        // And what part of the canvas we're drawing it to
                        0, 0, destWidth, destHeight);

      // Once the image has been copied, we can release the decoded image
      // memory and the blob URL.
      offscreenImage.src = '';
      URL.revokeObjectURL(baseURL);

      // Finally, encode the image into a blob
      canvas.toBlob(gotEncodedBlob, outputType || JPEG);

      function gotEncodedBlob(blob) {
        // We have the encoded image but before we pass it to the callback
        // we need to free the canvas.
        canvas.width = canvas.height = 0;
        canvas = context = null;
        callback(null, blob);
      }
    }
  }
}
;
define("cropResizeRotate", ["BlobView","getImageSize","jpegMetaDataParser","downsample"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.cropResizeRotate;
    };
}(this)));

define('lib/resize-image-and-save',['require','exports','module','lib/storage','cropResizeRotate'],function(require, exports, module) {


var Storage = require('lib/storage');
var cropResizeRotate = require('cropResizeRotate');

/**
 * Exports
 */

module.exports = function(options, done) {
  var blob = options.blob;
  var outputSize = options.width && options.height ?
    {
      width: options.width,
      height: options.height
    } : options.size || null;

  cropResizeRotate(blob, null, outputSize, null, function(error, resizedBlob) {

    // If we couldn't resize or rotate it, use the original
    if (error) {
      console.error('Error while resizing image: ' + error);
      done(blob);
      return;
    }

    // We need to send a file-backed blob as the result of a pick activity
    // (see bug 975599) so we'll overwrite the old blob with the new one.
    // This means that the image stored will actually match the one passed
    // to the app that initiated the pick activity. We delete the old file,
    // then save the new blob with the same name. Then we read the file and
    // pass that to the callback.
    if (resizedBlob === blob) {
      done(blob);
      return;
    }

    var storage = new Storage();
    storage.deletePicture(blob.name);
    storage.addPicture(resizedBlob, {
      filepath: blob.name
    }, function(filepath, absolutePath, fileBlob) {
      done(fileBlob);
    });
  });
};

});

define('controllers/activity',['require','exports','module','debug','lib/bytes-to-pixels','lib/resize-image-and-save','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:activity');
var bytesToPixels = require('lib/bytes-to-pixels');
var resizeImageAndSave = require('lib/resize-image-and-save');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new ActivityController(app); };
module.exports.ActivityController = ActivityController;

/**
 * Initialize new `ActivityController`
 *
 * @param {App} app
 */
function ActivityController(app) {
  bindAll(this);
  this.settings = app.settings;
  this.app = app;
  this.configure();
  this.bindEvents();
  debug('initialized');
}

/**
 * Supported activity types.
 *
 * @type {Object}
 */
ActivityController.prototype.types = {
  pick: 'pick',
  record: 'record'
};

/**
 * Initial configuration.
 *
 * @private
 */
ActivityController.prototype.configure = function() {
  this.app.activity[this.getName()] = true;
};

/**
 * Filter down pictureSizes and
 * recorderProfiles to match activity
 * parameters each time the settings
 * are configured.
 *
 * @private
 */
ActivityController.prototype.bindEvents = function() {
  navigator.mozSetMessageHandler('activity', this.onMessage);
  this.app.on('activitycanceled', this.onActivityCanceled);
  this.app.on('confirm:selected', this.onActivityConfirmed);
};

/**
 * Get activity name from the hash fragment.
 *
 * This is used only so that some parts
 * of the app can prepare for an incoming
 * activity before the message arrives.
 *
 * @private
 */
ActivityController.prototype.getName = function() {
  var hash = location.hash;
  var name = hash && hash.substr(1);
  return this.types[name];
};

/**
 * Responds to incoming activity message.
 *
 * Configures the mode then emits an
 * event so that other parts of
 * the app can update accordingly.
 *
 * @param  {MozActivity} activity
 */
ActivityController.prototype.onMessage = function(activity) {
  debug('incoming activity', activity);
  var name = activity.source.name;
  var supported = this.types[name];

  // Exit if this activity isn't supported
  if (!supported) { return; }

  var data = {
    name: name,
    maxPixelSize: this.getMaxPixelSize(activity),
    maxFileSizeBytes: activity.source.data.maxFileSizeBytes
  };

  this.activity = activity;
  this.configureMode(activity);
  this.app.emit('activity', data);
  this.app.emit('activity:' + name, data);
};

/**
 * Configures the mode setting based
 * on the parameters supplied by
 * the incoming activity.
 *
 * @param  {MozActivity} activity
 * @private
 */
ActivityController.prototype.configureMode = function(activity) {
  var type = activity.source.data.type;
  var name = activity.source.name;
  var modes = (name === 'pick') ?
    this.getModesForPick(type) :
    this.getModesForRecord(type);

  this.settings.mode.filterOptions(modes);
  this.settings.mode.select(modes[0]);
  debug('configured mode', modes);
};

/**
 * Get a max pixel size estimate based
 * on the parameters supplied by the
 * incoming activity.
 *
 * Activities don't always supply pixel
 * size restrictions.
 *
 * NOTE: There
 *
 * @param  {MozActivity} activity
 * @return {Number|null}
 */
ActivityController.prototype.getMaxPixelSize = function(activity) {
  var data = activity.source.data;
  var bytes = data.maxFileSizeBytes;
  var maxPickPixelSize = this.settings.activity.get('maxPickPixelSize') || 0;
  var maxPixelSize;

  // If bytes were specified then derive
  // a maxPixelSize from that, else we
  // calculate the maxPixelSize using
  // supplied dimensions.
  if (bytes) {
    maxPixelSize = bytesToPixels(bytes);
  } else if (data.width || data.height) {
    maxPixelSize = this.getMaxPixelsFromSize(data);
  } else {
    maxPixelSize = maxPickPixelSize;
  }

  // If the Camera app has been configured to have a max pixel size
  // for pick activities, ensure we are at or below that value.
  if (maxPickPixelSize > 0) {
    maxPixelSize = Math.min(maxPixelSize, maxPickPixelSize);
  }

  debug('maxPixelsSize: %s', maxPixelSize);
  return maxPixelSize;
};

ActivityController.prototype.getMaxPixelsFromSize = function(size) {
  var scale = this.settings.activity.get('maxPixelSizeScaleFactor');
  var aspect = 4 / 3;

  // In the event that only one dimension has
  // been supplied, calculate the largest the
  // other edge could be based on a 4:3 aspect.
  var width = size.width || size.height * aspect;
  var height = size.height || size.width * aspect;
  var pixels = width * height;

  // Take the actual total number of
  // pixels asked for and bump it by the
  // `scale` to cover pictureSizes above
  // the pixels asked for. We later resize
  // the image post-capture to the exact size
  // requested (data.width * data.height).
  //
  // This is to avoid us picking a pictureSize
  // smaller than the number of pixels requested
  // and then to scaling up post-capture,
  // resulting in a shitty image.
  return pixels * scale;
};

/**
 * Parse types given by 'pick' activity
 * and return a list of modes.
 *
 * @param  {Array|String} types
 * @return {Array}
 */
ActivityController.prototype.getModesForPick = function(types) {
  types = [].concat(types || []);
  var modes = [];

  types.forEach(function(item) {
    var type = item.split('/')[0];
    var mode = type === 'image' ? 'picture' : type;

    if (modes.indexOf(mode) === -1) {
      modes.push(mode);
    }
  });

  if (modes.length === 0) {
    modes = ['picture', 'video'];
  }

  return modes;
};

/**
 * Parse types given by 'record' activity
 * and return a list of modes.
 *
 * @param  {String} type
 * @return {Array}
 */
ActivityController.prototype.getModesForRecord = function(type) {
  return type === 'videos' ?
    ['video', 'picture'] :
    ['picture', 'video'];
};

/**
 * Respond to activity cancelation
 * events and send the error call
 * via the original acitity object.
 *
 * @private
 */
ActivityController.prototype.onActivityCanceled = function() {
  if (!this.activity) { return; }
  this.activity.postError('pick cancelled');
};

// TODO: Messy, tidy up!
ActivityController.prototype.onActivityConfirmed = function(newMedia) {
  var activity = this.activity;
  var needsResizing;
  var media = {
    blob: newMedia.blob
  };

  // Video
  if (newMedia.isVideo) {
    media.type = 'video/3gpp';
    media.poster = newMedia.poster.blob;
  }

  // Image
  else {
    media.type = 'image/jpeg';
    needsResizing = activity.source.data.width || activity.source.data.height;
    debug('needs resizing: %s', needsResizing);

    if (needsResizing) {
      resizeImageAndSave({
        blob: newMedia.blob,
        width: activity.source.data.width,
        height: activity.source.data.height
      }, function(resizedBlob) {
        media.blob = resizedBlob;
        activity.postResult(media);
      });
      return;
    }
  }

  this.activity.postResult(media);
};

});

define('controllers/camera',['require','exports','module','debug','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:camera');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new CameraController(app); };
module.exports.CameraController = CameraController;

/**
 * Initialize a new `CameraController`
 *
 * @param {App} app
 */
function CameraController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.camera = app.camera;
  this.settings = app.settings;
  this.activity = app.activity;
  this.viewfinder = app.views.viewfinder;
  this.controls = app.views.controls;
  this.hdrDisabled = this.settings.hdr.get('disabled');
  this.l10nGet = app.l10nGet;
  this.configure();
  this.bindEvents();
  debug('initialized');
}

CameraController.prototype.bindEvents = function() {
  var settings = this.settings;
  var camera = this.camera;
  var app = this.app;

  // Relaying camera events means other modules
  // don't have to depend directly on camera
  camera.on('change:videoElapsed', app.firer('camera:recorderTimeUpdate'));
  camera.on('autofocuschanged', app.firer('camera:autofocuschanged'));
  camera.on('focusconfigured',  app.firer('camera:focusconfigured'));
  camera.on('change:focus', app.firer('camera:focusstatechanged'));
  camera.on('facesdetected', app.firer('camera:facesdetected'));
  camera.on('filesizelimitreached', this.onFileSizeLimitReached);
  camera.on('takingpicture', app.firer('camera:takingpicture'));
  camera.on('change:recording', app.setter('recording'));
  camera.on('newcamera', app.firer('camera:newcamera'));
  camera.on('newimage', app.firer('camera:newimage'));
  camera.on('newvideo', app.firer('camera:newvideo'));
  camera.on('shutter', app.firer('camera:shutter'));
  camera.on('configured', this.onCameraConfigured);
  camera.on('loaded', app.firer('camera:loaded'));
  camera.on('ready', app.firer('camera:ready'));
  camera.on('busy', app.firer('camera:busy'));
  camera.on('willrecord', app.firer('camera:willrecord'));

  // App
  app.on('viewfinder:focuspointchanged', this.onFocusPointChanged);
  app.on('previewgallery:opened', this.onPreviewGalleryOpened);
  app.on('previewgallery:closed', this.onPreviewGalleryClosed);
  app.on('change:batteryStatus', this.onBatteryStatusChange);
  app.on('settings:configured', this.onSettingsConfigured);
  app.on('storage:changed', this.onStorageChanged);
  app.on('activity:pick', this.onPickActivity);
  app.on('timer:ended', this.capture);
  app.on('visible', this.camera.load);
  app.on('capture', this.capture);
  app.on('hidden', this.onHidden);
  app.on('attentionscreenopened', this.camera.stopRecording);

  // Settings
  settings.recorderProfiles.on('change:selected', this.updateRecorderProfile);
  settings.pictureSizes.on('change:selected', this.updatePictureSize);
  settings.flashModes.on('change:selected', this.onFlashModeChange);
  settings.flashModes.on('change:selected', this.setFlashMode);
  settings.cameras.on('change:selected', this.setCamera);
  settings.mode.on('change:selected', this.setMode);
  settings.hdr.on('change:selected', this.setHDR);
  settings.hdr.on('change:selected', this.onHDRChange);

  debug('events bound');
};

/**
 * Configure the 'cameras' setting using the
 * `cameraList` data given by the camera hardware
 *
 * @private
 */
CameraController.prototype.configure = function() {
  this.settings.cameras.filterOptions(this.camera.cameraList);
  debug('configured');
};

/**
 * Once the settings have finished configuring
 * we do the final camera configuration.
 *
 * @private
 */
CameraController.prototype.onSettingsConfigured = function() {
  var recorderProfile = this.settings.recorderProfiles.selected('key');
  var pictureSize = this.settings.pictureSizes.selected('data');

  this.setWhiteBalance();
  this.setFlashMode();
  this.setISO();
  this.setHDR();

  this.camera.setRecorderProfile(recorderProfile);
  this.camera.setPictureSize(pictureSize);
  this.camera.configureZoom();

  // Bug 983930 - [B2G][Camera] CameraControl API's "zoom" attribute doesn't
  // scale preview properly
  //
  // For some reason, the above calculation for `maxHardwareZoom` does not
  // work properly on Nexus 4 devices.
  var hardware = navigator.mozSettings.createLock().get('deviceinfo.hardware');
  var self = this;
  hardware.onsuccess = function(evt) {
    var device = evt.target.result['deviceinfo.hardware'];
    if (device === 'mako') {

      // Nexus 4 needs zoom preview adjustment since the viewfinder preview
      // stream does not automatically reflect the current zoom value.
      self.settings.zoom.set('useZoomPreviewAdjustment', true);

      if (self.camera.selectedCamera === 'front') {
        self.camera.set('maxHardwareZoom', 1);
      } else {
        self.camera.set('maxHardwareZoom', 1.25);
      }

      self.camera.emit('zoomconfigured');
    }
  };

  debug('camera configured with final settings');
};

/**
 * Saves the last camera configuration
 * and relays the event through the app.
 *
 * @param  {Object} config
 * @private
 */
CameraController.prototype.onCameraConfigured = function(config) {
  this.app.emit('camera:configured');
};

/**
 * Updates camera configuration in
 * response to pick activity parameters.
 *
 * @param  {Object} data
 * @private
 */
CameraController.prototype.onPickActivity = function(data) {

  // This is set so that the video recorder can
  // automatically stop when video size limit is reached.
  this.camera.set('maxFileSizeBytes', data.maxFileSizeBytes);

  // Disable camera config caches when in 'pick' activity
  // to prevent activity specific configuration persisting.
  this.camera.cacheConfig = false;
};

/**
 * Begins capture, first checking if
 * a countdown timer should be installed.
 *
 * @private
 */
CameraController.prototype.capture = function() {
  if (this.shouldCountdown()) {
    this.app.emit('startcountdown');
    return;
  }

  var position = this.app.geolocation.position;
  this.camera.capture({ position: position });
};

/**
 * Fires a 'startcountdown' event if:
 * A timer settings is set, no timer is
 * already active, and the camera is
 * not currently recording.
 *
 * This event triggers the TimerController
 * to begin counting down, using the TimerView
 * to communicate the remaining seconds.
 *
 * @private
 */
CameraController.prototype.shouldCountdown = function() {
  var timerSet = this.settings.timer.selected('value');
  var timerActive = this.app.get('timerActive');
  var recording = this.app.get('recording');

  return timerSet && !timerActive && !recording;
};

CameraController.prototype.onFileSizeLimitReached = function() {
  this.camera.stopRecording();
  this.showSizeLimitAlert();
};

CameraController.prototype.showSizeLimitAlert = function() {
  if (this.sizeLimitAlertActive) { return; }
  this.sizeLimitAlertActive = true;
  var alertText = this.activity.pick ?
    'activity-size-limit-reached' :
    'storage-size-limit-reached';
  alert(this.l10nGet(alertText));
  this.sizeLimitAlertActive = false;
};

CameraController.prototype.setMode = function(mode) {
  var self = this;
  this.setFlashMode();
  this.viewfinder.fadeOut(function() {
    self.camera.setMode(mode);
  });
};

CameraController.prototype.updatePictureSize = function() {
  var pictureMode = this.settings.mode.selected('key') === 'picture';
  var value = this.settings.pictureSizes.selected('data');
  var self = this;

  // Only configure in video mode
  if (!pictureMode) {
    this.camera.setPictureSize(value, { configure: false });
    return;
  }

  // Fade out, then configure
  this.viewfinder.fadeOut(function() {
    self.camera.setPictureSize(value);
  });
};

CameraController.prototype.updateRecorderProfile = function() {
  var videoMode = this.settings.mode.selected('key') === 'video';
  var key = this.settings.recorderProfiles.selected('key');
  var self = this;

  // Only configure in picture mode
  if (!videoMode) {
    this.camera.setRecorderProfile(key, { configure: false });
    return;
  }

  // Fade out, then change the setting
  this.viewfinder.fadeOut(function() {
    self.camera.setRecorderProfile(key);
  });
};

/**
 * Set the 'selected' camera.
 *
 * @param {String} camera 'front'|'back'
 */
CameraController.prototype.setCamera = function(camera) {
  var self = this;
  this.viewfinder.fadeOut(function() {
    self.camera.setCamera(camera);
  });
};

CameraController.prototype.setFlashMode = function() {
  var flashSetting = this.settings.flashModes;
  this.camera.setFlashMode(flashSetting.selected('key'));
};

CameraController.prototype.onHidden = function() {
  debug('app hidden');
  this.camera.stopRecording();
  this.camera.set('focus', 'none');
  this.camera.release();
};

CameraController.prototype.setISO = function() {
  if (!this.settings.isoModes.get('disabled')) {
    this.camera.setISOMode(this.settings.isoModes.selected('key'));
  }
};

CameraController.prototype.setWhiteBalance = function() {
  if (!this.settings.whiteBalance.get('disabled')) {
    this.camera.setWhiteBalance(this.settings.whiteBalance.selected('key'));
  }
};

CameraController.prototype.setHDR = function() {
  if (this.hdrDisabled) { return; }
  this.camera.setHDR(this.settings.hdr.selected('key'));
};

CameraController.prototype.onFlashModeChange = function(flashModes) {
  if (this.hdrDisabled) { return; }
  var ishdrOn = this.settings.hdr.selected('key') === 'on';
  if (ishdrOn &&  flashModes !== 'off') {
    this.settings.hdr.select('off');
  }
};

CameraController.prototype.onHDRChange = function(hdr) {
  var flashMode = this.settings.flashModesPicture.selected('key');
  var ishdrOn = hdr === 'on';
  if (ishdrOn && flashMode !== 'off') {
    this.settings.flashModesPicture.select('off');
  }
};

CameraController.prototype.onBatteryStatusChange = function(status) {
  if (status === 'shutdown') { this.camera.stopRecording(); }
};

/**
 * Stop recording if storage becomes
 * 'shared' (unavailable) usually due
 * to the device being connected to
 * a computer via USB.
 *
 * @private
 */
CameraController.prototype.onStorageChanged = function(state) {
  if (state === 'shared') { this.camera.stopRecording(); }
};

/**
 * Resets the camera zoom and stops focus when the preview gallery
 * is opened.
 */
CameraController.prototype.onPreviewGalleryOpened = function() {
  this.camera.configureZoom(this.camera.previewSize());
  this.camera.stopFocus();
};

/**
 * Resumes focus when the preview gallery
 * is opened.
 */
CameraController.prototype.onPreviewGalleryClosed = function() {
  this.camera.resumeFocus();
};

/**
 * Updates focus area when the user clicks on the viewfinder
 */
CameraController.prototype.onFocusPointChanged = function(focusPoint) {
  this.camera.updateFocusArea(focusPoint.area);
};

});

define('controllers/zoom-bar',['require','exports','module','debug','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:zoom-bar');
var bindAll = require('lib/bind-all');
/**
 * Exports
 */

module.exports = function(app) { return new ZoomBarController(app); };
module.exports.ZoomBarController = ZoomBarController;

/**
 * Initialize a new `ZoomBarController`
 *
 * @param {App} app
 */
function ZoomBarController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.camera = app.camera;
  this.viewfinder = app.views.viewfinder;
  this.zoomBar = app.views.zoomBar;
  this.bindEvents();
  debug('initialized');
}

ZoomBarController.prototype.bindEvents = function() {
  this.zoomBar.on('change', this.onChange);
  this.camera.on('zoomconfigured', this.onZoomConfigured);
  this.camera.on('zoomchanged', this.onZoomChanged);
  this.viewfinder.on('pinchstarted', this.onPinchStarted);
  this.viewfinder.on('pinchended', this.onPinchEnded);
};

ZoomBarController.prototype.onChange = function(value) {
  var minimumZoom = this.camera.getMinimumZoom();
  var maximumZoom = this.camera.getMaximumZoom();
  var range = maximumZoom - minimumZoom;
  var zoom = (range * value / 100) + minimumZoom;
  this.camera.setZoom(zoom);
};

ZoomBarController.prototype.onZoomConfigured = function() {
  this.zoomBar.hide();
};

ZoomBarController.prototype.onZoomChanged = function(zoom) {
  var minimumZoom = this.camera.getMinimumZoom();
  var maximumZoom = this.camera.getMaximumZoom();
  var range = maximumZoom - minimumZoom;
  var percent = (zoom - minimumZoom) / range * 100;
  this.zoomBar.setValue(percent);
};

ZoomBarController.prototype.onPinchStarted = function() {
  this.zoomBar.setScrubberActive(true);
};

ZoomBarController.prototype.onPinchEnded = function() {
  this.zoomBar.setScrubberActive(false);
};

});

define('views/indicators',['require','exports','module','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'indicators',
  tag: 'ul',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
  },

  template: function() {
    return '<li class="indicator_timer icon-self-timer rotates"></li>' +
    '<li class="indicator_hdr icon-hdr rotates"></li>' +
    '<li class="indicator_geolocation icon-geolocation rotates"></li>' +
    '<li class="indicator_battery icon rotates"></li>';
  }
});

});
define('controllers/indicators',['require','exports','module','debug','views/indicators'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:indicators');
var IndicatorsView = require('views/indicators');

/**
 * Exports
 */

module.exports = function(app) { return new IndicatorsController(app); };
module.exports.IndicatorsController = IndicatorsController;

/**
 * Initialize a new `IndicatorsController`
 *
 * @param {Object} options
 */
function IndicatorsController(app) {
  debug('initializing');
  this.app = app;
  this.settings = app.settings;
  this.onSettingsConfigured = this.onSettingsConfigured.bind(this);
  this.configure();
  debug('initialized');
}

/**
 * Initial configuration. Injects
 * view and binds events.
 *
 * @private
 */
IndicatorsController.prototype.configure = function() {
  this.view = this.app.views.indicators || new IndicatorsView();
  // Indicators hidden by default until the settings are configured
  this.view.hide();
  this.view.appendTo(this.app.el);
  this.bindEvents();
  debug('events bound');
};

/**
 * Update the view when related
 * settings and app state change.
 *
 * Configure each time the settings
 * configure.
 *
 * @public
 */
IndicatorsController.prototype.bindEvents = function() {
  this.settings.timer.on('change:selected', this.view.setter('timer'));
  this.settings.hdr.on('change:selected', this.view.setter('hdr'));
  this.app.on('change:batteryStatus', this.view.setter('battery'));
  this.app.on('change:recording', this.view.setter('recording'));
  this.app.on('settings:configured', this.onSettingsConfigured);
  debug('events bound');
};

/**
 * Enables supported indicators,
 * configures initial state and
 * then shows the view.
 *
 * @private
 */
IndicatorsController.prototype.onSettingsConfigured = function() {
  debug('configuring');
  this.configureEnabled();
  this.view.set('hdr', this.settings.hdr.selected('key'));
  this.view.set('timer', this.settings.timer.selected('key'));
  this.view.show();
  debug('configured');
};

/**
 * Configures the enabling/disabling
 * of all keys in the indicator config.
 *
 * @private
 */
IndicatorsController.prototype.configureEnabled = function() {
  for (var key in this.enabled) { this.enable(key, this.enabled[key]); }
};

/**
 * Enables an indicator in the view,
 * if truthy in indicator config, and
 * not a setting, or is a 'supported'
 * setting.
 *
 * @param  {String} key
 * @param {Boolean} enabled
 * @private
 */
IndicatorsController.prototype.enable = function(key, enabled) {
  var setting = this.settings[key];
  var shouldEnable = enabled && (!setting || setting.supported());
  this.view.enable(key, shouldEnable);
  debug('enable key: %s, shouldEnable: %s', key, shouldEnable);
};

});
define('main',['require','lib/settings','lib/geo-location','config/config','lib/camera/camera','app','controllers/hud','controllers/controls','controllers/viewfinder','controllers/recording-timer','controllers/overlay','controllers/settings','controllers/activity','controllers/camera','controllers/zoom-bar','controllers/indicators'],function(require) {


/**
 * Module Dependencies
 */

var Settings = require('lib/settings');
var GeoLocation = require('lib/geo-location');
var settingsData = require('config/config');
var settings = new Settings(settingsData);
var Camera = require('lib/camera/camera');
var App = require('app');

// Log dom-loaded to keep perf on our radar
var timing = window.performance.timing;
var domLoaded = timing.domComplete - timing.domLoading;
console.log('domloaded in %s', domLoaded + 'ms');

// Create globals specified in the config file
if (settingsData.globals) {
  for (var key in settingsData.globals) {
    window[key] = settingsData.globals[key];
  }
}

// Create new `App`
var app = window.app = new App({
  settings: settings,
  geolocation: new GeoLocation(),

  el: document.body,
  doc: document,
  win: window,

  camera: new Camera({
    focus: settingsData.focus
  }),

  controllers: {
    hud: require('controllers/hud'),
    controls: require('controllers/controls'),
    viewfinder: require('controllers/viewfinder'),
    recordingTimer: require('controllers/recording-timer'),
    overlay: require('controllers/overlay'),
    settings: require('controllers/settings'),
    activity: require('controllers/activity'),
    camera: require('controllers/camera'),
    zoomBar: require('controllers/zoom-bar'),
    indicators: require('controllers/indicators'),

    // Lazy loaded
    previewGallery: 'controllers/preview-gallery',
    storage: 'controllers/storage',
    confirm: 'controllers/confirm',
    battery: 'controllers/battery',
    sounds: 'controllers/sounds',
    timer: 'controllers/timer',
  }
});

// We start the camera loading straight
// away (async), as this is the slowest
// part of the boot process.
app.camera.load();
app.settings.fetch();
app.boot();

});
require.config({
  baseUrl: '/js',
  paths: {
    'l10n': '../shared/js/l10n',
    'asyncStorage': '../shared/js/async_storage',
    'getVideoRotation': '../shared/js/media/get_video_rotation',
    'performance-testing-helper': '../shared/js/performance_testing_helper',
    'jpegMetaDataParser': '../shared/js/media/jpeg_metadata_parser',
    'downsample': '../shared/js/media/downsample',
    'getImageSize': '../shared/js/media/image_size',
    'cropResizeRotate': '../shared/js/media/crop_resize_rotate',
    'format': '../shared/js/format',
    'GestureDetector': '../shared/js/gesture_detector',
    'VideoPlayer': '../shared/js/media/video_player',
    'MediaFrame': '../shared/js/media/media_frame',
    'BlobView': '../shared/js/blobview',
    'CustomDialog': '../shared/js/custom_dialog',
    'FontSizeUtils': '../shared/js/font_size_utils',
    'debug': 'vendor/debug'
  },
  shim: {
    'format': {
      exports: 'Format'
    },
    'getVideoRotation': {
      deps: ['BlobView'],
      exports: 'getVideoRotation'
    },
    'MediaFrame': {
      deps: ['format', 'VideoPlayer'],
      exports: 'MediaFrame'
    },
    'BlobView': {
      exports: 'BlobView'
    },
    'asyncStorage': {
      exports: 'asyncStorage'
    },
    'performance-testing-helper': {
      exports: 'PerformanceTestingHelper'
    },
    'jpegMetaDataParser': {
      deps: ['BlobView'],
      exports: 'parseJPEGMetadata'
    },
    'getImageSize': {
      deps: ['BlobView', 'jpegMetaDataParser'],
      exports: 'getImageSize'
    },
    'cropResizeRotate': {
      deps: ['BlobView', 'getImageSize', 'jpegMetaDataParser', 'downsample'],
      exports: 'cropResizeRotate'
    },
    'GestureDetector': {
      exports: 'GestureDetector'
    },
    'CustomDialog': {
      exports: 'CustomDialog'
    },
    'FontSizeUtils': {
      exports: 'FontSizeUtils'
    }
  }
});

define("config/require", function(){});

require(["main"]);
