var ssrdSpeed = 1,
	ssrdDisplay = 0;

var getHotData = function() {
	return $.ajax({
		url:'http://webapi.br.baidu.com/V1/mini_billboard.jsonp',
		type: "GET",
		cache:true,
	    dataType:'jsonp',
	    jsonp: 'cb',
	    jsonpCallback:'getNews',
	    success:function(item){
	    	if(!item  || !item.data || !item.data.keywords){
	    		return;
	    	}
            var arr = item.data.keywords;
            arr.length = 11;
            for(var i=0;i<arr.length;i++){
                main_obj.fullPoint[i].text = arr[i].keyword;
                main_obj.fullPoint[i+11].text = arr[i].keyword;
            }
	    }
	}); 
};

var main_obj = {
	

	fullPoint : [
	    {x:'116',y:'327',color:'#99c7dd',text:''},
		{x:'270',y:'406',color:'#93dba0',text:''},
		{x:'433',y:'239',color:'#4fc971',text:''},
		{x:'636',y:'411',color:'#f1ab1f',text:''},
		{x:'774',y:'304',color:'#f6b7a2',text:''},
		{x:'879',y:'467',color:'#ec9f8a',text:''},
		{x:'1104',y:'329',color:'#eb4d68',text:''},
		{x:'1252',y:'263',color:'#9053e2',text:''},
		{x:'1374',y:'393',color:'#6c73e3',text:''},
		{x:'1596',y:'325',color:'#43c8b4',text:''},
		{x:'1839',y:'314',color:'#fbbf9f',text:''},


		{x:'2036',y:'327',color:'#99c7dd',text:''},
		{x:'2190',y:'406',color:'#93dba0',text:''},
		{x:'2353',y:'239',color:'#4fc971',text:''},
		{x:'2556',y:'411',color:'#f1ab1f',text:''},
		{x:'2694',y:'304',color:'#f6b7a2',text:''},
		{x:'2799',y:'467',color:'#ec9f8a',text:''},
		{x:'3024',y:'329',color:'#eb4d68',text:''},
		{x:'3172',y:'263',color:'#9053e2',text:''},
		{x:'3294',y:'393',color:'#6c73e3',text:''},
		{x:'3516',y:'325',color:'#43c8b4',text:''},
		{x:'3759',y:'314',color:'#fbbf9f',text:''}
  	],
	timer:0,

	movefunc:function(){
		var self = this,
		    length = 0-$("#main").offsetLeft;

		ssrdDisplay = 1;
		  
		$("#searched_logo").stop(true).fadeIn();
		$(".logo_span").stop(true).fadeOut(500);
		$('#main').stop(true).animate({
	    	top: -100,
	    	left: 150,
	    	'margin-left': 0
	    }, function() {
	    	$('#ssrd').stop(true).fadeIn();
	    	
	    	self.ssrdMountain();
	    	getHotData().done(function() {
	        	main_obj.init();
		       	randomObj.start();
	        });
	    });
		
		$('.index_tab_top').animate({
			'margin-left': -120
		});
	},
    
    backfunc:function(){
    	ssrdDisplay = 0;

    	clearInterval(this.timer);
    	
    	$('#ssrd').stop(true).fadeOut();
    	$("#searched_logo").stop(true).fadeOut();
		$(".logo_span").stop(true).fadeIn();
			
		$('#main').stop(true).animate({
	    	top: 90,
	    	left: '50%',
	    	'margin-left': -350
	  	}, function() {
	  		
	  	});
    	
    	$('.index_tab_top').stop(true).animate({
			'margin-left': -80
		});
    	
	    randomObj.stop();
    },


	ssrdMountain:function(){
		var self = this,
		    left = 0,
		    delay = 60;
		    chartWidth = $(".stats-data").width(),
		    halfChartWidth = chartWidth/2,
		    $sdw = $(".stats-data-wrapper");
		    
	    this.timer = setInterval(function(){
			if(left >= halfChartWidth){
			    left = 0;
		    }else{
		    	left = left + ssrdSpeed;
		    	left = Math.min(halfChartWidth,left);
		    }
	        $sdw.css('left', -left);
		},delay);
	},

	ssrdTextStyle:function(){
		var self = this;
		$('#ssrd').on('mouseenter','li', function(){
			var that = this;
			var i = $(this).index();

            randomObj.stop();

			$(that).find('table').css('background',self.fullPoint[i].color);
		    $(that).find('span').show();
		    $(that).find('span').css('border-top-color',self.fullPoint[i].color);
		    $(that).find('a').css('color','#fff');
		}).on('mouseleave','li', function(){
			var that = this;
			var i = $(this).index();
			$(that).find('table').css('background','none');
		    $(that).find('span').hide();
		    $(that).find('a').css('color',self.fullPoint[i].color);
		    randomObj.start();
		});
		
		$("#ssrd ul li").each(function(i){
			var that = this; 
			$(that).css({
				left: self.fullPoint[i].x-40,
				bottom: 600-self.fullPoint[i].y
	       });
		});

	},

	ssrdTextColor:function(){
		var self = this;
		$("#ssrd ul li").each(function(i){
			var that = this;
			//$(that).find('tr').css('color',self.fullPoint[i].color);
			$(that).find('td').html('<a>'+self.fullPoint[i].text + '</a>');
			$(that).find('a').css('color',self.fullPoint[i].color).attr('href','http://www.baidu.com/s?wd='+ encodeURIComponent(self.fullPoint[i].text));
		});
	},

	init: function() {
		if (!this.initialized) {
			this.ssrdTextStyle();
			this.initialized = true;
		}
		this.ssrdTextColor();
	}
};

var randomObj = {

	start:function(){
		var self = this;
		var delay = 5000; 
		clearTimeout(this.timer);
		this.timer = setTimeout(function(){
			var arr = self.selectRandomDate();
			if(arr.length == 0){
				self.start();
				return;
			}
			var j = Math.floor(Math.random()*arr.length),
			    i = arr[j], 
			    randomDate = $("#ssrd ul li").eq(i);
			
			self.reset();
			randomDate.find('table').css('background',main_obj.fullPoint[i].color);
		    randomDate.find('span').show();
		    randomDate.find('span').css('border-top-color',main_obj.fullPoint[i].color);
		    randomDate.find('a').css('color','#fff');

            self.start();
		},delay);
	},
 
	stop:function(){
		clearTimeout(this.timer);
        this.reset();
	},

	reset:function(){
		$("#ssrd ul").find('li').each(function(){
				var that = this;
				var i = $(this).index();
				$(that).find('table').css('background','none');
			    $(that).find('span').hide();
			    $(that).find('a').css('color',main_obj.fullPoint[i].color);	          
			});
	},

	selectRandomDate:function(){

        var chartWidth = $(".stats-data").width()/2,
            windowWidth = $(window).width(),
            wrapperLeft = Math.abs(parseInt($('.stats-data-wrapper').css('left')) || 0);
            DateArr = [];
        var that = this;
        $.each(main_obj.fullPoint,function(i,item){
			    var left = main_obj.fullPoint[i].x;

			if((left-wrapperLeft)>0&&(left-wrapperLeft)<windowWidth){
				DateArr.push(i);
			};
		});
		return DateArr;
	}

};

$('#su').on('click',function (e) {
    var isEmpty = $.trim($('#kw').val()) == '';
    if(isEmpty){
        e.preventDefault();
        location.reload(true);
    }
});

$('#kw').on('keydown',function(e){
    if(e.keyCode == 13){
        var isEmpty = $.trim($('#kw').val()) == '';
        if(isEmpty){
            e.preventDefault();
            location.reload(true);
            return false;
        }
    }
})

 
/*use for baidu Statistics of user action */
var bdStatistics = function(){

	$('#ssrd').on('click','a',function(){
		var _this = $(this),
		    href = _this.attr('href'),
		    title = _this.html(),
		    moduleId_1 = 1304,
		    moduleId_2 = 1302;

		dataReport(moduleId_1,[
			{key:101,value:title},
			{key:102,value:href},
			{key:103,value:1}
		]);

		dataReport(moduleId_2,[
			{key:3,value:href}
		]);
	});

	$('#button-show-chart').on('mouseenter',function(){
		var moduleId = 1304;
		dataReport(moduleId,[{key:1,value:1}]);
	}).on('click',function(){
		var moduleId = 1304;
		dataReport(moduleId,[{key:2,value:1}]);
	});
    
    $('#su').on('click',function(){
    	var moduleId_1 = 1302,
    	    moduleId_2 = 1303,
    	    url = 'http://www.baidu.com/s?wd=' + $('#kw').val();

    	    dataReport(moduleId_1,[{key:2,value:url}]);
    	    dataReport(moduleId_2,[{key:3,value:url}]);
    });

    $('#form').on('keypress',function(event){
    	if(event.keyCode == "13"){
    		var moduleId_1 = 1302,
    	    moduleId_2 = 1303,
    	    url = 'http://www.baidu.com/s?wd=' + $('#kw').val();

    	    dataReport(moduleId_1,[{key:2,value:url}]);
    	    dataReport(moduleId_2,[{key:3,value:url}]);
    	}
    });
             
    $('#searched_logo').on('click',function(){
		var moduleId = 1305;
		dataReport(moduleId,[{key:2,value:1}]);
	});
};

$('#searched_logo').on('click',function(){

	button = $('#button-show-chart');
	icon = $('.button-show-chart-icon');
	text = $('.button-show-chart-text');

	button.addClass('button-show-chart-expand');
	button.removeClass('button-show-chart-collapse');
	breathingLight._start();
    icon.css('background-color', '#cfe2ff');

    var buttonOriPos = {
			left: '50%',
			marginLeft: -25
		};

    var top = $(window).height() - button.height() - 76;
	buttonOriPos.top = top < 310 ? 310 : top;
	
    button.stop(true).animate(buttonOriPos, 800, function() {
				text.show();
			});

	clouds.stop();
	main_obj.backfunc();
});

function mousewheelEvent(e, delta) {
	var r = delta/120;
	if(ssrdDisplay > 0){
		ssrdSpeed = ssrdSpeed + r;
		if(ssrdSpeed >12){
			ssrdSpeed = 12;
		}else if(ssrdSpeed < 1){
			ssrdSpeed = 1;
		}
	}
};
             
/*if(document.attachEvent) {
    document.attachEvent("onmousewheel", function(e) {
        mousewheelEvent(e, e.wheelDelta);
    });
}*/
