var breathingLight = {
	_start: function(delay, speed) {
		var that = this;
		
		delay = delay || 1800;
		speed = speed || 800;
		
		if ($('html').hasClass('lt-ie7')) {
			return;
		}
		
		this.$icon.animate({
			backgroundColor: '#b5d2ff'
		}, speed, function() {
			that.$icon.animate({
				backgroundColor: '#cfe2ff'
			}, speed);
		});
		
		this._runTimer = setTimeout(function() {
			that._start(delay, speed);
		}, delay);
	},
	_stop: function() {
		clearTimeout(this._runTimer);
		this.$icon.finish();
	},
	
	_calcButtonTop: function() {
		var top = $(window).height() - this.$button.height() - 76;
		
		this.buttonOriPos.top = top < 310 ? 310 : top;
		if (this.$button.hasClass('button-show-chart-expand') && !this.$button.is(':animated')) {
			this.$button.css('top', this.buttonOriPos.top);
		}
	},
	
	init: function() {
		var that = this;
		
		this.$button = $('#button-show-chart');
		this.$icon = this.$button.find('.button-show-chart-icon');
		this.$text = this.$button.find('.button-show-chart-text');
		
		this.buttonOriPos = {
			left: '50%',
			marginLeft: -25
		};
		
		this.$button.show();
		this._calcButtonTop();
		
		$(window).resize(function() {
			clearTimeout(that.resizeTimer);
			that.resizeTimer = setTimeout(function() {
				that._calcButtonTop();
			}, 20);
		});
		
		this._start();
		this.$button.on('click', function(event) {
			var hasExpand, buttonTarPos,
				buttonNewPos = {
					top: 58,
					left: '94%',
					marginLeft: 0
				};
					
			that.$button.toggleClass('button-show-chart-expand button-show-chart-collapse');
			hasExpand = that.$button.hasClass('button-show-chart-expand');
			that[hasExpand ? '_start' : '_stop']();
			that.$icon.css('background-color', (hasExpand ? '#cfe2ff' : 'transparent'));
			
			buttonTarPos = hasExpand ? that.buttonOriPos : buttonNewPos;
			that.$button.stop(true).animate(buttonTarPos, 800, function() {
				that.$text[hasExpand ? 'show' : 'hide']();
			});
			
			main_obj[hasExpand ? 'backfunc' : 'movefunc']();
			clouds[hasExpand ? 'stop' : 'run']();

			event.preventDefault();
		});
	}
};

var clouds = {
	run: function() {
		var that = this;
			
		this.running = true;
		this.$clouds.each(function(i) {
			$(this).animate({
				left: $(window).width()
			}, that.oriPos[i].speed, function() {
				$(this).css('left', -that.oriPos[i].width);
				if (that.running) {
					that.run();
				}
			});
		});
	},
	stop: function() {
		var that = this;
		
		this.running = false;
		this.$clouds.stop(true, true)
			.each(function(i) {
				$(this).css('left', that.oriPos[i].left);
			});
	},
	init: function() {
		this.oriPos = [
			{left: 359, width: 59, speed: 65000},
			{left: 981, width: 61, speed: 60000},
			{left: 1457, width: 59, speed: 70000}
		];
		this.$clouds = $('.cloud');
	}
};

var suggestion = {
	search: function() {
		$('#form').submit();
	},
	
	init: function() {
		var that = this;
		
		this.$textinput = $('#kw');
		
		this.$textinput.autocomplete({
			appendTo: '#main',
			position: {
				my: 'left top-1',
				of: '.s_ipt_wr'
			},
			select  : function (e, ui) {
                that.$textinput.val(ui.item.value);
                that.search();
            },
            search: function (event) {
                if (event.keyCode === $.ui.keyCode.RIGHT ||
                    event.keyCode === $.ui.keyCode.LEFT) {

                    return false;
                }
            },
            source: function (req, res) {
                $.ajax({
                    scriptCharset: 'gbk',
                    url: 'http://suggestion.baidu.com/su?cb=?',
                    data: {
                        p: 3,
                        wd: req.term,
                        json: 1,
                        xzmode: 1
                    },
                    dataType: 'jsonp',
                    success: function(data) {
                    	res(data.s);
                    }
                });
            }
		})
		.data('ui-autocomplete')._renderItem = function (ul, item) {
	        return $('<li>')
	            .append('<a>' + item.label.replace(new RegExp('(' +  $.ui.autocomplete.escapeRegex(this.term) + ')', 'i'),
	                	'<strong>$1</strong>') + 
	                	'</a>')
	            .appendTo(ul);
	   	};
	    
	    this.$textinput.data('ui-autocomplete')._resizeMenu = function() {
	    	this.menu.element.outerWidth($('.s_ipt_wr').outerWidth());
	    };
	}
};

breathingLight.init();
clouds.init();
suggestion.init(); 
bdStatistics();