/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.awt.ConstrainableGraphics;
import sun.awt.SunHints;
import sun.font.FontDesignMetrics;
import sun.font.FontManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.NullSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.FontInfo;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.misc.PerformanceLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SunGraphics2D
extends Graphics2D
implements ConstrainableGraphics,
Cloneable {
    public static final int PAINT_CUSTOM = 4;
    public static final int PAINT_TEXTURE = 3;
    public static final int PAINT_GRADIENT = 2;
    public static final int PAINT_ALPHACOLOR = 1;
    public static final int PAINT_OPAQUECOLOR = 0;
    public static final int COMP_CUSTOM = 3;
    public static final int COMP_XOR = 2;
    public static final int COMP_ALPHA = 1;
    public static final int COMP_ISCOPY = 0;
    public static final int STROKE_CUSTOM = 3;
    public static final int STROKE_WIDE = 2;
    public static final int STROKE_THINDASHED = 1;
    public static final int STROKE_THIN = 0;
    public static final int TRANSFORM_GENERIC = 4;
    public static final int TRANSFORM_TRANSLATESCALE = 3;
    public static final int TRANSFORM_ANY_TRANSLATE = 2;
    public static final int TRANSFORM_INT_TRANSLATE = 1;
    public static final int TRANSFORM_ISIDENT = 0;
    public static final int CLIP_SHAPE = 2;
    public static final int CLIP_RECTANGULAR = 1;
    public static final int CLIP_DEVICE = 0;
    public int eargb;
    public int pixel;
    public SurfaceData surfaceData;
    public PixelDrawPipe drawpipe;
    public PixelFillPipe fillpipe;
    public DrawImagePipe imagepipe;
    public ShapeDrawPipe shapepipe;
    public TextPipe textpipe;
    public MaskFill alphafill;
    public RenderLoops loops;
    public CompositeType imageComp;
    public int paintState;
    public int compositeState;
    public int strokeState;
    public int transformState;
    public int clipState;
    public Color foregroundColor;
    public Color backgroundColor;
    public AffineTransform transform;
    public int transX;
    public int transY;
    protected static final Stroke defaultStroke = new BasicStroke();
    protected static final Composite defaultComposite = AlphaComposite.SrcOver;
    private static final Font defaultFont = new Font("Dialog", 0, 12);
    public Paint paint;
    public Stroke stroke;
    public Composite composite;
    protected Font font;
    protected FontMetrics fontMetrics;
    public int renderHint;
    public int antialiasHint;
    public int textAntialiasHint;
    private int fractionalMetricsHint;
    public int lcdTextContrast;
    private static int lcdTextContrastDefaultValue = 140;
    private int interpolationHint;
    public int strokeHint;
    public int interpolationType;
    public RenderingHints hints;
    public Region constrainClip;
    public int constrainX;
    public int constrainY;
    public Region clipRegion;
    public Shape usrClip;
    protected Region devClip;
    private boolean validFontInfo;
    private FontInfo fontInfo;
    private FontInfo glyphVectorFontInfo;
    private FontRenderContext glyphVectorFRC;
    private static final int slowTextTransformMask = 120;
    protected static ValidatePipe invalidpipe;
    private static final double[] IDENT_MATRIX;
    private static final AffineTransform IDENT_ATX;
    private static final int MINALLOCATED = 8;
    private static final int TEXTARRSIZE = 17;
    private static double[][] textTxArr;
    private static AffineTransform[] textAtArr;
    static final int NON_UNIFORM_SCALE_MASK = 36;
    public static final double MinPenSizeAASquared = 0.03999999538064003;
    public static final double MinPenSizeSquared = 1.000000001;
    static final int NON_RECTILINEAR_TRANSFORM_MASK = 48;
    Blit lastCAblit;
    Composite lastCAcomp;
    private FontRenderContext cachedFRC;

    public SunGraphics2D(SurfaceData surfaceData, Color color, Color color2, Font font) {
        this.surfaceData = surfaceData;
        this.foregroundColor = color;
        this.backgroundColor = color2;
        this.transform = new AffineTransform();
        this.stroke = defaultStroke;
        this.composite = defaultComposite;
        this.paint = this.foregroundColor;
        this.imageComp = CompositeType.SrcOverNoEa;
        this.renderHint = 0;
        this.antialiasHint = 1;
        this.textAntialiasHint = 0;
        this.fractionalMetricsHint = 1;
        this.lcdTextContrast = lcdTextContrastDefaultValue;
        this.interpolationHint = -1;
        this.strokeHint = 0;
        this.interpolationType = 1;
        this.validateColor();
        this.font = font;
        if (this.font == null) {
            this.font = defaultFont;
        }
        this.loops = surfaceData.getRenderLoops(this);
        this.setDevClip(surfaceData.getBounds());
        this.invalidatePipe();
    }

    protected Object clone() {
        try {
            SunGraphics2D sunGraphics2D = (SunGraphics2D)super.clone();
            sunGraphics2D.transform = new AffineTransform(this.transform);
            if (this.hints != null) {
                sunGraphics2D.hints = (RenderingHints)this.hints.clone();
            }
            if (this.fontInfo != null) {
                sunGraphics2D.fontInfo = this.validFontInfo ? (FontInfo)this.fontInfo.clone() : null;
            }
            if (this.glyphVectorFontInfo != null) {
                sunGraphics2D.glyphVectorFontInfo = (FontInfo)this.glyphVectorFontInfo.clone();
                sunGraphics2D.glyphVectorFRC = this.glyphVectorFRC;
            }
            return sunGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Graphics create() {
        return (Graphics)this.clone();
    }

    public void setDevClip(int n, int n2, int n3, int n4) {
        Region region = this.constrainClip;
        this.devClip = region == null ? Region.getInstanceXYWH(n, n2, n3, n4) : region.getIntersectionXYWH(n, n2, n3, n4);
        this.validateCompClip();
    }

    public void setDevClip(Rectangle rectangle) {
        this.setDevClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void constrain(int n, int n2, int n3, int n4) {
        if ((n | n2) != 0) {
            this.translate(n, n2);
        }
        if (this.transformState >= 3) {
            this.clipRect(0, 0, n3, n4);
            return;
        }
        n = this.constrainX = this.transX;
        n2 = this.constrainY = this.transY;
        n3 = Region.dimAdd(n, n3);
        n4 = Region.dimAdd(n2, n4);
        Region region = this.constrainClip;
        if (region == null) {
            region = Region.getInstanceXYXY(n, n2, n3, n4);
        } else if ((region = region.getIntersectionXYXY(n, n2, n3, n4)) == this.constrainClip) {
            return;
        }
        this.constrainClip = region;
        if (!this.devClip.isInsideQuickCheck(region)) {
            this.devClip = this.devClip.getIntersection(region);
            this.validateCompClip();
        }
    }

    protected void invalidatePipe() {
        this.drawpipe = invalidpipe;
        this.fillpipe = invalidpipe;
        this.shapepipe = invalidpipe;
        this.textpipe = invalidpipe;
        this.imagepipe = invalidpipe;
    }

    public void validatePipe() {
        this.surfaceData.validatePipe(this);
    }

    Shape intersectShapes(Shape shape, Shape shape2, boolean bl, boolean bl2) {
        if (shape instanceof Rectangle && shape2 instanceof Rectangle) {
            return ((Rectangle)shape).intersection((Rectangle)shape2);
        }
        if (shape instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)shape, shape2, bl, bl2);
        }
        if (shape2 instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)shape2, shape, bl2, bl);
        }
        return this.intersectByArea(shape, shape2, bl, bl2);
    }

    Shape intersectRectShape(Rectangle2D rectangle2D, Shape shape, boolean bl, boolean bl2) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D2 = (Rectangle2D)shape;
            Rectangle2D rectangle2D3 = !bl ? rectangle2D : (!bl2 ? rectangle2D2 : new Rectangle2D.Float());
            double d = Math.max(rectangle2D.getX(), rectangle2D2.getX());
            double d2 = Math.min(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D2.getX() + rectangle2D2.getWidth());
            double d3 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
            double d4 = Math.min(rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY() + rectangle2D2.getHeight());
            if (d2 - d < 0.0 || d4 - d3 < 0.0) {
                rectangle2D3.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                rectangle2D3.setFrameFromDiagonal(d, d3, d2, d4);
            }
            return rectangle2D3;
        }
        if (rectangle2D.contains(shape.getBounds2D())) {
            if (bl2) {
                shape = SunGraphics2D.cloneShape(shape);
            }
            return shape;
        }
        return this.intersectByArea(rectangle2D, shape, bl, bl2);
    }

    protected static Shape cloneShape(Shape shape) {
        return new GeneralPath(shape);
    }

    Shape intersectByArea(Shape shape, Shape shape2, boolean bl, boolean bl2) {
        Area area;
        if (!bl && shape instanceof Area) {
            area = (Area)shape;
        } else if (!bl2 && shape2 instanceof Area) {
            area = (Area)shape2;
            shape2 = shape;
        } else {
            area = new Area(shape);
        }
        Area area2 = shape2 instanceof Area ? (Area)shape2 : new Area(shape2);
        area.intersect(area2);
        if (area.isRectangular()) {
            return area.getBounds();
        }
        return area;
    }

    public Region getCompClip() {
        if (!this.surfaceData.isValid()) {
            this.revalidateAll();
        }
        return this.clipRegion;
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.font = defaultFont;
        }
        return this.font;
    }

    public FontInfo checkFontInfo(FontInfo fontInfo, Font font, FontRenderContext fontRenderContext) {
        AffineTransform affineTransform;
        if (fontInfo == null) {
            fontInfo = new FontInfo();
        }
        float f = font.getSize2D();
        AffineTransform affineTransform2 = null;
        if (font.isTransformed()) {
            affineTransform2 = font.getTransform();
            affineTransform2.scale(f, f);
            int n = affineTransform2.getType();
            fontInfo.originX = (float)affineTransform2.getTranslateX();
            fontInfo.originY = (float)affineTransform2.getTranslateY();
            affineTransform2.translate(-fontInfo.originX, -fontInfo.originY);
            if (this.transformState >= 3) {
                fontInfo.devTx = new double[4];
                this.transform.getMatrix(fontInfo.devTx);
                affineTransform = new AffineTransform(fontInfo.devTx);
                affineTransform2.preConcatenate(affineTransform);
            } else {
                fontInfo.devTx = IDENT_MATRIX;
                affineTransform = IDENT_ATX;
            }
            fontInfo.glyphTx = new double[4];
            affineTransform2.getMatrix(fontInfo.glyphTx);
            double d = affineTransform2.getShearX();
            double d2 = affineTransform2.getScaleY();
            if (d != 0.0) {
                d2 = Math.sqrt(d * d + d2 * d2);
            }
            fontInfo.pixelHeight = (int)(Math.abs(d2) + 0.5);
        } else {
            boolean bl = false;
            fontInfo.originY = 0.0f;
            fontInfo.originX = 0.0f;
            if (this.transformState >= 3) {
                fontInfo.devTx = new double[4];
                this.transform.getMatrix(fontInfo.devTx);
                affineTransform = new AffineTransform(fontInfo.devTx);
                fontInfo.glyphTx = new double[4];
                for (int i = 0; i < 4; ++i) {
                    fontInfo.glyphTx[i] = fontInfo.devTx[i] * (double)f;
                }
                affineTransform2 = new AffineTransform(fontInfo.glyphTx);
                double d = this.transform.getShearX();
                double d3 = this.transform.getScaleY();
                if (d != 0.0) {
                    d3 = Math.sqrt(d * d + d3 * d3);
                }
                fontInfo.pixelHeight = (int)(Math.abs(d3 * (double)f) + 0.5);
            } else {
                int n = (int)f;
                if (f == (float)n && n >= 8 && n < 17) {
                    fontInfo.glyphTx = textTxArr[n];
                    affineTransform2 = textAtArr[n];
                    fontInfo.pixelHeight = n;
                } else {
                    fontInfo.pixelHeight = (int)((double)f + 0.5);
                }
                if (affineTransform2 == null) {
                    fontInfo.glyphTx = new double[]{f, 0.0, 0.0, f};
                    affineTransform2 = new AffineTransform(fontInfo.glyphTx);
                }
                fontInfo.devTx = IDENT_MATRIX;
                affineTransform = IDENT_ATX;
            }
        }
        fontInfo.font2D = FontManager.getFont2D(font);
        int n = this.fractionalMetricsHint;
        if (n == 0) {
            n = 1;
        }
        fontInfo.lcdSubPixPos = false;
        int n2 = fontRenderContext == null ? this.textAntialiasHint : ((SunHints.Value)fontRenderContext.getAntiAliasingHint()).getIndex();
        if (n2 == 0) {
            n2 = this.antialiasHint == 2 ? 2 : 1;
        } else if (n2 == 3) {
            n2 = fontInfo.font2D.useAAForPtSize(fontInfo.pixelHeight) ? 2 : 1;
        } else if (n2 >= 4) {
            if (!this.surfaceData.canRenderLCDText(this)) {
                n2 = 2;
            } else {
                fontInfo.lcdRGBOrder = true;
                if (n2 == 5) {
                    n2 = 4;
                    fontInfo.lcdRGBOrder = false;
                } else if (n2 == 7) {
                    n2 = 6;
                    fontInfo.lcdRGBOrder = false;
                }
                fontInfo.lcdSubPixPos = n == 2 && n2 == 4;
            }
        }
        fontInfo.aaHint = n2;
        fontInfo.fontStrike = fontInfo.font2D.getStrike(font, affineTransform, affineTransform2, n2, n);
        return fontInfo;
    }

    public static boolean isRotated(double[] dArray) {
        return dArray[0] != dArray[3] || dArray[1] != 0.0 || dArray[2] != 0.0 || !(dArray[0] > 0.0);
    }

    @Override
    public void setFont(Font font) {
        if (font != null && font != this.font) {
            if (this.textAntialiasHint == 3 && this.textpipe != invalidpipe && (this.transformState > 2 || font.isTransformed() || this.fontInfo == null || this.fontInfo.aaHint == 2 != FontManager.getFont2D(font).useAAForPtSize(font.getSize()))) {
                this.textpipe = invalidpipe;
            }
            this.font = font;
            this.fontMetrics = null;
            this.validFontInfo = false;
        }
    }

    public FontInfo getFontInfo() {
        if (!this.validFontInfo) {
            this.fontInfo = this.checkFontInfo(this.fontInfo, this.font, null);
            this.validFontInfo = true;
        }
        return this.fontInfo;
    }

    public FontInfo getGVFontInfo(Font font, FontRenderContext fontRenderContext) {
        if (this.glyphVectorFontInfo != null && this.glyphVectorFontInfo.font == font && this.glyphVectorFRC == fontRenderContext) {
            return this.glyphVectorFontInfo;
        }
        this.glyphVectorFRC = fontRenderContext;
        this.glyphVectorFontInfo = this.checkFontInfo(this.glyphVectorFontInfo, font, fontRenderContext);
        return this.glyphVectorFontInfo;
    }

    @Override
    public FontMetrics getFontMetrics() {
        if (this.fontMetrics != null) {
            return this.fontMetrics;
        }
        this.fontMetrics = FontDesignMetrics.getMetrics(this.font, this.getFontRenderContext());
        return this.fontMetrics;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (this.fontMetrics != null && font == this.font) {
            return this.fontMetrics;
        }
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(font, this.getFontRenderContext());
        if (this.font == font) {
            this.fontMetrics = fontDesignMetrics;
        }
        return fontDesignMetrics;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.stroke.createStrokedShape(shape);
        }
        shape = this.transformShape(shape);
        if ((this.constrainX | this.constrainY) != 0) {
            rectangle = new Rectangle(rectangle);
            rectangle.translate(this.constrainX, this.constrainY);
        }
        return shape.intersects(rectangle);
    }

    public ColorModel getDeviceColorModel() {
        return this.surfaceData.getColorModel();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.surfaceData.getDeviceConfiguration();
    }

    public final SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    @Override
    public void setComposite(Composite composite) {
        int n;
        CompositeType compositeType;
        if (this.composite == composite) {
            return;
        }
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            compositeType = CompositeType.forAlphaComposite(alphaComposite);
            n = compositeType == CompositeType.SrcOverNoEa ? (this.paintState == 0 || this.paintState > 1 && this.paint.getTransparency() == 1 ? 0 : 1) : (compositeType == CompositeType.SrcNoEa || compositeType == CompositeType.Src || compositeType == CompositeType.Clear ? 0 : (this.surfaceData.getTransparency() == 1 && compositeType == CompositeType.SrcIn ? 0 : 1));
        } else if (composite instanceof XORComposite) {
            n = 2;
            compositeType = CompositeType.Xor;
        } else {
            if (composite == null) {
                throw new IllegalArgumentException("null Composite");
            }
            this.surfaceData.checkCustomComposite();
            n = 3;
            compositeType = CompositeType.General;
        }
        if (this.compositeState != n || this.imageComp != compositeType) {
            this.compositeState = n;
            this.imageComp = compositeType;
            this.invalidatePipe();
        }
        this.composite = composite;
        if (this.paintState <= 1) {
            this.validateColor();
        }
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (paint == null || this.paint == paint) {
            return;
        }
        this.paint = paint;
        if (this.imageComp == CompositeType.SrcOverNoEa) {
            if (paint.getTransparency() == 1) {
                if (this.compositeState != 0) {
                    this.compositeState = 0;
                }
            } else if (this.compositeState == 0) {
                this.compositeState = 1;
            }
        }
        this.paintState = paint.getClass() == GradientPaint.class ? 2 : (paint.getClass() == TexturePaint.class ? 3 : 4);
        this.invalidatePipe();
    }

    private void validateBasicStroke(BasicStroke basicStroke) {
        boolean bl;
        boolean bl2 = bl = this.antialiasHint == 2;
        if (this.transformState < 3) {
            this.strokeState = bl ? (basicStroke.getLineWidth() <= 0.19999999f ? (basicStroke.getDashArray() == null ? 0 : 1) : 2) : (basicStroke == defaultStroke ? 0 : (basicStroke.getLineWidth() <= 1.0f ? (basicStroke.getDashArray() == null ? 0 : 1) : 2));
        } else {
            double d;
            if ((this.transform.getType() & 0x24) == 0) {
                d = Math.abs(this.transform.getDeterminant());
            } else {
                double d2 = this.transform.getScaleX();
                double d3 = this.transform.getShearX();
                double d4 = this.transform.getShearY();
                double d5 = this.transform.getScaleY();
                double d6 = d2 * d2 + d4 * d4;
                double d7 = 2.0 * (d2 * d3 + d4 * d5);
                double d8 = d3 * d3 + d5 * d5;
                double d9 = Math.sqrt(d7 * d7 + (d6 - d8) * (d6 - d8));
                d = (d6 + d8 + d9) / 2.0;
            }
            if (basicStroke != defaultStroke) {
                d *= (double)(basicStroke.getLineWidth() * basicStroke.getLineWidth());
            }
            this.strokeState = d <= (bl ? 0.03999999538064003 : 1.000000001) ? (basicStroke.getDashArray() == null ? 0 : 1) : 2;
        }
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("null Stroke");
        }
        int n = this.strokeState;
        this.stroke = stroke;
        if (stroke instanceof BasicStroke) {
            this.validateBasicStroke((BasicStroke)stroke);
        } else {
            this.strokeState = 3;
        }
        if (this.strokeState != n) {
            this.invalidatePipe();
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (!key.isCompatibleValue(object)) {
            throw new IllegalArgumentException(object + " is not compatible with " + key);
        }
        if (key instanceof SunHints.Key) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = true;
            SunHints.Key key2 = (SunHints.Key)key;
            int n = key2 == SunHints.KEY_TEXT_ANTIALIAS_LCD_CONTRAST ? ((Integer)object).intValue() : ((SunHints.Value)object).getIndex();
            switch (key2.getIndex()) {
                case 0: {
                    boolean bl4 = bl = this.renderHint != n;
                    if (!bl) break;
                    this.renderHint = n;
                    if (this.interpolationHint != -1) break;
                    this.interpolationType = n == 2 ? 2 : 1;
                    break;
                }
                case 1: {
                    bl = this.antialiasHint != n;
                    this.antialiasHint = n;
                    if (!bl) break;
                    boolean bl5 = bl2 = this.textAntialiasHint == 0 || this.textAntialiasHint >= 4;
                    if (this.strokeState == 3) break;
                    this.validateBasicStroke((BasicStroke)this.stroke);
                    break;
                }
                case 2: {
                    bl2 = bl = this.textAntialiasHint != n;
                    this.textAntialiasHint = n;
                    break;
                }
                case 3: {
                    bl2 = bl = this.fractionalMetricsHint != n;
                    this.fractionalMetricsHint = n;
                    break;
                }
                case 100: {
                    bl = false;
                    this.lcdTextContrast = n;
                    break;
                }
                case 5: {
                    this.interpolationHint = n;
                    switch (n) {
                        case 2: {
                            n = 3;
                            break;
                        }
                        case 1: {
                            n = 2;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    bl = this.interpolationType != n;
                    this.interpolationType = n;
                    break;
                }
                case 8: {
                    bl = this.strokeHint != n;
                    this.strokeHint = n;
                    break;
                }
                default: {
                    bl3 = false;
                    bl = false;
                }
            }
            if (bl3) {
                if (bl) {
                    this.invalidatePipe();
                    if (bl2) {
                        this.fontMetrics = null;
                        this.cachedFRC = null;
                        this.validFontInfo = false;
                        this.glyphVectorFontInfo = null;
                    }
                }
                if (this.hints != null) {
                    this.hints.put(key, object);
                }
                return;
            }
        }
        if (this.hints == null) {
            this.hints = this.makeHints(null);
        }
        this.hints.put(key, object);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        if (this.hints != null) {
            return this.hints.get(key);
        }
        if (!(key instanceof SunHints.Key)) {
            return null;
        }
        int n = ((SunHints.Key)key).getIndex();
        switch (n) {
            case 0: {
                return SunHints.Value.get(0, this.renderHint);
            }
            case 1: {
                return SunHints.Value.get(1, this.antialiasHint);
            }
            case 2: {
                return SunHints.Value.get(2, this.textAntialiasHint);
            }
            case 3: {
                return SunHints.Value.get(3, this.fractionalMetricsHint);
            }
            case 100: {
                return new Integer(this.lcdTextContrast);
            }
            case 5: {
                switch (this.interpolationHint) {
                    case 0: {
                        return SunHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    }
                    case 1: {
                        return SunHints.VALUE_INTERPOLATION_BILINEAR;
                    }
                    case 2: {
                        return SunHints.VALUE_INTERPOLATION_BICUBIC;
                    }
                }
                return null;
            }
            case 8: {
                return SunHints.Value.get(8, this.strokeHint);
            }
        }
        return null;
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.hints = null;
        this.renderHint = 0;
        this.antialiasHint = 1;
        this.textAntialiasHint = 0;
        this.fractionalMetricsHint = 1;
        this.lcdTextContrast = lcdTextContrastDefaultValue;
        this.interpolationHint = -1;
        this.interpolationType = 1;
        boolean bl = false;
        for (Object obj : map.keySet()) {
            if (obj == SunHints.KEY_RENDERING || obj == SunHints.KEY_ANTIALIASING || obj == SunHints.KEY_TEXT_ANTIALIASING || obj == SunHints.KEY_FRACTIONALMETRICS || obj == SunHints.KEY_TEXT_ANTIALIAS_LCD_CONTRAST || obj == SunHints.KEY_STROKE_CONTROL || obj == SunHints.KEY_INTERPOLATION) {
                this.setRenderingHint((RenderingHints.Key)obj, map.get(obj));
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.hints = this.makeHints(map);
        }
        this.invalidatePipe();
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        boolean bl = false;
        for (Object obj : map.keySet()) {
            if (obj == SunHints.KEY_RENDERING || obj == SunHints.KEY_ANTIALIASING || obj == SunHints.KEY_TEXT_ANTIALIASING || obj == SunHints.KEY_FRACTIONALMETRICS || obj == SunHints.KEY_TEXT_ANTIALIAS_LCD_CONTRAST || obj == SunHints.KEY_STROKE_CONTROL || obj == SunHints.KEY_INTERPOLATION) {
                this.setRenderingHint((RenderingHints.Key)obj, map.get(obj));
                continue;
            }
            bl = true;
        }
        if (bl) {
            if (this.hints == null) {
                this.hints = this.makeHints(map);
            } else {
                this.hints.putAll(map);
            }
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        if (this.hints == null) {
            return this.makeHints(null);
        }
        return (RenderingHints)this.hints.clone();
    }

    RenderingHints makeHints(Map map) {
        Object object;
        RenderingHints renderingHints = new RenderingHints(map);
        renderingHints.put(SunHints.KEY_RENDERING, SunHints.Value.get(0, this.renderHint));
        renderingHints.put(SunHints.KEY_ANTIALIASING, SunHints.Value.get(1, this.antialiasHint));
        renderingHints.put(SunHints.KEY_TEXT_ANTIALIASING, SunHints.Value.get(2, this.textAntialiasHint));
        renderingHints.put(SunHints.KEY_FRACTIONALMETRICS, SunHints.Value.get(3, this.fractionalMetricsHint));
        renderingHints.put(SunHints.KEY_TEXT_ANTIALIAS_LCD_CONTRAST, new Integer(this.lcdTextContrast));
        switch (this.interpolationHint) {
            case 0: {
                object = SunHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case 1: {
                object = SunHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case 2: {
                object = SunHints.VALUE_INTERPOLATION_BICUBIC;
                break;
            }
            default: {
                object = null;
            }
        }
        if (object != null) {
            renderingHints.put(SunHints.KEY_INTERPOLATION, object);
        }
        renderingHints.put(SunHints.KEY_STROKE_CONTROL, SunHints.Value.get(8, this.strokeHint));
        return renderingHints;
    }

    @Override
    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        this.invalidateTransform();
    }

    @Override
    public void rotate(double d) {
        this.transform.rotate(d);
        this.invalidateTransform();
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
        this.invalidateTransform();
    }

    @Override
    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        this.invalidateTransform();
    }

    @Override
    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
        this.invalidateTransform();
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.invalidateTransform();
    }

    @Override
    public void translate(int n, int n2) {
        this.transform.translate(n, n2);
        if (this.transformState <= 1) {
            this.transX += n;
            this.transY += n2;
            this.transformState = (this.transX | this.transY) == 0 ? 0 : 1;
        } else {
            this.invalidateTransform();
        }
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        if ((this.constrainX | this.constrainY) == 0) {
            this.transform.setTransform(affineTransform);
        } else {
            this.transform.setToTranslation(this.constrainX, this.constrainY);
            this.transform.concatenate(affineTransform);
        }
        this.invalidateTransform();
    }

    protected void invalidateTransform() {
        int n = this.transform.getType();
        int n2 = this.transformState;
        if (n == 0) {
            this.transformState = 0;
            this.transY = 0;
            this.transX = 0;
        } else if (n == 1) {
            double d = this.transform.getTranslateX();
            double d2 = this.transform.getTranslateY();
            this.transX = (int)Math.floor(d + 0.5);
            this.transY = (int)Math.floor(d2 + 0.5);
            this.transformState = d == (double)this.transX && d2 == (double)this.transY ? 1 : 2;
        } else if ((n & 0x78) == 0) {
            this.transformState = 3;
            this.transY = 0;
            this.transX = 0;
        } else {
            this.transformState = 4;
            this.transY = 0;
            this.transX = 0;
        }
        if (this.transformState >= 3 || n2 >= 3) {
            this.cachedFRC = null;
            this.validFontInfo = false;
            this.fontMetrics = null;
            this.glyphVectorFontInfo = null;
            if (this.transformState != n2) {
                this.invalidatePipe();
            }
        }
        if (this.strokeState != 3) {
            this.validateBasicStroke((BasicStroke)this.stroke);
        }
    }

    @Override
    public AffineTransform getTransform() {
        if ((this.constrainX | this.constrainY) == 0) {
            return new AffineTransform(this.transform);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.constrainX, -this.constrainY);
        affineTransform.concatenate(this.transform);
        return affineTransform;
    }

    public AffineTransform cloneTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public Color getColor() {
        return this.foregroundColor;
    }

    final void validateColor() {
        int n;
        if (this.imageComp == CompositeType.Clear) {
            n = 0;
        } else {
            n = this.foregroundColor.getRGB();
            if (this.compositeState <= 1 && this.imageComp != CompositeType.SrcNoEa && this.imageComp != CompositeType.SrcOverNoEa) {
                AlphaComposite alphaComposite = (AlphaComposite)this.composite;
                int n2 = Math.round(alphaComposite.getAlpha() * (float)(n >>> 24));
                n = n & 0xFFFFFF | n2 << 24;
            }
        }
        this.eargb = n;
        this.pixel = this.surfaceData.pixelFor(n);
    }

    @Override
    public void setColor(Color color) {
        if (color == null || color == this.paint) {
            return;
        }
        this.foregroundColor = color;
        this.paint = this.foregroundColor;
        this.validateColor();
        if (this.eargb >> 24 == -1) {
            if (this.paintState == 0) {
                return;
            }
            this.paintState = 0;
            if (this.imageComp == CompositeType.SrcOverNoEa) {
                this.compositeState = 0;
            }
        } else {
            if (this.paintState == 1) {
                return;
            }
            this.paintState = 1;
            if (this.imageComp == CompositeType.SrcOverNoEa) {
                this.compositeState = 1;
            }
        }
        this.invalidatePipe();
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public Rectangle getClipBounds() {
        Rectangle rectangle;
        if (this.clipState == 0) {
            rectangle = null;
        } else if (this.transformState <= 1) {
            rectangle = this.usrClip instanceof Rectangle ? new Rectangle((Rectangle)this.usrClip) : this.usrClip.getBounds();
            rectangle.translate(-this.transX, -this.transY);
        } else {
            rectangle = this.getClip().getBounds();
        }
        return rectangle;
    }

    @Override
    public Rectangle getClipBounds(Rectangle rectangle) {
        if (this.clipState != 0) {
            if (this.transformState <= 1) {
                if (this.usrClip instanceof Rectangle) {
                    rectangle.setBounds((Rectangle)this.usrClip);
                } else {
                    rectangle.setBounds(this.usrClip.getBounds());
                }
                rectangle.translate(-this.transX, -this.transY);
            } else {
                rectangle.setBounds(this.getClip().getBounds());
            }
        } else if (rectangle == null) {
            throw new NullPointerException("null rectangle parameter");
        }
        return rectangle;
    }

    @Override
    public boolean hitClip(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return false;
        }
        if (this.transformState > 1) {
            double[] dArray = new double[]{n, n2, n + n3, n2, n, n2 + n4, n + n3, n2 + n4};
            this.transform.transform(dArray, 0, dArray, 0, 4);
            n = (int)Math.floor(Math.min(Math.min(dArray[0], dArray[2]), Math.min(dArray[4], dArray[6])));
            n2 = (int)Math.floor(Math.min(Math.min(dArray[1], dArray[3]), Math.min(dArray[5], dArray[7])));
            n3 = (int)Math.ceil(Math.max(Math.max(dArray[0], dArray[2]), Math.max(dArray[4], dArray[6])));
            n4 = (int)Math.ceil(Math.max(Math.max(dArray[1], dArray[3]), Math.max(dArray[5], dArray[7])));
        } else {
            n3 += (n += this.transX);
            n4 += (n2 += this.transY);
        }
        return this.getCompClip().intersectsQuickCheckXYXY(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateCompClip() {
        int n = this.clipState;
        if (this.usrClip == null) {
            this.clipState = 0;
            this.clipRegion = this.devClip;
        } else if (this.usrClip instanceof Rectangle2D) {
            this.clipState = 1;
            this.clipRegion = this.usrClip instanceof Rectangle ? this.devClip.getIntersection((Rectangle)this.usrClip) : this.devClip.getIntersection(this.usrClip.getBounds());
        } else {
            PathIterator pathIterator = this.usrClip.getPathIterator(null);
            int[] nArray = new int[4];
            ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(this, false);
            try {
                shapeSpanIterator.setOutputArea(this.devClip);
                shapeSpanIterator.appendPath(pathIterator);
                shapeSpanIterator.getPathBox(nArray);
                Region region = Region.getInstance(nArray);
                region.appendSpans(shapeSpanIterator);
                this.clipRegion = region;
                this.clipState = region.isRectangular() ? 1 : 2;
            }
            finally {
                shapeSpanIterator.dispose();
            }
        }
        if (n != this.clipState && (this.clipState == 2 || n == 2)) {
            this.invalidatePipe();
        }
    }

    protected Shape transformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (this.transformState > 1) {
            return SunGraphics2D.transformShape(this.transform, shape);
        }
        return SunGraphics2D.transformShape(this.transX, this.transY, shape);
    }

    public Shape untransformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (this.transformState > 1) {
            try {
                return SunGraphics2D.transformShape(this.transform.createInverse(), shape);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return null;
            }
        }
        return SunGraphics2D.transformShape(-this.transX, -this.transY, shape);
    }

    protected static Shape transformShape(int n, int n2, Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = shape.getBounds();
            rectangle.translate(n, n2);
            return rectangle;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            return new Rectangle2D.Double(rectangle2D.getX() + (double)n, rectangle2D.getY() + (double)n2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (n == 0 && n2 == 0) {
            return SunGraphics2D.cloneShape(shape);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        return affineTransform.createTransformedShape(shape);
    }

    protected static Shape transformShape(AffineTransform affineTransform, Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle2D && (affineTransform.getType() & 0x30) == 0) {
            double[] dArray;
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), dArray[0] + rectangle2D.getWidth(), dArray[1] + rectangle2D.getHeight()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            rectangle2D = new Rectangle2D.Float();
            rectangle2D.setFrameFromDiagonal(dArray[0], dArray[1], dArray[2], dArray[3]);
            return rectangle2D;
        }
        if (affineTransform.isIdentity()) {
            return SunGraphics2D.cloneShape(shape);
        }
        return affineTransform.createTransformedShape(shape);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public Shape getClip() {
        return this.untransformShape(this.usrClip);
    }

    @Override
    public void setClip(Shape shape) {
        this.usrClip = this.transformShape(shape);
        this.validateCompClip();
    }

    @Override
    public void clip(Shape shape) {
        shape = this.transformShape(shape);
        if (this.usrClip != null) {
            shape = this.intersectShapes(this.usrClip, shape, true, true);
        }
        this.usrClip = shape;
        this.validateCompClip();
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public void setXORMode(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null XORColor");
        }
        this.setComposite(new XORComposite(color, this.surfaceData));
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.doCopyArea(n, n2, n3, n4, n5, n6);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.doCopyArea(n, n2, n3, n4, n5, n6);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    private void doCopyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        SurfaceData surfaceData = this.surfaceData;
        if (surfaceData.copyArea(this, n, n2, n3, n4, n5, n6)) {
            return;
        }
        if (this.transformState >= 3) {
            throw new InternalError("transformed copyArea not implemented yet");
        }
        Region region = this.getCompClip();
        Composite composite = this.composite;
        if (this.lastCAcomp != composite) {
            object = surfaceData.getSurfaceType();
            CompositeType compositeType = this.imageComp;
            if (CompositeType.SrcOverNoEa.equals(compositeType) && surfaceData.getTransparency() == 1) {
                compositeType = CompositeType.SrcNoEa;
            }
            this.lastCAblit = Blit.locate((SurfaceType)object, compositeType, (SurfaceType)object);
            this.lastCAcomp = composite;
        }
        n += this.transX;
        n2 += this.transY;
        object = this.lastCAblit;
        if (n6 == 0 && n5 > 0 && n5 < n3) {
            while (n3 > 0) {
                int n7 = Math.min(n3, n5);
                int n8 = n + (n3 -= n7);
                ((Blit)object).Blit(surfaceData, surfaceData, composite, region, n8, n2, n8 + n5, n2 + n6, n7, n4);
            }
            return;
        }
        if (n6 > 0 && n6 < n4 && n5 > -n3 && n5 < n3) {
            while (n4 > 0) {
                int n9 = Math.min(n4, n6);
                int n10 = n2 + (n4 -= n9);
                ((Blit)object).Blit(surfaceData, surfaceData, composite, region, n, n10, n + n5, n10 + n6, n3, n9);
            }
            return;
        }
        ((Blit)object).Blit(surfaceData, surfaceData, composite, region, n, n2, n + n5, n2 + n6, n3, n4);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        try {
            this.drawpipe.drawLine(this, n, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawLine(this, n, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.drawpipe.drawRoundRect(this, n, n2, n3, n4, n5, n6);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawRoundRect(this, n, n2, n3, n4, n5, n6);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.fillpipe.fillRoundRect(this, n, n2, n3, n4, n5, n6);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillRoundRect(this, n, n2, n3, n4, n5, n6);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        try {
            this.drawpipe.drawOval(this, n, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawOval(this, n, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        try {
            this.fillpipe.fillOval(this, n, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillOval(this, n, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.drawpipe.drawArc(this, n, n2, n3, n4, n5, n6);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawArc(this, n, n2, n3, n4, n5, n6);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.fillpipe.fillArc(this, n, n2, n3, n4, n5, n6);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillArc(this, n, n2, n3, n4, n5, n6);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        try {
            this.drawpipe.drawPolyline(this, nArray, nArray2, n);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawPolyline(this, nArray, nArray2, n);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        try {
            this.drawpipe.drawPolygon(this, nArray, nArray2, n);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawPolygon(this, nArray, nArray2, n);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        try {
            this.fillpipe.fillPolygon(this, nArray, nArray2, n);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillPolygon(this, nArray, nArray2, n);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        try {
            this.drawpipe.drawRect(this, n, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawRect(this, n, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        try {
            this.fillpipe.fillRect(this, n, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillRect(this, n, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateAll() {
        this.surfaceData = this.surfaceData.getReplacement();
        if (this.surfaceData == null) {
            this.surfaceData = NullSurfaceData.theInstance;
        }
        this.setDevClip(this.surfaceData.getBounds());
        if (this.paintState <= 1) {
            this.validateColor();
        }
        if (this.composite instanceof XORComposite) {
            Color color = ((XORComposite)this.composite).getXorColor();
            this.setComposite(new XORComposite(color, this.surfaceData));
        }
        this.validatePipe();
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        Composite composite = this.composite;
        Paint paint = this.paint;
        this.setComposite(AlphaComposite.Src);
        this.setColor(this.getBackground());
        this.validatePipe();
        this.fillRect(n, n2, n3, n4);
        this.setPaint(paint);
        this.setComposite(composite);
    }

    @Override
    public void draw(Shape shape) {
        try {
            this.shapepipe.draw(this, shape);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.shapepipe.draw(this, shape);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void fill(Shape shape) {
        try {
            this.shapepipe.fill(this, shape);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.shapepipe.fill(this, shape);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    private static boolean isIntegerTranslation(AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return true;
        }
        if (affineTransform.getType() == 1) {
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            return d == (double)((int)d) && d2 == (double)((int)d2);
        }
        return false;
    }

    private static int getTileIndex(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    private static Rectangle getImageRegion(RenderedImage renderedImage, Region region, AffineTransform affineTransform, AffineTransform affineTransform2, int n, int n2) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = null;
        try {
            double d;
            double d2;
            double[] dArray = new double[8];
            dArray[0] = dArray[2] = (double)region.getLoX();
            dArray[4] = dArray[6] = (double)region.getHiX();
            dArray[1] = dArray[5] = (double)region.getLoY();
            dArray[3] = dArray[7] = (double)region.getHiY();
            affineTransform.inverseTransform(dArray, 0, dArray, 0, 4);
            affineTransform2.inverseTransform(dArray, 0, dArray, 0, 4);
            double d3 = d2 = dArray[0];
            double d4 = d = dArray[1];
            int n3 = 2;
            while (n3 < 8) {
                int n4 = n3++;
                double d5 = dArray[n4];
                if (d5 < d3) {
                    d3 = d5;
                } else if (d5 > d2) {
                    d2 = d5;
                }
                d5 = dArray[n3++];
                if (d5 < d4) {
                    d4 = d5;
                    continue;
                }
                if (!(d5 > d)) continue;
                d = d5;
            }
            n3 = (int)d3 - n;
            int n5 = (int)(d2 - d3 + (double)(2 * n));
            int n6 = (int)d4 - n2;
            int n7 = (int)(d - d4 + (double)(2 * n2));
            Rectangle rectangle3 = new Rectangle(n3, n6, n5, n7);
            rectangle2 = rectangle3.intersection(rectangle);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            rectangle2 = rectangle;
        }
        return rectangle2;
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (renderedImage == null) {
            return;
        }
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            this.drawImage(bufferedImage, affineTransform, null);
            return;
        }
        boolean bl = this.transformState <= 1 && SunGraphics2D.isIntegerTranslation(affineTransform);
        int n = bl ? 0 : 3;
        Rectangle rectangle = SunGraphics2D.getImageRegion(renderedImage, this.getCompClip(), this.transform, affineTransform, n, n);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        if (bl) {
            this.drawTranslatedRenderedImage(renderedImage, rectangle, (int)affineTransform.getTranslateX(), (int)affineTransform.getTranslateY());
            return;
        }
        Raster raster = renderedImage.getData(rectangle);
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null);
        int n2 = raster.getMinX();
        int n3 = raster.getMinY();
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = n2 - raster.getSampleModelTranslateX();
        int n7 = n3 - raster.getSampleModelTranslateY();
        if (n6 != 0 || n7 != 0 || n4 != writableRaster.getWidth() || n5 != writableRaster.getHeight()) {
            writableRaster = writableRaster.createWritableChild(n6, n7, n4, n5, 0, 0, null);
        }
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.translate(n2, n3);
        ColorModel colorModel = renderedImage.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        this.drawImage(bufferedImage, affineTransform2, null);
    }

    private boolean clipTo(Rectangle rectangle, Rectangle rectangle2) {
        int n = Math.max(rectangle.x, rectangle2.x);
        int n2 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n3 = Math.max(rectangle.y, rectangle2.y);
        int n4 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        if (n2 - n < 0 || n4 - n3 < 0) {
            rectangle.width = -1;
            rectangle.height = -1;
            return false;
        }
        rectangle.x = n;
        rectangle.y = n3;
        rectangle.width = n2 - n;
        rectangle.height = n4 - n3;
        return true;
    }

    private void drawTranslatedRenderedImage(RenderedImage renderedImage, Rectangle rectangle, int n, int n2) {
        int n3 = renderedImage.getTileGridXOffset();
        int n4 = renderedImage.getTileGridYOffset();
        int n5 = renderedImage.getTileWidth();
        int n6 = renderedImage.getTileHeight();
        int n7 = SunGraphics2D.getTileIndex(rectangle.x, n3, n5);
        int n8 = SunGraphics2D.getTileIndex(rectangle.y, n4, n6);
        int n9 = SunGraphics2D.getTileIndex(rectangle.x + rectangle.width - 1, n3, n5);
        int n10 = SunGraphics2D.getTileIndex(rectangle.y + rectangle.height - 1, n4, n6);
        ColorModel colorModel = renderedImage.getColorModel();
        Rectangle rectangle2 = new Rectangle();
        for (int i = n8; i <= n10; ++i) {
            for (int j = n7; j <= n9; ++j) {
                Raster raster = renderedImage.getTile(j, i);
                rectangle2.x = j * n5 + n3;
                rectangle2.y = i * n6 + n4;
                rectangle2.width = n5;
                rectangle2.height = n6;
                this.clipTo(rectangle2, rectangle);
                WritableRaster writableRaster = null;
                writableRaster = raster instanceof WritableRaster ? (WritableRaster)raster : Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null);
                writableRaster = writableRaster.createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 0, null);
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                this.copyImage(bufferedImage, rectangle2.x + n, rectangle2.y + n2, 0, 0, rectangle2.width, rectangle2.height, null, null);
            }
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        if (renderableImage == null) {
            return;
        }
        AffineTransform affineTransform3 = this.transform;
        AffineTransform affineTransform4 = new AffineTransform(affineTransform);
        affineTransform4.concatenate(affineTransform3);
        RenderContext renderContext = new RenderContext(affineTransform4);
        try {
            affineTransform2 = affineTransform3.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            renderContext = new RenderContext(affineTransform3);
            affineTransform2 = new AffineTransform();
        }
        RenderedImage renderedImage = renderableImage.createRendering(renderContext);
        this.drawRenderedImage(renderedImage, affineTransform2);
    }

    protected Rectangle transformBounds(Rectangle rectangle, AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return rectangle;
        }
        Shape shape = SunGraphics2D.transformShape(affineTransform, rectangle);
        return shape.getBounds();
    }

    @Override
    public void drawString(String string, int n, int n2) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (this.font.hasLayoutAttributes()) {
            new TextLayout(string, this.font, this.getFontRenderContext()).draw(this, n, n2);
            return;
        }
        try {
            this.textpipe.drawString(this, string, n, n2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.textpipe.drawString(this, string, n, n2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (this.font.hasLayoutAttributes()) {
            new TextLayout(string, this.font, this.getFontRenderContext()).draw(this, f, f2);
            return;
        }
        try {
            this.textpipe.drawString(this, string, f, f2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.textpipe.drawString(this, string, f, f2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("AttributedCharacterIterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, n, n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("AttributedCharacterIterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, f, f2);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (glyphVector == null) {
            throw new NullPointerException("GlyphVector is null");
        }
        try {
            this.textpipe.drawGlyphVector(this, glyphVector, f, f2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.textpipe.drawGlyphVector(this, glyphVector, f, f2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        if (cArray == null) {
            throw new NullPointerException("char data is null");
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("bad offset/length");
        }
        if (this.font.hasLayoutAttributes()) {
            new TextLayout(new String(cArray, n, n2), this.font, this.getFontRenderContext()).draw(this, n3, n4);
            return;
        }
        try {
            this.textpipe.drawChars(this, cArray, n, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.textpipe.drawChars(this, cArray, n, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray == null) {
            throw new NullPointerException("byte data is null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("bad offset/length");
        }
        char[] cArray = new char[n2];
        int n5 = n2;
        while (n5-- > 0) {
            cArray[n5] = (char)(byArray[n5 + n] & 0xFF);
        }
        if (this.font.hasLayoutAttributes()) {
            new TextLayout(new String(cArray), this.font, this.getFontRenderContext()).draw(this, n3, n4);
            return;
        }
        try {
            this.textpipe.drawChars(this, cArray, 0, n2, n3, n4);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.textpipe.drawChars(this, cArray, 0, n2, n3, n4);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean copyImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
        try {
            return this.imagepipe.copyImage(this, image, n, n2, n3, n4, n5, n6, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.copyImage(this, image, n, n2, n3, n4, n5, n6, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (n3 == image.getWidth(null) && n4 == image.getHeight(null)) {
            return this.copyImage(image, n, n2, 0, 0, n3, n4, color, imageObserver);
        }
        try {
            return this.imagepipe.scaleImage(this, image, n, n2, n3, n4, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.scaleImage(this, image, n, n2, n3, n4, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        try {
            return this.imagepipe.copyImage(this, image, n, n2, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.copyImage(this, image, n, n2, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        if (n == n3 || n2 == n4 || n5 == n7 || n6 == n8) {
            return true;
        }
        if (n7 - n5 == n3 - n && n8 - n6 == n4 - n2) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            if (n7 > n5) {
                n14 = n7 - n5;
                n13 = n5;
                n12 = n;
            } else {
                n14 = n5 - n7;
                n13 = n7;
                n12 = n3;
            }
            if (n8 > n6) {
                n11 = n8 - n6;
                n10 = n6;
                n9 = n2;
            } else {
                n11 = n6 - n8;
                n10 = n8;
                n9 = n4;
            }
            return this.copyImage(image, n12, n9, n13, n10, n14, n11, color, imageObserver);
        }
        try {
            return this.imagepipe.scaleImage(this, image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.scaleImage(this, image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        if (affineTransform == null || affineTransform.isIdentity()) {
            return this.drawImage(image, 0, 0, null, imageObserver);
        }
        try {
            return this.imagepipe.transformImage(this, image, affineTransform, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.transformImage(this, image, affineTransform, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImage == null) {
            return;
        }
        try {
            this.imagepipe.transformImage(this, bufferedImage, bufferedImageOp, n, n2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.imagepipe.transformImage(this, bufferedImage, bufferedImageOp, n, n2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        if (this.cachedFRC == null) {
            int n = this.textAntialiasHint;
            if (n == 0 && this.antialiasHint == 2) {
                n = 2;
            }
            AffineTransform affineTransform = null;
            if (this.transformState >= 3) {
                affineTransform = this.transform.getTranslateX() == 0.0 && this.transform.getTranslateY() == 0.0 ? this.transform : new AffineTransform(this.transform.getScaleX(), this.transform.getShearY(), this.transform.getShearX(), this.transform.getScaleY(), 0.0, 0.0);
            }
            this.cachedFRC = new FontRenderContext(affineTransform, SunHints.Value.get(2, n), SunHints.Value.get(3, this.fractionalMetricsHint));
        }
        return this.cachedFRC;
    }

    @Override
    public void dispose() {
        this.surfaceData = NullSurfaceData.theInstance;
        this.invalidatePipe();
    }

    @Override
    public void finalize() {
    }

    public Object getDestination() {
        return this.surfaceData.getDestination();
    }

    static {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("SunGraphics2D static initialization");
        }
        invalidpipe = new ValidatePipe();
        IDENT_MATRIX = new double[]{1.0, 0.0, 0.0, 1.0};
        IDENT_ATX = new AffineTransform();
        textTxArr = new double[17][];
        textAtArr = new AffineTransform[17];
        for (int i = 8; i < 17; ++i) {
            SunGraphics2D.textTxArr[i] = new double[]{i, 0.0, 0.0, i};
            SunGraphics2D.textAtArr[i] = new AffineTransform(textTxArr[i]);
        }
    }
}

