//
//  ECCdmaDef.h
//  ECCdmaMgr
//
//  Created by gdcn on 11-11-15.
//  Copyright 2011年 CDC. All rights reserved.
//
/**
 * @file    ECCdmaDef.h
 * @brief   cdma相关参数定义头文件，只有需要导出的才在这里定义
 * @author  liw
 * @date    2011-11-15
 * @version  v1.0
 */

#ifndef __ECCDMADEF__H__
#define __ECCDMADEF__H__

/**
	上网卡所支持模式定义，暂时只支持CDMA，HDR，CDMA_HDR三种模式
 */
typedef enum _SYSTEM_MODE {
	CT_MODE_NONE=0, /**< 无服务 */
    CT_MODE_AMPS, /**< AMPS模式 */
    CT_MODE_CDMA, /**< CDMA模式 */
    CT_MODE_GSM_GPRS, /**< GSM/GPRS模式 */
    CT_MODE_HDR, /**< HDR模式 */
    CT_MODE_WCDMA, /**< WCDMA模式 */
    CT_MODE_GPS, /**< GPS模式 */
    CT_MODE_GSM_WCDMA, /**< GSM/WCDMA模式 */
    CT_MODE_CDMA_HDR_HYBRID /**< CDMA/HDR HYBRID模式 */
} CT_SYSTEM_MODE;



/**
 存储介质类型定义
 */
typedef enum _TYPE_MEMORY{
	CT_MEMORY_PC=0, /**< 本地存储数据 */
	CT_MEMORY_ME, /**< 上网卡设备 */
	CT_MEMORY_UIM /**< UIM卡设备 */
}CT_TYPE_MEMORY;


/**
 PIN状态定义
 */
typedef enum _STATE_PIN{
	CT_PIN_UNKNOW, /**< 未知 */
    CT_PIN_NONE_UIM, /**< 没有插卡，或者卡没有插好 */
    CT_PIN_READY, /**< UIM 卡没有开启PIN 码 */
    CT_PIN_PIN, /**< UIM 卡有PIN 码保护，需要输入PIN 码来解锁 */
    CT_PIN_PUK, /**< UIM 卡有PIN 码保护，并且输入不正确，PIN 码次数已经超过3 次，PIN 码已经被，锁定，需要输入 8 位的PUK 码来解锁 */
    CT_PIN_LOCK	/**< UIM 卡已经被永久锁定 */
}CT_STATE_PIN;

/**
	PIN模式定义
 */
typedef enum _MODE_PIN{
	CT_MODE_PIN_UNLOCK, /**< 已解锁 */
    CT_MODE_PIN_LOCK    /**< 已锁定 */
} CT_MODE_PIN;

/**
 存储空间结构定义
 */
typedef struct _STATUS_SPACE {
	unsigned int uiSize; /**< CT_STATUS_MSG_SPACE的大小 */
    unsigned int uiMeTotal; /**< 数据卡的短信（或电话本）总量 */
    unsigned int uiMeUsed; /**< 数据卡中已使用短信（或电话本）条数 */
    unsigned int uiUIMTotal; /**< UIM卡中短信（或电话本）总量 */
    unsigned int uiUIMUsed; /**< UIM卡中已使用短信（或电话本）条数 */
}CT_STATUS_SPACE;

/**
 PIN状态结构体定义
 */
typedef struct _PIN_INFO{ 
 	unsigned int uiSize;			/**< CT_PIN_INFO的大小 */
 	CT_STATE_PIN eStatePin; 		/**< PIN码状态 */
 	CT_MODE_PIN eModePin;			/**< 锁状态 */
 	unsigned int uiPinTimes;		/**< 剩余PIN码校验次数 */
 	unsigned int uiPukTimes;		/**< 剩余PUK码校验次数 */
} CT_PIN_INFO;



/**
 设备信息结构体定义
 */
typedef struct _DEVICE_INFO {
	unsigned int uiSize;	/**< CT_DEVICE_INFO的大小 */
	bool	bHaveUim;		/**< 是否插入UIM卡 */
	char 	szGMI[64];		/**< 厂商信息 */
	char	szESN[64];		/**< 产品ESN号 */
	char	szGMM[64];		/**< 产品模型号 */
	char 	szGMR[64];		/**< 软件版本号 */
	char 	szIMSI[64];		/**< UIM卡的IMSI值 */
	char 	szMEID[64];		/**< 单板的MEID */
	char 	szHWV[64];		/**< 硬件版本号 */
    
} CT_DEVICE_INFO;

#endif //end __ECCDMADEF__H__