//
//  ECDeviceMgr.h
//  ECCdmaMgr
//
//  Created by gdcn on 11-10-20.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//
//  
//
/**
 * @file    ECDeviceMgr.h
 * @brief   设备管理处理类
 * @author  liw
 * @date    2011-10-20
 * @version  v1.0
 */

#import <Foundation/Foundation.h>
#import "ECStandardAT.h"



/**
	设备管理对象定义
 */
@interface ECDeviceMgr : NSObject {

@private
    NSThread*   deviceMonitorThread;
    NSThread*   openDeviceThread;
    NSString*   configFilePath;
    NSString*   pluginFilePath;
    id          cdmaMgr;
    NSString*   logDataPath;
}

/**
	获取默认管理实例，确保实例进程唯一
	@returns 成功返回设备管理对象，失败返回nil
 */
+ (id)defaultDeviceMgr;


/**
	设置插件,配置文件目录路径
	@param pluginPath 插件目录
	@param configPath 配置文件目录
 */
- (void)setPluginFilePath:(NSString*)pluginPath configFilePath:(NSString*)configPath;

/**
	设置数据目标,主要用于存储用户数据,如日志文件
	@param dataPath 用户数据目录
 */
- (void)setDataPath:(NSString*)dataPath;


/**
	开始网络监视，开始网络监视后，连接或断开网络会检测当前网络状态
	@returns 启动成功返回true，否则false
 */
- (Boolean)startMonitor;


/**
	停止网络监视
    @warning 由于每次连接或断开都会检测网络，然后Post消息通知，所以在自动连接或多任务网络操作时需要停止监视
 */
- (void)stopMonitor;

/**
	获取CDMA设备操作对象
	@returns 成功返回操作对象，失败返回nil
 */
- (id<ECStandardAT>)cdmaObj;


@end
